/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.quickfix.GoToSymbolFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.impl.scopes.ModulesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.search.FilenameIndex;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleHighlightUtil {
    @Nullable
    static HighlightInfo checkFileName(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileName"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileName"));
        }
        if (!"module-info.java".equals(file.getName())) {
            String message = JavaErrorMessages.message("module.file.wrong.name", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).description(message).create();
            QuickFixAction.registerQuickFixAction(info, ModuleHighlightUtil.factory().createRenameFileFix("module-info.java"));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFileDuplicates(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        Project project;
        Collection<VirtualFile> others;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileDuplicates"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileDuplicates"));
        }
        Module module = ModuleUtilCore.findModuleForPsiElement(element);
        if (module != null && (others = FilenameIndex.getVirtualFilesByName(project = file.getProject(), "module-info.java", new ModulesScope(module))).size() > 1) {
            String message = JavaErrorMessages.message("module.file.duplicate", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(ModuleHighlightUtil.range(element)).description(message).create();
            others.stream().map(f -> PsiManager.getInstance(project).findFile((VirtualFile)f)).filter(f -> {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "lambda$checkFileDuplicates$1"));
                }
                return f != file;
            }).findFirst().ifPresent(duplicate -> QuickFixAction.registerQuickFixAction(info, new GoToSymbolFix((NavigatablePsiElement)duplicate, JavaErrorMessages.message("module.open.duplicate.text", new Object[0]))));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkFileLocation(@NotNull PsiJavaModule element, @NotNull PsiFile file) {
        VirtualFile root;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileLocation"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/ModuleHighlightUtil", "checkFileLocation"));
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile != null && (root = ProjectFileIndex.SERVICE.getInstance(file.getProject()).getSourceRootForFile(vFile)) != null && !root.equals(vFile.getParent())) {
            String message = JavaErrorMessages.message("module.file.wrong.location", new Object[0]);
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.WARNING).range(ModuleHighlightUtil.range(element)).description(message).create();
            QuickFixAction.registerQuickFixAction(info, new MoveFileFix(vFile, root, QuickFixBundle.message("move.file.to.source.root.text", new Object[0])));
            return info;
        }
        return null;
    }

    @Nullable
    static HighlightInfo checkModuleReference(@Nullable PsiJavaModuleReferenceElement refElement) {
        if (refElement != null) {
            PsiPolyVariantReference ref = refElement.getReference();
            assert (ref != null) : refElement.getParent();
            if (ref.multiResolve(false).length == 0) {
                String message = JavaErrorMessages.message("module.ref.unknown", refElement.getReferenceText());
                return HighlightInfo.newHighlightInfo(HighlightInfoType.WRONG_REF).range(refElement).description(message).create();
            }
        }
        return null;
    }

    private static QuickFixFactory factory() {
        return QuickFixFactory.getInstance();
    }

    private static TextRange range(PsiJavaModule module) {
        return new TextRange(module.getTextOffset(), module.getNameElement().getTextRange().getEndOffset());
    }
}

