/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Predicate;
import gnu.trove.THashMap;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RefCountHolder {
    private final PsiFile myFile;
    private final MultiMap<PsiElement, PsiReference> myLocalRefsMap;
    private final Map<PsiAnchor, Boolean> myDclsUsedMap;
    private final Map<PsiReference, PsiImportStatementBase> myImportStatements;
    private final AtomicReference<ProgressIndicator> myState;
    private static final ProgressIndicator READY = new DaemonProgressIndicator(){
        {
            this.cancel();
        }

        @Override
        public String toString() {
            return "READY";
        }
    };
    private static final ProgressIndicator EMPTY = new DaemonProgressIndicator(){
        {
            this.cancel();
        }

        @Override
        public String toString() {
            return "EMPTY";
        }
    };
    private static final Key<Reference<RefCountHolder>> REF_COUNT_HOLDER_IN_FILE_KEY = Key.create("REF_COUNT_HOLDER_IN_FILE_KEY");

    @NotNull
    static RefCountHolder get(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "get"));
        }
        Reference<RefCountHolder> ref = file.getUserData(REF_COUNT_HOLDER_IN_FILE_KEY);
        RefCountHolder holder = SoftReference.dereference(ref);
        if (holder == null) {
            boolean replaced;
            holder = new RefCountHolder(file);
            java.lang.ref.SoftReference<RefCountHolder> newRef = new java.lang.ref.SoftReference<RefCountHolder>(holder);
            while (!(replaced = ((UserDataHolderEx)((Object)file)).replace(REF_COUNT_HOLDER_IN_FILE_KEY, ref, newRef))) {
                ref = file.getUserData(REF_COUNT_HOLDER_IN_FILE_KEY);
                RefCountHolder newHolder = SoftReference.dereference(ref);
                if (newHolder == null) continue;
                holder = newHolder;
                break;
            }
        }
        RefCountHolder refCountHolder = holder;
        if (refCountHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "get"));
        }
        return refCountHolder;
    }

    private RefCountHolder(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "<init>"));
        }
        this.myLocalRefsMap = MultiMap.createSet();
        this.myDclsUsedMap = new THashMap();
        this.myImportStatements = new THashMap();
        this.myState = new AtomicReference<ProgressIndicator>(EMPTY);
        this.myFile = file;
        RefCountHolder.log("c: created for ", file);
    }

    @NotNull
    GlobalUsageHelper getGlobalUsageHelper(@NotNull PsiFile file, @Nullable UnusedDeclarationInspectionBase deadCodeInspection, boolean isUnusedToolEnabled) {
        VirtualFile virtualFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "getGlobalUsageHelper"));
        }
        FileViewProvider viewProvider = file.getViewProvider();
        Project project = file.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        final boolean inLibrary = fileIndex.isInLibraryClasses(virtualFile = viewProvider.getVirtualFile()) || fileIndex.isInLibrarySource(virtualFile);
        boolean myDeadCodeEnabled = deadCodeInspection != null && isUnusedToolEnabled && deadCodeInspection.isGlobalEnabledInEditor();
        final Predicate<PsiElement> myIsEntryPointPredicate = member -> !myDeadCodeEnabled || deadCodeInspection.isEntryPoint((PsiElement)member);
        GlobalUsageHelper globalUsageHelper = new GlobalUsageHelper(){

            @Override
            public boolean shouldCheckUsages(@NotNull PsiMember member) {
                if (member == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder$3", "shouldCheckUsages"));
                }
                return !inLibrary && !myIsEntryPointPredicate.apply(member);
            }

            @Override
            public boolean isCurrentFileAlreadyChecked() {
                return true;
            }

            @Override
            public boolean isLocallyUsed(@NotNull PsiNamedElement member) {
                if (member == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder$3", "isLocallyUsed"));
                }
                return RefCountHolder.this.isReferenced(member);
            }
        };
        if (globalUsageHelper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "getGlobalUsageHelper"));
        }
        return globalUsageHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            this.myLocalRefsMap.clear();
        }
        this.myImportStatements.clear();
        this.myDclsUsedMap.clear();
    }

    void registerLocallyReferenced(@NotNull PsiNamedElement result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "registerLocallyReferenced"));
        }
        this.myDclsUsedMap.put(PsiAnchor.create(result), Boolean.TRUE);
    }

    void registerReference(@NotNull PsiReference ref, @NotNull JavaResolveResult resolveResult) {
        PsiElement resolveScope;
        PsiFile psiFile;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "registerReference"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "registerReference"));
        }
        PsiElement refElement = resolveResult.getElement();
        PsiFile psiFile2 = psiFile = refElement == null ? null : refElement.getContainingFile();
        if (psiFile != null) {
            psiFile = (PsiFile)psiFile.getNavigationElement();
        }
        if (refElement != null && psiFile != null && this.myFile.getViewProvider().equals(psiFile.getViewProvider())) {
            this.registerLocalRef(ref, refElement.getNavigationElement());
        }
        if ((resolveScope = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase) {
            this.registerImportStatement(ref, (PsiImportStatementBase)resolveScope);
        }
    }

    private void registerImportStatement(@NotNull PsiReference ref, @NotNull PsiImportStatementBase importStatement) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "registerImportStatement"));
        }
        if (importStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatement", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "registerImportStatement"));
        }
        this.myImportStatements.put(ref, importStatement);
    }

    boolean isRedundant(@NotNull PsiImportStatementBase importStatement) {
        if (importStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importStatement", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isRedundant"));
        }
        return !this.myImportStatements.containsValue(importStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerLocalRef(@NotNull PsiReference ref, PsiElement refElement) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "registerLocalRef"));
        }
        if (refElement instanceof PsiMethod && PsiTreeUtil.isAncestor(refElement, ref.getElement(), true)) {
            return;
        }
        if (refElement instanceof PsiClass && PsiTreeUtil.isAncestor(refElement, ref.getElement(), true)) {
            return;
        }
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            this.myLocalRefsMap.putValue(refElement, ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidRefs() {
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            ArrayList<Pair<PsiElement, PsiReference>> toRemove = new ArrayList<Pair<PsiElement, PsiReference>>();
            for (Map.Entry<PsiElement, Collection<PsiReference>> entry : this.myLocalRefsMap.entrySet()) {
                PsiElement element = entry.getKey();
                for (PsiReference ref : entry.getValue()) {
                    if (ref.getElement().isValid()) continue;
                    toRemove.add(Pair.create(element, ref));
                }
            }
            for (Pair pair : toRemove) {
                this.myLocalRefsMap.remove((PsiElement)pair.first, (PsiReference)pair.second);
            }
        }
        Iterator<PsiReference> iterator = this.myImportStatements.keySet().iterator();
        while (iterator.hasNext()) {
            PsiReference ref = iterator.next();
            if (ref.getElement().isValid()) continue;
            iterator.remove();
        }
        RefCountHolder.removeInvalidFrom(this.myDclsUsedMap.keySet());
    }

    private static void removeInvalidFrom(@NotNull Collection<? extends PsiAnchor> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "removeInvalidFrom"));
        }
        Iterator<? extends PsiAnchor> it = collection.iterator();
        while (it.hasNext()) {
            PsiAnchor element = it.next();
            if (element.retrieve() != null) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReferenced(@NotNull PsiElement element) {
        Collection<PsiReference> array;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isReferenced"));
        }
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            array = this.myLocalRefsMap.get(element);
        }
        if (!array.isEmpty() && !RefCountHolder.isParameterUsedRecursively(element, array)) {
            return true;
        }
        Boolean usedStatus = this.myDclsUsedMap.get(PsiAnchor.create(element));
        return usedStatus == Boolean.TRUE;
    }

    private static boolean isParameterUsedRecursively(@NotNull PsiElement element, @NotNull Collection<PsiReference> array) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isParameterUsedRecursively"));
        }
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isParameterUsedRecursively"));
        }
        if (!(element instanceof PsiParameter)) {
            return false;
        }
        PsiParameter parameter = (PsiParameter)element;
        PsiElement scope = parameter.getDeclarationScope();
        if (!(scope instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)scope;
        int paramIndex = ArrayUtilRt.find(method.getParameterList().getParameters(), parameter);
        for (PsiReference reference : array) {
            if (!(reference instanceof PsiElement)) {
                return false;
            }
            PsiElement argument = (PsiElement)((Object)reference);
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)new PsiMatcherImpl(argument).dot(PsiMatchers.hasClass(PsiReferenceExpression.class)).parent(PsiMatchers.hasClass(PsiExpressionList.class)).parent(PsiMatchers.hasClass(PsiMethodCallExpression.class)).getElement();
            if (methodCallExpression == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            if (method != methodExpression.resolve()) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            int argumentIndex = ArrayUtilRt.find(arguments, argument);
            if (paramIndex == argumentIndex) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReferencedForRead(@NotNull PsiVariable variable) {
        Collection<PsiReference> array;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isReferencedForRead"));
        }
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            array = this.myLocalRefsMap.get(variable);
        }
        if (array.isEmpty()) {
            return false;
        }
        for (PsiReference ref : array) {
            ReadWriteAccessDetector.Access access;
            PsiElement refElement = ref.getElement();
            PsiElement resolved = ref.resolve();
            if (resolved == null || (access = RefCountHolder.getAccess(ref, resolved)) != ReadWriteAccessDetector.Access.Read && access != ReadWriteAccessDetector.Access.ReadWrite || RefCountHolder.isJustIncremented(access, refElement)) continue;
            return true;
        }
        return false;
    }

    private static ReadWriteAccessDetector.Access getAccess(@NotNull PsiReference ref, @NotNull PsiElement resolved) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "getAccess"));
        }
        if (resolved == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolved", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "getAccess"));
        }
        PsiElement start = resolved.getLanguage() == ref.getElement().getLanguage() ? resolved : ref.getElement();
        ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector(start);
        if (detector != null) {
            return detector.getReferenceAccess(resolved, ref);
        }
        return null;
    }

    private static boolean isJustIncremented(@NotNull ReadWriteAccessDetector.Access access, @NotNull PsiElement refElement) {
        if (access == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "access", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isJustIncremented"));
        }
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isJustIncremented"));
        }
        return access == ReadWriteAccessDetector.Access.ReadWrite && refElement instanceof PsiExpression && refElement.getParent() instanceof PsiExpression && refElement.getParent().getParent() instanceof PsiExpressionStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReferencedForWrite(@NotNull PsiVariable variable) {
        Collection<PsiReference> array;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "isReferencedForWrite"));
        }
        MultiMap<PsiElement, PsiReference> multiMap = this.myLocalRefsMap;
        synchronized (multiMap) {
            array = this.myLocalRefsMap.get(variable);
        }
        if (array.isEmpty()) {
            return false;
        }
        for (PsiReference ref : array) {
            ReadWriteAccessDetector.Access access;
            PsiElement resolved = ref.resolve();
            if (resolved == null || (access = RefCountHolder.getAccess(ref, resolved)) != ReadWriteAccessDetector.Access.Write && access != ReadWriteAccessDetector.Access.ReadWrite) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean analyze(@NotNull PsiFile file, TextRange dirtyScope, @NotNull ProgressIndicator indicator, @NotNull Runnable analyze) {
        boolean bl;
        ProgressIndicator result;
        block14: {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "analyze"));
            }
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "analyze"));
            }
            if (analyze == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyze", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "analyze"));
            }
            if (this.myState.compareAndSet(EMPTY, indicator)) {
                if (!file.getTextRange().equals(dirtyScope)) {
                    this.myState.set(EMPTY);
                    return false;
                }
                result = EMPTY;
            } else if (this.myState.compareAndSet(READY, indicator)) {
                result = READY;
            } else {
                RefCountHolder.log("a: failed to change ", this.myState, "->", indicator);
                return false;
            }
            try {
                RefCountHolder.log("a: changed ", this.myState, "->", indicator);
                if (dirtyScope != null) {
                    if (dirtyScope.equals(file.getTextRange())) {
                        this.clear();
                    } else {
                        this.removeInvalidRefs();
                    }
                }
                analyze.run();
                result = READY;
                bl = true;
                boolean set = this.myState.compareAndSet(indicator, result);
                if ($assertionsDisabled || set) break block14;
            }
            catch (Throwable throwable) {
                boolean set = this.myState.compareAndSet(indicator, result);
                assert (set) : this.myState.get();
                RefCountHolder.log("a: changed after analyze", indicator, "->", result);
                throw throwable;
            }
            throw new AssertionError(this.myState.get());
        }
        RefCountHolder.log("a: changed after analyze", indicator, "->", result);
        return bl;
    }

    private static void log(Object ... info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/analysis/RefCountHolder", "log"));
        }
        FileStatusMap.log(info);
    }
}

