/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyStreamApiCallChainsInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance("#" + SimplifyStreamApiCallChainsInspection.class.getName());
    private static final String FOR_EACH_METHOD = "forEach";
    private static final String FOR_EACH_ORDERED_METHOD = "forEachOrdered";
    private static final String STREAM_METHOD = "stream";
    private static final String AS_LIST_METHOD = "asList";
    private static final String OF_METHOD = "of";

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                if (SimplifyStreamApiCallChainsInspection.isCallOf(methodCall, "java.util.Collection", SimplifyStreamApiCallChainsInspection.STREAM_METHOD, 0)) {
                    PsiMethodCallExpression qualifierCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(methodCall);
                    if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifierCall, "java.util.Arrays", SimplifyStreamApiCallChainsInspection.AS_LIST_METHOD, 1)) {
                        PsiExpression[] argumentExpressions = qualifierCall.getArgumentList().getExpressions();
                        if (argumentExpressions.length == 1 && argumentExpressions[0].getType() instanceof PsiArrayType) {
                            holder.registerProblem((PsiElement)methodCall, null, "Arrays.asList().stream() can be replaced with Arrays.stream()", new ArraysAsListSingleArrayFix());
                        } else {
                            holder.registerProblem((PsiElement)methodCall, null, "Arrays.asList().stream() can be replaced with Stream.of()", new ArraysAsListVarargFix());
                        }
                    }
                } else {
                    String name;
                    if (SimplifyStreamApiCallChainsInspection.isCallOf(methodCall, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD, 1)) {
                        name = SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD;
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(methodCall, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.FOR_EACH_ORDERED_METHOD, 1)) {
                        name = SimplifyStreamApiCallChainsInspection.FOR_EACH_ORDERED_METHOD;
                    } else {
                        return;
                    }
                    PsiMethodCallExpression qualifierCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(methodCall);
                    if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifierCall, "java.util.Collection", SimplifyStreamApiCallChainsInspection.STREAM_METHOD, 0)) {
                        CollectionForEachFix fix;
                        String message = "Collection.stream()." + name + "() can be replaced with Collection.forEach()";
                        if (SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD.equals(name)) {
                            fix = new CollectionForEachFix();
                        } else {
                            fix = new CollectionForEachOrderedFix();
                            message = message + " (may change semantics)";
                        }
                        holder.registerProblem((PsiElement)methodCall, SimplifyStreamApiCallChainsInspection.this.getCallChainRange(methodCall, qualifierCall), message, fix);
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static PsiMethodCallExpression getQualifierMethodCall(PsiMethodCallExpression methodCall) {
        PsiExpression qualifierExpression = methodCall.getMethodExpression().getQualifierExpression();
        if (qualifierExpression instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)qualifierExpression;
        }
        return null;
    }

    @NotNull
    protected TextRange getCallChainRange(@NotNull PsiMethodCallExpression expression, @NotNull PsiMethodCallExpression qualifierExpression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        if (qualifierExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierExpression", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        PsiReferenceExpression qualifierMethodExpression = qualifierExpression.getMethodExpression();
        PsiElement qualifierNameElement = qualifierMethodExpression.getReferenceNameElement();
        int startOffset = (qualifierNameElement != null ? qualifierNameElement : qualifierMethodExpression).getTextOffset();
        int endOffset = expression.getMethodExpression().getTextRange().getEndOffset();
        TextRange textRange = new TextRange(startOffset, endOffset).shiftRight(-expression.getTextOffset());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        return textRange;
    }

    @Contract(value="null, _, _, _ -> false")
    protected static boolean isCallOf(@Nullable PsiMethodCallExpression expression, @NotNull String className, @NotNull String methodName, int parametersCount) {
        PsiClass containingClass;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "isCallOf"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "isCallOf"));
        }
        if (expression == null) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        return method != null && methodName.equals(method.getName()) && method.getParameterList().getParametersCount() == parametersCount && (containingClass = method.getContainingClass()) != null && className.equals(containingClass.getQualifiedName());
    }

    private static class CollectionForEachOrderedFix
    extends CollectionForEachFix {
        private CollectionForEachOrderedFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace Collection.stream().forEachOrdered() with Collection.forEach() (may change semantics)" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CollectionForEachOrderedFix", "getFamilyName"));
            }
            return "Replace Collection.stream().forEachOrdered() with Collection.forEach() (may change semantics)";
        }

        @Override
        protected void replaceMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiMethodCallExpression qualifierCall, @Nullable PsiExpression qualifierExpression) {
            PsiElement nameElement;
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CollectionForEachOrderedFix", "replaceMethodCall"));
            }
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CollectionForEachOrderedFix", "replaceMethodCall"));
            }
            if (qualifierExpression != null && (nameElement = methodCall.getMethodExpression().getReferenceNameElement()) != null) {
                qualifierCall.replace(qualifierExpression);
                Project project = methodCall.getProject();
                PsiIdentifier forEachIdentifier = JavaPsiFacade.getElementFactory(project).createIdentifier(SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD);
                nameElement.replace(forEachIdentifier);
            }
        }
    }

    private static class CollectionForEachFix
    extends CallChainFixBase {
        private CollectionForEachFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace Collection.stream().forEach() with Collection.forEach()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CollectionForEachFix", "getFamilyName"));
            }
            return "Replace Collection.stream().forEach() with Collection.forEach()";
        }

        @Override
        protected void replaceMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiMethodCallExpression qualifierCall, @Nullable PsiExpression qualifierExpression) {
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CollectionForEachFix", "replaceMethodCall"));
            }
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CollectionForEachFix", "replaceMethodCall"));
            }
            if (qualifierExpression != null) {
                qualifierCall.replace(qualifierExpression);
            }
        }
    }

    private static class ArraysAsListSingleArrayFix
    extends ArraysAsListFix {
        private ArraysAsListSingleArrayFix() {
            super("java.util.Arrays.stream");
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace Arrays.asList().stream() with Arrays.stream()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListSingleArrayFix", "getFamilyName"));
            }
            return "Replace Arrays.asList().stream() with Arrays.stream()";
        }
    }

    private static class ArraysAsListVarargFix
    extends ArraysAsListFix {
        private ArraysAsListVarargFix() {
            super("java.util.stream.Stream.of");
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace Arrays.asList().stream() with Stream.of()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListVarargFix", "getFamilyName"));
            }
            return "Replace Arrays.asList().stream() with Stream.of()";
        }
    }

    private static abstract class ArraysAsListFix
    extends CallChainFixBase {
        private final String myMethodFQN;

        private ArraysAsListFix(String methodFQN) {
            this.myMethodFQN = methodFQN;
        }

        @Override
        protected void replaceMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiMethodCallExpression qualifierCall, @Nullable PsiExpression qualifierExpression) {
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListFix", "replaceMethodCall"));
            }
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListFix", "replaceMethodCall"));
            }
            methodCall.getArgumentList().replace(qualifierCall.getArgumentList());
            Project project = methodCall.getProject();
            PsiExpression newMethodExpression = JavaPsiFacade.getElementFactory(project).createExpressionFromText(this.myMethodFQN, methodCall);
            PsiElement shortMethodExpression = JavaCodeStyleManager.getInstance(project).shortenClassReferences(newMethodExpression);
            methodCall.getMethodExpression().replace(shortMethodExpression);
        }
    }

    private static abstract class CallChainFixBase
    implements LocalQuickFix {
        private CallChainFixBase() {
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CallChainFixBase", "getName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CallChainFixBase", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CallChainFixBase", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (element instanceof PsiMethodCallExpression) {
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element.getContainingFile())) {
                    return;
                }
                PsiMethodCallExpression expression = (PsiMethodCallExpression)element;
                PsiExpression forEachMethodQualifier = expression.getMethodExpression().getQualifierExpression();
                if (forEachMethodQualifier instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression previousExpression = (PsiMethodCallExpression)forEachMethodQualifier;
                    PsiExpression qualifierExpression = previousExpression.getMethodExpression().getQualifierExpression();
                    this.replaceMethodCall(expression, previousExpression, qualifierExpression);
                }
            }
        }

        protected abstract void replaceMethodCall(@NotNull PsiMethodCallExpression var1, @NotNull PsiMethodCallExpression var2, @Nullable PsiExpression var3);
    }
}

