/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrozenDocument
implements DocumentEx {
    private final ImmutableCharSequence myText;
    private final LineSet myLineSet;
    private final long myStamp;
    private volatile SoftReference<String> myTextString;

    /*
     * WARNING - void declaration
     */
    FrozenDocument(@NotNull ImmutableCharSequence text, @NotNull LineSet lineSet, long stamp, @Nullable String string) {
        void textString;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/FrozenDocument", "<init>"));
        }
        if (lineSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineSet", "com/intellij/openapi/editor/impl/FrozenDocument", "<init>"));
        }
        this.myText = text;
        this.myLineSet = lineSet;
        this.myStamp = stamp;
        this.myTextString = textString == null ? null : new SoftReference<void>(textString);
    }

    public FrozenDocument applyEvent(DocumentEvent event, int newStamp) {
        int offset = event.getOffset();
        int oldEnd = offset + event.getOldLength();
        ImmutableCharSequence newText = this.myText.delete(offset, oldEnd).insert(offset, event.getNewFragment());
        LineSet newLineSet = this.myLineSet.update(this.myText, offset, oldEnd, event.getNewFragment(), event.isWholeTextReplaced());
        return new FrozenDocument(newText, newLineSet, newStamp, null);
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        LineIterator lineIterator = this.myLineSet.createIterator();
        if (lineIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FrozenDocument", "createLineIterator"));
        }
        return lineIterator;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/FrozenDocument", "addEditReadOnlyListener"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/FrozenDocument", "removeEditReadOnlyListener"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/openapi/editor/impl/FrozenDocument", "replaceText"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveText(int srcStart, int srcEnd, int dstOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getListenersCount() {
        return 0;
    }

    @Override
    public void suppressGuardedExceptions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unSuppressGuardedExceptions() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInEventsHandling() {
        return false;
    }

    @Override
    public void clearLineModificationFlags() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/editor/impl/FrozenDocument", "removeRangeMarker"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (rangeMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeMarker", "com/intellij/openapi/editor/impl/FrozenDocument", "registerRangeMarker"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInBulkUpdate() {
        return false;
    }

    @Override
    public void setInBulkUpdate(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public List<RangeMarker> getGuardedBlocks() {
        List<RangeMarker> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FrozenDocument", "getGuardedBlocks"));
        }
        return list;
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<RangeMarker> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/FrozenDocument", "processRangeMarkers"));
        }
        return true;
    }

    @Override
    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<RangeMarker> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/editor/impl/FrozenDocument", "processRangeMarkersOverlappingWith"));
        }
        return true;
    }

    @Override
    @NotNull
    public String getText() {
        String s = SoftReference.dereference(this.myTextString);
        if (s == null) {
            s = this.myText.toString();
            this.myTextString = new SoftReference<String>(s);
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FrozenDocument", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getText(@NotNull TextRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/openapi/editor/impl/FrozenDocument", "getText"));
        }
        String string = this.myText.subSequence(range.getStartOffset(), range.getEndOffset()).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FrozenDocument", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getCharsSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FrozenDocument", "getCharsSequence"));
        }
        return immutableCharSequence;
    }

    @Override
    @NotNull
    public CharSequence getImmutableCharSequence() {
        ImmutableCharSequence immutableCharSequence = this.myText;
        if (immutableCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FrozenDocument", "getImmutableCharSequence"));
        }
        return immutableCharSequence;
    }

    @Override
    @NotNull
    public char[] getChars() {
        char[] cArray = CharArrayUtil.fromSequence(this.myText);
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/FrozenDocument", "getChars"));
        }
        return cArray;
    }

    @Override
    public int getTextLength() {
        return this.myText.length();
    }

    @Override
    public int getLineCount() {
        return this.myLineSet.getLineCount();
    }

    @Override
    public int getLineNumber(int offset) {
        return this.myLineSet.findLineIndex(offset);
    }

    @Override
    public int getLineStartOffset(int line) {
        if (line == 0) {
            return 0;
        }
        return this.myLineSet.getLineStart(line);
    }

    @Override
    public int getLineEndOffset(int line) {
        if (this.getTextLength() == 0 && line == 0) {
            return 0;
        }
        int result = this.myLineSet.getLineEnd(line) - this.getLineSeparatorLength(line);
        assert (result >= 0);
        return result;
    }

    @Override
    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/FrozenDocument", "insertString"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteString(int startOffset, int endOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/editor/impl/FrozenDocument", "replaceString"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public long getModificationStamp() {
        return this.myStamp;
    }

    @Override
    public void fireReadOnlyModificationAttempt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/FrozenDocument", "addDocumentListener"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDocumentListener(@NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/FrozenDocument", "addDocumentListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/editor/impl/FrozenDocument", "addDocumentListener"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeDocumentListener(@NotNull DocumentListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/FrozenDocument", "removeDocumentListener"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/FrozenDocument", "addPropertyChangeListener"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/editor/impl/FrozenDocument", "removePropertyChangeListener"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/openapi/editor/impl/FrozenDocument", "removeGuardedBlock"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public RangeMarker getOffsetGuard(int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public RangeMarker getRangeGuard(int start, int end) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startGuardedBlockChecking() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void stopGuardedBlockChecking() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCyclicBufferSize(int bufferSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setText(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/editor/impl/FrozenDocument", "setText"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/openapi/editor/impl/FrozenDocument", "createRangeMarker"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLineSeparatorLength(int line) {
        return this.myLineSet.getSeparatorLength(line);
    }

    @Override
    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/FrozenDocument", "getUserData"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/impl/FrozenDocument", "putUserData"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int getModificationSequence() {
        return 0;
    }
}

