/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ThrowableConvertor;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SchemeManager<T extends Scheme> {
    @NotNull
    public abstract Collection<T> loadSchemes();

    public abstract void addNewScheme(@NotNull T var1, boolean var2);

    public void addScheme(@NotNull T scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemeManager", "addScheme"));
        }
        this.addNewScheme(scheme, true);
    }

    public abstract void clearAllSchemes();

    @NotNull
    public abstract List<T> getAllSchemes();

    public boolean isEmpty() {
        return this.getAllSchemes().isEmpty();
    }

    @Nullable
    public abstract T findSchemeByName(@NotNull String var1);

    public final void setCurrentSchemeName(@Nullable String schemeName) {
        this.setCurrentSchemeName(schemeName, true);
    }

    public abstract void setCurrentSchemeName(@Nullable String var1, boolean var2);

    public final void setCurrent(@Nullable T scheme) {
        this.setCurrent(scheme, true);
    }

    public void setCurrent(@Nullable T scheme, boolean notify2) {
        this.setCurrentSchemeName(scheme == null ? null : scheme.getName());
    }

    @Nullable
    public abstract T getCurrentScheme();

    @Nullable
    public String getCurrentSchemeName() {
        T scheme = this.getCurrentScheme();
        return scheme == null ? null : scheme.getName();
    }

    public abstract void removeScheme(@NotNull T var1);

    @Nullable
    public T removeScheme(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/options/SchemeManager", "removeScheme"));
        }
        T scheme = this.findSchemeByName(name);
        if (scheme != null) {
            this.removeScheme(scheme);
            return scheme;
        }
        return null;
    }

    @NotNull
    public abstract Collection<String> getAllSchemeNames();

    public abstract File getRootDirectory();

    public void loadBundledScheme(@NotNull String resourceName, @NotNull Object requestor, @NotNull ThrowableConvertor<Element, T, Throwable> convertor) {
        if (resourceName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceName", "com/intellij/openapi/options/SchemeManager", "loadBundledScheme"));
        }
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/options/SchemeManager", "loadBundledScheme"));
        }
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/openapi/options/SchemeManager", "loadBundledScheme"));
        }
    }

    public final void setSchemes(@NotNull List<T> newSchemes) {
        if (newSchemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSchemes", "com/intellij/openapi/options/SchemeManager", "setSchemes"));
        }
        this.setSchemes(newSchemes, null, null);
    }

    public final void setSchemes(@NotNull List<T> newSchemes, @Nullable T newCurrentScheme) {
        if (newSchemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSchemes", "com/intellij/openapi/options/SchemeManager", "setSchemes"));
        }
        this.setSchemes(newSchemes, newCurrentScheme, null);
    }

    public void setSchemes(@NotNull List<T> newSchemes, @Nullable T newCurrentScheme, @Nullable Condition<T> removeCondition) {
        if (newSchemes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newSchemes", "com/intellij/openapi/options/SchemeManager", "setSchemes"));
        }
    }

    public boolean isMetadataEditable(@NotNull T scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/options/SchemeManager", "isMetadataEditable"));
        }
        return true;
    }
}

