/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.search.JavaNullMethodArgumentIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaNullMethodArgumentUtil {
    public static boolean hasNullArgument(@NotNull PsiMethod method, int argumentIdx) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaNullMethodArgumentUtil", "hasNullArgument"));
        }
        boolean[] result = new boolean[]{false};
        JavaNullMethodArgumentUtil.searchNullArgument(method, argumentIdx, expression -> {
            result[0] = true;
            return false;
        });
        return result[0];
    }

    public static void searchNullArgument(@NotNull PsiMethod method, int argumentIdx, @NotNull Processor<PsiExpression> nullArgumentProcessor) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaNullMethodArgumentUtil", "searchNullArgument"));
        }
        if (nullArgumentProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullArgumentProcessor", "com/intellij/psi/impl/search/JavaNullMethodArgumentUtil", "searchNullArgument"));
        }
        GlobalSearchScope scope = JavaNullMethodArgumentUtil.findScopeWhereNullArgumentCanPass(method, argumentIdx);
        if (scope == null) {
            return;
        }
        MethodReferencesSearch.search(method, scope, true).forEach(ref -> {
            if (nullArgumentProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nullArgumentProcessor", "com/intellij/psi/impl/search/JavaNullMethodArgumentUtil", "lambda$searchNullArgument$1"));
            }
            PsiElement psi = ref.getElement();
            if (psi != null) {
                PsiExpression argument;
                PsiExpression[] arguments;
                PsiElement parent = psi.getParent();
                PsiExpressionList argumentList = null;
                if (parent instanceof PsiCallExpression) {
                    argumentList = ((PsiCallExpression)parent).getArgumentList();
                } else if (parent instanceof PsiAnonymousClass) {
                    argumentList = ((PsiAnonymousClass)parent).getArgumentList();
                }
                if (argumentList != null && argumentIdx < (arguments = argumentList.getExpressions()).length && (argument = arguments[argumentIdx]) instanceof PsiLiteralExpression && "null".equals(argument.getText())) {
                    return nullArgumentProcessor.process(argument);
                }
            }
            return true;
        });
    }

    @Nullable
    private static GlobalSearchScope findScopeWhereNullArgumentCanPass(@NotNull PsiMethod method, int parameterIndex) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaNullMethodArgumentUtil", "findScopeWhereNullArgumentCanPass"));
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        CommonProcessors.CollectProcessor<VirtualFile> collector = new CommonProcessors.CollectProcessor<VirtualFile>(new ArrayList());
        fileBasedIndex.getFilesWithKey(JavaNullMethodArgumentIndex.INDEX_ID, Collections.singleton(new JavaNullMethodArgumentIndex.MethodCallData(method.getName(), parameterIndex)), collector, GlobalSearchScopeUtil.toGlobalSearchScope(method.getUseScope(), method.getProject()));
        Collection<VirtualFile> candidateFiles = collector.getResults();
        return candidateFiles.isEmpty() ? null : GlobalSearchScope.filesScope(method.getProject(), candidateFiles);
    }
}

