/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.BooleanStack;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;

public class DefaultStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.stubs.DefaultStubBuilder");

    @Override
    public StubElement buildStubTree(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTree"));
        }
        return this.buildStubTreeFor(file.getNode(), this.createStubForFile(file));
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file) {
        PsiFileStubImpl<PsiFile> stub;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/DefaultStubBuilder", "createStubForFile"));
        }
        PsiFileStubImpl<PsiFile> psiFileStubImpl = stub = new PsiFileStubImpl<PsiFile>(file);
        if (psiFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/DefaultStubBuilder", "createStubForFile"));
        }
        return psiFileStubImpl;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull PsiElement parent, @NotNull PsiElement element) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }

    @NotNull
    protected StubElement buildStubTreeFor(@NotNull ASTNode root, @NotNull StubElement parentStub) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        if (parentStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentStub", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        Stack<ASTNode> parentNodes = new Stack<ASTNode>();
        BooleanStack parentNodesStubbed = new BooleanStack();
        parentNodes.push(root);
        parentStubs.push(parentStub);
        parentNodesStubbed.push(true);
        while (!parentStubs.isEmpty()) {
            IStubElementType type;
            boolean hasStub;
            StubElement<Object> stub = (StubElement)parentStubs.pop();
            ASTNode node = (ASTNode)parentNodes.pop();
            boolean immediateParentStubbed = parentNodesStubbed.pop();
            IElementType nodeType = node.getElementType();
            boolean bl = hasStub = node == root;
            if (nodeType instanceof IStubElementType && (type = (IStubElementType)nodeType).shouldCreateStub(node)) {
                PsiElement element = node.getPsi();
                if (!(element instanceof StubBasedPsiElement)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type + ", PSI: " + element);
                }
                Object s = type.createStub(element, stub);
                if (!immediateParentStubbed) {
                    ((ObjectStubBase)s).markDangling();
                }
                stub = s;
                hasStub = true;
                LOG.assertTrue(stub != null, element);
            }
            for (ASTNode childNode = node.getLastChildNode(); childNode != null; childNode = childNode.getTreePrev()) {
                if (this.skipChildProcessingWhenBuildingStubs(node, childNode)) continue;
                parentNodes.push(childNode);
                parentStubs.push(stub);
                parentNodesStubbed.push(hasStub);
            }
        }
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        return stubElement;
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }
}

