/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ControlFlowStatementVisitorBase
extends BaseInspectionVisitor {
    private final HighlightDisplayKey myKey;

    protected ControlFlowStatementVisitorBase(BaseInspection inspection) {
        String shortName = inspection.getShortName();
        this.myKey = HighlightDisplayKey.find(shortName);
    }

    @Override
    public void visitForeachStatement(PsiForeachStatement statement) {
        super.visitForeachStatement(statement);
        PsiStatement body = statement.getBody();
        if (this.isApplicable(body)) {
            this.registerLoopStatementErrors(statement, body, "for");
        }
    }

    @Override
    public void visitForStatement(PsiForStatement statement) {
        super.visitForStatement(statement);
        PsiStatement body = statement.getBody();
        if (this.isApplicable(body)) {
            this.registerLoopStatementErrors(statement, body, "for");
        }
    }

    @Override
    public void visitWhileStatement(PsiWhileStatement statement) {
        super.visitWhileStatement(statement);
        PsiStatement body = statement.getBody();
        if (this.isApplicable(body)) {
            this.registerLoopStatementErrors(statement, body, "while");
        }
    }

    @Override
    public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        super.visitDoWhileStatement(statement);
        PsiStatement body = statement.getBody();
        if (this.isApplicable(body)) {
            this.registerLoopStatementErrors(statement, body, "do");
        }
    }

    @Override
    public void visitIfStatement(PsiIfStatement statement) {
        PsiStatement elseBranch;
        super.visitIfStatement(statement);
        PsiStatement thenBranch = statement.getThenBranch();
        if (this.isApplicable(thenBranch)) {
            this.registerControlFlowStatementErrors(statement.getFirstChild(), thenBranch.getLastChild(), thenBranch, "if");
        }
        if (this.isApplicable(elseBranch = statement.getElseBranch())) {
            this.registerControlFlowStatementErrors(statement.getElseElement(), elseBranch.getLastChild(), elseBranch, "else");
        }
    }

    @Contract(value="null->false")
    protected abstract boolean isApplicable(PsiStatement var1);

    @Nullable
    protected abstract Pair<PsiElement, PsiElement> getOmittedBodyBounds(PsiStatement var1);

    private void registerLoopStatementErrors(@NotNull PsiLoopStatement statement, @NotNull PsiStatement body, @NotNull String keywordText) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/style/ControlFlowStatementVisitorBase", "registerLoopStatementErrors"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/siyeh/ig/style/ControlFlowStatementVisitorBase", "registerLoopStatementErrors"));
        }
        if (keywordText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywordText", "com/siyeh/ig/style/ControlFlowStatementVisitorBase", "registerLoopStatementErrors"));
        }
        this.registerControlFlowStatementErrors(statement.getFirstChild(), statement.getLastChild(), body, keywordText);
    }

    private void registerControlFlowStatementErrors(@Nullable PsiElement rangeStart, @Nullable PsiElement rangeEnd, @NotNull PsiStatement body, @NotNull String keywordText) {
        PsiElement afterOmitted;
        PsiElement endOfHighlight;
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/siyeh/ig/style/ControlFlowStatementVisitorBase", "registerControlFlowStatementErrors"));
        }
        if (keywordText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keywordText", "com/siyeh/ig/style/ControlFlowStatementVisitorBase", "registerControlFlowStatementErrors"));
        }
        boolean highlightOnlyKeyword = this.isHighlightOnlyKeyword(body);
        if (highlightOnlyKeyword) {
            if (rangeStart != null) {
                this.registerError(rangeStart, keywordText);
            }
            return;
        }
        Pair<PsiElement, PsiElement> omittedBodyBounds = this.getOmittedBodyBounds(body);
        if (omittedBodyBounds == null) {
            if (rangeStart != null && rangeEnd != null) {
                this.registerErrorAtRange(rangeStart, rangeEnd, keywordText);
            }
            return;
        }
        if (rangeStart != null) {
            PsiElement beforeOmitted = omittedBodyBounds.getFirst();
            endOfHighlight = beforeOmitted != null ? beforeOmitted : rangeStart;
            this.registerErrorAtRange(rangeStart, endOfHighlight, keywordText);
        }
        if ((afterOmitted = omittedBodyBounds.getSecond()) != null) {
            endOfHighlight = afterOmitted;
            if (rangeEnd != null && rangeEnd != afterOmitted) {
                if (afterOmitted.getParent() == rangeEnd) {
                    PsiElement rangeEndLastChild = rangeEnd.getLastChild();
                    if (rangeEndLastChild != null) {
                        endOfHighlight = rangeEndLastChild;
                    }
                } else {
                    endOfHighlight = rangeEnd;
                }
            }
            this.registerErrorAtRange(afterOmitted, endOfHighlight, keywordText);
        }
    }

    private boolean isHighlightOnlyKeyword(PsiElement element) {
        if (!this.isOnTheFly()) {
            return true;
        }
        if (this.myKey != null) {
            Project project = element.getProject();
            InspectionProfile profile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
            HighlightDisplayLevel errorLevel = profile.getErrorLevel(this.myKey, element);
            return !HighlightDisplayLevel.DO_NOT_SHOW.equals(errorLevel);
        }
        return false;
    }
}

