/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;

public class CommandEvent
extends EventObject {
    private final Runnable myCommand;
    private final Project myProject;
    private final String myCommandName;
    private final Object myCommandGroupId;
    private final UndoConfirmationPolicy myUndoConfirmationPolicy;
    private final Document myDocument;

    public CommandEvent(@NotNull CommandProcessor processor, @NotNull Runnable command, Project project, @NotNull UndoConfirmationPolicy undoConfirmationPolicy) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/command/CommandEvent", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/command/CommandEvent", "<init>"));
        }
        if (undoConfirmationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "undoConfirmationPolicy", "com/intellij/openapi/command/CommandEvent", "<init>"));
        }
        this(processor, command, null, null, project, undoConfirmationPolicy);
    }

    public CommandEvent(@NotNull CommandProcessor processor, @NotNull Runnable command, String commandName, Object commandGroupId, Project project, @NotNull UndoConfirmationPolicy undoConfirmationPolicy) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/command/CommandEvent", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/command/CommandEvent", "<init>"));
        }
        if (undoConfirmationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "undoConfirmationPolicy", "com/intellij/openapi/command/CommandEvent", "<init>"));
        }
        this(processor, command, commandName, commandGroupId, project, undoConfirmationPolicy, null);
    }

    public CommandEvent(@NotNull CommandProcessor processor, @NotNull Runnable command, String commandName, Object commandGroupId, Project project, @NotNull UndoConfirmationPolicy undoConfirmationPolicy, Document document) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/openapi/command/CommandEvent", "<init>"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/openapi/command/CommandEvent", "<init>"));
        }
        if (undoConfirmationPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "undoConfirmationPolicy", "com/intellij/openapi/command/CommandEvent", "<init>"));
        }
        super(processor);
        this.myCommand = command;
        this.myCommandName = commandName;
        this.myCommandGroupId = commandGroupId;
        this.myProject = project;
        this.myUndoConfirmationPolicy = undoConfirmationPolicy;
        this.myDocument = document;
    }

    @NotNull
    public CommandProcessor getCommandProcessor() {
        CommandProcessor commandProcessor = (CommandProcessor)this.getSource();
        if (commandProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/CommandEvent", "getCommandProcessor"));
        }
        return commandProcessor;
    }

    @NotNull
    public Runnable getCommand() {
        Runnable runnable = this.myCommand;
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/CommandEvent", "getCommand"));
        }
        return runnable;
    }

    public Project getProject() {
        return this.myProject;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public Object getCommandGroupId() {
        return this.myCommandGroupId;
    }

    @NotNull
    public UndoConfirmationPolicy getUndoConfirmationPolicy() {
        UndoConfirmationPolicy undoConfirmationPolicy = this.myUndoConfirmationPolicy;
        if (undoConfirmationPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/CommandEvent", "getUndoConfirmationPolicy"));
        }
        return undoConfirmationPolicy;
    }

    public Document getDocument() {
        return this.myDocument;
    }
}

