/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.source.PsiJavaFileBaseImpl;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaFileImpl
extends PsiJavaFileBaseImpl {
    public PsiJavaFileImpl(FileViewProvider file) {
        super(JavaStubElementTypes.JAVA_FILE, JavaStubElementTypes.JAVA_FILE, file);
    }

    @Override
    @NotNull
    public FileType getFileType() {
        JavaFileType javaFileType = JavaFileType.INSTANCE;
        if (javaFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaFileImpl", "getFileType"));
        }
        return javaFileType;
    }

    @Override
    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        PsiJavaFileStub stub = (PsiJavaFileStub)this.getStub();
        if (stub != null) {
            return stub.getModule();
        }
        PsiElement element = this.getFirstChild();
        if (element instanceof PsiWhiteSpace || element instanceof PsiComment) {
            element = PsiTreeUtil.skipSiblingsForward(element, PsiWhiteSpace.class, PsiComment.class);
        }
        return element instanceof PsiJavaModule ? (PsiJavaModule)element : null;
    }

    @Override
    public String toString() {
        return "PsiJavaFile:" + this.getName();
    }
}

