/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeHighlighting;

import com.intellij.codeHighlighting.ColorGenerator;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RainbowHighlighter {
    private static final JBColor[] RAINBOW_JB_COLORS_DEFAULT = new JBColor[]{new JBColor(10173290, 5414226), new JBColor(1133943, 12480624), new JBColor(12355152, 4028022), new JBColor(22800, 12491120), new JBColor(12341584, 10310268)};
    private static final TextAttributesKey[] RAINBOW_COLOR_KEYS = new TextAttributesKey[RAINBOW_JB_COLORS_DEFAULT.length];
    private static final int RAINBOW_COLORS_BETWEEN = 4;
    private static final String UNIT_TEST_COLORS = "#000001,#000002,#000003,#000004";
    @NotNull
    private final TextAttributesScheme myColorsScheme;
    @NotNull
    private final Color[] myRainbowColors;
    public static final HighlightInfoType RAINBOW_ELEMENT;

    public RainbowHighlighter(@Nullable TextAttributesScheme colorsScheme) {
        this.myColorsScheme = colorsScheme != null ? colorsScheme : EditorColorsManager.getInstance().getGlobalScheme();
        this.myRainbowColors = RainbowHighlighter.generateColorSequence(this.myColorsScheme);
    }

    public static boolean isRainbowEnabled() {
        return Registry.is("editor.rainbow.identifiers", false);
    }

    @NotNull
    private Color calculateForeground(int colorIndex) {
        Color color = this.myRainbowColors[colorIndex];
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/RainbowHighlighter", "calculateForeground"));
        }
        return color;
    }

    public int getColorsCount() {
        return this.myRainbowColors.length;
    }

    @NotNull
    private static Color[] generateColorSequence(@NotNull TextAttributesScheme colorsScheme) {
        if (colorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/codeHighlighting/RainbowHighlighter", "generateColorSequence"));
        }
        String colorDump = ApplicationManager.getApplication().isUnitTestMode() ? UNIT_TEST_COLORS : Registry.get("rainbow.highlighter.colors").asString();
        List<String> registryColors = StringUtil.split(colorDump, ",");
        if (!registryColors.isEmpty()) {
            Color[] colorArray = (Color[])registryColors.stream().map(s -> ColorUtil.fromHex(s.trim())).toArray(Color[]::new);
            if (colorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/RainbowHighlighter", "generateColorSequence"));
            }
            return colorArray;
        }
        List<Color> foregroundColors = ContainerUtil.map(RAINBOW_COLOR_KEYS, key -> {
            if (colorsScheme == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/codeHighlighting/RainbowHighlighter", "lambda$generateColorSequence$2"));
            }
            return colorsScheme.getAttributes((TextAttributesKey)key).getForegroundColor();
        });
        List<Color> colors = ColorGenerator.generateLinearColorSequence(foregroundColors, 4);
        Color[] colorArray = colors.toArray(new Color[colors.size()]);
        if (colorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeHighlighting/RainbowHighlighter", "generateColorSequence"));
        }
        return colorArray;
    }

    public HighlightInfo getInfo(int colorIndex, @Nullable PsiElement id, @Nullable TextAttributesKey colorKey) {
        if (id == null) {
            return null;
        }
        if (colorKey == null) {
            colorKey = DefaultLanguageHighlighterColors.LOCAL_VARIABLE;
        }
        return HighlightInfo.newHighlightInfo(RAINBOW_ELEMENT).textAttributes(TextAttributes.fromFlyweight(this.myColorsScheme.getAttributes(colorKey).getFlyweight().withForeground(this.calculateForeground(colorIndex)))).range(id).create();
    }

    static {
        for (int i = 0; i < RAINBOW_JB_COLORS_DEFAULT.length; ++i) {
            JBColor jbColor = RAINBOW_JB_COLORS_DEFAULT[i];
            TextAttributes textAttributes = new TextAttributes(jbColor, null, null, null, 0);
            RainbowHighlighter.RAINBOW_COLOR_KEYS[i] = TextAttributesKey.createTextAttributesKey("RAINBOW_COLOR" + i, textAttributes);
        }
        RAINBOW_ELEMENT = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, DefaultLanguageHighlighterColors.CONSTANT);
    }
}

