/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.folding.impl.ParameterNameFoldingManager;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.util.containers.HashSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHintsPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    private static final Key<Boolean> REPEATED_PASS = Key.create("RepeatedParameterHintsPass");

    public ParameterHintsPassFactory(Project project, TextEditorHighlightingPassRegistrar registrar) {
        super(project);
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ParameterHintsPassFactory", "createHighlightingPass"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPassFactory", "createHighlightingPass"));
        }
        return new ParameterHintsPass(file, editor);
    }

    private static class ParameterHintsPass
    extends EditorBoundHighlightingPass {
        private final Map<Integer, String> myAnnotations;

        private ParameterHintsPass(@NotNull PsiFile file, @NotNull Editor editor) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ParameterHintsPassFactory$ParameterHintsPass", "<init>"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPassFactory$ParameterHintsPass", "<init>"));
            }
            super(editor, file, true);
            this.myAnnotations = new HashMap<Integer, String>();
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            PsiClass[] classes;
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/ParameterHintsPassFactory$ParameterHintsPass", "doCollectInformation"));
            }
            assert (this.myDocument != null);
            this.myAnnotations.clear();
            if (!Registry.is("editor.inline.parameter.hints") || !(this.myFile instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)this.myFile;
            for (PsiClass aClass : classes = file.getClasses()) {
                ProgressIndicatorProvider.checkCanceled();
                this.addElementsToFold(aClass);
            }
        }

        private void addElementsToFold(PsiClass aClass) {
            PsiElement[] children;
            for (PsiElement child : children = aClass.getChildren()) {
                ProgressIndicatorProvider.checkCanceled();
                if (child instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)child;
                    PsiCodeBlock body = method.getBody();
                    if (body == null) continue;
                    this.addCodeBlockFolds(body);
                    continue;
                }
                if (child instanceof PsiField) {
                    PsiField field = (PsiField)child;
                    PsiExpression initializer = field.getInitializer();
                    if (initializer != null) {
                        this.addCodeBlockFolds(initializer);
                        continue;
                    }
                    if (!(field instanceof PsiEnumConstant)) continue;
                    this.addCodeBlockFolds(field);
                    continue;
                }
                if (child instanceof PsiClassInitializer) {
                    PsiClassInitializer initializer = (PsiClassInitializer)child;
                    this.addCodeBlockFolds(initializer);
                    continue;
                }
                if (!(child instanceof PsiClass)) continue;
                this.addElementsToFold((PsiClass)child);
            }
        }

        private void addCodeBlockFolds(PsiElement scope) {
            scope.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitClass(PsiClass aClass) {
                    this.addElementsToFold(aClass);
                }

                @Override
                public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                    this.inlineLiteralArgumentsNames(expression);
                    super.visitMethodCallExpression(expression);
                }

                @Override
                public void visitNewExpression(PsiNewExpression expression) {
                    this.inlineLiteralArgumentsNames(expression);
                    super.visitNewExpression(expression);
                }
            });
        }

        private void inlineLiteralArgumentsNames(@NotNull PsiCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/ParameterHintsPassFactory$ParameterHintsPass", "inlineLiteralArgumentsNames"));
            }
            ParameterNameFoldingManager manager = new ParameterNameFoldingManager(expression);
            List<FoldingDescriptor> descriptors = manager.getDescriptors();
            for (FoldingDescriptor descriptor : descriptors) {
                String text = descriptor.getPlaceholderText();
                assert (text != null);
                int colonPos = text.indexOf(58);
                this.myAnnotations.put(descriptor.getRange().getEndOffset(), text.substring(1, colonPos));
            }
        }

        @Override
        public void doApplyInformationToEditor() {
            int offset;
            assert (this.myDocument != null);
            boolean firstTime = this.myEditor.getUserData(REPEATED_PASS) == null;
            ParameterHintsPresentationManager presentationManager = ParameterHintsPresentationManager.getInstance();
            HashSet<String> removedHints = new HashSet<String>();
            for (Inlay inlay : this.myEditor.getInlayModel().getInlineElementsInRange(0, this.myDocument.getTextLength())) {
                if (!presentationManager.isParameterHint(inlay)) continue;
                offset = inlay.getOffset();
                String oldText = presentationManager.getHintText(inlay);
                String newText = this.myAnnotations.remove(offset);
                if (Objects.equals(newText, oldText)) continue;
                if (newText == null) {
                    removedHints.add(oldText);
                    presentationManager.deleteHint(this.myEditor, inlay);
                    continue;
                }
                presentationManager.replaceHint(this.myEditor, inlay, newText);
            }
            for (Map.Entry entry : this.myAnnotations.entrySet()) {
                offset = (Integer)entry.getKey();
                String text = (String)entry.getValue();
                presentationManager.addHint(this.myEditor, offset, text, !firstTime && !removedHints.contains(text));
            }
            this.myEditor.putUserData(REPEATED_PASS, Boolean.TRUE);
        }
    }
}

