/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHintsPresentationManager
implements Disposable {
    private static final Key<FontMetrics> HINT_FONT_METRICS = Key.create("ParameterHintFontMetrics");
    private static final Key<AnimationStep> ANIMATION_STEP = Key.create("ParameterHintAnimationStep");
    private static final int ANIMATION_STEP_MS = 25;
    private static final int ANIMATION_CHARS_PER_STEP = 3;
    private final Alarm myAlarm = new Alarm((Disposable)this);

    public static ParameterHintsPresentationManager getInstance() {
        return ServiceManager.getService(ParameterHintsPresentationManager.class);
    }

    private ParameterHintsPresentationManager() {
    }

    public boolean isParameterHint(@NotNull Inlay inlay) {
        if (inlay == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlay", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "isParameterHint"));
        }
        return inlay.getRenderer() instanceof MyRenderer;
    }

    public String getHintText(@NotNull Inlay inlay) {
        if (inlay == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlay", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "getHintText"));
        }
        EditorCustomElementRenderer renderer = inlay.getRenderer();
        return renderer instanceof MyRenderer ? ((MyRenderer)renderer).myText : null;
    }

    public void addHint(@NotNull Editor editor, int offset, @NotNull String hintText, boolean useAnimation) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "addHint"));
        }
        if (hintText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintText", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "addHint"));
        }
        MyRenderer renderer = new MyRenderer(editor, hintText, useAnimation);
        Inlay inlay = editor.getInlayModel().addInlineElement(offset, renderer);
        if (useAnimation && inlay != null) {
            this.scheduleRendererUpdate(editor, inlay);
        }
    }

    public void deleteHint(@NotNull Editor editor, @NotNull Inlay hint) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "deleteHint"));
        }
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "deleteHint"));
        }
        this.updateRenderer(editor, hint, null);
    }

    public void replaceHint(@NotNull Editor editor, @NotNull Inlay hint, @NotNull String newText) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "replaceHint"));
        }
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "replaceHint"));
        }
        if (newText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newText", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "replaceHint"));
        }
        this.updateRenderer(editor, hint, newText);
    }

    private void updateRenderer(@NotNull Editor editor, @NotNull Inlay hint, @Nullable String newText) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "updateRenderer"));
        }
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "updateRenderer"));
        }
        MyRenderer renderer = (MyRenderer)hint.getRenderer();
        renderer.update(editor, newText);
        hint.updateSize();
        this.scheduleRendererUpdate(editor, hint);
    }

    @Override
    public void dispose() {
    }

    private void scheduleRendererUpdate(Editor editor, Inlay inlay) {
        AnimationStep step = editor.getUserData(ANIMATION_STEP);
        if (step == null) {
            step = new AnimationStep(editor);
            editor.putUserData(ANIMATION_STEP, step);
        }
        step.inlays.add(inlay);
        this.scheduleAnimationStep(step);
    }

    private void scheduleAnimationStep(AnimationStep step) {
        this.myAlarm.cancelRequest((Runnable)step);
        this.myAlarm.addRequest((Runnable)step, 25, ModalityState.any());
    }

    private static Font getFont(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "getFont"));
        }
        return ParameterHintsPresentationManager.getFontMetrics(editor).getFont();
    }

    private static FontMetrics getFontMetrics(@NotNull Editor editor) {
        Font font;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager", "getFontMetrics"));
        }
        String familyName = UIManager.getFont("Label.font").getFamily();
        int size = Math.max(1, editor.getColorsScheme().getEditorFontSize() - 1);
        FontMetrics metrics = editor.getUserData(HINT_FONT_METRICS);
        if (!(metrics == null || familyName.equals((font = metrics.getFont()).getFamily()) && size == font.getSize())) {
            metrics = null;
        }
        if (metrics == null) {
            font = new Font(familyName, 0, size);
            metrics = FontInfo.createReferenceGraphics().getFontMetrics(font);
            editor.putUserData(HINT_FONT_METRICS, metrics);
        }
        return metrics;
    }

    private class AnimationStep
    implements Runnable {
        private final Editor myEditor;
        private final Set<Inlay> inlays = new HashSet<Inlay>();

        AnimationStep(Editor editor) {
            this.myEditor = editor;
        }

        @Override
        public void run() {
            Iterator<Inlay> it = this.inlays.iterator();
            while (it.hasNext()) {
                Inlay inlay = it.next();
                if (inlay.isValid()) {
                    MyRenderer renderer = (MyRenderer)inlay.getRenderer();
                    if (!renderer.nextStep()) {
                        it.remove();
                    }
                    if (renderer.calcWidthInPixels(this.myEditor) == 0) {
                        Disposer.dispose(inlay);
                        continue;
                    }
                    inlay.updateSize();
                    continue;
                }
                it.remove();
            }
            if (this.inlays.isEmpty()) {
                this.myEditor.putUserData(ANIMATION_STEP, null);
            } else {
                ParameterHintsPresentationManager.this.scheduleAnimationStep(this);
            }
        }
    }

    private static class MyRenderer
    implements EditorCustomElementRenderer {
        private String myText;
        private int startWidth;
        private int steps;
        private int step;

        private MyRenderer(Editor editor, String text, boolean animated) {
            this.updateState(editor, text);
            if (!animated) {
                this.step = this.steps + 1;
            }
        }

        public void update(Editor editor, String newText) {
            this.updateState(editor, newText);
        }

        private void updateState(Editor editor, String text) {
            FontMetrics metrics = ParameterHintsPresentationManager.getFontMetrics(editor);
            this.startWidth = MyRenderer.doCalcWidth(this.myText, metrics);
            this.myText = text;
            int endWidth = MyRenderer.doCalcWidth(this.myText, metrics);
            this.step = 1;
            this.steps = Math.max(1, Math.abs(endWidth - this.startWidth) / metrics.charWidth('a') / 3);
        }

        public boolean nextStep() {
            return ++this.step <= this.steps;
        }

        @Override
        public int calcWidthInPixels(@NotNull Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$MyRenderer", "calcWidthInPixels"));
            }
            FontMetrics metrics = ParameterHintsPresentationManager.getFontMetrics(editor);
            int endWidth = MyRenderer.doCalcWidth(this.myText, metrics);
            return this.step <= this.steps ? Math.max(1, this.startWidth + (endWidth - this.startWidth) / this.steps * this.step) : endWidth;
        }

        private static int doCalcWidth(@Nullable String text, @NotNull FontMetrics fontMetrics) {
            if (fontMetrics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontMetrics", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$MyRenderer", "doCalcWidth"));
            }
            return text == null ? 0 : fontMetrics.stringWidth(text) + 14;
        }

        @Override
        public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
            TextAttributes attributes;
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$MyRenderer", "paint"));
            }
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$MyRenderer", "paint"));
            }
            if (r == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/codeInsight/daemon/impl/ParameterHintsPresentationManager$MyRenderer", "paint"));
            }
            if (this.myText != null && (this.step > this.steps || this.startWidth != 0) && (attributes = editor.getColorsScheme().getAttributes(JavaHighlightingColors.INLINE_PARAMETER_HINT)) != null) {
                Color foregroundColor;
                Color backgroundColor = attributes.getBackgroundColor();
                if (backgroundColor != null) {
                    GraphicsConfig config = GraphicsUtil.setupAAPainting(g);
                    int shadeRectHeight = Math.min(4, r.height - 3);
                    g.setColor(ColorUtil.darker(backgroundColor, 1));
                    g.fillRoundRect(r.x + 2, r.y + r.height - shadeRectHeight - 1, r.width - 4, shadeRectHeight, 4, 4);
                    g.setColor(backgroundColor);
                    g.fillRoundRect(r.x + 2, r.y + 1, r.width - 4, r.height - 3, 4, 4);
                    config.restore();
                }
                if ((foregroundColor = attributes.getForegroundColor()) != null) {
                    g.setColor(foregroundColor);
                    g.setFont(ParameterHintsPresentationManager.getFont(editor));
                    FontMetrics metrics = g.getFontMetrics();
                    Shape savedClip = g.getClip();
                    g.clipRect(r.x + 3, r.y + 1, r.width - 6, r.height - 3);
                    int editorAscent = editor instanceof EditorImpl ? ((EditorImpl)editor).getAscent() : 0;
                    g.drawString(this.myText, r.x + 7, r.y + Math.max(editorAscent, (r.height + metrics.getAscent() - metrics.getDescent()) / 2) - 1);
                    g.setClip(savedClip);
                }
            }
        }
    }
}

