/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.ModulesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaModuleGraphBuilder {
    private JavaModuleGraphBuilder() {
    }

    @Nullable
    public static Graph<PsiJavaModule> getOrBuild(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphBuilder", "getOrBuild"));
        }
        return (Graph)CachedValuesManager.getManager(project).getCachedValue(project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphBuilder", "lambda$getOrBuild$1"));
            }
            Graph graph = ReadAction.compute(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphBuilder", "lambda$null$0"));
                }
                return JavaModuleGraphBuilder.build(project);
            });
            return CachedValueProvider.Result.create(graph, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        });
    }

    @Nullable
    public static Collection<PsiJavaModule> findCycle(@NotNull Graph<PsiJavaModule> graph, @NotNull PsiJavaModule module) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphBuilder", "findCycle"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphBuilder", "findCycle"));
        }
        return ((JavaModuleGraph)graph).myCycles.stream().filter(set -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphBuilder", "lambda$findCycle$2"));
            }
            return set.contains(module);
        }).findFirst().orElse(null);
    }

    private static Graph<PsiJavaModule> build(Project project) {
        HashSet<PsiJavaModule> projectModules = ContainerUtil.newHashSet();
        for (Module module : ModuleManager.getInstance(project).getModules()) {
            PsiJavaModule moduleDeclaration;
            PsiFile psiFile;
            Collection<VirtualFile> files = FilenameIndex.getVirtualFilesByName(project, "module-info.java", new ModulesScope(module));
            if (files.size() > 1) {
                return null;
            }
            VirtualFile vFile = ContainerUtil.getFirstItem(files);
            if (vFile == null || !((psiFile = PsiManager.getInstance(project).findFile(vFile)) instanceof PsiJavaFile) || (moduleDeclaration = ((PsiJavaFile)psiFile).getModuleDeclaration()) == null) continue;
            projectModules.add(moduleDeclaration);
        }
        MultiMap<PsiJavaModule, PsiJavaModule> relations = MultiMap.create();
        for (PsiJavaModule moduleDeclaration : projectModules) {
            for (PsiRequiresStatement statement : SyntaxTraverser.psiTraverser().children(moduleDeclaration).filter(PsiRequiresStatement.class)) {
                PsiJavaModule dependency = JavaModuleGraphBuilder.resolveDependency(statement);
                if (dependency == null || !projectModules.contains(dependency)) continue;
                relations.putValue(moduleDeclaration, dependency);
            }
        }
        return new JavaModuleGraph(relations);
    }

    private static PsiJavaModule resolveDependency(PsiRequiresStatement statement) {
        PsiElement target;
        PsiPolyVariantReference ref;
        PsiJavaModuleReferenceElement refElement = statement.getReferenceElement();
        if (refElement != null && (ref = refElement.getReference()) != null && (target = ref.resolve()) instanceof PsiJavaModule) {
            return (PsiJavaModule)target;
        }
        return null;
    }

    private static class JavaModuleGraph
    implements Graph<PsiJavaModule> {
        private final MultiMap<PsiJavaModule, PsiJavaModule> myMap;
        private final List<Set<PsiJavaModule>> myCycles;

        public JavaModuleGraph(MultiMap<PsiJavaModule, PsiJavaModule> map) {
            this.myMap = map;
            DFSTBuilder<PsiJavaModule> builder = new DFSTBuilder<PsiJavaModule>(this);
            this.myCycles = builder.getComponents().stream().map(ContainerUtil::newLinkedHashSet).collect(Collectors.toList());
        }

        @Override
        public Collection<PsiJavaModule> getNodes() {
            return this.myMap.keySet();
        }

        @Override
        public Iterator<PsiJavaModule> getIn(PsiJavaModule n) {
            return ContainerUtil.emptyIterator();
        }

        @Override
        public Iterator<PsiJavaModule> getOut(PsiJavaModule n) {
            return this.myMap.get(n).iterator();
        }
    }
}

