/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyStreamApiCallChainsInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final String FOR_EACH_METHOD = "forEach";
    private static final String FOR_EACH_ORDERED_METHOD = "forEachOrdered";
    private static final String COUNT_METHOD = "count";
    private static final String SIZE_METHOD = "size";
    private static final String STREAM_METHOD = "stream";
    private static final String EMPTY_METHOD = "empty";
    private static final String AS_LIST_METHOD = "asList";
    private static final String OF_METHOD = "of";
    private static final String EMPTY_LIST_METHOD = "emptyList";
    private static final String EMPTY_SET_METHOD = "emptySet";
    private static final String SINGLETON_LIST_METHOD = "singletonList";
    private static final String SINGLETON_METHOD = "singleton";

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                PsiMethod method = methodCall.resolveMethod();
                if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.Collection", SimplifyStreamApiCallChainsInspection.STREAM_METHOD, 0)) {
                    PsiMethodCallExpression qualifierCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(methodCall);
                    if (qualifierCall == null) {
                        return;
                    }
                    PsiMethod qualifier = qualifierCall.resolveMethod();
                    ReplaceCollectionStreamFix fix = null;
                    if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Arrays", SimplifyStreamApiCallChainsInspection.AS_LIST_METHOD, 1)) {
                        fix = SimplifyStreamApiCallChainsInspection.hasSingleArrayArgument(qualifierCall) ? new ArraysAsListSingleArrayFix() : new ReplaceWithStreamOfFix("Arrays.asList()");
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collections", SimplifyStreamApiCallChainsInspection.SINGLETON_LIST_METHOD, 1)) {
                        if (!SimplifyStreamApiCallChainsInspection.hasSingleArrayArgument(qualifierCall)) {
                            fix = new ReplaceSingletonWithStreamOfFix("Collections.singletonList()");
                        }
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collections", SimplifyStreamApiCallChainsInspection.SINGLETON_METHOD, 1)) {
                        if (!SimplifyStreamApiCallChainsInspection.hasSingleArrayArgument(qualifierCall)) {
                            fix = new ReplaceSingletonWithStreamOfFix("Collections.singleton()");
                        }
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collections", SimplifyStreamApiCallChainsInspection.EMPTY_LIST_METHOD, 0)) {
                        fix = new ReplaceWithStreamEmptyFix(SimplifyStreamApiCallChainsInspection.EMPTY_LIST_METHOD);
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collections", SimplifyStreamApiCallChainsInspection.EMPTY_SET_METHOD, 0)) {
                        fix = new ReplaceWithStreamEmptyFix(SimplifyStreamApiCallChainsInspection.EMPTY_SET_METHOD);
                    }
                    if (fix != null) {
                        holder.registerProblem((PsiElement)methodCall, null, fix.getMessage(), fix);
                    }
                } else {
                    String name;
                    if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD, 1)) {
                        name = SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD;
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.FOR_EACH_ORDERED_METHOD, 1)) {
                        name = SimplifyStreamApiCallChainsInspection.FOR_EACH_ORDERED_METHOD;
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.COUNT_METHOD, 0)) {
                        name = SimplifyStreamApiCallChainsInspection.COUNT_METHOD;
                    } else {
                        return;
                    }
                    PsiMethodCallExpression qualifierCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(methodCall);
                    if (qualifierCall == null) {
                        return;
                    }
                    PsiMethod qualifier = qualifierCall.resolveMethod();
                    if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collection", SimplifyStreamApiCallChainsInspection.STREAM_METHOD, 0)) {
                        ReplaceStreamMethodFix fix = SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD.equals(name) ? new ReplaceStreamMethodFix(name, SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD, false) : (SimplifyStreamApiCallChainsInspection.FOR_EACH_ORDERED_METHOD.equals(name) ? new ReplaceStreamMethodFix(name, SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD, true) : new ReplaceStreamMethodFix(name, SimplifyStreamApiCallChainsInspection.SIZE_METHOD, false));
                        holder.registerProblem((PsiElement)methodCall, SimplifyStreamApiCallChainsInspection.this.getCallChainRange(methodCall, qualifierCall), fix.getMessage(), fix);
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    static boolean hasSingleArrayArgument(PsiMethodCallExpression qualifierCall) {
        PsiType type;
        PsiExpression[] argumentExpressions = qualifierCall.getArgumentList().getExpressions();
        if (argumentExpressions.length == 1 && (type = argumentExpressions[0].getType()) instanceof PsiArrayType) {
            PsiType[] parameters;
            PsiType methodType = qualifierCall.getType();
            return !(methodType instanceof PsiClassType) || (parameters = ((PsiClassType)methodType).getParameters()).length != 1 || !TypeConversionUtil.isAssignable(parameters[0], type) || TypeConversionUtil.isAssignable(parameters[0], ((PsiArrayType)type).getComponentType());
        }
        return false;
    }

    @Nullable
    private static PsiMethodCallExpression getQualifierMethodCall(PsiMethodCallExpression methodCall) {
        PsiExpression qualifierExpression = methodCall.getMethodExpression().getQualifierExpression();
        if (qualifierExpression instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)qualifierExpression;
        }
        return null;
    }

    @NotNull
    protected TextRange getCallChainRange(@NotNull PsiMethodCallExpression expression, @NotNull PsiMethodCallExpression qualifierExpression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        if (qualifierExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierExpression", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        PsiReferenceExpression qualifierMethodExpression = qualifierExpression.getMethodExpression();
        PsiElement qualifierNameElement = qualifierMethodExpression.getReferenceNameElement();
        int startOffset = (qualifierNameElement != null ? qualifierNameElement : qualifierMethodExpression).getTextOffset();
        int endOffset = expression.getMethodExpression().getTextRange().getEndOffset();
        TextRange textRange = new TextRange(startOffset, endOffset).shiftRight(-expression.getTextOffset());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        return textRange;
    }

    @Contract(value="null, _, _, _ -> false")
    protected static boolean isCallOf(@Nullable PsiMethod method, @NotNull String className, @NotNull String methodName, int parametersCount) {
        PsiClass containingClass;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "isCallOf"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "isCallOf"));
        }
        if (method == null) {
            return false;
        }
        return methodName.equals(method.getName()) && method.getParameterList().getParametersCount() == parametersCount && (containingClass = method.getContainingClass()) != null && className.equals(containingClass.getQualifiedName());
    }

    private static class ReplaceStreamMethodFix
    extends CallChainFixBase {
        private final String myStreamMethod;
        private final String myCollectionMethod;
        private final boolean myChangeSemantics;

        public ReplaceStreamMethodFix(String streamMethod, String collectionMethod, boolean changeSemantics) {
            this.myStreamMethod = streamMethod;
            this.myCollectionMethod = collectionMethod;
            this.myChangeSemantics = changeSemantics;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = "Replace Collection.stream()." + this.myStreamMethod + "() with Collection." + this.myCollectionMethod + "()" + (this.myChangeSemantics ? " (may change semantics)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceStreamMethodFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        String getMessage() {
            String string = "Collection.stream()." + this.myStreamMethod + "() can be replaced with Collection." + this.myCollectionMethod + "()" + (this.myChangeSemantics ? " (may change semantics)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceStreamMethodFix", "getMessage"));
            }
            return string;
        }

        @Override
        protected void replaceMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiMethodCallExpression qualifierCall, @Nullable PsiExpression qualifierExpression) {
            PsiElement nameElement;
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceStreamMethodFix", "replaceMethodCall"));
            }
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceStreamMethodFix", "replaceMethodCall"));
            }
            if (qualifierExpression != null && (nameElement = methodCall.getMethodExpression().getReferenceNameElement()) != null) {
                qualifierCall.replace(qualifierExpression);
                if (!this.myStreamMethod.equals(this.myCollectionMethod)) {
                    Project project = methodCall.getProject();
                    PsiIdentifier collectionMethod = JavaPsiFacade.getElementFactory(project).createIdentifier(this.myCollectionMethod);
                    nameElement.replace(collectionMethod);
                }
            }
        }
    }

    private static class ReplaceWithStreamEmptyFix
    extends ReplaceCollectionStreamFix {
        private ReplaceWithStreamEmptyFix(String qualifierMethodName) {
            super("Collections." + qualifierMethodName + "()", "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.EMPTY_METHOD);
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with Stream.empty()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceWithStreamEmptyFix", "getFamilyName"));
            }
            return "Replace with Stream.empty()";
        }
    }

    private static class ArraysAsListSingleArrayFix
    extends ReplaceCollectionStreamFix {
        private ArraysAsListSingleArrayFix() {
            super("Arrays.asList()", "java.util.Arrays", SimplifyStreamApiCallChainsInspection.STREAM_METHOD);
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace Arrays.asList().stream() with Arrays.stream()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListSingleArrayFix", "getFamilyName"));
            }
            return "Replace Arrays.asList().stream() with Arrays.stream()";
        }
    }

    private static class ReplaceSingletonWithStreamOfFix
    extends ReplaceWithStreamOfFix {
        private ReplaceSingletonWithStreamOfFix(String qualifierCall) {
            super(qualifierCall);
        }

        @Override
        @Nullable
        protected String getTypeParameter(@NotNull PsiMethodCallExpression qualifierCall) {
            PsiType argType;
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceSingletonWithStreamOfFix", "getTypeParameter"));
            }
            String typeParameter = super.getTypeParameter(qualifierCall);
            if (typeParameter != null) {
                return typeParameter;
            }
            PsiType[] argTypes = qualifierCall.getArgumentList().getExpressionTypes();
            if (argTypes.length == 1 && (argType = argTypes[0]) instanceof PsiArrayType) {
                return argType.getCanonicalText();
            }
            return null;
        }
    }

    private static class ReplaceWithStreamOfFix
    extends ReplaceCollectionStreamFix {
        private ReplaceWithStreamOfFix(String qualifierCall) {
            super(qualifierCall, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.OF_METHOD);
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with Stream.of()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceWithStreamOfFix", "getFamilyName"));
            }
            return "Replace with Stream.of()";
        }
    }

    private static abstract class ReplaceCollectionStreamFix
    extends CallChainFixBase {
        private final String myClassName;
        private final String myMethodName;
        private final String myQualifierCall;

        private ReplaceCollectionStreamFix(String qualifierCall, String className, String methodName) {
            this.myQualifierCall = qualifierCall;
            this.myClassName = className;
            this.myMethodName = methodName;
        }

        @NotNull
        String getMessage() {
            String string = this.myQualifierCall + ".stream() can be replaced with " + ClassUtil.extractClassName(this.myClassName) + "." + this.myMethodName + "()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "getMessage"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace " + this.myQualifierCall + ".stream() with " + ClassUtil.extractClassName(this.myClassName) + "." + this.myMethodName + "()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "getName"));
            }
            return string;
        }

        @Nullable
        protected String getTypeParameter(@NotNull PsiMethodCallExpression qualifierCall) {
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "getTypeParameter"));
            }
            PsiType[] parameters = qualifierCall.getMethodExpression().getTypeParameters();
            return parameters.length == 1 ? parameters[0].getCanonicalText() : null;
        }

        @Override
        protected void replaceMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiMethodCallExpression qualifierCall, @Nullable PsiExpression qualifierExpression) {
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "replaceMethodCall"));
            }
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "replaceMethodCall"));
            }
            methodCall.getArgumentList().replace(qualifierCall.getArgumentList());
            Project project = methodCall.getProject();
            String typeParameter = this.getTypeParameter(qualifierCall);
            String replacement = typeParameter != null ? this.myClassName + ".<" + typeParameter + ">" + this.myMethodName : this.myClassName + "." + this.myMethodName;
            PsiExpression newMethodExpression = JavaPsiFacade.getElementFactory(project).createExpressionFromText(replacement, methodCall);
            JavaCodeStyleManager.getInstance(project).shortenClassReferences(methodCall.getMethodExpression().replace(newMethodExpression));
        }
    }

    private static abstract class CallChainFixBase
    implements LocalQuickFix {
        private CallChainFixBase() {
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CallChainFixBase", "getName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CallChainFixBase", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CallChainFixBase", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (element instanceof PsiMethodCallExpression) {
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element.getContainingFile())) {
                    return;
                }
                PsiMethodCallExpression expression = (PsiMethodCallExpression)element;
                PsiExpression forEachMethodQualifier = expression.getMethodExpression().getQualifierExpression();
                if (forEachMethodQualifier instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression previousExpression = (PsiMethodCallExpression)forEachMethodQualifier;
                    PsiExpression qualifierExpression = previousExpression.getMethodExpression().getQualifierExpression();
                    this.replaceMethodCall(expression, previousExpression, qualifierExpression);
                }
            }
        }

        protected abstract void replaceMethodCall(@NotNull PsiMethodCallExpression var1, @NotNull PsiMethodCallExpression var2, @Nullable PsiExpression var3);
    }
}

