/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamApiMigrationInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance("#" + StreamApiMigrationInspection.class.getName());
    public boolean REPLACE_TRIVIAL_FOREACH;

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Replace trivial foreach statements", this, "REPLACE_TRIVIAL_FOREACH");
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("foreach loop can be collapsed with Stream API" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getDisplayName"));
        }
        return "foreach loop can be collapsed with Stream API";
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("Convert2streamapi" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getShortName"));
        }
        return "Convert2streamapi";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/StreamApiMigrationInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitForeachStatement(PsiForeachStatement statement) {
                super.visitForeachStatement(statement);
                if (PsiUtil.getLanguageLevel(statement).isAtLeast(LanguageLevel.JDK_1_8)) {
                    PsiExpression iteratedValue = statement.getIteratedValue();
                    PsiStatement body = statement.getBody();
                    if (iteratedValue != null && body != null) {
                        PsiType iteratedValueType = iteratedValue.getType();
                        PsiClass iteratorClass = PsiUtil.resolveClassInClassTypeOnly(iteratedValueType);
                        PsiClass collectionClass = JavaPsiFacade.getInstance(body.getProject()).findClass("java.util.Collection", statement.getResolveScope());
                        if (collectionClass != null && InheritanceUtil.isInheritorOrSelf(iteratorClass, collectionClass, true)) {
                            try {
                                ControlFlow controlFlow = ControlFlowFactory.getInstance(holder.getProject()).getControlFlow(body, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                                int startOffset = controlFlow.getStartOffset(body);
                                int endOffset = controlFlow.getEndOffset(body);
                                Collection<PsiStatement> exitPoints = ControlFlowUtil.findExitPointsAndStatements(controlFlow, startOffset, endOffset, new IntArrayList(), PsiContinueStatement.class, PsiBreakStatement.class, PsiReturnStatement.class, PsiThrowStatement.class);
                                if (exitPoints.isEmpty()) {
                                    List<PsiVariable> usedVariables = ControlFlowUtil.getUsedVariables(controlFlow, startOffset, endOffset);
                                    for (PsiVariable variable : usedVariables) {
                                        if (HighlightControlFlowUtil.isEffectivelyFinal(variable, body, null)) continue;
                                        return;
                                    }
                                    if (ExceptionUtil.getThrownCheckedExceptions(new PsiElement[]{body}).isEmpty()) {
                                        if (!this.isRawSubstitution(iteratedValueType, collectionClass) && StreamApiMigrationInspection.isCollectCall(body, statement.getIterationParameter())) {
                                            boolean addAll = StreamApiMigrationInspection.isAddAllCall(statement, body);
                                            holder.registerProblem((PsiElement)iteratedValue, "Can be replaced with " + (addAll ? "addAll call" : "collect call"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, addAll ? new ReplaceWithAddAllFix() : new ReplaceWithCollectFix());
                                        } else if (StreamApiMigrationInspection.this.REPLACE_TRIVIAL_FOREACH || !StreamApiMigrationInspection.isTrivial(body, statement.getIterationParameter())) {
                                            ArrayList<ReplaceWithForeachCallFix> fixes = new ArrayList<ReplaceWithForeachCallFix>();
                                            fixes.add(new ReplaceWithForeachCallFix("forEach"));
                                            if (StreamApiMigrationInspection.extractIfStatement(body) != null) {
                                                fixes.add(new ReplaceWithForeachCallFix("forEachOrdered"));
                                            }
                                            holder.registerProblem((PsiElement)iteratedValue, "Can be replaced with foreach call", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes.toArray(new LocalQuickFix[fixes.size()]));
                                        }
                                    }
                                }
                            }
                            catch (AnalysisCanceledException analysisCanceledException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }

            private boolean isRawSubstitution(PsiType iteratedValueType, PsiClass collectionClass) {
                return iteratedValueType instanceof PsiClassType && PsiUtil.isRawSubstitutor(collectionClass, TypeConversionUtil.getSuperClassSubstitutor(collectionClass, (PsiClassType)iteratedValueType));
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static boolean isAddAllCall(PsiForeachStatement statement, PsiStatement body) {
        PsiIfStatement ifStatement = StreamApiMigrationInspection.extractIfStatement(body);
        if (ifStatement == null) {
            PsiParameter parameter = statement.getIterationParameter();
            PsiMethodCallExpression methodCallExpression = StreamApiMigrationInspection.extractAddCall(body, null);
            LOG.assertTrue(methodCallExpression != null);
            return StreamApiMigrationInspection.isIdentityMapping(parameter, methodCallExpression.getArgumentList().getExpressions()[0]);
        }
        return false;
    }

    private static boolean isCollectCall(PsiStatement body, PsiParameter parameter) {
        PsiIfStatement ifStatement = StreamApiMigrationInspection.extractIfStatement(body);
        PsiMethodCallExpression methodCallExpression = StreamApiMigrationInspection.extractAddCall(body, ifStatement);
        if (methodCallExpression != null) {
            PsiClass enclosingClass;
            PsiElement resolve;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            PsiClass qualifierClass = null;
            if (qualifierExpression instanceof PsiReferenceExpression) {
                if (ReferencesSearch.search(parameter, new LocalSearchScope(qualifierExpression)).findFirst() != null) {
                    return false;
                }
                resolve = ((PsiReferenceExpression)qualifierExpression).resolve();
                if (resolve instanceof PsiVariable && ReferencesSearch.search(resolve, new LocalSearchScope(methodCallExpression.getArgumentList())).findFirst() != null) {
                    return false;
                }
                qualifierClass = PsiUtil.resolveClassInType(qualifierExpression.getType());
            } else if (qualifierExpression == null && PsiUtil.getEnclosingStaticElement(body, enclosingClass = PsiTreeUtil.getParentOfType((PsiElement)body, PsiClass.class)) == null) {
                qualifierClass = enclosingClass;
            }
            if (qualifierClass != null && InheritanceUtil.isInheritor(qualifierClass, false, "java.util.Collection")) {
                PsiExpression[] args;
                while (ifStatement != null && PsiTreeUtil.isAncestor(body, ifStatement, false)) {
                    PsiExpression condition = ifStatement.getCondition();
                    if (condition != null && StreamApiMigrationInspection.isConditionDependsOnUpdatedCollections(condition, qualifierExpression)) {
                        return false;
                    }
                    ifStatement = PsiTreeUtil.getParentOfType((PsiElement)ifStatement, PsiIfStatement.class);
                }
                resolve = methodExpression.resolve();
                if (resolve instanceof PsiMethod && "add".equals(((PsiMethod)resolve).getName()) && ((PsiMethod)resolve).getParameterList().getParametersCount() == 1 && (args = methodCallExpression.getArgumentList().getExpressions()).length == 1) {
                    if (args[0] instanceof PsiCallExpression) {
                        PsiMethod method = ((PsiCallExpression)args[0]).resolveMethod();
                        return method != null && !method.hasTypeParameters() && !StreamApiMigrationInspection.isThrowsCompatible(method);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isConditionDependsOnUpdatedCollections(PsiExpression condition, PsiExpression qualifierExpression) {
        PsiElement collection;
        PsiElement psiElement = collection = qualifierExpression instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifierExpression).resolve() : null;
        if (collection != null) {
            return ReferencesSearch.search(collection, new LocalSearchScope(condition)).findFirst() != null;
        }
        final boolean[] dependsOnCollection = new boolean[]{false};
        condition.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiExpression callQualifier = expression.getMethodExpression().getQualifierExpression();
                if (callQualifier == null || callQualifier instanceof PsiThisExpression && ((PsiThisExpression)callQualifier).getQualifier() == null || callQualifier instanceof PsiSuperExpression && ((PsiSuperExpression)callQualifier).getQualifier() == null) {
                    dependsOnCollection[0] = true;
                }
            }

            @Override
            public void visitThisExpression(PsiThisExpression expression) {
                super.visitThisExpression(expression);
                if (expression.getQualifier() == null && expression.getParent() instanceof PsiExpressionList) {
                    dependsOnCollection[0] = true;
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression) {
            }
        });
        return dependsOnCollection[0];
    }

    private static boolean isTrivial(PsiStatement body, PsiParameter parameter) {
        PsiIfStatement ifStatement = StreamApiMigrationInspection.extractIfStatement(body);
        if (ifStatement != null) {
            return false;
        }
        PsiCallExpression callExpression = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(body instanceof PsiBlockStatement ? ((PsiBlockStatement)body).getCodeBlock() : body, new PsiParameter[]{parameter}, StreamApiMigrationInspection.createDefaultConsumerType(parameter.getProject(), parameter));
        if (callExpression == null) {
            return true;
        }
        PsiMethod method = callExpression.resolveMethod();
        return method != null && StreamApiMigrationInspection.isThrowsCompatible(method);
    }

    private static boolean isThrowsCompatible(PsiMethod method) {
        return ContainerUtil.find(method.getThrowsList().getReferencedTypes(), type -> !ExceptionUtil.isUncheckedException(type)) != null;
    }

    private static boolean isIdentityMapping(PsiParameter parameter, PsiExpression mapperCall) {
        return mapperCall instanceof PsiReferenceExpression && ((PsiReferenceExpression)mapperCall).resolve() == parameter;
    }

    private static PsiClassType createDefaultConsumerType(Project project, PsiParameter parameter) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiClass consumerClass = psiFacade.findClass("java.util.function.Consumer", GlobalSearchScope.allScope(project));
        return consumerClass != null ? psiFacade.getElementFactory().createType(consumerClass, parameter.getType()) : null;
    }

    private static String compoundLambdaOrMethodReference(PsiParameter parameter, PsiExpression expression, String samQualifiedName, PsiType[] samParamTypes) {
        String result = "";
        Project project = parameter.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiClass functionClass = psiFacade.findClass(samQualifiedName, GlobalSearchScope.allScope(project));
        for (int i = 0; i < samParamTypes.length; ++i) {
            if (!(samParamTypes[i] instanceof PsiPrimitiveType)) continue;
            samParamTypes[i] = ((PsiPrimitiveType)samParamTypes[i]).getBoxedType(expression);
        }
        PsiParameter[] parameters = new PsiParameter[]{parameter};
        PsiClassType functionalInterfaceType = functionClass != null ? psiFacade.getElementFactory().createType(functionClass, samParamTypes) : null;
        String methodReferenceText = LambdaCanBeMethodReferenceInspection.convertToMethodReference(expression, parameters, functionalInterfaceType, null);
        if (methodReferenceText != null) {
            LOG.assertTrue(functionalInterfaceType != null);
            result = result + "(" + functionalInterfaceType.getCanonicalText() + ")" + methodReferenceText;
        } else {
            result = result + parameter.getName() + " -> " + expression.getText();
        }
        return result;
    }

    private static void simplifyRedundantCast(PsiElement result) {
        PsiElement parent;
        PsiMethodReferenceExpression methodReferenceExpression = PsiTreeUtil.findChildOfType(result, PsiMethodReferenceExpression.class);
        if (methodReferenceExpression != null && (parent = methodReferenceExpression.getParent()) instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)parent)) {
            PsiExpression operand = ((PsiTypeCastExpression)parent).getOperand();
            LOG.assertTrue(operand != null);
            parent.replace(operand);
        }
    }

    private static void restoreComments(PsiForeachStatement foreachStatement, PsiStatement body) {
        PsiElement parent = foreachStatement.getParent();
        for (PsiElement psiElement : PsiTreeUtil.findChildrenOfType(body, PsiComment.class)) {
            parent.addBefore(psiElement, foreachStatement);
        }
    }

    private static String createFiltersChainText(PsiStatement body, PsiParameter parameter, PsiIfStatement ifStatement) {
        ArrayList<String> filters = new ArrayList<String>();
        while (ifStatement != null && PsiTreeUtil.isAncestor(body, ifStatement, false)) {
            PsiExpression condition = ifStatement.getCondition();
            if (condition != null) {
                filters.add(".filter(" + StreamApiMigrationInspection.compoundLambdaOrMethodReference(parameter, condition, "java.util.function.Predicate", new PsiType[]{parameter.getType()}) + ")");
            }
            ifStatement = PsiTreeUtil.getParentOfType((PsiElement)ifStatement, PsiIfStatement.class);
        }
        Collections.reverse(filters);
        return StringUtil.join(filters, "");
    }

    private static String getIteratedValueText(PsiExpression iteratedValue) {
        return iteratedValue instanceof PsiCallExpression || iteratedValue instanceof PsiReferenceExpression || iteratedValue instanceof PsiQualifiedExpression || iteratedValue instanceof PsiParenthesizedExpression ? iteratedValue.getText() : "(" + iteratedValue.getText() + ")";
    }

    private static PsiIfStatement extractIfStatement(PsiStatement body) {
        PsiStatement thenBranch;
        PsiStatement[] statements;
        PsiIfStatement ifStmt = null;
        if (body instanceof PsiIfStatement) {
            ifStmt = (PsiIfStatement)body;
        } else if (body instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)body).getCodeBlock().getStatements()).length == 1 && statements[0] instanceof PsiIfStatement) {
            ifStmt = (PsiIfStatement)statements[0];
        }
        if (ifStmt != null && ifStmt.getElseBranch() == null && ifStmt.getCondition() != null && (thenBranch = ifStmt.getThenBranch()) != null) {
            PsiIfStatement deeperThen = StreamApiMigrationInspection.extractIfStatement(thenBranch);
            return deeperThen != null ? deeperThen : ifStmt;
        }
        return null;
    }

    private static PsiMethodCallExpression extractAddCall(PsiStatement body, PsiIfStatement ifStatement) {
        PsiExpression expression;
        if (ifStatement != null) {
            PsiStatement thenBranch = ifStatement.getThenBranch();
            return StreamApiMigrationInspection.extractAddCall(thenBranch, null);
        }
        PsiExpressionStatement stmt = null;
        if (body instanceof PsiBlockStatement) {
            PsiStatement[] statements = ((PsiBlockStatement)body).getCodeBlock().getStatements();
            if (statements.length == 1 && statements[0] instanceof PsiExpressionStatement) {
                stmt = (PsiExpressionStatement)statements[0];
            }
        } else if (body instanceof PsiExpressionStatement) {
            stmt = (PsiExpressionStatement)body;
        }
        if (stmt != null && (expression = stmt.getExpression()) instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)expression;
        }
        return null;
    }

    private static abstract class ReplaceWithCollectAbstractFix
    implements LocalQuickFix {
        private ReplaceWithCollectAbstractFix() {
        }

        protected abstract String getMethodName();

        @Override
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectAbstractFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = "Replace with " + this.getMethodName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectAbstractFix", "getFamilyName"));
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectAbstractFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectAbstractFix", "applyFix"));
            }
            PsiForeachStatement foreachStatement = PsiTreeUtil.getParentOfType(descriptor.getPsiElement(), PsiForeachStatement.class);
            if (foreachStatement != null) {
                if (!FileModificationService.getInstance().preparePsiElementForWrite(foreachStatement)) {
                    return;
                }
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
                PsiStatement body = foreachStatement.getBody();
                PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                if (body != null && iteratedValue != null) {
                    PsiExpression qualifierExpression;
                    PsiElement result;
                    StringBuilder builder;
                    block10: {
                        PsiParameter parameter = foreachStatement.getIterationParameter();
                        PsiIfStatement ifStatement = StreamApiMigrationInspection.extractIfStatement(body);
                        PsiMethodCallExpression methodCallExpression = StreamApiMigrationInspection.extractAddCall(body, ifStatement);
                        if (methodCallExpression == null) {
                            return;
                        }
                        if (StreamApiMigrationInspection.isAddAllCall(foreachStatement, body)) {
                            StreamApiMigrationInspection.restoreComments(foreachStatement, body);
                            PsiExpression qualifierExpression2 = methodCallExpression.getMethodExpression().getQualifierExpression();
                            String qualifierText = qualifierExpression2 != null ? qualifierExpression2.getText() : "";
                            String callText = StringUtil.getQualifiedName(qualifierText, "addAll(" + StreamApiMigrationInspection.getIteratedValueText(iteratedValue) + ");");
                            PsiElement result2 = foreachStatement.replace(elementFactory.createStatementFromText(callText, foreachStatement));
                            ReplaceWithCollectAbstractFix.reformatWhenNeeded(project, result2);
                            return;
                        }
                        builder = new StringBuilder(StreamApiMigrationInspection.getIteratedValueText(iteratedValue) + ".stream()");
                        builder.append(StreamApiMigrationInspection.createFiltersChainText(body, parameter, ifStatement));
                        builder.append(ReplaceWithCollectAbstractFix.createMapperFunctionalExpressionText(parameter, methodCallExpression.getArgumentList().getExpressions()[0]));
                        builder.append(".collect(java.util.stream.Collectors.");
                        result = null;
                        try {
                            PsiExpressionList argumentList;
                            PsiExpression initializer;
                            PsiElement resolve;
                            qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
                            if (!(qualifierExpression instanceof PsiReferenceExpression) || !((resolve = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiVariable) || !(resolve instanceof PsiLocalVariable) || !foreachStatement.equals(PsiTreeUtil.skipSiblingsForward(resolve.getParent(), PsiWhiteSpace.class, PsiComment.class)) || !((initializer = ((PsiVariable)resolve).getInitializer()) instanceof PsiNewExpression) || (argumentList = ((PsiNewExpression)initializer).getArgumentList()) == null || argumentList.getExpressions().length != 0) break block10;
                            StreamApiMigrationInspection.restoreComments(foreachStatement, body);
                            String callText = builder.toString() + ReplaceWithCollectAbstractFix.createInitializerReplacementText(((PsiVariable)resolve).getType(), initializer) + ")";
                            result = initializer.replace(elementFactory.createExpressionFromText(callText, null));
                            StreamApiMigrationInspection.simplifyRedundantCast(result);
                            foreachStatement.delete();
                        }
                        catch (Throwable throwable) {
                            ReplaceWithCollectAbstractFix.reformatWhenNeeded(project, result);
                            throw throwable;
                        }
                        ReplaceWithCollectAbstractFix.reformatWhenNeeded(project, result);
                        return;
                    }
                    StreamApiMigrationInspection.restoreComments(foreachStatement, body);
                    String qualifierText = qualifierExpression != null ? qualifierExpression.getText() : "";
                    String callText = StringUtil.getQualifiedName(qualifierText, "addAll(" + builder.toString() + "toList()));");
                    result = foreachStatement.replace(elementFactory.createStatementFromText(callText, foreachStatement));
                    StreamApiMigrationInspection.simplifyRedundantCast(result);
                    ReplaceWithCollectAbstractFix.reformatWhenNeeded(project, result);
                }
            }
        }

        private static void reformatWhenNeeded(@NotNull Project project, PsiElement result) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectAbstractFix", "reformatWhenNeeded"));
            }
            if (result != null) {
                CodeStyleManager.getInstance(project).reformat(JavaCodeStyleManager.getInstance(project).shortenClassReferences(result));
            }
        }

        private static String createInitializerReplacementText(PsiType varType, PsiExpression initializer) {
            PsiClassType rawVarType;
            PsiType initializerType = initializer.getType();
            PsiClassType rawType = initializerType instanceof PsiClassType ? ((PsiClassType)initializerType).rawType() : null;
            PsiClassType psiClassType = rawVarType = varType instanceof PsiClassType ? ((PsiClassType)varType).rawType() : null;
            if (rawType != null && rawVarType != null && rawType.equalsToText("java.util.ArrayList") && rawVarType.equalsToText("java.util.List")) {
                return "toList()";
            }
            if (rawType != null && rawVarType != null && rawType.equalsToText("java.util.HashSet") && rawVarType.equalsToText("java.util.Set")) {
                return "toSet()";
            }
            if (rawType != null) {
                return "toCollection(" + rawType.getClassName() + "::new)";
            }
            return "toCollection(() -> " + initializer.getText() + ")";
        }

        private static String createMapperFunctionalExpressionText(PsiParameter parameter, PsiExpression expression) {
            String iteration = "";
            if (!StreamApiMigrationInspection.isIdentityMapping(parameter, expression)) {
                iteration = iteration + ".map(";
                iteration = iteration + StreamApiMigrationInspection.compoundLambdaOrMethodReference(parameter, expression, "java.util.function.Function", new PsiType[]{parameter.getType(), expression.getType()});
                iteration = iteration + ")";
            }
            return iteration;
        }
    }

    private static class ReplaceWithAddAllFix
    extends ReplaceWithCollectAbstractFix {
        private ReplaceWithAddAllFix() {
        }

        @Override
        protected String getMethodName() {
            return "addAll";
        }
    }

    private static class ReplaceWithCollectFix
    extends ReplaceWithCollectAbstractFix {
        private ReplaceWithCollectFix() {
        }

        @Override
        protected String getMethodName() {
            return "collect";
        }
    }

    private static class ReplaceWithForeachCallFix
    implements LocalQuickFix {
        private final String myForEachMethodName;

        protected ReplaceWithForeachCallFix(String forEachMethodName) {
            this.myForEachMethodName = forEachMethodName;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = "Replace with " + this.myForEachMethodName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "applyFix"));
            }
            PsiForeachStatement foreachStatement = PsiTreeUtil.getParentOfType(descriptor.getPsiElement(), PsiForeachStatement.class);
            if (foreachStatement != null) {
                if (!FileModificationService.getInstance().preparePsiElementForWrite(foreachStatement)) {
                    return;
                }
                PsiStatement body = foreachStatement.getBody();
                PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                if (body != null && iteratedValue != null) {
                    StreamApiMigrationInspection.restoreComments(foreachStatement, body);
                    PsiParameter parameter = foreachStatement.getIterationParameter();
                    PsiIfStatement ifStmt = StreamApiMigrationInspection.extractIfStatement(body);
                    StringBuilder buffer = new StringBuilder(StreamApiMigrationInspection.getIteratedValueText(iteratedValue));
                    if (ifStmt != null) {
                        PsiStatement thenBranch = ifStmt.getThenBranch();
                        LOG.assertTrue(thenBranch != null);
                        buffer.append(".stream()");
                        buffer.append(StreamApiMigrationInspection.createFiltersChainText(body, parameter, ifStmt));
                        body = thenBranch;
                    }
                    buffer.append(".").append(this.myForEachMethodName).append("(");
                    String functionalExpressionText = ReplaceWithForeachCallFix.createForEachFunctionalExpressionText(project, body, parameter);
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
                    PsiExpressionStatement callStatement = (PsiExpressionStatement)elementFactory.createStatementFromText(buffer.toString() + functionalExpressionText + ");", foreachStatement);
                    callStatement = (PsiExpressionStatement)foreachStatement.replace(callStatement);
                    PsiExpressionList argumentList = ((PsiCallExpression)callStatement.getExpression()).getArgumentList();
                    LOG.assertTrue(argumentList != null, callStatement.getText());
                    PsiExpression[] expressions = argumentList.getExpressions();
                    LOG.assertTrue(expressions.length == 1);
                    if (expressions[0] instanceof PsiFunctionalExpression && ((PsiFunctionalExpression)expressions[0]).getFunctionalInterfaceType() == null) {
                        callStatement = (PsiExpressionStatement)callStatement.replace(elementFactory.createStatementFromText(buffer.toString() + "(" + parameter.getText() + ") -> " + ReplaceWithForeachCallFix.wrapInBlock(body) + ");", callStatement));
                    }
                    StreamApiMigrationInspection.simplifyRedundantCast(callStatement);
                    CodeStyleManager.getInstance(project).reformat(JavaCodeStyleManager.getInstance(project).shortenClassReferences(callStatement));
                }
            }
        }

        private static String createForEachFunctionalExpressionText(Project project, PsiStatement body, PsiParameter parameter) {
            PsiClassType functionalType;
            PsiParameter[] parameters;
            PsiStatement bodyBlock;
            String methodReferenceText;
            PsiCallExpression callExpression = LambdaCanBeMethodReferenceInspection.extractMethodCallFromBlock(body);
            if (callExpression != null && (methodReferenceText = LambdaCanBeMethodReferenceInspection.convertToMethodReference(bodyBlock = body instanceof PsiBlockStatement ? ((PsiBlockStatement)body).getCodeBlock() : body, parameters = new PsiParameter[]{parameter}, functionalType = StreamApiMigrationInspection.createDefaultConsumerType(project, parameter), null)) != null) {
                return methodReferenceText;
            }
            return parameter.getName() + " -> " + ReplaceWithForeachCallFix.wrapInBlock(body);
        }

        private static String wrapInBlock(PsiStatement body) {
            if (body instanceof PsiExpressionStatement) {
                return ((PsiExpressionStatement)body).getExpression().getText();
            }
            String bodyText = body.getText();
            if (!(body instanceof PsiBlockStatement)) {
                return "{" + bodyText + "}";
            }
            return bodyText;
        }
    }
}

