/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.SmartRefElementPointer;
import com.intellij.codeInspection.reference.SmartRefElementPointerImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EntryPointsManager")
public abstract class EntryPointsManagerBase
extends EntryPointsManager
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String[] STANDARD_ANNOS = new String[]{"javax.ws.rs.*"};
    private volatile List<String> ADDITIONAL_ANNOS;
    public JDOMExternalizableStringList ADDITIONAL_ANNOTATIONS;
    private final Map<String, SmartRefElementPointer> myPersistentEntryPoints;
    private final LinkedHashSet<ClassPattern> myPatterns;
    private final Set<RefElement> myTemporaryEntryPoints;
    private static final String VERSION = "2.0";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String ENTRY_POINT_ATTR = "entry_point";
    private boolean myAddNonJavaEntries;
    private boolean myResolved;
    protected final Project myProject;
    private long myLastModificationCount;

    public Collection<String> getAdditionalAnnotations() {
        List<String> annos = this.ADDITIONAL_ANNOS;
        if (annos == null) {
            EntryPoint[] extensions;
            annos = new ArrayList<String>();
            Collections.addAll(annos, STANDARD_ANNOS);
            for (EntryPoint extension : extensions = (EntryPoint[])Extensions.getExtensions("com.intellij.deadCode", null)) {
                String[] ignoredAnnotations = extension.getIgnoreAnnotations();
                if (ignoredAnnotations == null) continue;
                ContainerUtil.addAll(annos, ignoredAnnotations);
            }
            this.ADDITIONAL_ANNOS = annos = Collections.unmodifiableList(annos);
        }
        return annos;
    }

    public EntryPointsManagerBase(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/EntryPointsManagerBase", "<init>"));
        }
        this.ADDITIONAL_ANNOTATIONS = new JDOMExternalizableStringList();
        this.myPatterns = new LinkedHashSet();
        this.myAddNonJavaEntries = true;
        this.myLastModificationCount = -1L;
        this.myProject = project;
        this.myTemporaryEntryPoints = new HashSet<RefElement>();
        this.myPersistentEntryPoints = new LinkedHashMap<String, SmartRefElementPointer>();
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.deadCode");
        ((ExtensionPointImpl)point).addExtensionPointListener(new ExtensionPointListener<EntryPoint>(){

            @Override
            public void extensionAdded(@NotNull EntryPoint extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInspection/ex/EntryPointsManagerBase$1", "extensionAdded"));
                }
                this.extensionRemoved(extension, pluginDescriptor);
            }

            @Override
            public void extensionRemoved(@NotNull EntryPoint extension, @Nullable PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/codeInspection/ex/EntryPointsManagerBase$1", "extensionRemoved"));
                }
                if (EntryPointsManagerBase.this.ADDITIONAL_ANNOS != null) {
                    EntryPointsManagerBase.this.ADDITIONAL_ANNOS = null;
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (!ApplicationManager.getApplication().isDisposed()) {
                            InspectionProfileManager.getInstance().fireProfileChanged(null);
                        }
                    });
                }
                DaemonCodeAnalyzer.getInstance(EntryPointsManagerBase.this.myProject).restart();
            }
        }, false, this);
    }

    public static EntryPointsManagerBase getInstance(Project project) {
        return (EntryPointsManagerBase)ServiceManager.getService(project, EntryPointsManager.class);
    }

    @Override
    public void loadState(Element element) {
        Element entryPointsElement = element.getChild("entry_points");
        if (entryPointsElement != null) {
            String version = entryPointsElement.getAttributeValue(VERSION_ATTR);
            if (!Comparing.strEqual(version, VERSION)) {
                EntryPointsManagerBase.convert(entryPointsElement, this.myPersistentEntryPoints);
            } else {
                List content = entryPointsElement.getChildren();
                for (Object aContent : content) {
                    Element entryElement = (Element)aContent;
                    if (!ENTRY_POINT_ATTR.equals(entryElement.getName())) continue;
                    SmartRefElementPointerImpl entryPoint = new SmartRefElementPointerImpl(entryElement);
                    this.myPersistentEntryPoints.put(entryPoint.getFQName(), entryPoint);
                }
            }
        }
        try {
            this.ADDITIONAL_ANNOTATIONS.readExternal(element);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.getPatterns().clear();
        for (Element pattern : element.getChildren("pattern")) {
            ClassPattern classPattern = new ClassPattern();
            XmlSerializer.deserializeInto(classPattern, pattern);
            this.getPatterns().add(classPattern);
        }
    }

    @Override
    public Element getState() {
        Element element = new Element("state");
        EntryPointsManagerBase.writeExternal(element, this.myPersistentEntryPoints, this.ADDITIONAL_ANNOTATIONS);
        if (!this.getPatterns().isEmpty()) {
            for (ClassPattern pattern : this.getPatterns()) {
                element.addContent(XmlSerializer.serialize(pattern, new SkipDefaultsSerializationFilter()));
            }
        }
        return element;
    }

    public static void writeExternal(Element element, Map<String, SmartRefElementPointer> persistentEntryPoints, JDOMExternalizableStringList additional_annotations) {
        Element entryPointsElement = new Element("entry_points");
        entryPointsElement.setAttribute(VERSION_ATTR, VERSION);
        for (SmartRefElementPointer entryPoint : persistentEntryPoints.values()) {
            assert (entryPoint.isPersistent());
            entryPoint.writeExternal(entryPointsElement);
        }
        element.addContent(entryPointsElement);
        if (!additional_annotations.isEmpty()) {
            additional_annotations.writeExternal(element);
        }
    }

    @Override
    public void resolveEntryPoints(@NotNull RefManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/ex/EntryPointsManagerBase", "resolveEntryPoints"));
        }
        if (!this.myResolved) {
            this.myResolved = true;
            this.cleanup();
            this.validateEntryPoints();
            ApplicationManager.getApplication().runReadAction(() -> {
                if (manager == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/ex/EntryPointsManagerBase", "lambda$resolveEntryPoints$0"));
                }
                for (SmartRefElementPointer entryPoint : this.myPersistentEntryPoints.values()) {
                    if (!entryPoint.resolve(manager)) continue;
                    RefEntity refElement = entryPoint.getRefElement();
                    ((RefElementImpl)refElement).setEntry(true);
                    ((RefElementImpl)refElement).setPermanentEntry(entryPoint.isPersistent());
                }
                for (ClassPattern pattern : this.myPatterns) {
                    RefEntity refClass = manager.getReference("class", pattern.pattern);
                    if (refClass == null) continue;
                    for (RefMethod constructor : ((RefClass)refClass).getConstructors()) {
                        ((RefMethodImpl)constructor).setEntry(true);
                        ((RefMethodImpl)constructor).setPermanentEntry(true);
                    }
                }
            });
        }
    }

    private void purgeTemporaryEntryPoints() {
        for (RefElement entryPoint : this.myTemporaryEntryPoints) {
            ((RefElementImpl)entryPoint).setEntry(false);
        }
        this.myTemporaryEntryPoints.clear();
    }

    @Override
    public void addEntryPoint(@NotNull RefElement newEntryPoint, boolean isPersistent) {
        if (newEntryPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newEntryPoint", "com/intellij/codeInspection/ex/EntryPointsManagerBase", "addEntryPoint"));
        }
        if (!newEntryPoint.isValid()) {
            return;
        }
        if (isPersistent && (newEntryPoint instanceof RefImplicitConstructor || newEntryPoint instanceof RefClass)) {
            ClassPattern classPattern = new ClassPattern();
            classPattern.pattern = new SmartRefElementPointerImpl(newEntryPoint, true).getFQName();
            this.getPatterns().add(classPattern);
            EntryPointsManagerBase entryPointsManager = EntryPointsManagerBase.getInstance(newEntryPoint.getRefManager().getProject());
            if (this != entryPointsManager) {
                ((EntryPointsManager)entryPointsManager).addEntryPoint(newEntryPoint, true);
            }
            return;
        }
        if (newEntryPoint instanceof RefClass) {
            RefClass refClass = (RefClass)newEntryPoint;
            if (refClass.isAnonymous()) {
                return;
            }
            List<RefMethod> refConstructors = refClass.getConstructors();
            if (refConstructors.size() == 1) {
                this.addEntryPoint(refConstructors.get(0), isPersistent);
            } else if (refConstructors.size() > 1) {
                for (RefMethod refConstructor : refConstructors) {
                    this.addEntryPoint(refConstructor, isPersistent);
                }
            }
        }
        if (!isPersistent) {
            this.myTemporaryEntryPoints.add(newEntryPoint);
            ((RefElementImpl)newEntryPoint).setEntry(true);
        } else if (this.myPersistentEntryPoints.get(newEntryPoint.getExternalName()) == null) {
            EntryPointsManagerBase entryPointsManager;
            SmartRefElementPointerImpl entry = new SmartRefElementPointerImpl(newEntryPoint, true);
            this.myPersistentEntryPoints.put(entry.getFQName(), entry);
            ((RefElementImpl)newEntryPoint).setEntry(true);
            ((RefElementImpl)newEntryPoint).setPermanentEntry(true);
            if (entry.isPersistent() && this != (entryPointsManager = EntryPointsManagerBase.getInstance(newEntryPoint.getRefManager().getProject()))) {
                ((EntryPointsManager)entryPointsManager).addEntryPoint(newEntryPoint, true);
            }
        }
    }

    @Override
    public void removeEntryPoint(@NotNull RefElement anEntryPoint) {
        Project project;
        EntryPointsManagerBase entryPointsManager;
        if (anEntryPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anEntryPoint", "com/intellij/codeInspection/ex/EntryPointsManagerBase", "removeEntryPoint"));
        }
        this.myTemporaryEntryPoints.remove(anEntryPoint);
        Set<Map.Entry<String, SmartRefElementPointer>> set = this.myPersistentEntryPoints.entrySet();
        String key = null;
        for (Map.Entry<String, SmartRefElementPointer> entry : set) {
            SmartRefElementPointer value = entry.getValue();
            if (value.getRefElement() != anEntryPoint) continue;
            key = entry.getKey();
            break;
        }
        if (key != null) {
            this.myPersistentEntryPoints.remove(key);
        }
        ((RefElementImpl)anEntryPoint).setEntry(false);
        if (anEntryPoint.isPermanentEntry() && anEntryPoint.isValid() && this != (entryPointsManager = EntryPointsManagerBase.getInstance(project = anEntryPoint.getElement().getProject()))) {
            ((EntryPointsManager)entryPointsManager).removeEntryPoint(anEntryPoint);
        }
        if (anEntryPoint instanceof RefMethod && ((RefMethod)anEntryPoint).isConstructor() || anEntryPoint instanceof RefClass) {
            RefClass aClass = anEntryPoint instanceof RefClass ? (RefClass)anEntryPoint : ((RefMethod)anEntryPoint).getOwnerClass();
            String qualifiedName = aClass.getQualifiedName();
            Iterator iterator = this.getPatterns().iterator();
            while (iterator.hasNext()) {
                if (!Comparing.equal(((ClassPattern)iterator.next()).pattern, qualifiedName)) continue;
                iterator.remove();
            }
        }
    }

    @Override
    @NotNull
    public RefElement[] getEntryPoints() {
        this.validateEntryPoints();
        ArrayList<RefElement> entries = new ArrayList<RefElement>();
        Collection<SmartRefElementPointer> collection = this.myPersistentEntryPoints.values();
        for (SmartRefElementPointer refElementPointer : collection) {
            RefEntity elt = refElementPointer.getRefElement();
            if (!(elt instanceof RefElement)) continue;
            entries.add((RefElement)elt);
        }
        entries.addAll(this.myTemporaryEntryPoints);
        RefElement[] refElementArray = entries.toArray(new RefElement[entries.size()]);
        if (refElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/EntryPointsManagerBase", "getEntryPoints"));
        }
        return refElementArray;
    }

    @Override
    public void dispose() {
        this.cleanup();
    }

    private void validateEntryPoints() {
        long count = PsiManager.getInstance(this.myProject).getModificationTracker().getModificationCount();
        if (count != this.myLastModificationCount) {
            SmartRefElementPointer[] entries;
            this.myLastModificationCount = count;
            Collection<SmartRefElementPointer> collection = this.myPersistentEntryPoints.values();
            for (SmartRefElementPointer entry : entries = collection.toArray(new SmartRefElementPointer[collection.size()])) {
                RefElement refElement = (RefElement)entry.getRefElement();
                if (refElement == null || refElement.isValid()) continue;
                this.myPersistentEntryPoints.remove(entry.getFQName());
            }
            Iterator<RefElement> it = this.myTemporaryEntryPoints.iterator();
            while (it.hasNext()) {
                RefElement refElement = it.next();
                if (refElement.isValid()) continue;
                it.remove();
            }
        }
    }

    @Override
    public void cleanup() {
        this.purgeTemporaryEntryPoints();
        Collection<SmartRefElementPointer> entries = this.myPersistentEntryPoints.values();
        for (SmartRefElementPointer entry : entries) {
            entry.freeReference();
        }
    }

    @Override
    public boolean isAddNonJavaEntries() {
        return this.myAddNonJavaEntries;
    }

    public void addAllPersistentEntries(EntryPointsManagerBase manager) {
        this.myPersistentEntryPoints.putAll(manager.myPersistentEntryPoints);
        this.myPatterns.addAll(manager.getPatterns());
    }

    public static void convert(Element element, Map<String, SmartRefElementPointer> persistentEntryPoints) {
        List content = element.getChildren();
        for (Object aContent : content) {
            Element entryElement = (Element)aContent;
            if (!ENTRY_POINT_ATTR.equals(entryElement.getName())) continue;
            String fqName = entryElement.getAttributeValue("FQNAME");
            String type = entryElement.getAttributeValue("TYPE");
            if (Comparing.strEqual(type, "method")) {
                int spaceIdx = fqName.indexOf(32);
                int lastDotIdx = fqName.lastIndexOf(46);
                int parenIndex = fqName.indexOf(40);
                while (lastDotIdx > parenIndex) {
                    lastDotIdx = fqName.lastIndexOf(46, lastDotIdx - 1);
                }
                boolean notype = false;
                if (spaceIdx < 0 || spaceIdx + 1 > lastDotIdx || spaceIdx > parenIndex) {
                    notype = true;
                }
                String className = fqName.substring(notype ? 0 : spaceIdx + 1, lastDotIdx);
                String methodSignature = notype ? fqName.substring(lastDotIdx + 1) : fqName.substring(0, spaceIdx) + ' ' + fqName.substring(lastDotIdx + 1);
                fqName = className + " " + methodSignature;
            } else if (Comparing.strEqual(type, "field")) {
                int lastDotIdx = fqName.lastIndexOf(46);
                if (lastDotIdx <= 0 || lastDotIdx >= fqName.length() - 2) continue;
                String className = fqName.substring(0, lastDotIdx);
                String fieldName = fqName.substring(lastDotIdx + 1);
                fqName = className + " " + fieldName;
            }
            SmartRefElementPointerImpl entryPoint = new SmartRefElementPointerImpl(type, fqName);
            persistentEntryPoints.put(entryPoint.getFQName(), entryPoint);
        }
    }

    public void setAddNonJavaEntries(boolean addNonJavaEntries) {
        this.myAddNonJavaEntries = addNonJavaEntries;
    }

    @Override
    public boolean isEntryPoint(@NotNull PsiElement element) {
        String qualifiedName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/EntryPointsManagerBase", "isEntryPoint"));
        }
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        PsiModifierListOwner owner = (PsiModifierListOwner)element;
        if (!this.ADDITIONAL_ANNOTATIONS.isEmpty() && this.ADDITIONAL_ANNOTATIONS.contains(Deprecated.class.getName()) && element instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)element).isDeprecated()) {
            return true;
        }
        if (element instanceof PsiClass && (qualifiedName = ((PsiClass)element).getQualifiedName()) != null) {
            for (ClassPattern pattern : this.getPatterns()) {
                if (!EntryPointsManagerBase.isAcceptedByPattern((PsiClass)element, qualifiedName, pattern, new HashSet<PsiClass>())) continue;
                return true;
            }
        }
        return AnnotationUtil.checkAnnotatedUsingPatterns(owner, this.ADDITIONAL_ANNOTATIONS) || AnnotationUtil.checkAnnotatedUsingPatterns(owner, this.getAdditionalAnnotations());
    }

    private static boolean isAcceptedByPattern(@NotNull PsiClass element, String qualifiedName, ClassPattern pattern, Set<PsiClass> visited) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/EntryPointsManagerBase", "isAcceptedByPattern"));
        }
        if (qualifiedName == null) {
            return false;
        }
        if (qualifiedName.equals(pattern.pattern)) {
            return true;
        }
        Pattern regexp = pattern.getRegexp();
        if (regexp != null) {
            try {
                if (regexp.matcher(qualifiedName).matches()) {
                    return true;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        if (pattern.hierarchically) {
            for (PsiClass superClass : element.getSupers()) {
                String superClassQualifiedName = superClass.getQualifiedName();
                if (!visited.add(superClass) || !EntryPointsManagerBase.isAcceptedByPattern(superClass, superClassQualifiedName, pattern, visited)) continue;
                return true;
            }
        }
        return false;
    }

    public LinkedHashSet<ClassPattern> getPatterns() {
        return this.myPatterns;
    }

    @Tag(value="pattern")
    public static class ClassPattern {
        @Attribute(value="value")
        public String pattern = "";
        @Attribute(value="hierarchically")
        public boolean hierarchically = false;
        private Pattern regexp;

        public ClassPattern(ClassPattern classPattern) {
            this.hierarchically = classPattern.hierarchically;
            this.pattern = classPattern.pattern;
        }

        public ClassPattern() {
        }

        @Nullable
        public Pattern getRegexp() {
            if (this.regexp == null && this.pattern.contains("*")) {
                String replace = this.pattern.replace("*", ".*").replace(".", "\\.");
                try {
                    this.regexp = Pattern.compile(replace);
                }
                catch (PatternSyntaxException e) {
                    return null;
                }
            }
            return this.regexp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassPattern otherPattern = (ClassPattern)o;
            if (this.hierarchically != otherPattern.hierarchically) {
                return false;
            }
            return this.pattern.equals(otherPattern.pattern);
        }

        public int hashCode() {
            int result = this.pattern.hashCode();
            result = 31 * result + (this.hierarchically ? 1 : 0);
            return result;
        }
    }
}

