/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaParameterTypeCanBeSpecifiedInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance("#" + LambdaParameterTypeCanBeSpecifiedInspection.class.getName());

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.descriptor", infos);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InferLambdaParameterTypeVisitor();
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new InferLambdaParameterTypeFix(infos);
    }

    private static void doFix(@NotNull Project project, @NotNull PsiLambdaExpression lambdaExpression) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection", "doFix"));
        }
        if (lambdaExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpression", "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection", "doFix"));
        }
        PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
        String buf = LambdaParameterTypeCanBeSpecifiedInspection.getInferredTypes(functionalInterfaceType, lambdaExpression, true);
        PsiMethod methodFromText = JavaPsiFacade.getElementFactory(project).createMethodFromText("void foo" + buf, lambdaExpression);
        JavaCodeStyleManager.getInstance(project).shortenClassReferences(lambdaExpression.getParameterList().replace(methodFromText.getParameterList()));
    }

    @Nullable
    private static String getInferredTypes(PsiType functionalInterfaceType, PsiLambdaExpression lambdaExpression, boolean useFQN) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType);
        LOG.assertTrue(interfaceMethod != null);
        PsiParameter[] parameters = interfaceMethod.getParameterList().getParameters();
        PsiParameter[] lambdaParameters = lambdaExpression.getParameterList().getParameters();
        if (parameters.length != lambdaParameters.length) {
            return null;
        }
        for (int i = 0; i < parameters.length; ++i) {
            PsiParameter parameter = parameters[i];
            PsiType psiType = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult).substitute(parameter.getType());
            if (!PsiTypesUtil.isDenotableType(psiType)) {
                return null;
            }
            if (psiType != null) {
                buf.append(useFQN ? psiType.getCanonicalText() : psiType.getPresentableText()).append(" ").append(lambdaParameters[i].getName());
            } else {
                buf.append(lambdaParameters[i].getName());
            }
            if (i >= parameters.length - 1) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    private static class InferLambdaParameterTypeFix
    extends InspectionGadgetsFix {
        private final Object[] myInfos;

        public InferLambdaParameterTypeFix(Object ... infos) {
            this.myInfos = infos;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.quickfix", this.myInfos);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection$InferLambdaParameterTypeFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("lambda.parameter.type.can.be.specified.family.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/LambdaParameterTypeCanBeSpecifiedInspection$InferLambdaParameterTypeFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiLambdaExpression) {
                LambdaParameterTypeCanBeSpecifiedInspection.doFix(project, (PsiLambdaExpression)element);
            }
        }
    }

    private static class InferLambdaParameterTypeVisitor
    extends BaseInspectionVisitor {
        private InferLambdaParameterTypeVisitor() {
        }

        @Override
        public void visitLambdaExpression(PsiLambdaExpression lambdaExpression) {
            String inferredTypesText;
            super.visitLambdaExpression(lambdaExpression);
            PsiParameter[] parameters = lambdaExpression.getParameterList().getParameters();
            if (parameters.length == 0) {
                return;
            }
            for (PsiParameter parameter : parameters) {
                if (parameter.getTypeElement() == null) continue;
                return;
            }
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            if (functionalInterfaceType != null && LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType) != null && LambdaUtil.isLambdaFullyInferred(lambdaExpression, functionalInterfaceType) && (inferredTypesText = LambdaParameterTypeCanBeSpecifiedInspection.getInferredTypes(functionalInterfaceType, lambdaExpression, false)) != null) {
                this.registerError((PsiElement)lambdaExpression, inferredTypesText);
            }
        }
    }
}

