/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.util.Consumer;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncPromiseKt;
import org.jetbrains.concurrency.Promise;

class RejectedPromise<T>
extends Promise<T> {
    private final Throwable error;

    public RejectedPromise(@NotNull Throwable error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "org/jetbrains/concurrency/RejectedPromise", "<init>"));
        }
        this.error = error;
    }

    @Override
    @NotNull
    public Promise<T> done(@NotNull Consumer<? super T> done2) {
        if (done2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "org/jetbrains/concurrency/RejectedPromise", "done"));
        }
        RejectedPromise rejectedPromise = this;
        if (rejectedPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/RejectedPromise", "done"));
        }
        return rejectedPromise;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull AsyncPromise<? super T> fulfilled) {
        if (fulfilled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fulfilled", "org/jetbrains/concurrency/RejectedPromise", "processed"));
        }
        fulfilled.setError(this.error);
        RejectedPromise rejectedPromise = this;
        if (rejectedPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/RejectedPromise", "processed"));
        }
        return rejectedPromise;
    }

    @Override
    @NotNull
    public Promise<T> rejected(@NotNull Consumer<Throwable> rejected2) {
        if (rejected2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rejected", "org/jetbrains/concurrency/RejectedPromise", "rejected"));
        }
        if (!AsyncPromiseKt.isObsolete(rejected2)) {
            rejected2.consume(this.error);
        }
        RejectedPromise rejectedPromise = this;
        if (rejectedPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/RejectedPromise", "rejected"));
        }
        return rejectedPromise;
    }

    @Override
    public RejectedPromise<T> processed(@NotNull Consumer<? super T> processed2) {
        if (processed2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processed", "org/jetbrains/concurrency/RejectedPromise", "processed"));
        }
        processed2.consume(null);
        return this;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> done2) {
        if (done2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "org/jetbrains/concurrency/RejectedPromise", "then"));
        }
        RejectedPromise rejectedPromise = this;
        if (rejectedPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/RejectedPromise", "then"));
        }
        return rejectedPromise;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, Promise<SUB_RESULT>> done2) {
        if (done2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "org/jetbrains/concurrency/RejectedPromise", "thenAsync"));
        }
        RejectedPromise rejectedPromise = this;
        if (rejectedPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/RejectedPromise", "thenAsync"));
        }
        return rejectedPromise;
    }

    @Override
    @NotNull
    public Promise.State getState() {
        Promise.State state = Promise.State.REJECTED;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/RejectedPromise", "getState"));
        }
        return state;
    }

    @Override
    public void notify(@NotNull AsyncPromise<? super T> child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/concurrency/RejectedPromise", "notify"));
        }
        child.setError(this.error);
    }
}

