/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalysisScope {
    private static final Logger LOG = Logger.getInstance("#com.intellij.analysis.AnalysisScope");
    public static final int PROJECT = 1;
    public static final int DIRECTORY = 2;
    public static final int FILE = 3;
    public static final int MODULE = 4;
    public static final int INVALID = 6;
    public static final int MODULES = 7;
    public static final int CUSTOM = 8;
    public static final int VIRTUAL_FILES = 9;
    public static final int UNCOMMITTED_FILES = 10;
    @NotNull
    private final Project myProject;
    protected List<Module> myModules;
    protected Module myModule;
    protected PsiElement myElement;
    private final SearchScope myScope;
    private boolean mySearchInLibraries;
    private GlobalSearchScope myFilter;
    @Type
    protected int myType;
    private final Set<VirtualFile> myVFiles;
    protected Set<VirtualFile> myFilesSet;
    protected boolean myIncludeTestSource;

    public AnalysisScope(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        this.myIncludeTestSource = true;
        this.myProject = project;
        this.myElement = null;
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myType = 1;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        this.myIncludeTestSource = true;
        this.myProject = module.getProject();
        this.myElement = null;
        this.myModules = null;
        this.myScope = null;
        this.myModule = module;
        this.myType = 4;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull Module[] modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        this.myIncludeTestSource = true;
        this.myModules = Arrays.asList(modules);
        this.myModule = null;
        this.myProject = modules[0].getProject();
        this.myElement = null;
        this.myScope = null;
        this.myType = 7;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull PsiDirectory psiDirectory) {
        if (psiDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiDirectory", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        this.myIncludeTestSource = true;
        this.myProject = psiDirectory.getProject();
        this.myModules = null;
        this.myModule = null;
        this.myScope = null;
        this.myElement = psiDirectory;
        this.myType = 2;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        this.myIncludeTestSource = true;
        this.myProject = psiFile.getProject();
        this.myElement = psiFile;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myType = 3;
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull SearchScope scope, @NotNull Project project) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        this.myIncludeTestSource = true;
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = scope;
        this.myType = 8;
        this.mySearchInLibraries = scope instanceof GlobalSearchScope && ((GlobalSearchScope)scope).isSearchInLibraries();
        this.myVFiles = null;
    }

    public AnalysisScope(@NotNull Project project, @NotNull Collection<VirtualFile> virtualFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        if (virtualFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFiles", "com/intellij/analysis/AnalysisScope", "<init>"));
        }
        this.myIncludeTestSource = true;
        this.myProject = project;
        this.myElement = null;
        this.myModule = null;
        this.myModules = null;
        this.myScope = null;
        this.myVFiles = new HashSet<VirtualFile>(virtualFiles);
        this.myType = 9;
    }

    public void setSearchInLibraries(boolean searchInLibraries) {
        this.mySearchInLibraries = searchInLibraries;
    }

    public void setIncludeTestSource(boolean includeTestSource) {
        this.myIncludeTestSource = includeTestSource;
    }

    @NotNull
    protected PsiElementVisitor createFileSearcher() {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.setText(AnalysisScopeBundle.message("scanning.scope.progress.title", new Object[0]));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            @Override
            public void visitFile(@NotNull PsiFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/analysis/AnalysisScope$1", "visitFile"));
                }
                if (AnalysisScope.this.mySearchInLibraries || !(file instanceof PsiCompiledElement)) {
                    VirtualFile virtualFile = file.getVirtualFile();
                    if (virtualFile == null) {
                        return;
                    }
                    if (AnalysisScope.this.isFiltered(virtualFile)) {
                        return;
                    }
                    if (!AnalysisScope.shouldHighlightFile(file)) {
                        return;
                    }
                    AnalysisScope.this.myFilesSet.add(virtualFile);
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "createFileSearcher"));
        }
        return psiElementVisitor;
    }

    private boolean isFiltered(VirtualFile virtualFile) {
        if (this.myFilter != null && !this.myFilter.contains(virtualFile)) {
            return true;
        }
        return !this.myIncludeTestSource && TestSourcesFilter.isTestSources(virtualFile, this.myProject);
    }

    @NotNull
    private FileIndex getFileIndex() {
        FileIndex fileIndex = this.myModule != null ? ModuleRootManager.getInstance(this.myModule).getFileIndex() : ProjectRootManager.getInstance(this.myProject).getFileIndex();
        FileIndex fileIndex2 = fileIndex;
        if (fileIndex2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getFileIndex"));
        }
        return fileIndex2;
    }

    private static String displayProjectRelativePath(@NotNull PsiFileSystemItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/analysis/AnalysisScope", "displayProjectRelativePath"));
        }
        VirtualFile virtualFile = item.getVirtualFile();
        LOG.assertTrue(virtualFile != null, item);
        return ProjectUtilCore.displayUrlRelativeToProject(virtualFile, virtualFile.getPresentableUrl(), item.getProject(), true, false);
    }

    public boolean contains(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/analysis/AnalysisScope", "contains"));
        }
        VirtualFile file = psiElement.getContainingFile().getVirtualFile();
        return file != null && this.contains(file);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/analysis/AnalysisScope", "contains"));
        }
        if (this.myFilesSet == null) {
            if (this.myType == 8) {
                if (this.myScope instanceof GlobalSearchScope) {
                    return ((GlobalSearchScope)this.myScope).contains(file);
                }
                if (this.myScope instanceof LocalSearchScope) {
                    return ((LocalSearchScope)this.myScope).isInScope(file);
                }
            }
            if (this.myType == 1) {
                ProjectFileIndex index = ProjectRootManager.getInstance(this.myProject).getFileIndex();
                return index.isInContent(file) && !this.isFiltered(file);
            }
            this.initFilesSet();
        }
        return this.myFilesSet.contains(file);
    }

    protected void initFilesSet() {
        if (this.myType == 3) {
            this.myFilesSet = new HashSet<VirtualFile>(1);
            this.myFilesSet.add(((PsiFileSystemItem)this.myElement).getVirtualFile());
        } else if (this.myType == 2 || this.myType == 1 || this.myType == 7 || this.myType == 4 || this.myType == 8) {
            this.myFilesSet = new HashSet<VirtualFile>();
            this.accept(this.createFileSearcher(), false);
        } else if (this.myType == 9) {
            this.myFilesSet = new HashSet<VirtualFile>();
            final ProjectFileIndex fileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
            Iterator<VirtualFile> iterator = this.myVFiles.iterator();
            while (iterator.hasNext()) {
                VirtualFile vFile = iterator.next();
                VfsUtilCore.visitChildrenRecursively(vFile, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                    @Override
                    @NotNull
                    public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/analysis/AnalysisScope$2", "visitFileEx"));
                        }
                        boolean ignored = fileIndex.isExcluded(file);
                        if (!ignored && !file.isDirectory()) {
                            AnalysisScope.this.myFilesSet.add(file);
                        }
                        VirtualFileVisitor.Result result = ignored ? SKIP_CHILDREN : CONTINUE;
                        if (result == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope$2", "visitFileEx"));
                        }
                        return result;
                    }
                });
                if (!vFile.isDirectory()) continue;
                iterator.remove();
            }
        }
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/analysis/AnalysisScope", "accept"));
        }
        this.accept(visitor, true);
    }

    private void accept(@NotNull PsiElementVisitor visitor, boolean clearResolveCache) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/analysis/AnalysisScope", "accept"));
        }
        boolean needReadAction = !ApplicationManager.getApplication().isReadAccessAllowed();
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        FileIndex fileIndex = this.getFileIndex();
        this.accept((VirtualFile file) -> {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/analysis/AnalysisScope", "lambda$accept$0"));
            }
            if (file.isDirectory()) {
                return true;
            }
            if (ProjectCoreUtil.isProjectOrWorkspaceFile(file)) {
                return true;
            }
            if (fileIndex.isInContent((VirtualFile)file) && !this.isFiltered((VirtualFile)file) && !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(file, this.myProject)) {
                return AnalysisScope.processFile(file, visitor, psiManager, needReadAction, clearResolveCache);
            }
            return true;
        });
    }

    public boolean accept(@NotNull Processor<VirtualFile> processor) {
        List<Module> modules;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/analysis/AnalysisScope", "accept"));
        }
        if (this.myType == 9) {
            if (this.myFilesSet == null) {
                this.initFilesSet();
            }
            for (VirtualFile file : this.myFilesSet) {
                if (this.isFiltered(file) || processor.process(file)) continue;
                return false;
            }
            return true;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance(this.myProject).getFileIndex();
        if (this.myScope instanceof GlobalSearchScope) {
            ContentIterator contentIterator = this.createScopeIterator(processor, this.myScope);
            if (!projectFileIndex.iterateContent(contentIterator)) {
                return false;
            }
            if (this.mySearchInLibraries) {
                VirtualFile[] libraryRoots;
                for (VirtualFile libraryRoot : libraryRoots = LibraryUtil.getLibraryRoots(this.myProject, false, false)) {
                    if (VfsUtilCore.iterateChildrenRecursively(libraryRoot, VirtualFileFilter.ALL, contentIterator)) continue;
                    return false;
                }
            }
            return true;
        }
        if (this.myScope instanceof LocalSearchScope) {
            PsiElement[] psiElements = ((LocalSearchScope)this.myScope).getScope();
            THashSet files = new THashSet();
            for (final PsiElement element : psiElements) {
                VirtualFile file = ApplicationManager.getApplication().runReadAction(new Computable<VirtualFile>(){

                    @Override
                    public VirtualFile compute() {
                        return PsiUtilCore.getVirtualFile(element);
                    }
                });
                if (file == null || !files.add(file) || processor.process(file)) continue;
                return false;
            }
            return true;
        }
        List<Module> list = modules = this.myModule != null ? Collections.singletonList(this.myModule) : this.myModules;
        if (modules != null) {
            for (Module module : modules) {
                ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(module).getFileIndex();
                if (moduleFileIndex.iterateContent(this.createScopeIterator(processor, null))) continue;
                return false;
            }
            return true;
        }
        if (this.myElement instanceof PsiDirectory) {
            return this.accept((PsiDirectory)this.myElement, processor);
        }
        if (this.myElement != null) {
            VirtualFile file = ApplicationManager.getApplication().runReadAction(new Computable<VirtualFile>(){

                @Override
                public VirtualFile compute() {
                    return PsiUtilCore.getVirtualFile(AnalysisScope.this.myElement);
                }
            });
            return file == null || processor.process(file);
        }
        return projectFileIndex.iterateContent(this.createScopeIterator(processor, null));
    }

    @NotNull
    private ContentIterator createScopeIterator(@NotNull Processor<VirtualFile> processor, final @Nullable SearchScope searchScope) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/analysis/AnalysisScope", "createScopeIterator"));
        }
        ContentIterator contentIterator = fileOrDir -> {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/analysis/AnalysisScope", "lambda$createScopeIterator$1"));
            }
            boolean isInScope = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                @Override
                public Boolean compute() {
                    if (AnalysisScope.this.isFiltered(fileOrDir)) {
                        return false;
                    }
                    if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(fileOrDir, AnalysisScope.this.myProject)) {
                        return false;
                    }
                    return searchScope == null || ((GlobalSearchScope)searchScope).contains(fileOrDir);
                }
            });
            return !isInScope || processor.process(fileOrDir);
        };
        if (contentIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "createScopeIterator"));
        }
        return contentIterator;
    }

    private static boolean processFile(@NotNull VirtualFile vFile, @NotNull PsiElementVisitor visitor, @NotNull PsiManager psiManager, boolean needReadAction, boolean clearResolveCache) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/analysis/AnalysisScope", "processFile"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/analysis/AnalysisScope", "processFile"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/analysis/AnalysisScope", "processFile"));
        }
        Runnable runnable = () -> {
            if (visitor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/analysis/AnalysisScope", "lambda$processFile$2"));
            }
            if (psiManager == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/analysis/AnalysisScope", "lambda$processFile$2"));
            }
            if (vFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/analysis/AnalysisScope", "lambda$processFile$2"));
            }
            AnalysisScope.doProcessFile(visitor, psiManager, vFile, clearResolveCache);
        };
        if (needReadAction && !ApplicationManager.getApplication().isDispatchThread()) {
            AnalysisScope.commitAndRunInSmartMode(runnable, psiManager.getProject());
        } else {
            runnable.run();
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        return indicator == null || !indicator.isCanceled();
    }

    private static void commitAndRunInSmartMode(Runnable runnable, Project project) {
        DumbService dumbService;
        boolean passed;
        do {
            dumbService = DumbService.getInstance(project);
            dumbService.waitForSmartMode();
        } while (!(passed = PsiDocumentManager.getInstance(project).commitAndRunReadAction(() -> {
            if (dumbService.isDumb()) {
                return false;
            }
            runnable.run();
            return true;
        }).booleanValue()));
    }

    protected static boolean shouldHighlightFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/analysis/AnalysisScope", "shouldHighlightFile"));
        }
        return ProblemHighlightFilter.shouldProcessFileInBatch(file);
    }

    public boolean containsModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/analysis/AnalysisScope", "containsModule"));
        }
        switch (this.myType) {
            case 1: {
                return true;
            }
            case 4: {
                return this.myModule == module;
            }
            case 7: {
                return this.myModules.contains(module);
            }
        }
        return false;
    }

    private static void doProcessFile(@NotNull PsiElementVisitor visitor, @NotNull PsiManager psiManager, @NotNull VirtualFile vFile, boolean clearResolveCache) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/analysis/AnalysisScope", "doProcessFile"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/analysis/AnalysisScope", "doProcessFile"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/analysis/AnalysisScope", "doProcessFile"));
        }
        if (!vFile.isValid()) {
            return;
        }
        PsiFile psiFile = psiManager.findFile(vFile);
        if (psiFile == null || !AnalysisScope.shouldHighlightFile(psiFile)) {
            return;
        }
        psiFile.accept(visitor);
        if (clearResolveCache) {
            psiManager.dropResolveCaches();
            InjectedLanguageManager.getInstance(psiManager.getProject()).dropFileCaches(psiFile);
        }
    }

    protected boolean accept(@NotNull PsiDirectory dir, @NotNull Processor<VirtualFile> processor) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/analysis/AnalysisScope", "accept"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/analysis/AnalysisScope", "accept"));
        }
        Project project = dir.getProject();
        boolean processGeneratedFiles = GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(dir.getVirtualFile(), project);
        return VfsUtilCore.iterateChildrenRecursively(dir.getVirtualFile(), VirtualFileFilter.ALL, fileOrDir -> {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/analysis/AnalysisScope", "lambda$accept$4"));
            }
            if (this.isFiltered(fileOrDir)) {
                return true;
            }
            if (!processGeneratedFiles && GeneratedSourcesFilter.isGeneratedSourceByAnyFilter(fileOrDir, project)) {
                return true;
            }
            if (!fileOrDir.isDirectory()) {
                return processor.process(fileOrDir);
            }
            return true;
        });
    }

    public boolean isValid() {
        if (this.myModules != null) {
            for (Module module : this.myModules) {
                if (!module.isDisposed()) continue;
                return false;
            }
            return true;
        }
        if (this.myModule != null) {
            return !this.myModule.isDisposed();
        }
        if (this.myElement != null) {
            return this.myElement.isValid();
        }
        return this.myType == 9 || this.myType == 8 || this.myType == 1;
    }

    @Type
    public int getScopeType() {
        return this.myType;
    }

    @NotNull
    public String getDisplayName() {
        switch (this.myType) {
            case 8: {
                String string = this.myScope.getDisplayName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getDisplayName"));
                }
                return string;
            }
            case 4: {
                String string = AnalysisScopeBundle.message("scope.option.module", AnalysisScope.pathToName(this.myModule.getModuleFilePath()));
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getDisplayName"));
                }
                return string;
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, module -> AnalysisScope.pathToName(module.getModuleFilePath()), ", ");
                String string = AnalysisScopeBundle.message("scope.module.list", modules, this.myModules.size());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getDisplayName"));
                }
                return string;
            }
            case 1: {
                String string = AnalysisScopeBundle.message("scope.project", this.myProject.getName());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getDisplayName"));
                }
                return string;
            }
            case 3: {
                String string = AnalysisScopeBundle.message("scope.file", AnalysisScope.displayProjectRelativePath((PsiFileSystemItem)this.myElement));
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getDisplayName"));
                }
                return string;
            }
            case 2: {
                String string = AnalysisScopeBundle.message("scope.directory", AnalysisScope.displayProjectRelativePath((PsiFileSystemItem)this.myElement));
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getDisplayName"));
                }
                return string;
            }
            case 9: {
                String string = AnalysisScopeBundle.message("scope.virtual.files", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getDisplayName"));
                }
                return string;
            }
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getDisplayName"));
        }
        return "";
    }

    @NotNull
    public String getShortenName() {
        switch (this.myType) {
            case 8: {
                String string = this.myScope.getDisplayName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getShortenName"));
                }
                return string;
            }
            case 4: {
                String string = AnalysisScopeBundle.message("scope.option.module", this.myModule.getName());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getShortenName"));
                }
                return string;
            }
            case 7: {
                String modules = StringUtil.join(this.myModules, Module::getName, ", ");
                String string = AnalysisScopeBundle.message("scope.module.list", modules, this.myModules.size());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getShortenName"));
                }
                return string;
            }
            case 1: {
                String string = AnalysisScopeBundle.message("scope.project", this.myProject.getName());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getShortenName"));
                }
                return string;
            }
            case 3: {
                String relativePath = this.getRelativePath();
                String string = AnalysisScopeBundle.message("scope.file", relativePath);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getShortenName"));
                }
                return string;
            }
            case 2: {
                String relativeDirPath = this.getRelativePath();
                String string = AnalysisScopeBundle.message("scope.directory", relativeDirPath);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getShortenName"));
                }
                return string;
            }
            case 9: {
                String string = AnalysisScopeBundle.message("scope.selected.files", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getShortenName"));
                }
                return string;
            }
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getShortenName"));
        }
        return "";
    }

    @Nullable
    private String getRelativePath() {
        String relativePath = AnalysisScope.displayProjectRelativePath((PsiFileSystemItem)this.myElement);
        if (relativePath.length() > 100) {
            return ((PsiFileSystemItem)this.myElement).getName();
        }
        return relativePath;
    }

    @NotNull
    private static String pathToName(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/analysis/AnalysisScope", "pathToName"));
        }
        File file = new File(path);
        String string = FileUtil.getNameWithoutExtension(file);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "pathToName"));
        }
        return string;
    }

    public int getFileCount() {
        ProgressIndicator indicator;
        if (this.myFilesSet == null) {
            this.initFilesSet();
        }
        if ((indicator = ProgressManager.getInstance().getProgressIndicator()) != null) {
            indicator.setText("");
            indicator.setText2("");
        }
        return this.myFilesSet.size();
    }

    public void invalidate() {
        if (this.myType == 9) {
            Iterator<VirtualFile> i = this.myVFiles.iterator();
            while (i.hasNext()) {
                VirtualFile virtualFile = i.next();
                if (virtualFile != null && virtualFile.isValid()) continue;
                i.remove();
            }
        } else {
            this.myFilesSet = null;
        }
    }

    public boolean containsSources(boolean isTest) {
        if (this.myElement != null) {
            VirtualFile file;
            Project project = this.myElement.getProject();
            ProjectFileIndex index = ProjectRootManager.getInstance(project).getFileIndex();
            if (this.myElement instanceof PsiDirectory) {
                VirtualFile directory = ((PsiFileSystemItem)this.myElement).getVirtualFile();
                if (index.isInSourceContent(directory)) {
                    return isTest == TestSourcesFilter.isTestSources(directory, this.myProject);
                }
            } else if (this.myElement instanceof PsiFile && (file = ((PsiFileSystemItem)this.myElement).getVirtualFile()) != null) {
                return isTest == TestSourcesFilter.isTestSources(file, this.myProject);
            }
        }
        return true;
    }

    @NotNull
    public AnalysisScope getNarrowedComplementaryScope(@NotNull Project defaultProject) {
        if (defaultProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultProject", "com/intellij/analysis/AnalysisScope", "getNarrowedComplementaryScope"));
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(defaultProject).getFileIndex();
        HashSet<Module> modules = new HashSet<Module>();
        if (this.myType == 3 || this.myType == 2) {
            VirtualFile vFile = ((PsiFileSystemItem)this.myElement).getVirtualFile();
            modules.addAll(AnalysisScope.getAllInterestingModules(fileIndex, vFile));
        } else if (this.myType == 4) {
            modules.add(this.myModule);
        } else if (this.myType == 7) {
            modules.addAll(this.myModules);
        }
        AnalysisScope analysisScope = AnalysisScope.collectScopes(defaultProject, modules);
        if (analysisScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getNarrowedComplementaryScope"));
        }
        return analysisScope;
    }

    @NotNull
    protected static AnalysisScope collectScopes(@NotNull Project defaultProject, @NotNull HashSet<Module> modules) {
        if (defaultProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultProject", "com/intellij/analysis/AnalysisScope", "collectScopes"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/analysis/AnalysisScope", "collectScopes"));
        }
        if (modules.isEmpty()) {
            AnalysisScope analysisScope = new AnalysisScope(defaultProject);
            if (analysisScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "collectScopes"));
            }
            return analysisScope;
        }
        Module[] allModules = ModuleManager.getInstance(defaultProject).getModules();
        HashSet<Module> modulesToAnalyze = new HashSet<Module>();
        for (Module module : modules) {
            modulesToAnalyze.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            modulesToAnalyze.addAll(AnalysisScope.getExportBackwardDependencies(module, allModules));
            modulesToAnalyze.add(module);
        }
        AnalysisScope analysisScope = new AnalysisScope(modulesToAnalyze.toArray(new Module[modulesToAnalyze.size()]));
        if (analysisScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "collectScopes"));
        }
        return analysisScope;
    }

    @NotNull
    private static Set<Module> getExportBackwardDependencies(@NotNull Module fromModule, @NotNull Module[] allModules) {
        if (fromModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromModule", "com/intellij/analysis/AnalysisScope", "getExportBackwardDependencies"));
        }
        if (allModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allModules", "com/intellij/analysis/AnalysisScope", "getExportBackwardDependencies"));
        }
        HashSet<Module> result = new HashSet<Module>();
        for (Module module : allModules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
                if (!(orderEntry instanceof ModuleOrderEntry) || !((ExportableOrderEntry)orderEntry).isExported() || fromModule != ((ModuleOrderEntry)orderEntry).getModule()) continue;
                result.addAll(AnalysisScope.getDirectBackwardDependencies(module, allModules));
            }
        }
        HashSet<Module> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getExportBackwardDependencies"));
        }
        return hashSet;
    }

    @NotNull
    private static Set<Module> getDirectBackwardDependencies(@NotNull Module module, @NotNull Module[] allModules) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/analysis/AnalysisScope", "getDirectBackwardDependencies"));
        }
        if (allModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allModules", "com/intellij/analysis/AnalysisScope", "getDirectBackwardDependencies"));
        }
        HashSet<Module> result = new HashSet<Module>();
        for (Module dependency : allModules) {
            if (ArrayUtil.find(ModuleRootManager.getInstance(dependency).getDependencies(), module) <= -1) continue;
            result.add(dependency);
        }
        HashSet<Module> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getDirectBackwardDependencies"));
        }
        return hashSet;
    }

    @NotNull
    protected static HashSet<Module> getAllInterestingModules(@NotNull ProjectFileIndex fileIndex, @NotNull VirtualFile vFile) {
        if (fileIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIndex", "com/intellij/analysis/AnalysisScope", "getAllInterestingModules"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/analysis/AnalysisScope", "getAllInterestingModules"));
        }
        HashSet<Module> modules = new HashSet<Module>();
        if (fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile)) {
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(vFile)) {
                modules.add(orderEntry.getOwnerModule());
            }
        } else {
            modules.add(fileIndex.getModuleForFile(vFile));
        }
        HashSet<Module> hashSet = modules;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "getAllInterestingModules"));
        }
        return hashSet;
    }

    @NotNull
    public SearchScope toSearchScope() {
        switch (this.myType) {
            case 8: {
                SearchScope searchScope = this.myScope;
                if (searchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return searchScope;
            }
            case 2: {
                GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoryScope((PsiDirectory)this.myElement, true);
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return globalSearchScope;
            }
            case 3: {
                LocalSearchScope localSearchScope = new LocalSearchScope(this.myElement);
                if (localSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return localSearchScope;
            }
            case 6: {
                LocalSearchScope localSearchScope = LocalSearchScope.EMPTY;
                if (localSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return localSearchScope;
            }
            case 4: {
                GlobalSearchScope moduleScope = GlobalSearchScope.moduleScope(this.myModule);
                GlobalSearchScope globalSearchScope = this.myIncludeTestSource ? moduleScope : GlobalSearchScope.notScope(GlobalSearchScopesCore.projectTestScope(this.myModule.getProject())).intersectWith(moduleScope);
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return globalSearchScope;
            }
            case 7: {
                SearchScope scope = GlobalSearchScope.EMPTY_SCOPE;
                for (Module module : this.myModules) {
                    scope = ((SearchScope)scope).union(GlobalSearchScope.moduleScope(module));
                }
                GlobalSearchScope globalSearchScope = scope;
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return globalSearchScope;
            }
            case 1: {
                GlobalSearchScope globalSearchScope = this.myIncludeTestSource ? GlobalSearchScope.projectScope(this.myProject) : GlobalSearchScopesCore.projectProductionScope(this.myProject);
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return globalSearchScope;
            }
            case 9: {
                GlobalSearchScope globalSearchScope = new GlobalSearchScope(){

                    @Override
                    public boolean contains(@NotNull VirtualFile file) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/analysis/AnalysisScope$6", "contains"));
                        }
                        return AnalysisScope.this.myFilesSet.contains(file);
                    }

                    @Override
                    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                        if (file1 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/analysis/AnalysisScope$6", "compare"));
                        }
                        if (file2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/analysis/AnalysisScope$6", "compare"));
                        }
                        return 0;
                    }

                    @Override
                    public boolean isSearchInModuleContent(@NotNull Module aModule) {
                        if (aModule == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/analysis/AnalysisScope$6", "isSearchInModuleContent"));
                        }
                        return false;
                    }

                    @Override
                    public boolean isSearchInLibraries() {
                        return false;
                    }
                };
                if (globalSearchScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
                }
                return globalSearchScope;
            }
        }
        LOG.error("invalid type " + this.myType);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/AnalysisScope", "toSearchScope"));
        }
        return globalSearchScope;
    }

    public boolean isAnalyzeTestsByDefault() {
        switch (this.myType) {
            case 2: {
                return TestSourcesFilter.isTestSources(((PsiDirectory)this.myElement).getVirtualFile(), this.myElement.getProject());
            }
            case 3: {
                PsiFile containingFile = this.myElement.getContainingFile();
                return TestSourcesFilter.isTestSources(containingFile.getVirtualFile(), containingFile.getProject());
            }
            case 4: {
                return AnalysisScope.isTestOnly(this.myModule);
            }
            case 7: {
                for (Module module : this.myModules) {
                    if (AnalysisScope.isTestOnly(module)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isTestOnly(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/analysis/AnalysisScope", "isTestOnly"));
        }
        return ModuleRootManager.getInstance(module).getSourceRootUrls(false).length == 0;
    }

    public boolean isIncludeTestSource() {
        return this.myIncludeTestSource;
    }

    public void setFilter(GlobalSearchScope filter) {
        this.myFilter = filter;
    }

    public static @interface Type {
    }
}

