/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiMethodUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ComparatorCombinatorsInspection
extends BaseJavaBatchLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/ComparatorCombinatorsInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                PsiMethodCallExpression methodCall;
                PsiElement body;
                super.visitLambdaExpression(lambda2);
                PsiType type = lambda2.getFunctionalInterfaceType();
                if (type instanceof PsiClassType && ((PsiClassType)type).rawType().equalsToText("java.util.Comparator") && (body = lambda2.getBody()) instanceof PsiMethodCallExpression && PsiMethodUtil.isCompareToCall(methodCall = (PsiMethodCallExpression)body)) {
                    PsiExpression left = methodCall.getMethodExpression().getQualifierExpression();
                    PsiExpression right = methodCall.getArgumentList().getExpressions()[0];
                    if (left instanceof PsiMethodCallExpression && right instanceof PsiMethodCallExpression) {
                        PsiMethodCallExpression leftCall = (PsiMethodCallExpression)left;
                        PsiMethodCallExpression rightCall = (PsiMethodCallExpression)right;
                        if (leftCall.getArgumentList().getExpressions().length == 0 && rightCall.getArgumentList().getExpressions().length == 0) {
                            PsiMethod leftMethod = leftCall.resolveMethod();
                            PsiMethod rightMethod = rightCall.resolveMethod();
                            if (leftMethod != null && rightMethod != null && leftMethod == rightMethod && ComparatorCombinatorsInspection.areLambdaParameters(lambda2, leftCall.getMethodExpression().getQualifierExpression(), rightCall.getMethodExpression().getQualifierExpression())) {
                                holder.registerProblem((PsiElement)lambda2, "Can be replaced with Comparator.comparing", new ReplaceWithComparatorFix());
                            }
                        }
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ComparatorCombinatorsInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static boolean areLambdaParameters(PsiLambdaExpression lambda2, PsiExpression left, PsiExpression right) {
        PsiParameter[] parameters = lambda2.getParameterList().getParameters();
        return left instanceof PsiReferenceExpression && right instanceof PsiReferenceExpression && ((PsiReferenceExpression)left).resolve() == parameters[0] && ((PsiReferenceExpression)right).resolve() == parameters[1];
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Use Comparator combinators" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ComparatorCombinatorsInspection", "getDisplayName"));
        }
        return "Use Comparator combinators";
    }

    static class ReplaceWithComparatorFix
    implements LocalQuickFix {
        ReplaceWithComparatorFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ComparatorCombinatorsInspection$ReplaceWithComparatorFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with Comparator.comparing" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ComparatorCombinatorsInspection$ReplaceWithComparatorFix", "getFamilyName"));
            }
            return "Replace with Comparator.comparing";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ComparatorCombinatorsInspection$ReplaceWithComparatorFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ComparatorCombinatorsInspection$ReplaceWithComparatorFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiLambdaExpression)) {
                return;
            }
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)element;
            PsiElement body = lambda2.getBody();
            if (!(body instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)body;
            if (!PsiMethodUtil.isCompareToCall(methodCall)) {
                return;
            }
            PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
            if (!(qualifier instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)qualifier;
            if (call.getArgumentList().getExpressions().length != 0) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass methodClass = method.getContainingClass();
            if (methodClass == null) {
                return;
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            PsiExpression replacement = factory.createExpressionFromText("java.util.Comparator.comparing(" + methodClass.getQualifiedName() + "::" + method.getName() + ")", element);
            PsiElement result = lambda2.replace(replacement);
            CodeStyleManager.getInstance(project).reformat(JavaCodeStyleManager.getInstance(project).shortenClassReferences(result));
        }
    }
}

