/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaCanBeMethodReferenceInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final String SHORT_NAME = "Convert2MethodRef";
    public static final Logger LOG = Logger.getInstance("#" + LambdaCanBeMethodReferenceInspection.class.getName());
    public boolean REPLACE_INSTANCEOF;
    public boolean REPLACE_CAST;
    public boolean REPLACE_NULL_CHECK = true;

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(this);
        panel.addCheckbox("Replace instanceof", "REPLACE_INSTANCEOF");
        panel.addCheckbox("Replace cast", "REPLACE_CAST");
        panel.addCheckbox("Replace null-check", "REPLACE_NULL_CHECK");
        return panel;
    }

    @Nullable
    static LambdaCanBeMethodReferenceInspection getInstance(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getInstance"));
        }
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(element.getProject()).getCurrentProfile();
        return (LambdaCanBeMethodReferenceInspection)inspectionProfile.getUnwrappedTool(SHORT_NAME, element);
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Lambda can be replaced with method reference" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getDisplayName"));
        }
        return "Lambda can be replaced with method reference";
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression) {
                super.visitLambdaExpression(expression);
                if (PsiUtil.getLanguageLevel(expression).isAtLeast(LanguageLevel.JDK_1_8)) {
                    PsiExpression candidate;
                    PsiElement body = expression.getBody();
                    PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
                    if (functionalInterfaceType != null && (candidate = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(body, expression.getParameterList().getParameters(), functionalInterfaceType)) != null) {
                        holder.registerProblem((PsiElement)candidate, "Can be replaced with method reference", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new ReplaceWithMethodRefFix());
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Nullable
    public static String convertToMethodReference(@Nullable PsiElement body, PsiVariable[] parameters, PsiType functionalInterfaceType, @Nullable PsiElement context) {
        PsiExpression candidate = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(body, parameters, functionalInterfaceType, context);
        return LambdaCanBeMethodReferenceInspection.createMethodReferenceText(candidate, functionalInterfaceType, parameters);
    }

    @Nullable
    public static PsiExpression canBeMethodReferenceProblem(@Nullable PsiElement body, PsiVariable[] parameters, PsiType functionalInterfaceType) {
        return LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(body, parameters, functionalInterfaceType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static PsiExpression canBeMethodReferenceProblem(@Nullable PsiElement body, PsiVariable[] parameters, PsiType functionalInterfaceType, @Nullable PsiElement context) {
        PsiNewExpression newExpression;
        PsiExpression methodRefCandidate = LambdaCanBeMethodReferenceInspection.extractMethodReferenceCandidateExpression(body);
        if (methodRefCandidate instanceof PsiNewExpression && ((newExpression = (PsiNewExpression)methodRefCandidate).getAnonymousClass() != null || newExpression.getArrayInitializer() != null)) {
            return null;
        }
        String methodReferenceText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText(methodRefCandidate, functionalInterfaceType, parameters);
        if (methodReferenceText != null) {
            PsiMethodReferenceExpression methodReferenceExpression;
            LOG.assertTrue(methodRefCandidate != null);
            if (!(methodRefCandidate instanceof PsiCallExpression)) {
                return methodRefCandidate;
            }
            PsiCallExpression callExpression = (PsiCallExpression)methodRefCandidate;
            PsiMethod method = callExpression.resolveMethod();
            if (method != null) {
                if (!LambdaCanBeMethodReferenceInspection.isSimpleCall(parameters, callExpression, method)) {
                    return null;
                }
            } else {
                LOG.assertTrue(callExpression instanceof PsiNewExpression);
                if (((PsiNewExpression)callExpression).getQualifier() != null) {
                    return null;
                }
                PsiExpression[] dims = ((PsiNewExpression)callExpression).getArrayDimensions();
                if (dims.length == 1 && parameters.length == 1 ? !LambdaCanBeMethodReferenceInspection.resolvesToParameter(dims[0], parameters[0]) : dims.length > 0) {
                    return null;
                }
                if (callExpression.getTypeArguments().length > 0) {
                    return null;
                }
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(callExpression.getProject());
            try {
                methodReferenceExpression = (PsiMethodReferenceExpression)elementFactory.createExpressionFromText(methodReferenceText, context != null ? context : callExpression);
            }
            catch (IncorrectOperationException e) {
                LOG.error(callExpression.getText(), e);
                return null;
            }
            Map<PsiElement, PsiType> map = LambdaUtil.getFunctionalTypeMap();
            try {
                map.put(methodReferenceExpression, functionalInterfaceType);
                JavaResolveResult result = methodReferenceExpression.advancedResolve(false);
                PsiElement element = result.getElement();
                if (element != null && result.isAccessible() && (!(result instanceof MethodCandidateInfo) || ((MethodCandidateInfo)result).isApplicable())) {
                    if (!(element instanceof PsiMethod)) {
                        PsiCallExpression psiCallExpression = callExpression;
                        return psiCallExpression;
                    }
                    PsiCallExpression psiCallExpression = method != null && MethodSignatureUtil.areSignaturesEqual((PsiMethod)element, method) ? callExpression : null;
                    return psiCallExpression;
                }
            }
            finally {
                map.remove(methodReferenceExpression);
            }
        }
        return null;
    }

    private static boolean isSimpleCall(final PsiVariable[] parameters, PsiCallExpression callExpression, PsiMethod psiMethod) {
        PsiExpressionList argumentList = callExpression.getArgumentList();
        if (argumentList == null) {
            return false;
        }
        int calledParametersCount = psiMethod.getParameterList().getParametersCount();
        PsiExpression[] expressions = argumentList.getExpressions();
        PsiExpression qualifier = callExpression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)callExpression).getMethodExpression().getQualifierExpression() : (callExpression instanceof PsiNewExpression ? ((PsiNewExpression)callExpression).getQualifier() : null);
        if (expressions.length == 0 && parameters.length == 0) {
            return !(callExpression instanceof PsiNewExpression) || qualifier == null;
        }
        int offset = parameters.length - calledParametersCount;
        if (expressions.length > calledParametersCount || offset < 0) {
            return false;
        }
        for (int i = 0; i < expressions.length; ++i) {
            if (LambdaCanBeMethodReferenceInspection.resolvesToParameter(expressions[i], parameters[i + offset])) continue;
            return false;
        }
        if (offset == 0) {
            if (qualifier != null) {
                final boolean[] parameterUsed = new boolean[]{false};
                qualifier.accept(new JavaRecursiveElementWalkingVisitor(){

                    @Override
                    public void visitElement(PsiElement element) {
                        if (parameterUsed[0]) {
                            return;
                        }
                        super.visitElement(element);
                    }

                    @Override
                    public void visitReferenceExpression(PsiReferenceExpression expression) {
                        super.visitReferenceExpression(expression);
                        parameterUsed[0] = parameterUsed[0] | ArrayUtil.find(parameters, expression.resolve()) >= 0;
                    }
                });
                return !parameterUsed[0];
            }
            return true;
        }
        return LambdaCanBeMethodReferenceInspection.resolvesToParameter(qualifier, parameters[0]);
    }

    private static boolean resolvesToParameter(PsiExpression expression, PsiVariable parameter) {
        return expression instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression).resolve() == parameter;
    }

    static boolean isNull(PsiElement element) {
        return element instanceof PsiLiteralExpression && ((PsiLiteralExpression)element).getValue() == null;
    }

    public static PsiExpression extractMethodReferenceCandidateExpression(PsiElement body) {
        PsiExpression expression = LambdaUtil.extractSingleExpressionFromBody(body);
        if (expression == null) {
            return null;
        }
        if (expression instanceof PsiNewExpression ? LambdaCanBeMethodReferenceInspection.checkQualifier(((PsiNewExpression)expression).getQualifier()) : expression instanceof PsiMethodCallExpression && LambdaCanBeMethodReferenceInspection.checkQualifier(((PsiMethodCallExpression)expression).getMethodExpression().getQualifier())) {
            return expression;
        }
        LambdaCanBeMethodReferenceInspection instance = LambdaCanBeMethodReferenceInspection.getInstance(expression);
        if (instance != null) {
            PsiTypeElement typeElement;
            if (expression instanceof PsiInstanceOfExpression && instance.REPLACE_INSTANCEOF) {
                return expression;
            }
            if (expression instanceof PsiBinaryExpression && instance.REPLACE_NULL_CHECK) {
                IElementType tokenType = ((PsiBinaryExpression)expression).getOperationTokenType();
                if ((JavaTokenType.EQEQ.equals(tokenType) || JavaTokenType.NE.equals(tokenType)) && (LambdaCanBeMethodReferenceInspection.isNull(((PsiBinaryExpression)expression).getLOperand()) || LambdaCanBeMethodReferenceInspection.isNull(((PsiBinaryExpression)expression).getROperand()))) {
                    return expression;
                }
            } else if (expression instanceof PsiTypeCastExpression && instance.REPLACE_CAST && (typeElement = ((PsiTypeCastExpression)expression).getCastType()) != null) {
                PsiJavaCodeReferenceElement refs = typeElement.getInnermostComponentReferenceElement();
                if (refs != null && refs.getParameterList() != null && refs.getParameterList().getTypeParameterElements().length != 0) {
                    return null;
                }
                PsiType type = typeElement.getType();
                if (type instanceof PsiPrimitiveType) {
                    return null;
                }
                return expression;
            }
        }
        return null;
    }

    private static boolean checkQualifier(PsiElement qualifier) {
        if (qualifier == null) {
            return true;
        }
        Condition callExpressionCondition = Conditions.instanceOf(PsiCallExpression.class);
        Condition<PsiElement> nonFinalFieldRefCondition = expression -> {
            PsiElement element;
            return expression instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)expression).resolve()) instanceof PsiField && !((PsiField)element).hasModifierProperty("final");
        };
        return ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot(qualifier)).filter(Conditions.or(callExpressionCondition, nonFinalFieldRefCondition))).toList().isEmpty();
    }

    @Nullable
    private static PsiMethod getNonAmbiguousReceiver(PsiVariable[] parameters, @NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "getNonAmbiguousReceiver"));
        }
        String methodName = psiMethod.getName();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        PsiMethod[] psiMethods = containingClass.findMethodsByName(methodName, false);
        if (psiMethods.length == 1) {
            return psiMethod;
        }
        PsiType receiverType = parameters[0].getType();
        for (PsiMethod method : psiMethods) {
            if (!LambdaCanBeMethodReferenceInspection.isPairedNoReceiver(parameters, receiverType, method)) continue;
            PsiMethod[] deepestSuperMethods = psiMethod.findDeepestSuperMethods();
            if (deepestSuperMethods.length > 0) {
                for (PsiMethod superMethod : deepestSuperMethods) {
                    PsiMethod validSuperMethod = LambdaCanBeMethodReferenceInspection.getNonAmbiguousReceiver(parameters, superMethod);
                    if (validSuperMethod == null) continue;
                    return validSuperMethod;
                }
            }
            return null;
        }
        return psiMethod;
    }

    private static boolean isPairedNoReceiver(PsiVariable[] parameters, PsiType receiverType, PsiMethod method) {
        PsiParameter[] nonReceiverCandidateParams = method.getParameterList().getParameters();
        return nonReceiverCandidateParams.length == parameters.length && method.hasModifierProperty("static") && TypeConversionUtil.areTypesConvertible(nonReceiverCandidateParams[0].getType(), receiverType);
    }

    private static boolean isSoleParameter(@NotNull PsiVariable[] parameters, @Nullable PsiExpression expression) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "isSoleParameter"));
        }
        return parameters.length == 1 && expression instanceof PsiReferenceExpression && parameters[0] == ((PsiReferenceExpression)expression).resolve();
    }

    @Nullable
    public static String createMethodReferenceText(PsiElement element, PsiType functionalInterfaceType, PsiVariable[] parameters) {
        PsiTypeElement type;
        PsiTypeCastExpression castExpression;
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
            JavaResolveResult result = methodCall.resolveMethodGenerics();
            PsiMethod psiMethod = (PsiMethod)result.getElement();
            if (psiMethod == null) {
                return null;
            }
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            String qualifierByMethodCall = LambdaCanBeMethodReferenceInspection.getQualifierTextByMethodCall(methodCall, functionalInterfaceType, parameters, psiMethod, result.getSubstitutor());
            if (qualifierByMethodCall != null) {
                return qualifierByMethodCall + "::" + ((PsiMethodCallExpression)element).getTypeArgumentList().getText() + methodExpression.getReferenceName();
            }
        } else if (element instanceof PsiNewExpression) {
            String qualifierByNew = LambdaCanBeMethodReferenceInspection.getQualifierTextByNewExpression((PsiNewExpression)element);
            if (qualifierByNew != null) {
                return qualifierByNew + ((PsiNewExpression)element).getTypeArgumentList().getText() + "::new";
            }
        } else if (element instanceof PsiInstanceOfExpression) {
            PsiTypeElement type2;
            if (LambdaCanBeMethodReferenceInspection.isSoleParameter(parameters, ((PsiInstanceOfExpression)element).getOperand()) && (type2 = ((PsiInstanceOfExpression)element).getCheckType()) != null) {
                return type2.getText() + ".class::isInstance";
            }
        } else if (element instanceof PsiBinaryExpression) {
            PsiExpression operand;
            PsiBinaryExpression nullCheck = (PsiBinaryExpression)element;
            if (LambdaCanBeMethodReferenceInspection.isNull(nullCheck.getROperand())) {
                operand = nullCheck.getLOperand();
            } else if (LambdaCanBeMethodReferenceInspection.isNull(nullCheck.getLOperand())) {
                operand = nullCheck.getROperand();
            } else {
                return null;
            }
            if (LambdaCanBeMethodReferenceInspection.isSoleParameter(parameters, operand)) {
                IElementType tokenType = nullCheck.getOperationTokenType();
                if (JavaTokenType.EQEQ.equals(tokenType)) {
                    return "java.util.Objects::isNull";
                }
                if (JavaTokenType.NE.equals(tokenType)) {
                    return "java.util.Objects::nonNull";
                }
            }
        } else if (element instanceof PsiTypeCastExpression && LambdaCanBeMethodReferenceInspection.isSoleParameter(parameters, (castExpression = (PsiTypeCastExpression)element).getOperand()) && (type = castExpression.getCastType()) != null) {
            return type.getText() + ".class::cast";
        }
        return null;
    }

    private static String getQualifierTextByNewExpression(PsiNewExpression element) {
        PsiType deepComponentType;
        JavaResolveResult resolve;
        PsiElement resolveElement;
        PsiType newExprType = element.getType();
        if (newExprType == null) {
            return null;
        }
        PsiClass containingClass = null;
        PsiJavaCodeReferenceElement classReference = element.getClassOrAnonymousClassReference();
        if (classReference != null && (resolveElement = (resolve = classReference.advancedResolve(false)).getElement()) instanceof PsiClass) {
            containingClass = (PsiClass)resolveElement;
        }
        String classOrPrimitiveName = null;
        if (containingClass != null) {
            classOrPrimitiveName = LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
        } else if (newExprType instanceof PsiArrayType && (deepComponentType = newExprType.getDeepComponentType()) instanceof PsiPrimitiveType) {
            classOrPrimitiveName = deepComponentType.getCanonicalText();
        }
        if (classOrPrimitiveName == null) {
            return null;
        }
        int dim = newExprType.getArrayDimensions();
        while (dim-- > 0) {
            classOrPrimitiveName = classOrPrimitiveName + "[]";
        }
        return classOrPrimitiveName;
    }

    @Nullable
    private static String getQualifierTextByMethodCall(PsiMethodCallExpression methodCall, PsiType functionalInterfaceType, PsiVariable[] parameters, PsiMethod psiMethod, PsiSubstitutor substitutor) {
        PsiExpression qualifierExpression = methodCall.getMethodExpression().getQualifierExpression();
        PsiClass containingClass = psiMethod.getContainingClass();
        LOG.assertTrue(containingClass != null);
        if (qualifierExpression != null) {
            boolean isReceiverType = false;
            if (qualifierExpression instanceof PsiReferenceExpression && ArrayUtil.find(parameters, ((PsiReferenceExpression)qualifierExpression).resolve()) > -1) {
                isReceiverType = PsiMethodReferenceUtil.isReceiverType(PsiMethodReferenceUtil.getFirstParameterType(functionalInterfaceType, qualifierExpression), containingClass, substitutor);
            }
            return isReceiverType ? LambdaCanBeMethodReferenceInspection.composeReceiverQualifierText(parameters, psiMethod, containingClass, qualifierExpression) : qualifierExpression.getText();
        }
        if (psiMethod.hasModifierProperty("static")) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
        }
        PsiClass parentContainingClass = PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiClass.class);
        if (parentContainingClass instanceof PsiAnonymousClass) {
            parentContainingClass = PsiTreeUtil.getParentOfType((PsiElement)parentContainingClass, PsiClass.class, true);
        }
        PsiClass treeContainingClass = parentContainingClass;
        while (treeContainingClass != null && !InheritanceUtil.isInheritorOrSelf(treeContainingClass, containingClass, true)) {
            treeContainingClass = PsiTreeUtil.getParentOfType((PsiElement)treeContainingClass, PsiClass.class, true);
        }
        if (treeContainingClass != null && containingClass != parentContainingClass && treeContainingClass != parentContainingClass) {
            String treeContainingClassName = treeContainingClass.getName();
            if (treeContainingClassName == null) {
                return null;
            }
            return treeContainingClassName + ".this";
        }
        return "this";
    }

    @Nullable
    private static String composeReceiverQualifierText(PsiVariable[] parameters, PsiMethod psiMethod, PsiClass containingClass, @NotNull PsiExpression qualifierExpression) {
        if (qualifierExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierExpression", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection", "composeReceiverQualifierText"));
        }
        if (psiMethod.hasModifierProperty("static")) {
            return null;
        }
        PsiMethod nonAmbiguousMethod = LambdaCanBeMethodReferenceInspection.getNonAmbiguousReceiver(parameters, psiMethod);
        if (nonAmbiguousMethod == null) {
            return null;
        }
        PsiClass nonAmbiguousContainingClass = nonAmbiguousMethod.getContainingClass();
        if (!containingClass.equals(nonAmbiguousContainingClass)) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(nonAmbiguousContainingClass);
        }
        if (containingClass.isPhysical() && qualifierExpression instanceof PsiReferenceExpression && !PsiTypesUtil.isGetClass(psiMethod) && ArrayUtil.find(parameters, ((PsiReferenceExpression)qualifierExpression).resolve()) > -1) {
            return LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
        }
        PsiType qualifierExpressionType = qualifierExpression.getType();
        if (qualifierExpressionType != null && !FunctionalInterfaceParameterizationUtil.isWildcardParameterized(qualifierExpressionType)) {
            try {
                String canonicalText = qualifierExpressionType.getCanonicalText();
                JavaPsiFacade.getElementFactory(containingClass.getProject()).createExpressionFromText(canonicalText + "::foo", qualifierExpression);
                return canonicalText;
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        return LambdaCanBeMethodReferenceInspection.getClassReferenceName(containingClass);
    }

    private static String getClassReferenceName(PsiClass containingClass) {
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName != null) {
            return qualifiedName;
        }
        return containingClass.getName();
    }

    private static class ReplaceWithMethodRefFix
    implements LocalQuickFix {
        private ReplaceWithMethodRefFix() {
        }

        @Override
        @NotNull
        public String getName() {
            if ("Replace lambda with method reference" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "getName"));
            }
            return "Replace lambda with method reference";
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/LambdaCanBeMethodReferenceInspection$ReplaceWithMethodRefFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            PsiLambdaExpression lambdaExpression = PsiTreeUtil.getParentOfType(element, PsiLambdaExpression.class);
            if (lambdaExpression == null) {
                return;
            }
            PsiType functionalInterfaceType = lambdaExpression.getFunctionalInterfaceType();
            if (functionalInterfaceType == null || !functionalInterfaceType.isValid()) {
                return;
            }
            PsiType denotableFunctionalInterfaceType = RefactoringChangeUtil.getTypeByExpression(lambdaExpression);
            if (denotableFunctionalInterfaceType == null) {
                return;
            }
            List<PsiComment> comments = ContainerUtil.map(PsiTreeUtil.findChildrenOfType(lambdaExpression, PsiComment.class), comment -> (PsiComment)comment.copy());
            String methodRefText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText(element, functionalInterfaceType, lambdaExpression.getParameterList().getParameters());
            if (methodRefText != null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
                PsiExpression psiExpression = factory.createExpressionFromText(methodRefText, lambdaExpression);
                SmartTypePointer typePointer = SmartTypePointerManager.getInstance(project).createSmartTypePointer(denotableFunctionalInterfaceType);
                PsiElement replace = lambdaExpression.replace(psiExpression);
                PsiType functionalTypeAfterReplacement = GenericsUtil.getVariableTypeByExpressionType(((PsiMethodReferenceExpression)replace).getFunctionalInterfaceType());
                functionalInterfaceType = typePointer.getType();
                if (functionalTypeAfterReplacement == null || functionalInterfaceType != null && !functionalTypeAfterReplacement.equals(functionalInterfaceType)) {
                    PsiTypeCastExpression cast = (PsiTypeCastExpression)factory.createExpressionFromText("(A)a", replace);
                    cast.getCastType().replace(factory.createTypeElement(functionalInterfaceType));
                    cast.getOperand().replace(replace);
                    replace = replace.replace(cast);
                }
                AnonymousCanBeLambdaInspection.restoreComments(comments, replace);
                JavaCodeStyleManager.getInstance(project).shortenClassReferences(replace);
            }
        }
    }
}

