/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SimplifyStreamApiCallChainsInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceInefficientStreamCountInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final String COUNT_METHOD = "count";
    private static final String SIZE_METHOD = "size";
    private static final String STREAM_METHOD = "stream";
    private static final String FLAT_MAP_METHOD = "flatMap";

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                PsiMethod method = methodCall.resolveMethod();
                if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.stream.Stream", ReplaceInefficientStreamCountInspection.COUNT_METHOD, 0)) {
                    PsiMethodCallExpression qualifierCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(methodCall);
                    if (qualifierCall == null) {
                        return;
                    }
                    PsiMethod qualifier = qualifierCall.resolveMethod();
                    if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collection", ReplaceInefficientStreamCountInspection.STREAM_METHOD, 0)) {
                        StreamCountFix fix = new StreamCountFix();
                        holder.registerProblem((PsiElement)methodCall, SimplifyStreamApiCallChainsInspection.getCallChainRange(methodCall, qualifierCall), fix.getMessage(), fix);
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.stream.Stream", ReplaceInefficientStreamCountInspection.FLAT_MAP_METHOD, 1) && ReplaceInefficientStreamCountInspection.this.doesFlatMapCallCollectionStream(qualifierCall)) {
                        FlatMapCountFix fix = new FlatMapCountFix();
                        holder.registerProblem((PsiElement)methodCall, SimplifyStreamApiCallChainsInspection.getCallChainRange(methodCall, qualifierCall), fix.getMessage(), fix);
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    boolean doesFlatMapCallCollectionStream(PsiMethodCallExpression flatMapCall) {
        PsiMethod lambdaMethod;
        PsiExpression expression;
        PsiMethodReferenceExpression methodRef;
        PsiElement resolvedMethodRef;
        PsiExpression parameter = flatMapCall.getArgumentList().getExpressions()[0];
        return parameter instanceof PsiMethodReferenceExpression ? (resolvedMethodRef = (methodRef = (PsiMethodReferenceExpression)parameter).resolve()) instanceof PsiMethod && SimplifyStreamApiCallChainsInspection.isCallOf((PsiMethod)resolvedMethodRef, "java.util.Collection", STREAM_METHOD, 0) : parameter instanceof PsiLambdaExpression && (expression = ReplaceInefficientStreamCountInspection.extractLambdaReturnExpression((PsiLambdaExpression)parameter)) instanceof PsiMethodCallExpression && SimplifyStreamApiCallChainsInspection.isCallOf(lambdaMethod = ((PsiMethodCallExpression)expression).resolveMethod(), "java.util.Collection", STREAM_METHOD, 0);
    }

    @Nullable
    private static PsiExpression extractLambdaReturnExpression(PsiLambdaExpression lambda2) {
        PsiStatement[] statements;
        PsiElement lambdaBody = lambda2.getBody();
        PsiExpression expression = null;
        if (lambdaBody instanceof PsiExpression) {
            expression = (PsiExpression)lambdaBody;
        } else if (lambdaBody instanceof PsiCodeBlock && (statements = ((PsiCodeBlock)lambdaBody).getStatements()).length == 1 && statements[0] instanceof PsiReturnStatement) {
            expression = ((PsiReturnStatement)statements[0]).getReturnValue();
        }
        return PsiUtil.skipParenthesizedExprDown(expression);
    }

    private static class FlatMapCountFix
    implements LocalQuickFix {
        private FlatMapCountFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$FlatMapCountFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace Stream.flatMap().count() with Stream.mapToLong().sum()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$FlatMapCountFix", "getFamilyName"));
            }
            return "Replace Stream.flatMap().count() with Stream.mapToLong().sum()";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression expression;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$FlatMapCountFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$FlatMapCountFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiElement countName = ((PsiMethodCallExpression)element).getMethodExpression().getReferenceNameElement();
            if (countName == null) {
                return;
            }
            PsiMethodCallExpression qualifierCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall((PsiMethodCallExpression)element);
            if (qualifierCall == null) {
                return;
            }
            PsiMethod qualifier = qualifierCall.resolveMethod();
            if (!SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.stream.Stream", ReplaceInefficientStreamCountInspection.FLAT_MAP_METHOD, 1)) {
                return;
            }
            PsiElement flatMapName = qualifierCall.getMethodExpression().getReferenceNameElement();
            if (flatMapName == null) {
                return;
            }
            PsiExpression parameter = qualifierCall.getArgumentList().getExpressions()[0];
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element.getContainingFile())) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            PsiElement streamCallName = null;
            if (parameter instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)parameter;
                streamCallName = methodRef.getReferenceNameElement();
            } else if (parameter instanceof PsiLambdaExpression && (expression = ReplaceInefficientStreamCountInspection.extractLambdaReturnExpression((PsiLambdaExpression)parameter)) instanceof PsiMethodCallExpression) {
                streamCallName = ((PsiMethodCallExpression)expression).getMethodExpression().getReferenceNameElement();
            }
            if (streamCallName == null || !streamCallName.getText().equals(ReplaceInefficientStreamCountInspection.STREAM_METHOD)) {
                return;
            }
            streamCallName.replace(factory.createIdentifier(ReplaceInefficientStreamCountInspection.SIZE_METHOD));
            flatMapName.replace(factory.createIdentifier("mapToLong"));
            countName.replace(factory.createIdentifier("sum"));
            PsiReferenceParameterList parameterList = qualifierCall.getMethodExpression().getParameterList();
            if (parameterList != null) {
                parameterList.delete();
            }
        }

        public String getMessage() {
            return "Stream.flatMap().count() can be replaced with Stream.mapToLong().sum()";
        }
    }

    private static class StreamCountFix
    extends SimplifyStreamApiCallChainsInspection.ReplaceStreamMethodFix {
        public StreamCountFix() {
            super(ReplaceInefficientStreamCountInspection.COUNT_METHOD, ReplaceInefficientStreamCountInspection.SIZE_METHOD, false);
        }

        @Override
        protected void replaceMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiMethodCallExpression qualifierCall, @Nullable PsiExpression qualifierExpression) {
            Project project;
            PsiExpression expression;
            PsiElement replacement;
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$StreamCountFix", "replaceMethodCall"));
            }
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/ReplaceInefficientStreamCountInspection$StreamCountFix", "replaceMethodCall"));
            }
            super.replaceMethodCall(methodCall, qualifierCall, qualifierExpression);
            PsiElement parent = methodCall.getParent();
            if (parent != null && !(parent instanceof PsiExpressionStatement) && (replacement = methodCall.replace(expression = JavaPsiFacade.getElementFactory(project = methodCall.getProject()).createExpressionFromText("(long) " + methodCall.getText(), methodCall))) instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)replacement)) {
                RedundantCastUtil.removeCast((PsiTypeCastExpression)replacement);
            }
        }
    }
}

