/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.text.MessageFormat;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplifyStreamApiCallChainsInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final String FOR_EACH_METHOD = "forEach";
    private static final String FOR_EACH_ORDERED_METHOD = "forEachOrdered";
    private static final String STREAM_METHOD = "stream";
    private static final String EMPTY_METHOD = "empty";
    private static final String AS_LIST_METHOD = "asList";
    private static final String OF_METHOD = "of";
    private static final String EMPTY_LIST_METHOD = "emptyList";
    private static final String EMPTY_SET_METHOD = "emptySet";
    private static final String SINGLETON_LIST_METHOD = "singletonList";
    private static final String SINGLETON_METHOD = "singleton";
    private static final String COLLECT_METHOD = "collect";
    private static final String COUNTING_COLLECTOR = "counting";
    private static final String MIN_BY_COLLECTOR = "minBy";
    private static final String MAX_BY_COLLECTOR = "maxBy";
    private static final String MAPPING_COLLECTOR = "mapping";
    private static final String REDUCING_COLLECTOR = "reducing";
    private static final String SUMMING_INT_COLLECTOR = "summingInt";
    private static final String SUMMING_LONG_COLLECTOR = "summingLong";
    private static final String SUMMING_DOUBLE_COLLECTOR = "summingDouble";

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression methodCall) {
                PsiMethod method = methodCall.resolveMethod();
                if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.Collection", SimplifyStreamApiCallChainsInspection.STREAM_METHOD, 0)) {
                    PsiMethodCallExpression qualifierCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(methodCall);
                    if (qualifierCall == null) {
                        return;
                    }
                    PsiMethod qualifier = qualifierCall.resolveMethod();
                    ReplaceCollectionStreamFix fix = null;
                    if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Arrays", SimplifyStreamApiCallChainsInspection.AS_LIST_METHOD, 1)) {
                        fix = SimplifyStreamApiCallChainsInspection.hasSingleArrayArgument(qualifierCall) ? new ArraysAsListSingleArrayFix() : new ReplaceWithStreamOfFix("Arrays.asList()");
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collections", SimplifyStreamApiCallChainsInspection.SINGLETON_LIST_METHOD, 1)) {
                        if (!SimplifyStreamApiCallChainsInspection.hasSingleArrayArgument(qualifierCall)) {
                            fix = new ReplaceSingletonWithStreamOfFix("Collections.singletonList()");
                        }
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collections", SimplifyStreamApiCallChainsInspection.SINGLETON_METHOD, 1)) {
                        if (!SimplifyStreamApiCallChainsInspection.hasSingleArrayArgument(qualifierCall)) {
                            fix = new ReplaceSingletonWithStreamOfFix("Collections.singleton()");
                        }
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collections", SimplifyStreamApiCallChainsInspection.EMPTY_LIST_METHOD, 0)) {
                        fix = new ReplaceWithStreamEmptyFix(SimplifyStreamApiCallChainsInspection.EMPTY_LIST_METHOD);
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collections", SimplifyStreamApiCallChainsInspection.EMPTY_SET_METHOD, 0)) {
                        fix = new ReplaceWithStreamEmptyFix(SimplifyStreamApiCallChainsInspection.EMPTY_SET_METHOD);
                    }
                    if (fix != null) {
                        holder.registerProblem((PsiElement)methodCall, null, fix.getMessage(), fix);
                    }
                } else if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.COLLECT_METHOD, 1)) {
                    PsiExpression parameter = methodCall.getArgumentList().getExpressions()[0];
                    if (parameter instanceof PsiMethodCallExpression) {
                        PsiMethodCallExpression collectorCall = (PsiMethodCallExpression)parameter;
                        PsiMethod collectorMethod = collectorCall.resolveMethod();
                        ReplaceCollectorFix fix = null;
                        if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.COUNTING_COLLECTOR, 0)) {
                            fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.COUNTING_COLLECTOR, "count()", false);
                        } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.MIN_BY_COLLECTOR, 1)) {
                            fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.MIN_BY_COLLECTOR, "min({0})", true);
                        } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.MAX_BY_COLLECTOR, 1)) {
                            fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.MAX_BY_COLLECTOR, "max({0})", true);
                        } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.MAPPING_COLLECTOR, 2)) {
                            fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.MAPPING_COLLECTOR, "map({0}).collect({1})", false);
                        } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.REDUCING_COLLECTOR, 1)) {
                            fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.REDUCING_COLLECTOR, "reduce({0})", true);
                        } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.REDUCING_COLLECTOR, 2)) {
                            fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.REDUCING_COLLECTOR, "reduce({0}, {1})", false);
                        } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.REDUCING_COLLECTOR, 3)) {
                            fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.REDUCING_COLLECTOR, "map({1}).reduce({0}, {2})", false);
                        } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.SUMMING_INT_COLLECTOR, 1)) {
                            fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.SUMMING_INT_COLLECTOR, "mapToInt({0}).sum()", false);
                        } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.SUMMING_LONG_COLLECTOR, 1)) {
                            fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.SUMMING_LONG_COLLECTOR, "mapToLong({0}).sum()", false);
                        } else if (SimplifyStreamApiCallChainsInspection.isCallOf(collectorMethod, "java.util.stream.Collectors", SimplifyStreamApiCallChainsInspection.SUMMING_DOUBLE_COLLECTOR, 1)) {
                            fix = new ReplaceCollectorFix(SimplifyStreamApiCallChainsInspection.SUMMING_DOUBLE_COLLECTOR, "mapToDouble({0}).sum()", false);
                        }
                        if (fix != null && collectorCall.getArgumentList().getExpressions().length == collectorMethod.getParameterList().getParametersCount()) {
                            TextRange range = methodCall.getTextRange();
                            PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
                            if (nameElement != null) {
                                range = new TextRange(nameElement.getTextOffset(), range.getEndOffset());
                            }
                            holder.registerProblem((PsiElement)methodCall, range.shiftRight(-methodCall.getTextOffset()), fix.getMessage(), fix);
                        }
                    }
                } else {
                    String name;
                    if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD, 1)) {
                        name = SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD;
                    } else if (SimplifyStreamApiCallChainsInspection.isCallOf(method, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.FOR_EACH_ORDERED_METHOD, 1)) {
                        name = SimplifyStreamApiCallChainsInspection.FOR_EACH_ORDERED_METHOD;
                    } else {
                        return;
                    }
                    PsiMethodCallExpression qualifierCall = SimplifyStreamApiCallChainsInspection.getQualifierMethodCall(methodCall);
                    if (qualifierCall == null) {
                        return;
                    }
                    PsiMethod qualifier = qualifierCall.resolveMethod();
                    if (SimplifyStreamApiCallChainsInspection.isCallOf(qualifier, "java.util.Collection", SimplifyStreamApiCallChainsInspection.STREAM_METHOD, 0)) {
                        ReplaceStreamMethodFix fix = new ReplaceStreamMethodFix(name, SimplifyStreamApiCallChainsInspection.FOR_EACH_METHOD, true);
                        holder.registerProblem((PsiElement)methodCall, SimplifyStreamApiCallChainsInspection.getCallChainRange(methodCall, qualifierCall), fix.getMessage(), fix);
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    static boolean hasSingleArrayArgument(PsiMethodCallExpression qualifierCall) {
        PsiType type;
        PsiExpression[] argumentExpressions = qualifierCall.getArgumentList().getExpressions();
        if (argumentExpressions.length == 1 && (type = argumentExpressions[0].getType()) instanceof PsiArrayType) {
            PsiType[] parameters;
            PsiType methodType = qualifierCall.getType();
            return !(methodType instanceof PsiClassType) || (parameters = ((PsiClassType)methodType).getParameters()).length != 1 || !TypeConversionUtil.isAssignable(parameters[0], type) || TypeConversionUtil.isAssignable(parameters[0], ((PsiArrayType)type).getComponentType());
        }
        return false;
    }

    @Nullable
    static PsiMethodCallExpression getQualifierMethodCall(PsiMethodCallExpression methodCall) {
        PsiExpression qualifierExpression = methodCall.getMethodExpression().getQualifierExpression();
        if (qualifierExpression instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)qualifierExpression;
        }
        return null;
    }

    @NotNull
    protected static TextRange getCallChainRange(@NotNull PsiMethodCallExpression expression, @NotNull PsiMethodCallExpression qualifierExpression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        if (qualifierExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierExpression", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        PsiReferenceExpression qualifierMethodExpression = qualifierExpression.getMethodExpression();
        PsiElement qualifierNameElement = qualifierMethodExpression.getReferenceNameElement();
        int startOffset = (qualifierNameElement != null ? qualifierNameElement : qualifierMethodExpression).getTextOffset();
        int endOffset = expression.getMethodExpression().getTextRange().getEndOffset();
        TextRange textRange = new TextRange(startOffset, endOffset).shiftRight(-expression.getTextOffset());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "getCallChainRange"));
        }
        return textRange;
    }

    @Contract(value="null, _, _, _ -> false")
    protected static boolean isCallOf(@Nullable PsiMethod method, @NotNull String className, @NotNull String methodName, int parametersCount) {
        PsiClass containingClass;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "isCallOf"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection", "isCallOf"));
        }
        if (method == null) {
            return false;
        }
        return methodName.equals(method.getName()) && method.getParameterList().getParametersCount() == parametersCount && (containingClass = method.getContainingClass()) != null && className.equals(containingClass.getQualifiedName());
    }

    private static class ReplaceCollectorFix
    implements LocalQuickFix {
        private final String myCollector;
        private final String myStreamSequence;
        private final String myStreamSequenceStripped;
        private final boolean myChangeSemantics;

        public ReplaceCollectorFix(String collector, String streamSequence, boolean changeSemantics) {
            this.myCollector = collector;
            this.myStreamSequence = streamSequence;
            this.myStreamSequenceStripped = streamSequence.replaceAll("\\([^)]+\\)", "()");
            this.myChangeSemantics = changeSemantics;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectorFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = "Replace Stream.collect(" + this.myCollector + "()) with Stream." + this.myStreamSequenceStripped + (this.myChangeSemantics ? " (may change semantics when result is null)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectorFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression parameter;
            PsiMethodCallExpression collectCall;
            PsiExpression qualifierExpression;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectorFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectorFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (element instanceof PsiMethodCallExpression && (qualifierExpression = (collectCall = (PsiMethodCallExpression)element).getMethodExpression().getQualifierExpression()) != null && (parameter = collectCall.getArgumentList().getExpressions()[0]) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression collectorCall = (PsiMethodCallExpression)parameter;
                PsiExpression[] collectorArgs = collectorCall.getArgumentList().getExpressions();
                String result = MessageFormat.format(this.myStreamSequence, Arrays.stream(collectorArgs).map(PsiElement::getText).toArray());
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element.getContainingFile())) {
                    return;
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
                PsiExpression replacement = factory.createExpressionFromText(qualifierExpression.getText() + "." + result, collectCall);
                ReplaceCollectorFix.addBoxingIfNecessary(factory, collectCall.replace(replacement));
            }
        }

        private static void addBoxingIfNecessary(PsiElementFactory factory, PsiElement expression) {
            PsiExpression castExpression;
            PsiElement cast;
            PsiClassType boxedType;
            PsiType type;
            if (expression instanceof PsiExpression && (type = ((PsiExpression)expression).getType()) instanceof PsiPrimitiveType && (boxedType = ((PsiPrimitiveType)type).getBoxedType(expression)) != null && (cast = expression.replace(castExpression = factory.createExpressionFromText("(" + boxedType.getCanonicalText() + ") " + expression.getText(), expression))) instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)cast)) {
                RedundantCastUtil.removeCast((PsiTypeCastExpression)cast);
            }
        }

        @NotNull
        String getMessage() {
            String string = "Stream.collect(" + this.myCollector + "()) can be replaced with Stream." + this.myStreamSequenceStripped + "()" + (this.myChangeSemantics ? " (may change semantics when result is null)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectorFix", "getMessage"));
            }
            return string;
        }
    }

    static class ReplaceStreamMethodFix
    extends CallChainFixBase {
        private final String myStreamMethod;
        private final String myCollectionMethod;
        private final boolean myChangeSemantics;

        public ReplaceStreamMethodFix(String streamMethod, String collectionMethod, boolean changeSemantics) {
            this.myStreamMethod = streamMethod;
            this.myCollectionMethod = collectionMethod;
            this.myChangeSemantics = changeSemantics;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = "Replace Collection.stream()." + this.myStreamMethod + "() with Collection." + this.myCollectionMethod + "()" + (this.myChangeSemantics ? " (may change semantics)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceStreamMethodFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        String getMessage() {
            String string = "Collection.stream()." + this.myStreamMethod + "() can be replaced with Collection." + this.myCollectionMethod + "()" + (this.myChangeSemantics ? " (may change semantics)" : "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceStreamMethodFix", "getMessage"));
            }
            return string;
        }

        @Override
        protected void replaceMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiMethodCallExpression qualifierCall, @Nullable PsiExpression qualifierExpression) {
            PsiElement nameElement;
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceStreamMethodFix", "replaceMethodCall"));
            }
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceStreamMethodFix", "replaceMethodCall"));
            }
            if (qualifierExpression != null && (nameElement = methodCall.getMethodExpression().getReferenceNameElement()) != null) {
                qualifierCall.replace(qualifierExpression);
                if (!this.myStreamMethod.equals(this.myCollectionMethod)) {
                    Project project = methodCall.getProject();
                    PsiIdentifier collectionMethod = JavaPsiFacade.getElementFactory(project).createIdentifier(this.myCollectionMethod);
                    nameElement.replace(collectionMethod);
                }
            }
        }
    }

    private static class ReplaceWithStreamEmptyFix
    extends ReplaceCollectionStreamFix {
        private ReplaceWithStreamEmptyFix(String qualifierMethodName) {
            super("Collections." + qualifierMethodName + "()", "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.EMPTY_METHOD);
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with Stream.empty()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceWithStreamEmptyFix", "getFamilyName"));
            }
            return "Replace with Stream.empty()";
        }
    }

    private static class ArraysAsListSingleArrayFix
    extends ReplaceCollectionStreamFix {
        private ArraysAsListSingleArrayFix() {
            super("Arrays.asList()", "java.util.Arrays", SimplifyStreamApiCallChainsInspection.STREAM_METHOD);
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace Arrays.asList().stream() with Arrays.stream()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ArraysAsListSingleArrayFix", "getFamilyName"));
            }
            return "Replace Arrays.asList().stream() with Arrays.stream()";
        }
    }

    private static class ReplaceSingletonWithStreamOfFix
    extends ReplaceWithStreamOfFix {
        private ReplaceSingletonWithStreamOfFix(String qualifierCall) {
            super(qualifierCall);
        }

        @Override
        @Nullable
        protected String getTypeParameter(@NotNull PsiMethodCallExpression qualifierCall) {
            PsiType argType;
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceSingletonWithStreamOfFix", "getTypeParameter"));
            }
            String typeParameter = super.getTypeParameter(qualifierCall);
            if (typeParameter != null) {
                return typeParameter;
            }
            PsiType[] argTypes = qualifierCall.getArgumentList().getExpressionTypes();
            if (argTypes.length == 1 && (argType = argTypes[0]) instanceof PsiArrayType) {
                return argType.getCanonicalText();
            }
            return null;
        }
    }

    private static class ReplaceWithStreamOfFix
    extends ReplaceCollectionStreamFix {
        private ReplaceWithStreamOfFix(String qualifierCall) {
            super(qualifierCall, "java.util.stream.Stream", SimplifyStreamApiCallChainsInspection.OF_METHOD);
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with Stream.of()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceWithStreamOfFix", "getFamilyName"));
            }
            return "Replace with Stream.of()";
        }
    }

    private static abstract class ReplaceCollectionStreamFix
    extends CallChainFixBase {
        private final String myClassName;
        private final String myMethodName;
        private final String myQualifierCall;

        private ReplaceCollectionStreamFix(String qualifierCall, String className, String methodName) {
            this.myQualifierCall = qualifierCall;
            this.myClassName = className;
            this.myMethodName = methodName;
        }

        @NotNull
        String getMessage() {
            String string = this.myQualifierCall + ".stream() can be replaced with " + ClassUtil.extractClassName(this.myClassName) + "." + this.myMethodName + "()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "getMessage"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace " + this.myQualifierCall + ".stream() with " + ClassUtil.extractClassName(this.myClassName) + "." + this.myMethodName + "()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "getName"));
            }
            return string;
        }

        @Nullable
        protected String getTypeParameter(@NotNull PsiMethodCallExpression qualifierCall) {
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "getTypeParameter"));
            }
            PsiType[] parameters = qualifierCall.getMethodExpression().getTypeParameters();
            return parameters.length == 1 ? parameters[0].getCanonicalText() : null;
        }

        @Override
        protected void replaceMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiMethodCallExpression qualifierCall, @Nullable PsiExpression qualifierExpression) {
            if (methodCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "replaceMethodCall"));
            }
            if (qualifierCall == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierCall", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$ReplaceCollectionStreamFix", "replaceMethodCall"));
            }
            methodCall.getArgumentList().replace(qualifierCall.getArgumentList());
            Project project = methodCall.getProject();
            String typeParameter = this.getTypeParameter(qualifierCall);
            String replacement = typeParameter != null ? this.myClassName + ".<" + typeParameter + ">" + this.myMethodName : this.myClassName + "." + this.myMethodName;
            PsiExpression newMethodExpression = JavaPsiFacade.getElementFactory(project).createExpressionFromText(replacement, methodCall);
            JavaCodeStyleManager.getInstance(project).shortenClassReferences(methodCall.getMethodExpression().replace(newMethodExpression));
        }
    }

    private static abstract class CallChainFixBase
    implements LocalQuickFix {
        private CallChainFixBase() {
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CallChainFixBase", "getName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CallChainFixBase", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/SimplifyStreamApiCallChainsInspection$CallChainFixBase", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            if (element instanceof PsiMethodCallExpression) {
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element.getContainingFile())) {
                    return;
                }
                PsiMethodCallExpression expression = (PsiMethodCallExpression)element;
                PsiExpression forEachMethodQualifier = expression.getMethodExpression().getQualifierExpression();
                if (forEachMethodQualifier instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression previousExpression = (PsiMethodCallExpression)forEachMethodQualifier;
                    PsiExpression qualifierExpression = previousExpression.getMethodExpression().getQualifierExpression();
                    this.replaceMethodCall(expression, previousExpression, qualifierExpression);
                }
            }
        }

        protected abstract void replaceMethodCall(@NotNull PsiMethodCallExpression var1, @NotNull PsiMethodCallExpression var2, @Nullable PsiExpression var3);
    }
}

