/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamApiMigrationInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance("#" + StreamApiMigrationInspection.class.getName());
    public boolean REPLACE_TRIVIAL_FOREACH;
    private HighlightDisplayKey myKey;

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Replace trivial foreach statements", this, "REPLACE_TRIVIAL_FOREACH");
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("foreach loop can be collapsed with Stream API" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getDisplayName"));
        }
        return "foreach loop can be collapsed with Stream API";
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("Convert2streamapi" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getShortName"));
        }
        return "Convert2streamapi";
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/StreamApiMigrationInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitForeachStatement(PsiForeachStatement statement) {
                super.visitForeachStatement(statement);
                if (PsiUtil.getLanguageLevel(statement).isAtLeast(LanguageLevel.JDK_1_8)) {
                    PsiExpression iteratedValue = statement.getIteratedValue();
                    PsiStatement body = statement.getBody();
                    if (iteratedValue != null && body != null) {
                        boolean isArray;
                        PsiType iteratedValueType = iteratedValue.getType();
                        PsiClass iteratorClass = PsiUtil.resolveClassInClassTypeOnly(iteratedValueType);
                        PsiClass collectionClass = null;
                        if (iteratedValueType instanceof PsiArrayType) {
                            if (((PsiArrayType)iteratedValueType).getComponentType() instanceof PsiPrimitiveType) {
                                return;
                            }
                            isArray = true;
                        } else {
                            collectionClass = JavaPsiFacade.getInstance(body.getProject()).findClass("java.util.Collection", statement.getResolveScope());
                            if (collectionClass != null && InheritanceUtil.isInheritorOrSelf(iteratorClass, collectionClass, true)) {
                                isArray = false;
                            } else {
                                return;
                            }
                        }
                        try {
                            if (ExceptionUtil.getThrownCheckedExceptions(new PsiElement[]{body}).isEmpty()) {
                                PsiReturnStatement returnStatement;
                                PsiExpression value;
                                TerminalBlock tb = TerminalBlock.from(statement.getIterationParameter(), body);
                                List<Operation> operations = tb.extractOperations();
                                if (tb.isEmpty()) {
                                    return;
                                }
                                ControlFlow controlFlow = ControlFlowFactory.getInstance(holder.getProject()).getControlFlow(body, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                                Collection<PsiStatement> exitPoints = ControlFlowUtil.findExitPointsAndStatements(controlFlow, tb.getStartOffset(controlFlow), tb.getEndOffset(controlFlow), new IntArrayList(), PsiContinueStatement.class, PsiBreakStatement.class, PsiReturnStatement.class, PsiThrowStatement.class);
                                int startOffset = controlFlow.getStartOffset(body);
                                int endOffset = controlFlow.getEndOffset(body);
                                List nonFinalVariables = ((StreamEx)StreamEx.of(ControlFlowUtil.getUsedVariables(controlFlow, startOffset, endOffset)).remove(variable -> HighlightControlFlowUtil.isEffectivelyFinal(variable, body, null))).toList();
                                if (exitPoints.isEmpty()) {
                                    if (StreamApiMigrationInspection.getIncrementedVariable(tb, operations, nonFinalVariables) != null) {
                                        StreamApiMigrationInspection.this.registerProblem(holder, statement, "count", new LocalQuickFix[]{new ReplaceWithCountFix()});
                                    }
                                    if (StreamApiMigrationInspection.getAccumulatedVariable(tb, operations, nonFinalVariables) != null) {
                                        StreamApiMigrationInspection.this.registerProblem(holder, statement, "sum", new LocalQuickFix[]{new ReplaceWithSumFix()});
                                    }
                                    if (!nonFinalVariables.isEmpty()) {
                                        return;
                                    }
                                    if ((isArray || !this.isRawSubstitution(iteratedValueType, collectionClass)) && StreamApiMigrationInspection.isCollectCall(tb, operations)) {
                                        PsiMethodCallExpression methodCallExpression;
                                        boolean addAll;
                                        boolean bl = addAll = operations.isEmpty() && StreamApiMigrationInspection.isAddAllCall(tb);
                                        String methodName = addAll ? "addAll" : ((methodCallExpression = tb.getSingleMethodCall()) != null && StreamApiMigrationInspection.extractReplaceableCollectionInitializer(methodCallExpression.getMethodExpression().getQualifierExpression(), statement) != null ? "collect" : "forEach");
                                        StreamApiMigrationInspection.this.registerProblem(holder, statement, methodName, new LocalQuickFix[]{new ReplaceWithCollectFix(methodName)});
                                    } else if (!operations.isEmpty() || !isArray && (StreamApiMigrationInspection.this.REPLACE_TRIVIAL_FOREACH || !StreamApiMigrationInspection.isTrivial(body, statement.getIterationParameter()))) {
                                        ArrayList<ReplaceWithForeachCallFix> fixes = new ArrayList<ReplaceWithForeachCallFix>();
                                        fixes.add(new ReplaceWithForeachCallFix("forEach"));
                                        if (!operations.isEmpty()) {
                                            fixes.add(new ReplaceWithForeachCallFix("forEachOrdered"));
                                        }
                                        StreamApiMigrationInspection.this.registerProblem(holder, statement, "forEach", fixes.toArray(new LocalQuickFix[fixes.size()]));
                                    }
                                } else if (nonFinalVariables.isEmpty() && tb.getSingleStatement() instanceof PsiReturnStatement && (StreamApiMigrationInspection.isLiteral(value = (returnStatement = (PsiReturnStatement)tb.getSingleStatement()).getReturnValue(), Boolean.TRUE) || StreamApiMigrationInspection.isLiteral(value, Boolean.FALSE))) {
                                    PsiReturnStatement nextReturnStatement;
                                    boolean foundResult = (Boolean)((PsiLiteralExpression)value).getValue();
                                    PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward(statement, PsiWhiteSpace.class, PsiComment.class);
                                    if (nextStatement instanceof PsiReturnStatement && StreamApiMigrationInspection.isLiteral((nextReturnStatement = (PsiReturnStatement)nextStatement).getReturnValue(), !foundResult)) {
                                        String methodName;
                                        if (foundResult) {
                                            methodName = "anyMatch";
                                        } else {
                                            Operation lastOp;
                                            methodName = "noneMatch";
                                            if (!operations.isEmpty() && (lastOp = operations.get(operations.size() - 1)) instanceof FilterOp && BoolUtils.isNegation(lastOp.getExpression())) {
                                                methodName = "allMatch";
                                            }
                                        }
                                        StreamApiMigrationInspection.this.registerProblem(holder, statement, methodName, new LocalQuickFix[]{new ReplaceWithMatchFix(methodName)});
                                    }
                                }
                            }
                        }
                        catch (AnalysisCanceledException analysisCanceledException) {
                            // empty catch block
                        }
                    }
                }
            }

            private boolean isRawSubstitution(PsiType iteratedValueType, PsiClass collectionClass) {
                return iteratedValueType instanceof PsiClassType && PsiUtil.isRawSubstitutor(collectionClass, TypeConversionUtil.getSuperClassSubstitutor(collectionClass, (PsiClassType)iteratedValueType));
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @NotNull
    private TextRange getRange(PsiForeachStatement statement) {
        PsiExpression iteratedValue;
        if (this.myKey == null) {
            this.myKey = HighlightDisplayKey.find(this.getShortName());
        }
        boolean wholeStatement = false;
        if (this.myKey != null) {
            InspectionProfile profile = InspectionProjectProfileManager.getInstance(statement.getProject()).getCurrentProfile();
            HighlightDisplayLevel level = profile.getErrorLevel(this.myKey, statement);
            wholeStatement = HighlightDisplayLevel.DO_NOT_SHOW.equals(level);
        }
        LOG.assertTrue((iteratedValue = statement.getIteratedValue()) != null);
        PsiJavaToken rParenth = statement.getRParenth();
        if (wholeStatement && rParenth != null) {
            TextRange textRange = new TextRange(statement.getTextOffset(), rParenth.getTextOffset() + 1);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getRange"));
            }
            return textRange;
        }
        TextRange textRange = iteratedValue.getTextRange();
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getRange"));
        }
        return textRange;
    }

    private void registerProblem(ProblemsHolder holder, PsiForeachStatement statement, String methodName, LocalQuickFix ... fixes) {
        PsiExpression iteratedValue = statement.getIteratedValue();
        LOG.assertTrue(iteratedValue != null);
        holder.registerProblem((PsiElement)statement, this.getRange(statement).shiftRight(-statement.getTextOffset()), "Can be replaced with '" + methodName + "' call", fixes);
    }

    @Contract(value="null, _ -> false")
    private static boolean isLiteral(PsiElement element, Object value) {
        return element instanceof PsiLiteralExpression && value.equals(((PsiLiteralExpression)element).getValue());
    }

    @Contract(value="null, null -> true; null, !null -> false")
    private static boolean sameReference(PsiExpression expr1, PsiExpression expr2) {
        if (expr1 == null && expr2 == null) {
            return true;
        }
        if (!(expr1 instanceof PsiReferenceExpression) || !(expr2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression ref1 = (PsiReferenceExpression)expr1;
        PsiReferenceExpression ref2 = (PsiReferenceExpression)expr2;
        return Objects.equals(ref1.getReferenceName(), ref2.getReferenceName()) && StreamApiMigrationInspection.sameReference(ref1.getQualifierExpression(), ref2.getQualifierExpression());
    }

    @Nullable
    private static PsiExpression extractAddend(PsiAssignmentExpression assignment) {
        PsiBinaryExpression binOp;
        if (JavaTokenType.PLUSEQ.equals(assignment.getOperationTokenType())) {
            return assignment.getRExpression();
        }
        if (JavaTokenType.EQ.equals(assignment.getOperationTokenType()) && assignment.getRExpression() instanceof PsiBinaryExpression && JavaTokenType.PLUS.equals((binOp = (PsiBinaryExpression)assignment.getRExpression()).getOperationTokenType())) {
            if (StreamApiMigrationInspection.sameReference(binOp.getLOperand(), assignment.getLExpression())) {
                return binOp.getROperand();
            }
            if (StreamApiMigrationInspection.sameReference(binOp.getROperand(), assignment.getLExpression())) {
                return binOp.getLOperand();
            }
        }
        return null;
    }

    @Nullable
    private static PsiLocalVariable extractAccumulator(PsiAssignmentExpression assignment) {
        PsiBinaryExpression binOp;
        if (!(assignment.getLExpression() instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression lExpr = (PsiReferenceExpression)assignment.getLExpression();
        PsiElement accumulator = lExpr.resolve();
        if (!(accumulator instanceof PsiLocalVariable)) {
            return null;
        }
        PsiLocalVariable var = (PsiLocalVariable)accumulator;
        if (JavaTokenType.PLUSEQ.equals(assignment.getOperationTokenType())) {
            return var;
        }
        if (JavaTokenType.EQ.equals(assignment.getOperationTokenType()) && assignment.getRExpression() instanceof PsiBinaryExpression && JavaTokenType.PLUS.equals((binOp = (PsiBinaryExpression)assignment.getRExpression()).getOperationTokenType())) {
            PsiExpression left = binOp.getLOperand();
            PsiExpression right = binOp.getROperand();
            if (StreamApiMigrationInspection.sameReference(left, lExpr) || StreamApiMigrationInspection.sameReference(right, lExpr)) {
                return var;
            }
        }
        return null;
    }

    @Contract(value="null -> null")
    private static PsiExpression extractIncrementedLValue(PsiExpression expression) {
        PsiAssignmentExpression assignment;
        if (expression instanceof PsiPostfixExpression) {
            if (JavaTokenType.PLUSPLUS.equals(((PsiPostfixExpression)expression).getOperationTokenType())) {
                return ((PsiPostfixExpression)expression).getOperand();
            }
        } else if (expression instanceof PsiPrefixExpression) {
            if (JavaTokenType.PLUSPLUS.equals(((PsiPrefixExpression)expression).getOperationTokenType())) {
                return ((PsiPrefixExpression)expression).getOperand();
            }
        } else if (expression instanceof PsiAssignmentExpression && StreamApiMigrationInspection.isLiteral(StreamApiMigrationInspection.extractAddend(assignment = (PsiAssignmentExpression)expression), 1)) {
            return assignment.getLExpression();
        }
        return null;
    }

    @Nullable
    private static PsiLocalVariable getIncrementedVariable(TerminalBlock tb, List<Operation> operations, List<PsiVariable> variables) {
        if (variables.size() != 1) {
            return null;
        }
        PsiExpression operand = StreamApiMigrationInspection.extractIncrementedLValue(tb.getSingleExpression(PsiExpression.class));
        if (!(operand instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)operand).resolve();
        if (!(element instanceof PsiLocalVariable) || !variables.contains(element)) {
            return null;
        }
        for (Operation operation : operations) {
            if (ReferencesSearch.search(element, new LocalSearchScope(operation.getExpression())).findFirst() == null) continue;
            return null;
        }
        return (PsiLocalVariable)element;
    }

    @Nullable
    private static PsiLocalVariable getAccumulatedVariable(TerminalBlock tb, List<Operation> operations, List<PsiVariable> variables) {
        if (variables.size() != 1) {
            return null;
        }
        PsiAssignmentExpression assignment = tb.getSingleExpression(PsiAssignmentExpression.class);
        if (assignment == null) {
            return null;
        }
        PsiLocalVariable var = StreamApiMigrationInspection.extractAccumulator(assignment);
        if (var == null || !variables.contains(var)) {
            return null;
        }
        if (!(var.getType() instanceof PsiPrimitiveType) || var.getType().equalsToText("float")) {
            return null;
        }
        for (Operation operation : operations) {
            if (ReferencesSearch.search(var, new LocalSearchScope(operation.getExpression())).findFirst() == null) continue;
            return null;
        }
        PsiExpression addend = StreamApiMigrationInspection.extractAddend(assignment);
        LOG.assertTrue(addend != null);
        if (ReferencesSearch.search(var, new LocalSearchScope(addend)).findFirst() != null) {
            return null;
        }
        return var;
    }

    private static boolean isAddAllCall(TerminalBlock tb) {
        PsiVariable variable = tb.getVariable();
        PsiMethodCallExpression methodCallExpression = tb.getSingleMethodCall();
        LOG.assertTrue(methodCallExpression != null);
        return StreamApiMigrationInspection.isIdentityMapping(variable, methodCallExpression.getArgumentList().getExpressions()[0]);
    }

    private static boolean isCollectCall(TerminalBlock tb, List<Operation> operations) {
        PsiMethodCallExpression methodCallExpression = tb.getSingleMethodCall();
        if (methodCallExpression != null) {
            Object enclosingClass;
            PsiElement resolve;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            PsiClass qualifierClass = null;
            if (qualifierExpression instanceof PsiReferenceExpression) {
                if (ReferencesSearch.search(tb.getVariable(), new LocalSearchScope(qualifierExpression)).findFirst() != null) {
                    return false;
                }
                resolve = ((PsiReferenceExpression)qualifierExpression).resolve();
                if (resolve instanceof PsiVariable && ReferencesSearch.search(resolve, new LocalSearchScope(methodCallExpression.getArgumentList())).findFirst() != null) {
                    return false;
                }
                qualifierClass = PsiUtil.resolveClassInType(qualifierExpression.getType());
            } else if (qualifierExpression == null && PsiUtil.getEnclosingStaticElement(methodCallExpression, (PsiClass)(enclosingClass = PsiTreeUtil.getParentOfType((PsiElement)methodCallExpression, PsiClass.class))) == null) {
                qualifierClass = enclosingClass;
            }
            if (qualifierClass != null && InheritanceUtil.isInheritor(qualifierClass, false, "java.util.Collection")) {
                PsiExpression[] args;
                for (Operation op : operations) {
                    PsiExpression expression = op.getExpression();
                    if (expression == null || !StreamApiMigrationInspection.isExpressionDependsOnUpdatedCollections(expression, qualifierExpression)) continue;
                    return false;
                }
                resolve = methodExpression.resolve();
                if (resolve instanceof PsiMethod && "add".equals(((PsiMethod)resolve).getName()) && ((PsiMethod)resolve).getParameterList().getParametersCount() == 1 && (args = methodCallExpression.getArgumentList().getExpressions()).length == 1) {
                    if (args[0] instanceof PsiCallExpression) {
                        PsiMethod method = ((PsiCallExpression)args[0]).resolveMethod();
                        return method != null && !method.hasTypeParameters() && !StreamApiMigrationInspection.isThrowsCompatible(method);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isExpressionDependsOnUpdatedCollections(PsiExpression condition, PsiExpression qualifierExpression) {
        PsiElement collection;
        PsiElement psiElement = collection = qualifierExpression instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifierExpression).resolve() : null;
        if (collection != null) {
            return ReferencesSearch.search(collection, new LocalSearchScope(condition)).findFirst() != null;
        }
        final boolean[] dependsOnCollection = new boolean[]{false};
        condition.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiExpression callQualifier = expression.getMethodExpression().getQualifierExpression();
                if (callQualifier == null || callQualifier instanceof PsiThisExpression && ((PsiThisExpression)callQualifier).getQualifier() == null || callQualifier instanceof PsiSuperExpression && ((PsiSuperExpression)callQualifier).getQualifier() == null) {
                    dependsOnCollection[0] = true;
                }
            }

            @Override
            public void visitThisExpression(PsiThisExpression expression) {
                super.visitThisExpression(expression);
                if (expression.getQualifier() == null && expression.getParent() instanceof PsiExpressionList) {
                    dependsOnCollection[0] = true;
                }
            }

            @Override
            public void visitClass(PsiClass aClass) {
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression) {
            }
        });
        return dependsOnCollection[0];
    }

    private static boolean isTrivial(PsiStatement body, PsiParameter parameter) {
        PsiExpression candidate = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem(body instanceof PsiBlockStatement ? ((PsiBlockStatement)body).getCodeBlock() : body, new PsiParameter[]{parameter}, StreamApiMigrationInspection.createDefaultConsumerType(parameter.getProject(), parameter));
        if (!(candidate instanceof PsiCallExpression)) {
            return true;
        }
        PsiMethod method = ((PsiCallExpression)candidate).resolveMethod();
        return method != null && StreamApiMigrationInspection.isThrowsCompatible(method);
    }

    private static boolean isThrowsCompatible(PsiMethod method) {
        return ContainerUtil.find(method.getThrowsList().getReferencedTypes(), type -> !ExceptionUtil.isUncheckedException(type)) != null;
    }

    private static boolean isIdentityMapping(PsiVariable variable, PsiExpression mapperCall) {
        return mapperCall instanceof PsiReferenceExpression && ((PsiReferenceExpression)mapperCall).resolve() == variable;
    }

    static String compoundLambdaOrMethodReference(PsiVariable variable, PsiExpression expression, String samQualifiedName, PsiType[] samParamTypes) {
        String result = "";
        Project project = variable.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiClass functionClass = psiFacade.findClass(samQualifiedName, expression.getResolveScope());
        for (int i = 0; i < samParamTypes.length; ++i) {
            if (!(samParamTypes[i] instanceof PsiPrimitiveType)) continue;
            samParamTypes[i] = ((PsiPrimitiveType)samParamTypes[i]).getBoxedType(expression);
        }
        PsiVariable[] parameters = new PsiVariable[]{variable};
        PsiClassType functionalInterfaceType = functionClass != null ? psiFacade.getElementFactory().createType(functionClass, samParamTypes) : null;
        String methodReferenceText = LambdaCanBeMethodReferenceInspection.convertToMethodReference(expression, parameters, functionalInterfaceType, null);
        if (methodReferenceText != null) {
            LOG.assertTrue(functionalInterfaceType != null);
            result = result + "(" + functionalInterfaceType.getCanonicalText() + ")" + methodReferenceText;
        } else {
            result = result + variable.getName() + " -> " + expression.getText();
        }
        return result;
    }

    private static PsiClassType createDefaultConsumerType(Project project, PsiVariable variable) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiClass consumerClass = psiFacade.findClass("java.util.function.Consumer", GlobalSearchScope.allScope(project));
        return consumerClass != null ? psiFacade.getElementFactory().createType(consumerClass, variable.getType()) : null;
    }

    @Contract(value="null, _ -> null")
    static PsiExpression extractReplaceableCollectionInitializer(PsiExpression qualifierExpression, PsiStatement foreachStatement) {
        PsiExpressionList argumentList;
        PsiExpression initializer;
        PsiLocalVariable var;
        PsiElement resolve;
        if (qualifierExpression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiLocalVariable && StreamApiMigrationInspection.isDeclarationJustBefore(var = (PsiLocalVariable)resolve, foreachStatement) && (initializer = var.getInitializer()) instanceof PsiNewExpression && (argumentList = ((PsiNewExpression)initializer).getArgumentList()) != null && argumentList.getExpressions().length == 0) {
            return initializer;
        }
        return null;
    }

    private static boolean isDeclarationJustBefore(PsiLocalVariable var, PsiStatement nextStatement) {
        PsiElement[] elements;
        PsiElement declaration = var.getParent();
        return declaration instanceof PsiDeclarationStatement && ArrayUtil.getLastElement(elements = ((PsiDeclarationStatement)declaration).getDeclaredElements()) == var && nextStatement.equals(PsiTreeUtil.skipSiblingsForward(declaration, PsiWhiteSpace.class, PsiComment.class));
    }

    static class TerminalBlock {
        private PsiVariable myVariable;
        private PsiStatement[] myStatements;

        private TerminalBlock(PsiVariable variable, PsiStatement[] statements) {
            this.myVariable = variable;
            this.myStatements = statements;
            this.flatten();
        }

        private void flatten() {
            while (this.myStatements.length == 1 && this.myStatements[0] instanceof PsiBlockStatement) {
                this.myStatements = ((PsiBlockStatement)this.myStatements[0]).getCodeBlock().getStatements();
            }
        }

        int getStartOffset(ControlFlow cf) {
            return cf.getStartOffset(this.myStatements[0]);
        }

        int getEndOffset(ControlFlow cf) {
            return cf.getEndOffset(this.myStatements[this.myStatements.length - 1]);
        }

        PsiStatement getSingleStatement() {
            return this.myStatements.length == 1 ? this.myStatements[0] : null;
        }

        @Nullable
        <T extends PsiExpression> T getSingleExpression(Class<T> wantedType) {
            PsiExpression expression;
            PsiStatement statement = this.getSingleStatement();
            if (statement instanceof PsiExpressionStatement && wantedType.isInstance(expression = ((PsiExpressionStatement)statement).getExpression())) {
                return (T)((PsiExpression)wantedType.cast(expression));
            }
            return null;
        }

        @Nullable
        PsiMethodCallExpression getSingleMethodCall() {
            return this.getSingleExpression(PsiMethodCallExpression.class);
        }

        @Nullable
        Operation extractOperation() {
            PsiIfStatement ifStatement;
            if (this.getSingleStatement() instanceof PsiIfStatement && (ifStatement = (PsiIfStatement)this.getSingleStatement()).getElseBranch() == null && ifStatement.getCondition() != null) {
                this.replaceWith(ifStatement.getThenBranch());
                return new FilterOp(ifStatement.getCondition(), this.myVariable, false);
            }
            if (this.getSingleStatement() instanceof PsiForeachStatement) {
                PsiForeachStatement foreachStatement = (PsiForeachStatement)this.getSingleStatement();
                PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                PsiStatement body = foreachStatement.getBody();
                if (iteratedValue != null && body != null) {
                    PsiType iteratedValueType = iteratedValue.getType();
                    Operation op = null;
                    if (iteratedValueType instanceof PsiArrayType) {
                        if (((PsiArrayType)iteratedValueType).getComponentType() instanceof PsiPrimitiveType) {
                            return null;
                        }
                        op = new ArrayFlatMapOp(iteratedValue, this.myVariable);
                    } else {
                        PsiClass iteratorClass = PsiUtil.resolveClassInClassTypeOnly(iteratedValueType);
                        PsiClass collectionClass = JavaPsiFacade.getInstance(body.getProject()).findClass("java.util.Collection", foreachStatement.getResolveScope());
                        if (collectionClass != null && InheritanceUtil.isInheritorOrSelf(iteratorClass, collectionClass, true)) {
                            op = new FlatMapOp(iteratedValue, this.myVariable);
                        }
                    }
                    if (op != null && ReferencesSearch.search(this.myVariable, new LocalSearchScope(body)).findFirst() == null) {
                        this.myVariable = foreachStatement.getIterationParameter();
                        this.replaceWith(body);
                        return op;
                    }
                }
            }
            if (this.myStatements.length >= 1) {
                PsiLocalVariable declaredVar;
                PsiElement element;
                PsiDeclarationStatement decl;
                PsiElement[] elements;
                PsiStatement first = this.myStatements[0];
                if (first instanceof PsiDeclarationStatement && (elements = (decl = (PsiDeclarationStatement)first).getDeclaredElements()).length == 1 && (element = elements[0]) instanceof PsiLocalVariable && !((declaredVar = (PsiLocalVariable)element).getType() instanceof PsiPrimitiveType)) {
                    PsiExpression initializer = declaredVar.getInitializer();
                    PsiElement[] leftOver = Arrays.copyOfRange(this.myStatements, 1, this.myStatements.length);
                    if (initializer != null && ReferencesSearch.search(this.myVariable, new LocalSearchScope(leftOver)).findFirst() == null) {
                        MapOp op = new MapOp(initializer, this.myVariable);
                        this.myVariable = declaredVar;
                        this.myStatements = leftOver;
                        this.flatten();
                        return op;
                    }
                }
                if (first instanceof PsiIfStatement) {
                    PsiStatement[] statements;
                    PsiIfStatement ifStatement2 = (PsiIfStatement)first;
                    if (ifStatement2.getCondition() == null) {
                        return null;
                    }
                    PsiStatement branch = ifStatement2.getThenBranch();
                    if (branch instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)branch).getCodeBlock().getStatements()).length == 1) {
                        branch = statements[0];
                    }
                    if (!(branch instanceof PsiContinueStatement) || ((PsiContinueStatement)branch).getLabelIdentifier() != null) {
                        return null;
                    }
                    if (ifStatement2.getElseBranch() != null) {
                        this.myStatements[0] = ifStatement2.getElseBranch();
                    } else {
                        this.myStatements = Arrays.copyOfRange(this.myStatements, 1, this.myStatements.length);
                    }
                    this.flatten();
                    return new FilterOp(ifStatement2.getCondition(), this.myVariable, true);
                }
            }
            return null;
        }

        @NotNull
        List<Operation> extractOperations() {
            ArrayList<Operation> result = new ArrayList<Operation>();
            while (true) {
                Operation op;
                if ((op = this.extractOperation()) == null) {
                    ArrayList<Operation> arrayList = result;
                    if (arrayList == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$TerminalBlock", "extractOperations"));
                    }
                    return arrayList;
                }
                result.add(op);
            }
        }

        private void replaceWith(PsiStatement statement) {
            this.myStatements = new PsiStatement[]{statement};
            this.flatten();
        }

        public PsiVariable getVariable() {
            return this.myVariable;
        }

        public boolean isEmpty() {
            return this.myStatements.length == 0;
        }

        @Contract(value="_, _ -> !null")
        static TerminalBlock from(PsiVariable variable, PsiStatement statement) {
            return new TerminalBlock(variable, new PsiStatement[]{statement});
        }

        @NotNull
        private List<String> extractOperationReplacements(PsiElementFactory factory) {
            Operation operation;
            ArrayList<String> intermediateOps = new ArrayList<String>();
            while ((operation = this.extractOperation()) != null) {
                intermediateOps.add(operation.createReplacement(factory));
            }
            ArrayList<String> arrayList = intermediateOps;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$TerminalBlock", "extractOperationReplacements"));
            }
            return arrayList;
        }

        public PsiElement convertToElement(PsiElementFactory factory) {
            if (this.myStatements.length == 1) {
                return this.myStatements[0];
            }
            PsiCodeBlock block = factory.createCodeBlock();
            for (PsiStatement statement : this.myStatements) {
                block.add(statement);
            }
            return block;
        }
    }

    static class ArrayFlatMapOp
    extends Operation {
        ArrayFlatMapOp(PsiExpression expression, PsiVariable variable) {
            super(expression, variable);
        }

        @Override
        public String createReplacement(PsiElementFactory factory) {
            PsiExpression replacement = factory.createExpressionFromText("java.util.Arrays.stream(" + this.myExpression.getText() + ")", this.myExpression);
            return ".flatMap(" + StreamApiMigrationInspection.compoundLambdaOrMethodReference(this.myVariable, replacement, "java.util.function.Function", new PsiType[]{this.myVariable.getType(), replacement.getType()}) + ")";
        }
    }

    static class FlatMapOp
    extends Operation {
        FlatMapOp(PsiExpression expression, PsiVariable variable) {
            super(expression, variable);
        }

        @Override
        public String createReplacement(PsiElementFactory factory) {
            PsiExpression replacement = factory.createExpressionFromText(this.myExpression.getText() + ".stream()", this.myExpression);
            return ".flatMap(" + StreamApiMigrationInspection.compoundLambdaOrMethodReference(this.myVariable, replacement, "java.util.function.Function", new PsiType[]{this.myVariable.getType(), replacement.getType()}) + ")";
        }
    }

    static class MapOp
    extends Operation {
        MapOp(PsiExpression expression, PsiVariable variable) {
            super(expression, variable);
        }

        @Override
        public String createReplacement(PsiElementFactory factory) {
            return ".map(" + StreamApiMigrationInspection.compoundLambdaOrMethodReference(this.myVariable, this.myExpression, "java.util.function.Function", new PsiType[]{this.myVariable.getType(), this.myExpression.getType()}) + ")";
        }
    }

    static class FilterOp
    extends Operation {
        private final boolean myNegated;

        FilterOp(PsiExpression condition, PsiVariable variable, boolean negated) {
            super(condition, variable);
            this.myNegated = negated;
        }

        @Override
        public String createReplacement(PsiElementFactory factory) {
            PsiExpression expression = this.myNegated ? factory.createExpressionFromText(BoolUtils.getNegatedExpressionText(this.myExpression), this.myExpression) : this.myExpression;
            return ".filter(" + StreamApiMigrationInspection.compoundLambdaOrMethodReference(this.myVariable, expression, "java.util.function.Predicate", new PsiType[]{this.myVariable.getType()}) + ")";
        }
    }

    static abstract class Operation {
        final PsiExpression myExpression;
        final PsiVariable myVariable;

        protected Operation(PsiExpression expression, PsiVariable variable) {
            this.myExpression = expression;
            this.myVariable = variable;
        }

        PsiExpression getExpression() {
            return this.myExpression;
        }

        abstract String createReplacement(PsiElementFactory var1);
    }

    private static class ReplaceWithSumFix
    extends MigrateToStreamFix {
        private ReplaceWithSumFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Replace with sum()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithSumFix", "getFamilyName"));
            }
            return "Replace with sum()";
        }

        @Override
        void migrate(@NotNull Project project, @NotNull ProblemDescriptor descriptor, @NotNull PsiForeachStatement foreachStatement, @NotNull PsiExpression iteratedValue, @NotNull PsiStatement body, @NotNull TerminalBlock tb, @NotNull List<String> intermediateOps) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithSumFix", "migrate"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithSumFix", "migrate"));
            }
            if (foreachStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreachStatement", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithSumFix", "migrate"));
            }
            if (iteratedValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iteratedValue", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithSumFix", "migrate"));
            }
            if (body == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithSumFix", "migrate"));
            }
            if (tb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithSumFix", "migrate"));
            }
            if (intermediateOps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intermediateOps", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithSumFix", "migrate"));
            }
            PsiAssignmentExpression assignment = tb.getSingleExpression(PsiAssignmentExpression.class);
            if (assignment == null) {
                return;
            }
            PsiLocalVariable var = StreamApiMigrationInspection.extractAccumulator(assignment);
            if (var == null) {
                return;
            }
            PsiExpression addend = StreamApiMigrationInspection.extractAddend(assignment);
            if (addend == null) {
                return;
            }
            PsiType type = var.getType();
            if (!(type instanceof PsiPrimitiveType)) {
                return;
            }
            PsiPrimitiveType primitiveType = (PsiPrimitiveType)type;
            if (primitiveType.equalsToText("float")) {
                return;
            }
            String typeName = primitiveType.equalsToText("double") ? "Double" : (primitiveType.equalsToText("long") ? "Long" : "Int");
            intermediateOps.add(".mapTo" + typeName + "(" + StreamApiMigrationInspection.compoundLambdaOrMethodReference(tb.getVariable(), addend, "java.util.function.To" + typeName + "Function", new PsiType[]{tb.getVariable().getType()}) + ")");
            StringBuilder builder = ReplaceWithSumFix.generateStream(iteratedValue, intermediateOps);
            builder.append(".sum()");
            ReplaceWithSumFix.replaceWithNumericAddition(project, foreachStatement, var, builder, typeName.toLowerCase(Locale.ENGLISH));
        }
    }

    private static class ReplaceWithMatchFix
    extends MigrateToStreamFix {
        private final String myMethodName;

        public ReplaceWithMatchFix(String methodName) {
            this.myMethodName = methodName;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = "Replace with " + this.myMethodName + "()";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithMatchFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        void migrate(@NotNull Project project, @NotNull ProblemDescriptor descriptor, @NotNull PsiForeachStatement foreachStatement, @NotNull PsiExpression iteratedValue, @NotNull PsiStatement body, @NotNull TerminalBlock tb, @NotNull List<String> intermediateOps) {
            String streamText;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithMatchFix", "migrate"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithMatchFix", "migrate"));
            }
            if (foreachStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreachStatement", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithMatchFix", "migrate"));
            }
            if (iteratedValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iteratedValue", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithMatchFix", "migrate"));
            }
            if (body == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithMatchFix", "migrate"));
            }
            if (tb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithMatchFix", "migrate"));
            }
            if (intermediateOps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intermediateOps", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithMatchFix", "migrate"));
            }
            PsiReturnStatement returnStatement = (PsiReturnStatement)tb.getSingleStatement();
            PsiExpression value = returnStatement.getReturnValue();
            if (!StreamApiMigrationInspection.isLiteral(value, Boolean.TRUE) && !StreamApiMigrationInspection.isLiteral(value, Boolean.FALSE)) {
                return;
            }
            boolean foundResult = (Boolean)((PsiLiteralExpression)value).getValue();
            PsiElement nextStatement = PsiTreeUtil.skipSiblingsForward(foreachStatement, PsiWhiteSpace.class, PsiComment.class);
            if (!(nextStatement instanceof PsiReturnStatement)) {
                return;
            }
            PsiReturnStatement nextReturnStatement = (PsiReturnStatement)nextStatement;
            if (!StreamApiMigrationInspection.isLiteral(nextReturnStatement.getReturnValue(), !foundResult)) {
                return;
            }
            String methodName = foundResult ? "anyMatch" : "noneMatch";
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
            PsiExpression stream = elementFactory.createExpressionFromText(streamText = ReplaceWithMatchFix.generateStream(iteratedValue, intermediateOps).toString(), foreachStatement);
            if (!(stream instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiElement nameElement = ((PsiMethodCallExpression)stream).getMethodExpression().getReferenceNameElement();
            if (nameElement != null && nameElement.getText().equals("filter")) {
                PsiLambdaExpression lambda2;
                PsiElement lambdaBody;
                PsiExpression[] expressions;
                if (!foundResult && (expressions = ((PsiMethodCallExpression)stream).getArgumentList().getExpressions()).length == 1 && expressions[0] instanceof PsiLambdaExpression && (lambdaBody = (lambda2 = (PsiLambdaExpression)expressions[0]).getBody()) instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)lambdaBody)) {
                    PsiExpression negated = BoolUtils.getNegated((PsiExpression)lambdaBody);
                    LOG.assertTrue(negated != null);
                    String methodReferenceText = LambdaCanBeMethodReferenceInspection.convertToMethodReference(negated, lambda2.getParameterList().getParameters(), lambda2.getFunctionalInterfaceType(), lambda2);
                    if (methodReferenceText != null) {
                        lambda2.replace(elementFactory.createExpressionFromText(methodReferenceText, lambda2));
                    } else {
                        lambdaBody.replace(negated);
                    }
                    methodName = "allMatch";
                }
                nameElement.replace(elementFactory.createIdentifier(methodName));
                streamText = stream.getText();
            } else {
                streamText = streamText + "." + methodName + "(" + tb.getVariable().getName() + " -> true)";
            }
            PsiElement result = foreachStatement.replace(elementFactory.createStatementFromText("return " + streamText + ";", foreachStatement));
            nextReturnStatement.delete();
            ReplaceWithMatchFix.simplifyAndFormat(project, result);
        }
    }

    private static class ReplaceWithCountFix
    extends MigrateToStreamFix {
        private ReplaceWithCountFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Replace with count()" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCountFix", "getFamilyName"));
            }
            return "Replace with count()";
        }

        @Override
        void migrate(@NotNull Project project, @NotNull ProblemDescriptor descriptor, @NotNull PsiForeachStatement foreachStatement, @NotNull PsiExpression iteratedValue, @NotNull PsiStatement body, @NotNull TerminalBlock tb, @NotNull List<String> intermediateOps) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCountFix", "migrate"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCountFix", "migrate"));
            }
            if (foreachStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreachStatement", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCountFix", "migrate"));
            }
            if (iteratedValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iteratedValue", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCountFix", "migrate"));
            }
            if (body == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCountFix", "migrate"));
            }
            if (tb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCountFix", "migrate"));
            }
            if (intermediateOps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intermediateOps", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCountFix", "migrate"));
            }
            PsiExpression operand = StreamApiMigrationInspection.extractIncrementedLValue(tb.getSingleExpression(PsiExpression.class));
            if (!(operand instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement element = ((PsiReferenceExpression)operand).resolve();
            if (!(element instanceof PsiLocalVariable)) {
                return;
            }
            PsiLocalVariable var = (PsiLocalVariable)element;
            StringBuilder builder = ReplaceWithCountFix.generateStream(iteratedValue, intermediateOps);
            builder.append(".count()");
            ReplaceWithCountFix.replaceWithNumericAddition(project, foreachStatement, var, builder, "long");
        }
    }

    private static class ReplaceWithCollectFix
    extends MigrateToStreamFix {
        final String myMethodName;

        protected ReplaceWithCollectFix(String methodName) {
            this.myMethodName = methodName;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = "Replace with " + this.myMethodName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        void migrate(@NotNull Project project, @NotNull ProblemDescriptor descriptor, @NotNull PsiForeachStatement foreachStatement, @NotNull PsiExpression iteratedValue, @NotNull PsiStatement body, @NotNull TerminalBlock tb, @NotNull List<String> intermediateOps) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectFix", "migrate"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectFix", "migrate"));
            }
            if (foreachStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreachStatement", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectFix", "migrate"));
            }
            if (iteratedValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iteratedValue", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectFix", "migrate"));
            }
            if (body == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectFix", "migrate"));
            }
            if (tb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectFix", "migrate"));
            }
            if (intermediateOps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intermediateOps", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectFix", "migrate"));
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
            PsiType iteratedValueType = iteratedValue.getType();
            PsiMethodCallExpression methodCallExpression = tb.getSingleMethodCall();
            if (methodCallExpression == null) {
                return;
            }
            ReplaceWithCollectFix.restoreComments(foreachStatement, body);
            if (intermediateOps.isEmpty() && StreamApiMigrationInspection.isAddAllCall(tb)) {
                PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
                String qualifierText = qualifierExpression != null ? qualifierExpression.getText() : "";
                String collectionText = iteratedValueType instanceof PsiArrayType ? "java.util.Arrays.asList(" + iteratedValue.getText() + ")" : ReplaceWithCollectFix.getIteratedValueText(iteratedValue);
                String callText = StringUtil.getQualifiedName(qualifierText, "addAll(" + collectionText + ");");
                PsiElement result = foreachStatement.replace(elementFactory.createStatementFromText(callText, foreachStatement));
                ReplaceWithCollectFix.simplifyAndFormat(project, result);
                return;
            }
            intermediateOps.add(ReplaceWithCollectFix.createMapperFunctionalExpressionText(tb.getVariable(), methodCallExpression.getArgumentList().getExpressions()[0]));
            StringBuilder builder = ReplaceWithCollectFix.generateStream(iteratedValue, intermediateOps);
            PsiExpression qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
            PsiExpression initializer = StreamApiMigrationInspection.extractReplaceableCollectionInitializer(qualifierExpression, foreachStatement);
            if (initializer != null) {
                String callText = builder.append(".collect(java.util.stream.Collectors.").append(ReplaceWithCollectFix.createInitializerReplacementText(qualifierExpression.getType(), initializer)).append(")").toString();
                PsiElement result = initializer.replace(elementFactory.createExpressionFromText(callText, null));
                ReplaceWithCollectFix.simplifyAndFormat(project, result);
                foreachStatement.delete();
                return;
            }
            String qualifierText = qualifierExpression != null ? qualifierExpression.getText() + "." : "";
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(project);
            SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, "item", null, null, false);
            String varName = codeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)suggestedNameInfo, (PsiElement)qualifierExpression, (boolean)false).names[0];
            PsiExpression forEachBody = elementFactory.createExpressionFromText(qualifierText + "add(" + varName + ")", qualifierExpression);
            String callText = builder.append(".forEach(").append(varName).append("->").append(forEachBody.getText()).append(");").toString();
            PsiElement result = foreachStatement.replace(elementFactory.createStatementFromText(callText, foreachStatement));
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)((PsiMethodCallExpression)((PsiExpressionStatement)result).getExpression()).getArgumentList().getExpressions()[0];
            String methodReference = LambdaCanBeMethodReferenceInspection.convertToMethodReference(lambda2.getBody(), lambda2.getParameterList().getParameters(), lambda2.getFunctionalInterfaceType(), lambda2);
            if (methodReference != null) {
                lambda2.replace(elementFactory.createExpressionFromText(methodReference, lambda2));
            }
            ReplaceWithCollectFix.simplifyAndFormat(project, result);
        }

        private static String createInitializerReplacementText(PsiType varType, PsiExpression initializer) {
            PsiClassType rawVarType;
            PsiType initializerType = initializer.getType();
            PsiClassType rawType = initializerType instanceof PsiClassType ? ((PsiClassType)initializerType).rawType() : null;
            PsiClassType psiClassType = rawVarType = varType instanceof PsiClassType ? ((PsiClassType)varType).rawType() : null;
            if (rawType != null && rawVarType != null && rawType.equalsToText("java.util.ArrayList") && (rawVarType.equalsToText("java.util.List") || rawVarType.equalsToText("java.util.Collection"))) {
                return "toList()";
            }
            if (rawType != null && rawVarType != null && rawType.equalsToText("java.util.HashSet") && (rawVarType.equalsToText("java.util.Set") || rawVarType.equalsToText("java.util.Collection"))) {
                return "toSet()";
            }
            if (rawType != null) {
                return "toCollection(" + rawType.getClassName() + "::new)";
            }
            return "toCollection(() -> " + initializer.getText() + ")";
        }

        private static String createMapperFunctionalExpressionText(PsiVariable variable, PsiExpression expression) {
            if (!StreamApiMigrationInspection.isIdentityMapping(variable, expression)) {
                return new MapOp(expression, variable).createReplacement(null);
            }
            return "";
        }
    }

    private static class ReplaceWithForeachCallFix
    extends MigrateToStreamFix {
        private final String myForEachMethodName;

        protected ReplaceWithForeachCallFix(String forEachMethodName) {
            this.myForEachMethodName = forEachMethodName;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = "Replace with " + this.myForEachMethodName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        void migrate(@NotNull Project project, @NotNull ProblemDescriptor descriptor, @NotNull PsiForeachStatement foreachStatement, @NotNull PsiExpression iteratedValue, @NotNull PsiStatement body, @NotNull TerminalBlock tb, @NotNull List<String> intermediateOps) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "migrate"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "migrate"));
            }
            if (foreachStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreachStatement", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "migrate"));
            }
            if (iteratedValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iteratedValue", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "migrate"));
            }
            if (body == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "migrate"));
            }
            if (tb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "migrate"));
            }
            if (intermediateOps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intermediateOps", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "migrate"));
            }
            ReplaceWithForeachCallFix.restoreComments(foreachStatement, body);
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
            StringBuilder buffer = ReplaceWithForeachCallFix.generateStream(iteratedValue, intermediateOps);
            PsiElement block = tb.convertToElement(elementFactory);
            buffer.append(".").append(this.myForEachMethodName).append("(");
            String functionalExpressionText = ReplaceWithForeachCallFix.createForEachFunctionalExpressionText(project, block, tb.getVariable());
            PsiExpressionStatement callStatement = (PsiExpressionStatement)elementFactory.createStatementFromText(buffer.toString() + functionalExpressionText + ");", foreachStatement);
            callStatement = (PsiExpressionStatement)foreachStatement.replace(callStatement);
            PsiExpressionList argumentList = ((PsiCallExpression)callStatement.getExpression()).getArgumentList();
            LOG.assertTrue(argumentList != null, callStatement.getText());
            PsiExpression[] expressions = argumentList.getExpressions();
            LOG.assertTrue(expressions.length == 1);
            if (expressions[0] instanceof PsiFunctionalExpression && ((PsiFunctionalExpression)expressions[0]).getFunctionalInterfaceType() == null) {
                callStatement = (PsiExpressionStatement)callStatement.replace(elementFactory.createStatementFromText(buffer.toString() + "(" + tb.getVariable().getText() + ") -> " + ReplaceWithForeachCallFix.wrapInBlock(block) + ");", callStatement));
            }
            ReplaceWithForeachCallFix.simplifyAndFormat(project, callStatement);
        }

        private static String createForEachFunctionalExpressionText(Project project, PsiElement block, PsiVariable variable) {
            PsiExpression methodRefCandidate = LambdaCanBeMethodReferenceInspection.extractMethodReferenceCandidateExpression(block);
            if (methodRefCandidate != null) {
                PsiClassType functionalType = StreamApiMigrationInspection.createDefaultConsumerType(project, variable);
                PsiVariable[] parameters = new PsiVariable[]{variable};
                String methodReferenceText = LambdaCanBeMethodReferenceInspection.convertToMethodReference(block, parameters, functionalType, null);
                if (methodReferenceText != null) {
                    return methodReferenceText;
                }
            }
            return variable.getName() + " -> " + ReplaceWithForeachCallFix.wrapInBlock(block);
        }

        private static String wrapInBlock(PsiElement block) {
            if (block instanceof PsiExpressionStatement) {
                return ((PsiExpressionStatement)block).getExpression().getText();
            }
            if (block instanceof PsiCodeBlock) {
                return block.getText();
            }
            return "{" + block.getText() + "}";
        }
    }

    private static abstract class MigrateToStreamFix
    implements LocalQuickFix {
        private MigrateToStreamFix() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$MigrateToStreamFix", "getName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$MigrateToStreamFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/StreamApiMigrationInspection$MigrateToStreamFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiForeachStatement) {
                PsiForeachStatement foreachStatement = (PsiForeachStatement)element;
                PsiStatement body = foreachStatement.getBody();
                PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                if (body != null && iteratedValue != null) {
                    PsiParameter parameter = foreachStatement.getIterationParameter();
                    TerminalBlock tb = TerminalBlock.from(parameter, body);
                    if (!FileModificationService.getInstance().preparePsiElementForWrite(foreachStatement)) {
                        return;
                    }
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
                    List replacements = tb.extractOperationReplacements(factory);
                    this.migrate(project, descriptor, foreachStatement, iteratedValue, body, tb, replacements);
                }
            }
        }

        abstract void migrate(@NotNull Project var1, @NotNull ProblemDescriptor var2, @NotNull PsiForeachStatement var3, @NotNull PsiExpression var4, @NotNull PsiStatement var5, @NotNull TerminalBlock var6, @NotNull List<String> var7);

        static void replaceWithNumericAddition(@NotNull Project project, PsiForeachStatement foreachStatement, PsiLocalVariable var, StringBuilder builder, String expressionType) {
            PsiExpression initializer;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$MigrateToStreamFix", "replaceWithNumericAddition"));
            }
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
            MigrateToStreamFix.restoreComments(foreachStatement, foreachStatement.getBody());
            if (StreamApiMigrationInspection.isDeclarationJustBefore(var, foreachStatement) && ExpressionUtils.isZero(initializer = var.getInitializer())) {
                String typeStr = var.getType().getCanonicalText();
                String replacement = (typeStr.equals(expressionType) ? "" : "(" + typeStr + ") ") + builder;
                initializer.replace(elementFactory.createExpressionFromText(replacement, foreachStatement));
                foreachStatement.delete();
                MigrateToStreamFix.simplifyAndFormat(project, var);
                return;
            }
            PsiElement result = foreachStatement.replace(elementFactory.createStatementFromText(var.getName() + "+=" + builder + ";", foreachStatement));
            MigrateToStreamFix.simplifyAndFormat(project, result);
        }

        static void simplifyAndFormat(@NotNull Project project, PsiElement result) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$MigrateToStreamFix", "simplifyAndFormat"));
            }
            if (result == null) {
                return;
            }
            MigrateToStreamFix.simplifyRedundantCast(result);
            CodeStyleManager.getInstance(project).reformat(JavaCodeStyleManager.getInstance(project).shortenClassReferences(result));
        }

        static void simplifyRedundantCast(PsiElement result) {
            for (PsiMethodReferenceExpression methodReferenceExpression : PsiTreeUtil.findChildrenOfType(result, PsiMethodReferenceExpression.class)) {
                PsiElement parent = methodReferenceExpression.getParent();
                if (!(parent instanceof PsiTypeCastExpression) || !RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)parent)) continue;
                PsiExpression operand = ((PsiTypeCastExpression)parent).getOperand();
                LOG.assertTrue(operand != null);
                parent.replace(operand);
            }
        }

        static void restoreComments(PsiForeachStatement foreachStatement, PsiStatement body) {
            PsiElement parent = foreachStatement.getParent();
            for (PsiElement psiElement : PsiTreeUtil.findChildrenOfType(body, PsiComment.class)) {
                parent.addBefore(psiElement, foreachStatement);
            }
        }

        @NotNull
        static StringBuilder generateStream(PsiExpression iteratedValue, List<String> intermediateOps) {
            StringBuilder buffer = new StringBuilder();
            PsiType iteratedValueType = iteratedValue.getType();
            if (iteratedValueType instanceof PsiArrayType) {
                buffer.append("java.util.Arrays.stream(").append(iteratedValue.getText()).append(")");
            } else {
                buffer.append(MigrateToStreamFix.getIteratedValueText(iteratedValue));
                if (!intermediateOps.isEmpty()) {
                    buffer.append(".stream()");
                }
            }
            intermediateOps.forEach(buffer::append);
            StringBuilder stringBuilder = buffer;
            if (stringBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$MigrateToStreamFix", "generateStream"));
            }
            return stringBuilder;
        }

        static String getIteratedValueText(PsiExpression iteratedValue) {
            return iteratedValue instanceof PsiCallExpression || iteratedValue instanceof PsiReferenceExpression || iteratedValue instanceof PsiQualifiedExpression || iteratedValue instanceof PsiParenthesizedExpression ? iteratedValue.getText() : "(" + iteratedValue.getText() + ")";
        }
    }
}

