/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.editor.colors.impl.TextAttributesReader;
import com.intellij.openapi.editor.colors.impl.ValueElementReader;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.ColorUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.JBUI;
import gnu.trove.THashMap;
import java.awt.Color;
import java.awt.Font;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractColorsScheme
implements EditorColorsScheme {
    private static final int CURR_VERSION = 142;
    private static final FontSize DEFAULT_FONT_SIZE = FontSize.SMALL;
    protected EditorColorsScheme myParentScheme;
    protected FontSize myQuickDocFontSize = DEFAULT_FONT_SIZE;
    protected float myLineSpacing;
    @NotNull
    private final Map<EditorFontType, Font> myFonts = new EnumMap<EditorFontType, Font>(EditorFontType.class);
    @NotNull
    private final FontPreferences myFontPreferences = new FontPreferences();
    @NotNull
    private final FontPreferences myConsoleFontPreferences = new FontPreferences();
    private final ValueElementReader myValueReader = new TextAttributesReader();
    private String myFallbackFontName;
    private String mySchemeName;
    private float myConsoleLineSpacing = -1.0f;
    private boolean myIsSaveNeeded;
    private int myVersion = 142;
    private int myOriginalVersion = 142;
    protected Map<ColorKey, Color> myColorsMap = ContainerUtilRt.newHashMap();
    protected Map<TextAttributesKey, TextAttributes> myAttributesMap = ContainerUtilRt.newHashMap();
    @NonNls
    private static final String EDITOR_FONT = "font";
    @NonNls
    private static final String CONSOLE_FONT = "console-font";
    @NonNls
    private static final String EDITOR_FONT_NAME = "EDITOR_FONT_NAME";
    @NonNls
    private static final String CONSOLE_FONT_NAME = "CONSOLE_FONT_NAME";
    private Color myDeprecatedBackgroundColor = null;
    @NonNls
    private static final String SCHEME_ELEMENT = "scheme";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String BASE_ATTRIBUTES_ATTR = "baseAttributes";
    @NonNls
    private static final String DEFAULT_SCHEME_ATTR = "default_scheme";
    @NonNls
    private static final String PARENT_SCHEME_ATTR = "parent_scheme";
    @NonNls
    private static final String OPTION_ELEMENT = "option";
    @NonNls
    private static final String COLORS_ELEMENT = "colors";
    @NonNls
    private static final String ATTRIBUTES_ELEMENT = "attributes";
    @NonNls
    private static final String VALUE_ELEMENT = "value";
    @NonNls
    private static final String BACKGROUND_COLOR_NAME = "BACKGROUND";
    @NonNls
    private static final String LINE_SPACING = "LINE_SPACING";
    @NonNls
    private static final String CONSOLE_LINE_SPACING = "CONSOLE_LINE_SPACING";
    @NonNls
    private static final String EDITOR_FONT_SIZE = "EDITOR_FONT_SIZE";
    @NonNls
    private static final String CONSOLE_FONT_SIZE = "CONSOLE_FONT_SIZE";
    @NonNls
    private static final String EDITOR_LIGATURES = "EDITOR_LIGATURES";
    @NonNls
    private static final String CONSOLE_LIGATURES = "CONSOLE_LIGATURES";
    @NonNls
    private static final String EDITOR_QUICK_JAVADOC_FONT_SIZE = "EDITOR_QUICK_DOC_FONT_SIZE";
    private final Properties myMetaInfo = new Properties();
    private static final SimpleDateFormat META_INFO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    @NonNls
    private static final String META_INFO_ELEMENT = "metaInfo";
    @NonNls
    private static final String PROPERTY_ELEMENT = "property";
    @NonNls
    private static final String PROPERTY_NAME_ATTR = "name";
    @NonNls
    private static final String META_INFO_CREATION_TIME = "created";
    @NonNls
    private static final String META_INFO_MODIFIED_TIME = "modified";
    @NonNls
    private static final String META_INFO_IDE = "ide";
    @NonNls
    private static final String META_INFO_IDE_VERSION = "ideVersion";
    @NonNls
    private static final String META_INFO_ORIGINAL = "originalScheme";
    @Deprecated
    public static final Map<String, Color> DEFAULT_ERROR_STRIPE_COLOR = new THashMap();
    private static final Map<String, Couple<Color>> DEFAULT_STRIPE_COLORS = new THashMap<String, Couple<Color>>(){
        {
            this.put(CodeInsightColors.ERRORS_ATTRIBUTES.getExternalName(), Couple.of(Color.red, ColorUtil.fromHex("CF5B56")));
            this.put(CodeInsightColors.WARNINGS_ATTRIBUTES.getExternalName(), Couple.of(Color.yellow, ColorUtil.fromHex("EBC700")));
            this.put("EXECUTIONPOINT_ATTRIBUTES", Couple.of(Color.blue, ColorUtil.fromHex("3763b0")));
            this.put(EditorColors.IDENTIFIER_UNDER_CARET_ATTRIBUTES.getExternalName(), Couple.of(ColorUtil.fromHex("CCCFFF"), ColorUtil.fromHex("BAA8FF")));
            this.put(EditorColors.WRITE_IDENTIFIER_UNDER_CARET_ATTRIBUTES.getExternalName(), Couple.of(ColorUtil.fromHex("FFCCE5"), ColorUtil.fromHex("F0ADF0")));
            this.put(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES.getExternalName(), Couple.of(ColorUtil.fromHex("586E75"), ColorUtil.fromHex("71B362")));
            this.put(CodeInsightColors.TODO_DEFAULT_ATTRIBUTES.getExternalName(), Couple.of(ColorUtil.fromHex("268BD2"), ColorUtil.fromHex("54AAE3")));
        }
    };

    protected AbstractColorsScheme(EditorColorsScheme parentScheme) {
        this.myParentScheme = parentScheme;
        this.myFontPreferences.setChangeListener(() -> this.initFonts());
    }

    public AbstractColorsScheme() {
    }

    public void setDefaultMetaInfo(@Nullable AbstractColorsScheme parentScheme) {
        this.myMetaInfo.setProperty(META_INFO_CREATION_TIME, META_INFO_DATE_FORMAT.format(new Date()));
        this.myMetaInfo.setProperty(META_INFO_IDE, PlatformUtils.getPlatformPrefix());
        this.myMetaInfo.setProperty(META_INFO_IDE_VERSION, ApplicationInfoEx.getInstanceEx().getStrictVersion());
        if (parentScheme != null && parentScheme != EmptyColorScheme.INSTANCE) {
            this.myMetaInfo.setProperty(META_INFO_ORIGINAL, parentScheme.getName());
        }
    }

    @Override
    @NotNull
    public Color getDefaultBackground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getBackgroundColor();
        Color color = c != null ? c : Color.white;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultBackground"));
        }
        return color;
    }

    @Override
    @NotNull
    public Color getDefaultForeground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getForegroundColor();
        Color color = c != null ? c : Color.black;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultForeground"));
        }
        return color;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.mySchemeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getName"));
        }
        return string;
    }

    @Override
    public void setFont(EditorFontType key, Font font) {
        this.myFonts.put(key, font);
    }

    @Override
    public abstract Object clone();

    public void copyTo(AbstractColorsScheme newScheme) {
        this.myFontPreferences.copyTo(newScheme.myFontPreferences);
        newScheme.myLineSpacing = this.myLineSpacing;
        newScheme.myQuickDocFontSize = this.myQuickDocFontSize;
        this.myConsoleFontPreferences.copyTo(newScheme.myConsoleFontPreferences);
        newScheme.myConsoleLineSpacing = this.myConsoleLineSpacing;
        Set<EditorFontType> types = this.myFonts.keySet();
        for (EditorFontType type : types) {
            Font font = this.myFonts.get((Object)type);
            newScheme.setFont(type, font);
        }
        newScheme.myAttributesMap = new HashMap<TextAttributesKey, TextAttributes>(this.myAttributesMap);
        newScheme.myColorsMap = new HashMap<ColorKey, Color>(this.myColorsMap);
        newScheme.myVersion = this.myVersion;
    }

    @Override
    public void setEditorFontName(String fontName) {
        int editorFontSize = this.getEditorFontSize();
        this.myFontPreferences.clear();
        this.myFontPreferences.register(fontName, editorFontSize);
        this.initFonts();
    }

    @Override
    public void setEditorFontSize(int fontSize) {
        fontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        this.myFontPreferences.register(this.getEditorFontName(), fontSize);
        this.initFonts();
    }

    @Override
    public void setQuickDocFontSize(@NotNull FontSize fontSize) {
        if (fontSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontSize", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setQuickDocFontSize"));
        }
        if (this.myQuickDocFontSize != fontSize) {
            this.myQuickDocFontSize = fontSize;
            this.myIsSaveNeeded = true;
        }
    }

    @Override
    public void setLineSpacing(float lineSpacing) {
        this.myLineSpacing = EditorFontsConstants.checkAndFixEditorLineSpacing(lineSpacing);
    }

    @Override
    public Font getFont(EditorFontType key) {
        if (UISettings.getInstance().PRESENTATION_MODE) {
            Font font = this.myFonts.get((Object)key);
            return new Font(font.getName(), font.getStyle(), UISettings.getInstance().PRESENTATION_MODE_FONT_SIZE);
        }
        return this.myFonts.get((Object)key);
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setName"));
        }
        this.mySchemeName = name;
    }

    @Override
    @NotNull
    public FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.myFontPreferences;
        if (fontPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getFontPreferences"));
        }
        return fontPreferences;
    }

    @Override
    public void setFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setFontPreferences"));
        }
        preferences.copyTo(this.myFontPreferences);
        this.initFonts();
    }

    @Override
    public String getEditorFontName() {
        if (this.myFallbackFontName != null) {
            return this.myFallbackFontName;
        }
        return this.myFontPreferences.getFontFamily();
    }

    @Override
    public int getEditorFontSize() {
        return this.myFontPreferences.getSize(this.getEditorFontName());
    }

    @Override
    @NotNull
    public FontSize getQuickDocFontSize() {
        FontSize fontSize = this.myQuickDocFontSize;
        if (fontSize == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getQuickDocFontSize"));
        }
        return fontSize;
    }

    @Override
    public float getLineSpacing() {
        float spacing = this.myLineSpacing;
        return spacing <= 0.0f ? 1.0f : spacing;
    }

    protected void initFonts() {
        String editorFontName = this.getEditorFontName();
        int editorFontSize = this.getEditorFontSize();
        this.myFallbackFontName = FontPreferences.getFallbackName(editorFontName, editorFontSize, this.myParentScheme);
        if (this.myFallbackFontName != null) {
            editorFontName = this.myFallbackFontName;
        }
        Font plainFont = new Font(editorFontName, 0, editorFontSize);
        Font boldFont = new Font(editorFontName, 1, editorFontSize);
        Font italicFont = new Font(editorFontName, 2, editorFontSize);
        Font boldItalicFont = new Font(editorFontName, 3, editorFontSize);
        this.myFonts.put(EditorFontType.PLAIN, plainFont);
        this.myFonts.put(EditorFontType.BOLD, boldFont);
        this.myFonts.put(EditorFontType.ITALIC, italicFont);
        this.myFonts.put(EditorFontType.BOLD_ITALIC, boldItalicFont);
        String consoleFontName = this.getConsoleFontName();
        int consoleFontSize = this.getConsoleFontSize();
        Font consolePlainFont = new Font(consoleFontName, 0, consoleFontSize);
        Font consoleBoldFont = new Font(consoleFontName, 1, consoleFontSize);
        Font consoleItalicFont = new Font(consoleFontName, 2, consoleFontSize);
        Font consoleBoldItalicFont = new Font(consoleFontName, 3, consoleFontSize);
        this.myFonts.put(EditorFontType.CONSOLE_PLAIN, consolePlainFont);
        this.myFonts.put(EditorFontType.CONSOLE_BOLD, consoleBoldFont);
        this.myFonts.put(EditorFontType.CONSOLE_ITALIC, consoleItalicFont);
        this.myFonts.put(EditorFontType.CONSOLE_BOLD_ITALIC, consoleBoldItalicFont);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void readExternal(Element parentNode) {
        UISettings settings = UISettings.getInstance();
        ColorBlindness blindness = settings == null ? null : settings.COLOR_BLINDNESS;
        this.myValueReader.setAttribute(blindness == null ? null : blindness.name());
        if (SCHEME_ELEMENT.equals(parentNode.getName())) {
            this.readScheme(parentNode);
        } else {
            for (Element element : parentNode.getChildren(SCHEME_ELEMENT)) {
                this.readScheme(element);
            }
        }
        this.initFonts();
        this.myVersion = 142;
    }

    private void readScheme(Element node) {
        boolean isDefault;
        this.myDeprecatedBackgroundColor = null;
        if (!SCHEME_ELEMENT.equals(node.getName())) {
            return;
        }
        this.setName(node.getAttributeValue("name"));
        int readVersion = Integer.parseInt(node.getAttributeValue(VERSION_ATTR, "0"));
        if (readVersion > 142) {
            throw new IllegalStateException("Unsupported color scheme version: " + readVersion);
        }
        this.myVersion = readVersion;
        this.myOriginalVersion = readVersion;
        String isDefaultScheme = node.getAttributeValue(DEFAULT_SCHEME_ATTR);
        boolean bl = isDefault = isDefaultScheme != null && Boolean.parseBoolean(isDefaultScheme);
        if (!isDefault) {
            this.myParentScheme = AbstractColorsScheme.getDefaultScheme(node.getAttributeValue(PARENT_SCHEME_ATTR, "Empty"));
        }
        this.myMetaInfo.clear();
        for (Object o : node.getChildren()) {
            Element childNode = (Element)o;
            String childName = childNode.getName();
            if (OPTION_ELEMENT.equals(childName)) {
                this.readSettings(childNode, isDefault);
                continue;
            }
            if (EDITOR_FONT.equals(childName)) {
                this.readFontSettings(childNode, this.myFontPreferences, isDefault);
                continue;
            }
            if (CONSOLE_FONT.equals(childName)) {
                this.readFontSettings(childNode, this.myConsoleFontPreferences, isDefault);
                continue;
            }
            if (COLORS_ELEMENT.equals(childName)) {
                this.readColors(childNode);
                continue;
            }
            if (ATTRIBUTES_ELEMENT.equals(childName)) {
                this.readAttributes(childNode);
                continue;
            }
            if (!META_INFO_ELEMENT.equals(childName)) continue;
            this.readMetaInfo(childNode);
        }
        if (this.myDeprecatedBackgroundColor != null) {
            TextAttributes textAttributes = this.myAttributesMap.get(HighlighterColors.TEXT);
            if (textAttributes == null) {
                textAttributes = new TextAttributes(Color.black, this.myDeprecatedBackgroundColor, null, EffectType.BOXED, 0);
                this.myAttributesMap.put(HighlighterColors.TEXT, textAttributes);
            } else {
                textAttributes.setBackgroundColor(this.myDeprecatedBackgroundColor);
            }
        }
        if (this.myConsoleFontPreferences.getEffectiveFontFamilies().isEmpty()) {
            this.myFontPreferences.copyTo(this.myConsoleFontPreferences);
        }
        this.initFonts();
    }

    @NotNull
    private static EditorColorsScheme getDefaultScheme(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultScheme"));
        }
        DefaultColorSchemesManager manager = DefaultColorSchemesManager.getInstance();
        EditorColorsScheme defaultScheme = manager.getScheme(name);
        if (defaultScheme == null) {
            defaultScheme = EmptyColorScheme.INSTANCE;
        }
        EditorColorsScheme editorColorsScheme = defaultScheme;
        if (editorColorsScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDefaultScheme"));
        }
        return editorColorsScheme;
    }

    private void readMetaInfo(@NotNull Element metaInfoElement) {
        if (metaInfoElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metaInfoElement", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readMetaInfo"));
        }
        this.myMetaInfo.clear();
        for (Element e : metaInfoElement.getChildren()) {
            String propertyName;
            if (!PROPERTY_ELEMENT.equals(e.getName()) || (propertyName = e.getAttributeValue("name")) == null) continue;
            this.myMetaInfo.setProperty(propertyName, e.getText());
        }
    }

    public void readAttributes(@NotNull Element childNode) {
        if (childNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childNode", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readAttributes"));
        }
        for (Element e : childNode.getChildren(OPTION_ELEMENT)) {
            TextAttributesKey key = TextAttributesKey.find(e.getAttributeValue("name"));
            Element valueElement = e.getChild(VALUE_ELEMENT);
            TextAttributes attr = this.myValueReader.read(TextAttributes.class, valueElement);
            String baseKeyName = e.getAttributeValue(BASE_ATTRIBUTES_ATTR);
            if (baseKeyName != null) {
                attr.setEnforceEmpty(false);
            }
            this.myAttributesMap.put(key, attr);
            this.migrateErrorStripeColorFrom14(key, attr);
        }
    }

    private void migrateErrorStripeColorFrom14(@NotNull TextAttributesKey name, @NotNull TextAttributes attr) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "migrateErrorStripeColorFrom14"));
        }
        if (attr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attr", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "migrateErrorStripeColorFrom14"));
        }
        if (this.myVersion >= 141 || this.myParentScheme == null) {
            return;
        }
        Couple<Color> m = DEFAULT_STRIPE_COLORS.get(name.getExternalName());
        if (m != null && Comparing.equal(m.first, attr.getErrorStripeColor())) {
            attr.setErrorStripeColor((Color)m.second);
        }
    }

    private void readColors(Element childNode) {
        for (Object o : childNode.getChildren(OPTION_ELEMENT)) {
            Element colorElement = (Element)o;
            Color valueColor = this.myValueReader.read(Color.class, colorElement);
            String colorName = colorElement.getAttributeValue("name");
            if (BACKGROUND_COLOR_NAME.equals(colorName)) {
                this.myDeprecatedBackgroundColor = valueColor;
            }
            ColorKey name = ColorKey.find(colorName);
            this.myColorsMap.put(name, valueColor);
        }
    }

    private void readSettings(Element childNode, boolean isDefault) {
        Boolean value;
        String name = childNode.getAttributeValue("name");
        if (LINE_SPACING.equals(name)) {
            Float value2 = this.myValueReader.read(Float.class, childNode);
            if (value2 != null) {
                this.myLineSpacing = value2.floatValue();
            }
        } else if (EDITOR_FONT_SIZE.equals(name)) {
            int value3 = this.readFontSize(childNode, isDefault);
            if (value3 > 0) {
                this.setEditorFontSize(value3);
            }
        } else if (EDITOR_FONT_NAME.equals(name)) {
            String value4 = this.myValueReader.read(String.class, childNode);
            if (value4 != null) {
                this.setEditorFontName(value4);
            }
        } else if (CONSOLE_LINE_SPACING.equals(name)) {
            Float value5 = this.myValueReader.read(Float.class, childNode);
            if (value5 != null) {
                this.setConsoleLineSpacing(value5.floatValue());
            }
        } else if (CONSOLE_FONT_SIZE.equals(name)) {
            int value6 = this.readFontSize(childNode, isDefault);
            if (value6 > 0) {
                this.setConsoleFontSize(value6);
            }
        } else if (CONSOLE_FONT_NAME.equals(name)) {
            String value7 = this.myValueReader.read(String.class, childNode);
            if (value7 != null) {
                this.setConsoleFontName(value7);
            }
        } else if (EDITOR_QUICK_JAVADOC_FONT_SIZE.equals(name)) {
            FontSize value8 = this.myValueReader.read(FontSize.class, childNode);
            if (value8 != null) {
                this.myQuickDocFontSize = value8;
            }
        } else if (EDITOR_LIGATURES.equals(name)) {
            Boolean value9 = this.myValueReader.read(Boolean.class, childNode);
            if (value9 != null) {
                this.myFontPreferences.setUseLigatures(value9);
            }
        } else if (CONSOLE_LIGATURES.equals(name) && (value = this.myValueReader.read(Boolean.class, childNode)) != null) {
            this.myConsoleFontPreferences.setUseLigatures(value);
        }
    }

    private int readFontSize(Element element, boolean isDefault) {
        Integer size = this.myValueReader.read(Integer.class, element);
        return size == null ? -1 : (!isDefault ? size : JBUI.scaleFontSize(size));
    }

    private void readFontSettings(@NotNull Element element, @NotNull FontPreferences preferences, boolean isDefaultScheme) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readFontSettings"));
        }
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "readFontSettings"));
        }
        List children = element.getChildren(OPTION_ELEMENT);
        String fontFamily = null;
        int size = -1;
        for (Object child : children) {
            Element e = (Element)child;
            if (EDITOR_FONT_NAME.equals(e.getAttributeValue("name"))) {
                fontFamily = this.myValueReader.read(String.class, e);
                continue;
            }
            if (!EDITOR_FONT_SIZE.equals(e.getAttributeValue("name"))) continue;
            size = this.readFontSize(e, isDefaultScheme);
        }
        if (fontFamily != null && size > 1) {
            preferences.register(fontFamily, size);
        } else if (fontFamily != null) {
            preferences.addFontFamily(fontFamily);
        }
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        boolean useOldFontFormat;
        parentNode.setAttribute("name", this.getName());
        parentNode.setAttribute(VERSION_ATTR, Integer.toString(this.myVersion));
        if (this.myParentScheme != null && this.myParentScheme != EmptyColorScheme.INSTANCE) {
            parentNode.setAttribute(PARENT_SCHEME_ATTR, this.myParentScheme.getName());
        }
        if (!this.myMetaInfo.isEmpty()) {
            parentNode.addContent(this.metaInfoToElement());
        }
        Element element = new Element(OPTION_ELEMENT);
        element.setAttribute("name", LINE_SPACING);
        element.setAttribute(VALUE_ELEMENT, String.valueOf(this.getLineSpacing()));
        parentNode.addContent(element);
        boolean bl = useOldFontFormat = this.myFontPreferences.getEffectiveFontFamilies().size() <= 1;
        if (useOldFontFormat) {
            element = new Element(OPTION_ELEMENT);
            element.setAttribute("name", EDITOR_FONT_SIZE);
            element.setAttribute(VALUE_ELEMENT, String.valueOf(this.getEditorFontSize()));
            parentNode.addContent(element);
        } else {
            AbstractColorsScheme.writeFontPreferences(EDITOR_FONT, parentNode, this.myFontPreferences);
        }
        AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.myFontPreferences, EDITOR_LIGATURES);
        if (!this.myFontPreferences.equals(this.myConsoleFontPreferences)) {
            if (this.myConsoleFontPreferences.getEffectiveFontFamilies().size() <= 1) {
                element = new Element(OPTION_ELEMENT);
                element.setAttribute("name", CONSOLE_FONT_NAME);
                element.setAttribute(VALUE_ELEMENT, this.getConsoleFontName());
                parentNode.addContent(element);
                if (this.getConsoleFontSize() != this.getEditorFontSize()) {
                    element = new Element(OPTION_ELEMENT);
                    element.setAttribute("name", CONSOLE_FONT_SIZE);
                    element.setAttribute(VALUE_ELEMENT, Integer.toString(this.getConsoleFontSize()));
                    parentNode.addContent(element);
                }
            } else {
                AbstractColorsScheme.writeFontPreferences(CONSOLE_FONT, parentNode, this.myConsoleFontPreferences);
            }
            AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.myConsoleFontPreferences, CONSOLE_LIGATURES);
        }
        if (this.getConsoleLineSpacing() != this.getLineSpacing()) {
            element = new Element(OPTION_ELEMENT);
            element.setAttribute("name", CONSOLE_LINE_SPACING);
            element.setAttribute(VALUE_ELEMENT, Float.toString(this.getConsoleLineSpacing()));
            parentNode.addContent(element);
        }
        if (DEFAULT_FONT_SIZE != this.getQuickDocFontSize()) {
            element = new Element(OPTION_ELEMENT);
            element.setAttribute("name", EDITOR_QUICK_JAVADOC_FONT_SIZE);
            element.setAttribute(VALUE_ELEMENT, this.getQuickDocFontSize().toString());
            parentNode.addContent(element);
        }
        if (useOldFontFormat) {
            element = new Element(OPTION_ELEMENT);
            element.setAttribute("name", EDITOR_FONT_NAME);
            element.setAttribute(VALUE_ELEMENT, this.getEditorFontName());
            parentNode.addContent(element);
        }
        Element colorElements = new Element(COLORS_ELEMENT);
        Element attrElements = new Element(ATTRIBUTES_ELEMENT);
        this.writeColors(colorElements);
        this.writeAttributes(attrElements);
        if (colorElements.getChildren().size() > 0) {
            parentNode.addContent(colorElements);
        }
        if (attrElements.getChildren().size() > 0) {
            parentNode.addContent(attrElements);
        }
        this.myIsSaveNeeded = false;
    }

    private static void writeLigaturesPreferences(Element parentNode, FontPreferences preferences, String optionName) {
        if (preferences.useLigatures()) {
            Element element = new Element(OPTION_ELEMENT);
            element.setAttribute("name", optionName);
            element.setAttribute(VALUE_ELEMENT, String.valueOf(true));
            parentNode.addContent(element);
        }
    }

    private static void writeFontPreferences(@NotNull String key, @NotNull Element parent, @NotNull FontPreferences preferences) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "writeFontPreferences"));
        }
        for (String fontFamily : preferences.getRealFontFamilies()) {
            Element element = new Element(key);
            Element e = new Element(OPTION_ELEMENT);
            e.setAttribute("name", EDITOR_FONT_NAME);
            e.setAttribute(VALUE_ELEMENT, fontFamily);
            element.addContent(e);
            e = new Element(OPTION_ELEMENT);
            e.setAttribute("name", EDITOR_FONT_SIZE);
            e.setAttribute(VALUE_ELEMENT, String.valueOf(preferences.getSize(fontFamily)));
            element.addContent(e);
            parent.addContent(element);
        }
    }

    private void writeAttributes(Element attrElements) throws WriteExternalException {
        ArrayList<TextAttributesKey> list = new ArrayList<TextAttributesKey>(this.myAttributesMap.keySet());
        Collections.sort(list);
        for (TextAttributesKey key : list) {
            TextAttributes defaultAttr = this.myParentScheme != null ? this.myParentScheme.getAttributes(key) : new TextAttributes();
            TextAttributesKey baseKey = key.getFallbackAttributeKey();
            TextAttributes defaultFallbackAttr = baseKey != null && this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getFallbackAttributes(baseKey) : null;
            TextAttributes value = this.myAttributesMap.get(key);
            Element element = new Element(OPTION_ELEMENT);
            element.setAttribute("name", key.getExternalName());
            if (baseKey != null && value.isFallbackEnabled()) {
                if (!this.isParentOverwritingInheritance(key)) continue;
                element.setAttribute(BASE_ATTRIBUTES_ATTR, baseKey.getExternalName());
                attrElements.addContent(element);
                continue;
            }
            if ((!value.containsValue() || value.equals(defaultAttr)) && defaultAttr != defaultFallbackAttr) continue;
            Element valueElement = new Element(VALUE_ELEMENT);
            value.writeExternal(valueElement);
            element.addContent(valueElement);
            attrElements.addContent(element);
        }
    }

    @NotNull
    private Element metaInfoToElement() {
        Element metaInfoElement = new Element(META_INFO_ELEMENT);
        this.myMetaInfo.setProperty(META_INFO_MODIFIED_TIME, META_INFO_DATE_FORMAT.format(new Date()));
        ArrayList<String> sortedPropertyNames = new ArrayList<String>(this.myMetaInfo.size());
        sortedPropertyNames.addAll(this.myMetaInfo.stringPropertyNames());
        Collections.sort(sortedPropertyNames);
        for (String propertyName : sortedPropertyNames) {
            String value = this.myMetaInfo.getProperty(propertyName);
            Element propertyInfo = new Element(PROPERTY_ELEMENT);
            propertyInfo.setAttribute("name", propertyName);
            propertyInfo.setText(value);
            metaInfoElement.addContent(propertyInfo);
        }
        Element element = metaInfoElement;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "metaInfoToElement"));
        }
        return element;
    }

    private boolean isParentOverwritingInheritance(@NotNull TextAttributesKey key) {
        TextAttributes parentAttrs;
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "isParentOverwritingInheritance"));
        }
        TextAttributes textAttributes = parentAttrs = this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : null;
        if (parentAttrs != null) {
            return !parentAttrs.isFallbackEnabled();
        }
        return false;
    }

    protected Color getOwnColor(ColorKey key) {
        return this.myColorsMap.get(key);
    }

    private void writeColors(Element colorElements) {
        ArrayList<ColorKey> list = new ArrayList<ColorKey>(this.myColorsMap.keySet());
        Collections.sort(list);
        for (ColorKey key : list) {
            if (!this.haveToWrite(key)) continue;
            Color value = this.myColorsMap.get(key);
            Element element = new Element(OPTION_ELEMENT);
            element.setAttribute("name", key.getExternalName());
            element.setAttribute(VALUE_ELEMENT, value != null ? Integer.toString(value.getRGB() & 0xFFFFFF, 16) : "");
            colorElements.addContent(element);
        }
    }

    private boolean haveToWrite(ColorKey key) {
        Color value = this.myColorsMap.get(key);
        return this.myParentScheme == null || !(this.myParentScheme instanceof AbstractColorsScheme ? Comparing.equal(((AbstractColorsScheme)this.myParentScheme).getOwnColor(key), value) && ((AbstractColorsScheme)this.myParentScheme).myColorsMap.containsKey(key) : Comparing.equal(this.myParentScheme.getColor(key), value));
    }

    @Override
    @NotNull
    public FontPreferences getConsoleFontPreferences() {
        FontPreferences fontPreferences = this.myConsoleFontPreferences;
        if (fontPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getConsoleFontPreferences"));
        }
        return fontPreferences;
    }

    @Override
    public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferences", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "setConsoleFontPreferences"));
        }
        preferences.copyTo(this.myConsoleFontPreferences);
        this.initFonts();
    }

    @Override
    public String getConsoleFontName() {
        return this.myConsoleFontPreferences.getFontFamily();
    }

    @Override
    public void setConsoleFontName(String fontName) {
        int consoleFontSize = this.getConsoleFontSize();
        this.myConsoleFontPreferences.clear();
        this.myConsoleFontPreferences.register(fontName, consoleFontSize);
    }

    @Override
    public int getConsoleFontSize() {
        String font = this.getConsoleFontName();
        UISettings uiSettings = UISettings.getInstance();
        if ((uiSettings == null || !uiSettings.PRESENTATION_MODE) && this.myConsoleFontPreferences.hasSize(font)) {
            return this.myConsoleFontPreferences.getSize(font);
        }
        return this.getEditorFontSize();
    }

    @Override
    public void setConsoleFontSize(int fontSize) {
        fontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        this.myConsoleFontPreferences.register(this.getConsoleFontName(), fontSize);
        this.initFonts();
    }

    @Override
    public float getConsoleLineSpacing() {
        float consoleLineSpacing = this.myConsoleLineSpacing;
        if (consoleLineSpacing == -1.0f) {
            return this.getLineSpacing();
        }
        return consoleLineSpacing;
    }

    @Override
    public void setConsoleLineSpacing(float lineSpacing) {
        this.myConsoleLineSpacing = lineSpacing;
    }

    protected TextAttributes getFallbackAttributes(TextAttributesKey fallbackKey) {
        if (fallbackKey == null) {
            return null;
        }
        TextAttributes fallbackAttributes = this.getDirectlyDefinedAttributes(fallbackKey);
        if (!(fallbackAttributes == null || fallbackAttributes.isFallbackEnabled() && fallbackKey.getFallbackAttributeKey() != null)) {
            return fallbackAttributes;
        }
        return this.getFallbackAttributes(fallbackKey.getFallbackAttributeKey());
    }

    @Nullable
    public TextAttributes getDirectlyDefinedAttributes(@NotNull TextAttributesKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getDirectlyDefinedAttributes"));
        }
        TextAttributes attributes = this.myAttributesMap.get(key);
        if (attributes != null) {
            return attributes;
        }
        return this.myParentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.myParentScheme).getDirectlyDefinedAttributes(key) : null;
    }

    protected static boolean containsValue(@Nullable TextAttributes attributes) {
        return attributes != null && attributes.containsValue();
    }

    public boolean isSaveNeeded() {
        return this.myIsSaveNeeded;
    }

    public void setSaveNeeded(boolean isSaveNeeded) {
        this.myIsSaveNeeded = isSaveNeeded;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    @NotNull
    public Properties getMetaProperties() {
        Properties properties = this.myMetaInfo;
        if (properties == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme", "getMetaProperties"));
        }
        return properties;
    }
}

