/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.roots.impl.FileIndexBase;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class ProjectFileIndexImpl
extends FileIndexBase
implements ProjectFileIndex {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.ProjectFileIndexImpl");
    private final Project myProject;
    private final ContentFilter myContentFilter;

    public ProjectFileIndexImpl(@NotNull Project project, @NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeManager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "<init>"));
        }
        if (directoryIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryIndex", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "<init>"));
        }
        if (fileTypeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeManager", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "<init>"));
        }
        super(directoryIndex, fileTypeManager, project);
        this.myProject = project;
        this.myContentFilter = new ContentFilter();
    }

    @Override
    public boolean iterateContent(@NotNull ContentIterator iterator) {
        Module[] modules;
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "iterateContent"));
        }
        for (Module module : modules = ApplicationManager.getApplication().runReadAction(new Computable<Module[]>(){

            @Override
            public Module[] compute() {
                return ModuleManager.getInstance(ProjectFileIndexImpl.this.myProject).getModules();
            }
        })) {
            for (VirtualFile contentRoot : this.getRootsToIterate(module)) {
                boolean finished = VfsUtilCore.iterateChildrenRecursively(contentRoot, this.myContentFilter, iterator);
                if (finished) continue;
                return false;
            }
        }
        return true;
    }

    private List<VirtualFile> getRootsToIterate(final Module module) {
        return ApplicationManager.getApplication().runReadAction(new Computable<List<VirtualFile>>(){

            @Override
            public List<VirtualFile> compute() {
                if (module.isDisposed()) {
                    return Collections.emptyList();
                }
                ArrayList<VirtualFile> result = ContainerUtil.newArrayList();
                for (VirtualFile contentRoot : ModuleRootManager.getInstance(module).getContentRoots()) {
                    DirectoryInfo parentInfo;
                    VirtualFile parent;
                    DirectoryInfo info = ProjectFileIndexImpl.this.getInfoForFileOrDirectory(contentRoot);
                    if (!info.isInProject() || !module.equals(info.getModule()) || (parent = contentRoot.getParent()) != null && (parentInfo = ProjectFileIndexImpl.this.getInfoForFileOrDirectory(parent)).isInProject() && parentInfo.getModule() != null) continue;
                    result.add(contentRoot);
                }
                return result;
            }
        });
    }

    @Override
    public boolean iterateContentUnderDirectory(@NotNull VirtualFile dir, @NotNull ContentIterator iterator) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "iterateContentUnderDirectory"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "iterateContentUnderDirectory"));
        }
        return VfsUtilCore.iterateChildrenRecursively(dir, this.myContentFilter, iterator);
    }

    @Override
    public boolean isExcluded(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isExcluded"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(file);
        return info.isIgnored() || info.isExcluded();
    }

    @Override
    public boolean isUnderIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isUnderIgnored"));
        }
        return this.getInfoForFileOrDirectory(file).isIgnored();
    }

    @Override
    public Module getModuleForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getModuleForFile"));
        }
        return this.getModuleForFile(file, true);
    }

    @Override
    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile file, boolean honorExclusion) {
        DirectoryInfo info;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getModuleForFile"));
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)((Object)file)).getDelegate();
        }
        if ((info = this.getInfoForFileOrDirectory(file)).isInProject() || !honorExclusion && info.isExcluded()) {
            return info.getModule();
        }
        return null;
    }

    @Override
    @NotNull
    public List<OrderEntry> getOrderEntriesForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getOrderEntriesForFile"));
        }
        List<OrderEntry> list = this.myDirectoryIndex.getOrderEntries(this.getInfoForFileOrDirectory(file));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getOrderEntriesForFile"));
        }
        return list;
    }

    @Override
    public VirtualFile getClassRootForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getClassRootForFile"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(file);
        if (!info.isInProject()) {
            return null;
        }
        return info.getLibraryClassRoot();
    }

    @Override
    public VirtualFile getSourceRootForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getSourceRootForFile"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(file);
        if (!info.isInProject()) {
            return null;
        }
        return info.getSourceRoot();
    }

    @Override
    public VirtualFile getContentRootForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getContentRootForFile"));
        }
        return this.getContentRootForFile(file, true);
    }

    @Override
    public VirtualFile getContentRootForFile(@NotNull VirtualFile file, boolean honorExclusion) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getContentRootForFile"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(file);
        if (info.isInProject() || !honorExclusion && info.isExcluded()) {
            return info.getContentRoot();
        }
        return null;
    }

    @Override
    public String getPackageNameByDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "getPackageNameByDirectory"));
        }
        if (!dir.isDirectory()) {
            LOG.error(dir.getPresentableUrl());
        }
        return this.myDirectoryIndex.getPackageName(dir);
    }

    @Override
    public boolean isLibraryClassFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isLibraryClassFile"));
        }
        if (file.isDirectory()) {
            return false;
        }
        DirectoryInfo parentInfo = this.getInfoForFileOrDirectory(file);
        return parentInfo.isInProject() && parentInfo.hasLibraryClassRoot();
    }

    @Override
    public boolean isInSource(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInSource"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource() || info.isInLibrarySource();
    }

    @Override
    public boolean isInLibraryClasses(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInLibraryClasses"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInProject() && info.hasLibraryClassRoot();
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInLibrarySource"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInProject() && info.isInLibrarySource();
    }

    @Override
    public boolean isInLibrary(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInLibrary"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInProject() && (info.hasLibraryClassRoot() || info.isInLibrarySource());
    }

    @Override
    public boolean isIgnored(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isIgnored"));
        }
        return this.isExcluded(file);
    }

    @Override
    public boolean isInContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInContent"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInProject() && info.getModule() != null;
    }

    @Override
    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInSourceContent"));
        }
        return this.getInfoForFileOrDirectory(fileOrDir).isInModuleSource();
    }

    @Override
    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isInTestSourceContent"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource() && JavaModuleSourceRootTypes.isTestSourceOrResource(this.myDirectoryIndex.getSourceRootType(info));
    }

    @Override
    public boolean isUnderSourceRootOfType(@NotNull VirtualFile fileOrDir, @NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileOrDir", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isUnderSourceRootOfType"));
        }
        if (rootTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTypes", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl", "isUnderSourceRootOfType"));
        }
        DirectoryInfo info = this.getInfoForFileOrDirectory(fileOrDir);
        return info.isInModuleSource() && rootTypes.contains(this.myDirectoryIndex.getSourceRootType(info));
    }

    private class ContentFilter
    implements VirtualFileFilter {
        private ContentFilter() {
        }

        @Override
        public boolean accept(final @NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexImpl$ContentFilter", "accept"));
            }
            return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                @Override
                public Boolean compute() {
                    DirectoryInfo info = ProjectFileIndexImpl.this.getInfoForFileOrDirectory(file);
                    if (!info.isInProject() || info.getModule() == null) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    return !ProjectFileIndexImpl.this.myFileTypeRegistry.isFileIgnored(file);
                }
            });
        }
    }
}

