/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiType
implements PsiAnnotationOwner,
Cloneable {
    public static final PsiPrimitiveType BYTE = new PsiPrimitiveType("byte", "java.lang.Byte");
    public static final PsiPrimitiveType CHAR = new PsiPrimitiveType("char", "java.lang.Character");
    public static final PsiPrimitiveType DOUBLE = new PsiPrimitiveType("double", "java.lang.Double");
    public static final PsiPrimitiveType FLOAT = new PsiPrimitiveType("float", "java.lang.Float");
    public static final PsiPrimitiveType INT = new PsiPrimitiveType("int", "java.lang.Integer");
    public static final PsiPrimitiveType LONG = new PsiPrimitiveType("long", "java.lang.Long");
    public static final PsiPrimitiveType SHORT = new PsiPrimitiveType("short", "java.lang.Short");
    public static final PsiPrimitiveType BOOLEAN = new PsiPrimitiveType("boolean", "java.lang.Boolean");
    public static final PsiPrimitiveType VOID = new PsiPrimitiveType("void", "java.lang.Void");
    public static final PsiPrimitiveType NULL = new PsiPrimitiveType("null", (String)null);
    public static final PsiType[] EMPTY_ARRAY = new PsiType[0];
    public static final ArrayFactory<PsiType> ARRAY_FACTORY = new ArrayFactory<PsiType>(){

        @NotNull
        public PsiType[] create(int count) {
            PsiType[] psiTypeArray = count == 0 ? EMPTY_ARRAY : new PsiType[count];
            if (psiTypeArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType$1", "create"));
            }
            return psiTypeArray;
        }
    };
    private TypeAnnotationProvider myAnnotationProvider;

    @NotNull
    public static PsiType[] createArray(int count) {
        PsiType[] psiTypeArray = ARRAY_FACTORY.create(count);
        if (psiTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "createArray"));
        }
        return psiTypeArray;
    }

    protected PsiType(@NotNull PsiAnnotation[] annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiType", "<init>"));
        }
        this(TypeAnnotationProvider.Static.create(annotations));
    }

    protected PsiType(@NotNull TypeAnnotationProvider annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiType", "<init>"));
        }
        this.myAnnotationProvider = annotations;
    }

    @NotNull
    public PsiType annotate(@NotNull TypeAnnotationProvider provider) {
        PsiType psiType;
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/psi/PsiType", "annotate"));
        }
        if (provider == this.myAnnotationProvider) {
            PsiType psiType2 = this;
            if (psiType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "annotate"));
            }
            return psiType2;
        }
        try {
            PsiType copy = (PsiType)this.clone();
            copy.myAnnotationProvider = provider;
            psiType = copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "annotate"));
        }
        return psiType;
    }

    @NotNull
    public PsiArrayType createArrayType() {
        PsiArrayType psiArrayType = new PsiArrayType(this);
        if (psiArrayType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "createArrayType"));
        }
        return psiArrayType;
    }

    public PsiArrayType createArrayType(PsiAnnotation ... annotations) {
        if (annotations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiType", "createArrayType"));
        }
        return new PsiArrayType(this, annotations);
    }

    @NotNull
    public String getPresentableText(boolean annotated) {
        String string = this.getPresentableText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getPresentableText"));
        }
        return string;
    }

    @NotNull
    public abstract String getPresentableText();

    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string = this.getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getCanonicalText"));
        }
        return string;
    }

    @NotNull
    public abstract String getCanonicalText();

    @NotNull
    public String getInternalCanonicalText() {
        String string = this.getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getInternalCanonicalText"));
        }
        return string;
    }

    public abstract boolean isValid();

    public boolean isAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/PsiType", "isAssignableFrom"));
        }
        return TypeConversionUtil.isAssignable(this, type);
    }

    public boolean isConvertibleFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/PsiType", "isConvertibleFrom"));
        }
        return TypeConversionUtil.areTypesConvertible(type, this);
    }

    public abstract boolean equalsToText(@NotNull String var1);

    public static PsiClassType getTypeByName(String qName, Project project, GlobalSearchScope resolveScope) {
        PsiElementFactory factory = JavaPsiFacade.getInstance(project).getElementFactory();
        return factory.createTypeByFQClassName(qName, resolveScope);
    }

    @NotNull
    public static PsiClassType getJavaLangObject(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/PsiType", "getJavaLangObject"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/PsiType", "getJavaLangObject"));
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.Object", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getJavaLangObject"));
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangClass(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/PsiType", "getJavaLangClass"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/PsiType", "getJavaLangClass"));
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.Class", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getJavaLangClass"));
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangThrowable(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/PsiType", "getJavaLangThrowable"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/PsiType", "getJavaLangThrowable"));
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.Throwable", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getJavaLangThrowable"));
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangString(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/PsiType", "getJavaLangString"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/PsiType", "getJavaLangString"));
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.String", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getJavaLangString"));
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangError(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/PsiType", "getJavaLangError"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/PsiType", "getJavaLangError"));
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.Error", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getJavaLangError"));
        }
        return psiClassType;
    }

    @NotNull
    public static PsiClassType getJavaLangRuntimeException(@NotNull PsiManager manager, @NotNull GlobalSearchScope resolveScope) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/PsiType", "getJavaLangRuntimeException"));
        }
        if (resolveScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveScope", "com/intellij/psi/PsiType", "getJavaLangRuntimeException"));
        }
        PsiClassType psiClassType = PsiType.getTypeByName("java.lang.RuntimeException", manager.getProject(), resolveScope);
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getJavaLangRuntimeException"));
        }
        return psiClassType;
    }

    public abstract <A> A accept(@NotNull PsiTypeVisitor<A> var1);

    public final int getArrayDimensions() {
        PsiType type = this;
        int dims = 0;
        while (type instanceof PsiArrayType) {
            ++dims;
            type = ((PsiArrayType)type).getComponentType();
        }
        return dims;
    }

    @NotNull
    public final PsiType getDeepComponentType() {
        PsiType type = this;
        while (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
        }
        PsiType psiType = type;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getDeepComponentType"));
        }
        return psiType;
    }

    @Nullable
    public abstract GlobalSearchScope getResolveScope();

    @NotNull
    public abstract PsiType[] getSuperTypes();

    @NotNull
    public final TypeAnnotationProvider getAnnotationProvider() {
        TypeAnnotationProvider typeAnnotationProvider = this.myAnnotationProvider;
        if (typeAnnotationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getAnnotationProvider"));
        }
        return typeAnnotationProvider;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.myAnnotationProvider.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/PsiType", "findAnnotation"));
        }
        for (PsiAnnotation annotation : this.getAnnotations()) {
            if (!qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/PsiType", "addAnnotation"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }

    public String toString() {
        return "PsiType:" + this.getPresentableText();
    }

    protected static abstract class Stub
    extends PsiType {
        protected Stub(@NotNull PsiAnnotation[] annotations) {
            if (annotations == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiType$Stub", "<init>"));
            }
            super(annotations);
        }

        protected Stub(@NotNull TypeAnnotationProvider annotations) {
            if (annotations == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotations", "com/intellij/psi/PsiType$Stub", "<init>"));
            }
            super(annotations);
        }

        @Override
        @NotNull
        public final String getPresentableText() {
            String string = this.getPresentableText(false);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType$Stub", "getPresentableText"));
            }
            return string;
        }

        @Override
        @NotNull
        public abstract String getPresentableText(boolean var1);

        @Override
        @NotNull
        public final String getCanonicalText() {
            String string = this.getCanonicalText(false);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiType$Stub", "getCanonicalText"));
            }
            return string;
        }

        @Override
        @NotNull
        public abstract String getCanonicalText(boolean var1);
    }
}

