/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualsReplaceableByObjectsCallInspection
extends BaseInspection {
    public boolean checkNotNull;

    @Override
    @NotNull
    public JComponent createOptionsPanel() {
        SingleCheckboxOptionsPanel singleCheckboxOptionsPanel = new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("equals.replaceable.by.objects.check.not.null.option", new Object[0]), this, "checkNotNull");
        if (singleCheckboxOptionsPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection", "createOptionsPanel"));
        }
        return singleCheckboxOptionsPanel;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new EqualsReplaceableByObjectsCallFix((String)infos[0], (String)infos[1], (Boolean)infos[2]);
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel7OrHigher(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsReplaceableByObjectsCallVisitor();
    }

    private class EqualsReplaceableByObjectsCallVisitor
    extends BaseInspectionVisitor {
        private EqualsReplaceableByObjectsCallVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiElement maybeBinary = PsiTreeUtil.skipParentsOfType(expression, PsiParenthesizedExpression.class, PsiPrefixExpression.class);
            if (maybeBinary instanceof PsiBinaryExpression && this.processNotNullCheck((PsiBinaryExpression)maybeBinary)) {
                return;
            }
            if (!EqualsReplaceableByObjectsCallInspection.this.checkNotNull) {
                PsiVariable variable = ExpressionUtils.getVariable(expression.getMethodExpression().getQualifierExpression());
                if (variable == null) {
                    return;
                }
                PsiVariable otherVariable = this.getArgumentFromEqualsCallOn(expression, variable);
                if (otherVariable == null) {
                    return;
                }
                this.registerError((PsiElement)expression, variable.getName(), otherVariable.getName(), true);
            }
        }

        private boolean processNotNullCheck(PsiBinaryExpression expression) {
            IElementType tokenType = expression.getOperationTokenType();
            if (JavaTokenType.ANDAND.equals(tokenType)) {
                PsiVariable variable = ExpressionUtils.getVariableFromNullComparison(expression.getLOperand(), false);
                if (variable == null) {
                    return false;
                }
                PsiVariable otherVariable = this.getArgumentFromEqualsCallOn(expression.getROperand(), variable);
                if (otherVariable == null) {
                    return false;
                }
                this.checkEqualityBefore(expression, true, variable, otherVariable);
            } else if (JavaTokenType.OROR.equals(tokenType)) {
                PsiVariable variable = ExpressionUtils.getVariableFromNullComparison(expression.getLOperand(), true);
                if (variable == null) {
                    return false;
                }
                PsiExpression rhs = ParenthesesUtils.stripParentheses(expression.getROperand());
                if (!(rhs instanceof PsiPrefixExpression)) {
                    return false;
                }
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)rhs;
                if (!JavaTokenType.EXCL.equals(prefixExpression.getOperationTokenType())) {
                    return false;
                }
                PsiVariable otherVariable = this.getArgumentFromEqualsCallOn(prefixExpression.getOperand(), variable);
                if (otherVariable == null) {
                    return false;
                }
                this.checkEqualityBefore(expression, false, variable, otherVariable);
            }
            return true;
        }

        private void checkEqualityBefore(PsiExpression expression, boolean equals, PsiVariable variable1, PsiVariable variable2) {
            PsiExpression lhs;
            PsiBinaryExpression binaryExpression;
            PsiElement parent = PsiTreeUtil.skipParentsOfType(expression, PsiParenthesizedExpression.class);
            if (parent instanceof PsiBinaryExpression && PsiTreeUtil.isAncestor((binaryExpression = (PsiBinaryExpression)parent).getROperand(), expression, false) && this.isEquality(lhs = binaryExpression.getLOperand(), equals, variable1, variable2)) {
                this.registerError((PsiElement)binaryExpression, variable1.getName(), variable2.getName(), equals);
                return;
            }
            this.registerError((PsiElement)expression, variable1.getName(), variable2.getName(), equals);
        }

        private boolean isEquality(PsiExpression expression, boolean equals, PsiVariable variable1, PsiVariable variable2) {
            if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            if (equals ? !JavaTokenType.EQEQ.equals(binaryExpression.getOperationTokenType()) : !JavaTokenType.NE.equals(binaryExpression.getOperationTokenType())) {
                return false;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            return VariableAccessUtils.evaluatesToVariable(lhs, variable1) && VariableAccessUtils.evaluatesToVariable(rhs, variable2) || VariableAccessUtils.evaluatesToVariable(lhs, variable2) && VariableAccessUtils.evaluatesToVariable(rhs, variable1);
        }

        private PsiVariable getArgumentFromEqualsCallOn(PsiExpression expression, PsiVariable variable) {
            if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName)) {
                return null;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!VariableAccessUtils.evaluatesToVariable(qualifier, variable)) {
                return null;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] expressions = argumentList.getExpressions();
            if (expressions.length != 1) {
                return null;
            }
            return ExpressionUtils.getVariable(expressions[0]);
        }
    }

    private static class EqualsReplaceableByObjectsCallFix
    extends InspectionGadgetsFix {
        private final String myName1;
        private final String myName2;
        private final Boolean myEquals;

        public EqualsReplaceableByObjectsCallFix(String name1, String name2, Boolean equals) {
            this.myName1 = name1;
            this.myName2 = name2;
            this.myEquals = equals;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("equals.replaceable.by.objects.call.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/EqualsReplaceableByObjectsCallInspection$EqualsReplaceableByObjectsCallFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiBinaryExpression) && !(element instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiExpression expression = (PsiExpression)element;
            if (this.myEquals.booleanValue()) {
                PsiReplacementUtil.replaceExpressionAndShorten(expression, "java.util.Objects.equals(" + this.myName1 + "," + this.myName2 + ")");
            } else {
                PsiReplacementUtil.replaceExpressionAndShorten(expression, "!java.util.Objects.equals(" + this.myName1 + "," + this.myName2 + ")");
            }
        }
    }
}

