/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryBoxingInspection
extends BaseInspection {
    public boolean onlyReportSuperfluouslyBoxed = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.boxing.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryBoxingInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.boxing.superfluous.option", new Object[0]), this, "onlyReportSuperfluouslyBoxed");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.boxing.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryBoxingInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryBoxingFix();
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return PsiUtil.isLanguageLevel5OrHigher(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryBoxingVisitor();
    }

    private class UnnecessaryBoxingVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryBoxingVisitor() {
        }

        @Override
        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            PsiType expectedType;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingVisitor", "visitNewExpression"));
            }
            super.visitNewExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiType constructorType = expression.getType();
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType(constructorType);
            if (unboxedType == null) {
                return;
            }
            PsiMethod constructor = expression.resolveConstructor();
            if (constructor == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression boxedExpression = arguments[0];
            PsiType argumentType = boxedExpression.getType();
            if (!(argumentType instanceof PsiPrimitiveType) || !this.canRemainUnboxed(expression, boxedExpression)) {
                return;
            }
            if (UnnecessaryBoxingInspection.this.onlyReportSuperfluouslyBoxed && !((expectedType = ExpectedTypeUtils.findExpectedType(expression, false, true)) instanceof PsiPrimitiveType)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression boxedExpression = arguments[0];
            if (!(boxedExpression.getType() instanceof PsiPrimitiveType)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!"valueOf".equals(referenceName)) {
                return;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
            String canonicalText = referenceExpression.getCanonicalText();
            if (PsiTypesUtil.unboxIfPossible(canonicalText) == canonicalText || !this.canRemainUnboxed(expression, boxedExpression)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        private boolean canRemainUnboxed(PsiExpression expression, PsiExpression boxedExpression) {
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression) {
                expression = (PsiExpression)parent;
                parent = parent.getParent();
            }
            if (parent instanceof PsiExpressionStatement || parent instanceof PsiReferenceExpression) {
                return false;
            }
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)parent;
                return !TypeUtils.isTypeParameter(castExpression.getType());
            }
            if (parent instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)parent;
                PsiExpression thenExpression = conditionalExpression.getThenExpression();
                PsiExpression elseExpression = conditionalExpression.getElseExpression();
                if (elseExpression == null || thenExpression == null) {
                    return false;
                }
                if (PsiTreeUtil.isAncestor(thenExpression, expression, false)) {
                    PsiType type = elseExpression.getType();
                    return type instanceof PsiPrimitiveType;
                }
                if (PsiTreeUtil.isAncestor(elseExpression, expression, false)) {
                    PsiType type = thenExpression.getType();
                    return type instanceof PsiPrimitiveType;
                }
                return true;
            }
            if (parent instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
                return !this.isPossibleObjectComparison(expression, polyadicExpression);
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiCallExpression)) {
                return true;
            }
            PsiCallExpression containingCallExpression = (PsiCallExpression)grandParent;
            return this.isSameMethodCalledWithoutBoxing(containingCallExpression, expression, boxedExpression);
        }

        private boolean isPossibleObjectComparison(PsiExpression expression, PsiPolyadicExpression polyadicExpression) {
            if (!ComparisonUtils.isEqualityComparison(polyadicExpression)) {
                return false;
            }
            for (PsiExpression operand : polyadicExpression.getOperands()) {
                if (operand == expression || operand.getType() instanceof PsiPrimitiveType) continue;
                return true;
            }
            return false;
        }

        private boolean canBinaryExpressionBeUnboxed(PsiExpression lhs, PsiExpression rhs) {
            PsiType rhsType = rhs.getType();
            if (rhsType == null) {
                return false;
            }
            PsiType lhsType = lhs.getType();
            if (lhsType == null) {
                return false;
            }
            if (!(lhsType instanceof PsiPrimitiveType) && !ExpressionUtils.isAnnotatedNotNull(lhs)) {
                return false;
            }
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType(rhsType);
            return unboxedType != null && unboxedType.isAssignableFrom(lhsType);
        }

        private boolean isSameMethodCalledWithoutBoxing(@NotNull PsiCallExpression methodCallExpression, @NotNull PsiExpression boxingExpression, @NotNull PsiExpression boxedExpression) {
            if (methodCallExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingVisitor", "isSameMethodCalledWithoutBoxing"));
            }
            if (boxingExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boxingExpression", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingVisitor", "isSameMethodCalledWithoutBoxing"));
            }
            if (boxedExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boxedExpression", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingVisitor", "isSameMethodCalledWithoutBoxing"));
            }
            PsiMethod originalMethod = methodCallExpression.resolveMethod();
            if (originalMethod == null) {
                return false;
            }
            PsiMethod otherMethod = MethodCallUtils.findMethodWithReplacedArgument(methodCallExpression, boxingExpression, boxedExpression);
            return originalMethod == otherMethod;
        }
    }

    private static class UnnecessaryBoxingFix
    extends InspectionGadgetsFix {
        private UnnecessaryBoxingFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.boxing.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(@NotNull Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            String replacementText;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingFix", "doFix"));
            }
            PsiCallExpression expression = (PsiCallExpression)descriptor.getPsiElement();
            PsiExpressionList argumentList = expression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression unboxedExpression = arguments[0];
            Object value = ExpressionUtils.computeConstantExpression(unboxedExpression);
            if (value != null) {
                if (value == Boolean.TRUE) {
                    PsiReplacementUtil.replaceExpression(expression, "java.lang.Boolean.TRUE");
                    return;
                }
                if (value == Boolean.FALSE) {
                    PsiReplacementUtil.replaceExpression(expression, "java.lang.Boolean.FALSE");
                    return;
                }
            }
            if ((replacementText = UnnecessaryBoxingFix.getUnboxedExpressionText(unboxedExpression, expression)) == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression(expression, replacementText);
        }

        @Nullable
        private static String getUnboxedExpressionText(@NotNull PsiExpression unboxedExpression, @NotNull PsiExpression boxedExpression) {
            if (unboxedExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unboxedExpression", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingFix", "getUnboxedExpressionText"));
            }
            if (boxedExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "boxedExpression", "com/siyeh/ig/migration/UnnecessaryBoxingInspection$UnnecessaryBoxingFix", "getUnboxedExpressionText"));
            }
            PsiType boxedType = boxedExpression.getType();
            if (boxedType == null) {
                return null;
            }
            PsiType expressionType = unboxedExpression.getType();
            if (expressionType == null) {
                return null;
            }
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType(boxedType);
            if (unboxedType == null) {
                return null;
            }
            String text = unboxedExpression.getText();
            if (expressionType.equals(unboxedType)) {
                PsiElement parent = boxedExpression.getParent();
                if (parent instanceof PsiExpression && ParenthesesUtils.areParenthesesNeeded(unboxedExpression, (PsiExpression)parent, false)) {
                    return '(' + text + ')';
                }
                return text;
            }
            if (unboxedExpression instanceof PsiLiteralExpression) {
                if (((Object)unboxedType).equals(PsiType.LONG) && expressionType.equals(PsiType.INT)) {
                    return text + 'L';
                }
                if (((Object)unboxedType).equals(PsiType.FLOAT) && (expressionType.equals(PsiType.INT) || expressionType.equals(PsiType.DOUBLE) && !StringUtil.endsWithIgnoreCase(text, "d"))) {
                    return text + 'f';
                }
                if (((Object)unboxedType).equals(PsiType.DOUBLE) && expressionType.equals(PsiType.INT)) {
                    return text + 'd';
                }
            }
            if (ParenthesesUtils.getPrecedence(unboxedExpression) > 4) {
                return '(' + ((PsiType)unboxedType).getCanonicalText() + ")(" + text + ')';
            }
            return '(' + ((PsiType)unboxedType).getCanonicalText() + ')' + text;
        }
    }
}

