/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.InlayInfo;
import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterNameHintsManager {
    private static final List<Couple<String>> COMMONLY_USED_PARAMETER_PAIR = ContainerUtil.newArrayList(new Couple[]{Couple.of("begin", "end"), Couple.of("start", "end"), Couple.of("first", "last"), Couple.of("first", "second"), Couple.of("from", "to"), Couple.of("key", "value"), Couple.of("min", "max")});
    @NotNull
    private final List<InlayInfo> myDescriptors;

    public ParameterNameHintsManager(@NotNull PsiCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "<init>"));
        }
        PsiExpression[] callArguments = ParameterNameHintsManager.getArguments(callExpression);
        JavaResolveResult resolveResult = callExpression.resolveMethodGenerics();
        JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
        List<Object> descriptors = Collections.emptyList();
        if (callArguments.length >= settings.getInlineLiteralParameterMinArgumentsToFold() && ParameterNameHintsManager.hasLiteralExpression(callArguments) && resolveResult.getElement() instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolveResult.getElement();
            PsiParameter[] parameters = method.getParameterList().getParameters();
            descriptors = ParameterNameHintsManager.buildDescriptorsForLiteralArguments(callArguments, parameters, resolveResult);
        }
        this.myDescriptors = descriptors;
    }

    static boolean isLiteralExpression(@Nullable PsiElement callArgument) {
        if (callArgument instanceof PsiLiteralExpression) {
            return true;
        }
        if (callArgument instanceof PsiPrefixExpression) {
            PsiPrefixExpression expr = (PsiPrefixExpression)callArgument;
            IElementType tokenType = expr.getOperationTokenType();
            return (JavaTokenType.MINUS.equals(tokenType) || JavaTokenType.PLUS.equals(tokenType)) && expr.getOperand() instanceof PsiLiteralExpression;
        }
        return false;
    }

    @NotNull
    private static PsiExpression[] getArguments(@NotNull PsiCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "getArguments"));
        }
        PsiExpressionList callArgumentsList = call.getArgumentList();
        PsiExpression[] psiExpressionArray = callArgumentsList == null ? PsiExpression.EMPTY_ARRAY : callArgumentsList.getExpressions();
        if (psiExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "getArguments"));
        }
        return psiExpressionArray;
    }

    @NotNull
    public List<InlayInfo> getDescriptors() {
        List<InlayInfo> list = this.myDescriptors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "getDescriptors"));
        }
        return list;
    }

    @NotNull
    private static List<InlayInfo> buildDescriptorsForLiteralArguments(@NotNull PsiExpression[] callArguments, @NotNull PsiParameter[] parameters, @NotNull JavaResolveResult resolveResult) {
        if (callArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callArguments", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "buildDescriptorsForLiteralArguments"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "buildDescriptorsForLiteralArguments"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "buildDescriptorsForLiteralArguments"));
        }
        if (callArguments.length == 2 && parameters.length == 2 && ParameterNameHintsManager.isCommonlyNamedParameterPair(0, 1, parameters)) {
            List<InlayInfo> list = ContainerUtil.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "buildDescriptorsForLiteralArguments"));
            }
            return list;
        }
        ArrayList<InlayInfo> descriptors = ContainerUtil.newArrayList();
        for (int index = 0; index < callArguments.length && index < parameters.length; ++index) {
            if (!ParameterNameHintsManager.shouldInlineParameterName(index, callArguments, parameters, resolveResult)) continue;
            descriptors.add(ParameterNameHintsManager.createInlayInfo(callArguments[index], parameters[index]));
        }
        if (ContainerUtil.find(descriptors, hint -> ParameterNameHintsManager.hasProperLength(hint.getText())) != null) {
            ArrayList<InlayInfo> arrayList = descriptors;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "buildDescriptorsForLiteralArguments"));
            }
            return arrayList;
        }
        List<InlayInfo> list = ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "buildDescriptorsForLiteralArguments"));
        }
        return list;
    }

    @NotNull
    private static InlayInfo createInlayInfo(@NotNull PsiExpression callArgument, @NotNull PsiParameter methodParam) {
        if (callArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callArgument", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "createInlayInfo"));
        }
        if (methodParam == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodParam", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "createInlayInfo"));
        }
        String paramName = methodParam.getName() + (methodParam.getType() instanceof PsiEllipsisType ? "..." : "");
        InlayInfo inlayInfo = new InlayInfo(paramName, callArgument.getTextRange().getStartOffset());
        if (inlayInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "createInlayInfo"));
        }
        return inlayInfo;
    }

    private static boolean isCommonlyNamedParameterPair(int first, int second, PsiParameter[] parameters) {
        if (first >= parameters.length || second >= parameters.length) {
            return false;
        }
        String firstParamName = parameters[first].getName();
        String secondParamName = parameters[second].getName();
        if (firstParamName == null || secondParamName == null) {
            return false;
        }
        for (Couple<String> knownPair : COMMONLY_USED_PARAMETER_PAIR) {
            if (!StringUtil.containsIgnoreCase(firstParamName, (String)knownPair.first) || !StringUtil.containsIgnoreCase(secondParamName, (String)knownPair.second)) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldInlineParameterName(int paramIndex, @NotNull PsiExpression[] callArguments, @NotNull PsiParameter[] parameters, @NotNull JavaResolveResult resolveResult) {
        if (callArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callArguments", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "shouldInlineParameterName"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "shouldInlineParameterName"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveResult", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "shouldInlineParameterName"));
        }
        PsiExpression argument = callArguments[paramIndex];
        if (argument.getType() == null) {
            return false;
        }
        PsiParameter parameter = parameters[paramIndex];
        PsiType argType = argument.getType();
        PsiType paramType = parameter.getType();
        if (ParameterNameHintsManager.isVarargParam(paramType, argType) && ParameterNameHintsManager.hasLiteralInVarargs(paramIndex, callArguments)) {
            return true;
        }
        if (ParameterNameHintsManager.isLiteralExpression(argument)) {
            PsiType parameterType = resolveResult.getSubstitutor().substitute(paramType);
            return TypeConversionUtil.isAssignable(parameterType, argType);
        }
        return false;
    }

    private static boolean hasProperLength(@Nullable String paramName) {
        JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
        return paramName != null && paramName.length() >= settings.getInlineLiteralParameterMinNameLength();
    }

    private static boolean hasLiteralInVarargs(int index, PsiExpression[] callArguments) {
        for (int i = index; i < callArguments.length; ++i) {
            PsiExpression arg = callArguments[i];
            if (!ParameterNameHintsManager.isLiteralExpression(arg)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVarargParam(@NotNull PsiType param, @NotNull PsiType argument) {
        if (param == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "param", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "isVarargParam"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "isVarargParam"));
        }
        PsiType deepType = param.getDeepComponentType();
        return param instanceof PsiEllipsisType && TypeConversionUtil.isAssignable(deepType, argument);
    }

    private static boolean hasLiteralExpression(@NotNull PsiExpression[] arguments) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/codeInsight/daemon/impl/ParameterNameHintsManager", "hasLiteralExpression"));
        }
        for (PsiExpression argument : arguments) {
            if (!ParameterNameHintsManager.isLiteralExpression(argument)) continue;
            return true;
        }
        return false;
    }
}

