/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolsImpl
implements Tools {
    @NonNls
    static final String ENABLED_BY_DEFAULT_ATTRIBUTE = "enabled_by_default";
    @NonNls
    static final String ENABLED_ATTRIBUTE = "enabled";
    @NonNls
    static final String LEVEL_ATTRIBUTE = "level";
    private final String myShortName;
    private final ScopeToolState myDefaultState;
    private List<ScopeToolState> myTools;
    private boolean myEnabled;

    public ToolsImpl(@NotNull InspectionToolWrapper toolWrapper, @NotNull HighlightDisplayLevel level, boolean enabled, boolean enabledByDefault) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/ToolsImpl", "<init>"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LEVEL_ATTRIBUTE, "com/intellij/codeInspection/ex/ToolsImpl", "<init>"));
        }
        this.myShortName = toolWrapper.getShortName();
        this.myDefaultState = new ScopeToolState(CustomScopesProviderEx.getAllScope(), toolWrapper, enabledByDefault, level);
        this.myTools = null;
        this.myEnabled = enabled;
    }

    public ToolsImpl(@NotNull InspectionToolWrapper toolWrapper, @NotNull HighlightDisplayLevel level, boolean enabled) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/ToolsImpl", "<init>"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LEVEL_ATTRIBUTE, "com/intellij/codeInspection/ex/ToolsImpl", "<init>"));
        }
        this(toolWrapper, level, enabled, enabled);
    }

    @NotNull
    public ScopeToolState addTool(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/ToolsImpl", "addTool"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/ToolsImpl", "addTool"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LEVEL_ATTRIBUTE, "com/intellij/codeInspection/ex/ToolsImpl", "addTool"));
        }
        ScopeToolState scopeToolState = this.insertTool(scope, toolWrapper, enabled, level, this.myTools != null ? this.myTools.size() : 0);
        if (scopeToolState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "addTool"));
        }
        return scopeToolState;
    }

    @NotNull
    public ScopeToolState prependTool(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/ToolsImpl", "prependTool"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/ToolsImpl", "prependTool"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LEVEL_ATTRIBUTE, "com/intellij/codeInspection/ex/ToolsImpl", "prependTool"));
        }
        ScopeToolState scopeToolState = this.insertTool(scope, toolWrapper, enabled, level, 0);
        if (scopeToolState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "prependTool"));
        }
        return scopeToolState;
    }

    public ScopeToolState addTool(@NotNull String scopeName, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/codeInspection/ex/ToolsImpl", "addTool"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/ToolsImpl", "addTool"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LEVEL_ATTRIBUTE, "com/intellij/codeInspection/ex/ToolsImpl", "addTool"));
        }
        return this.insertTool(new ScopeToolState(scopeName, toolWrapper, enabled, level), this.myTools != null ? this.myTools.size() : 0);
    }

    @NotNull
    private ScopeToolState insertTool(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level, int idx) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/ex/ToolsImpl", "insertTool"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/ToolsImpl", "insertTool"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LEVEL_ATTRIBUTE, "com/intellij/codeInspection/ex/ToolsImpl", "insertTool"));
        }
        ScopeToolState scopeToolState = this.insertTool(new ScopeToolState(scope, toolWrapper, enabled, level), idx);
        if (scopeToolState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "insertTool"));
        }
        return scopeToolState;
    }

    @NotNull
    private ScopeToolState insertTool(@NotNull ScopeToolState scopeToolState, int idx) {
        if (scopeToolState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeToolState", "com/intellij/codeInspection/ex/ToolsImpl", "insertTool"));
        }
        if (this.myTools == null) {
            this.myTools = new ArrayList<ScopeToolState>();
            if (scopeToolState.isEnabled()) {
                this.setEnabled(true);
            }
        }
        this.myTools.add(idx, scopeToolState);
        ScopeToolState scopeToolState2 = scopeToolState;
        if (scopeToolState2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "insertTool"));
        }
        return scopeToolState2;
    }

    @Override
    @NotNull
    public InspectionToolWrapper getInspectionTool(@Nullable PsiElement element) {
        if (this.myTools != null) {
            PsiFile containingFile = element == null ? null : element.getContainingFile();
            Project project = containingFile == null ? null : containingFile.getProject();
            for (ScopeToolState state : this.myTools) {
                PackageSet packageSet;
                if (element == null) {
                    InspectionToolWrapper inspectionToolWrapper = state.getTool();
                    if (inspectionToolWrapper == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getInspectionTool"));
                    }
                    return inspectionToolWrapper;
                }
                NamedScope scope = state.getScope(project);
                if (scope == null || (packageSet = scope.getValue()) == null || containingFile == null || !packageSet.contains(containingFile, DependencyValidationManager.getInstance(project))) continue;
                InspectionToolWrapper inspectionToolWrapper = state.getTool();
                if (inspectionToolWrapper == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getInspectionTool"));
                }
                return inspectionToolWrapper;
            }
        }
        InspectionToolWrapper inspectionToolWrapper = this.myDefaultState.getTool();
        if (inspectionToolWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getInspectionTool"));
        }
        return inspectionToolWrapper;
    }

    @Override
    @NotNull
    public String getShortName() {
        String string = this.myShortName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getShortName"));
        }
        return string;
    }

    public void cleanupTools(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/ToolsImpl", "cleanupTools"));
        }
        for (ScopeToolState state : this.getTools()) {
            state.getTool().cleanup(project);
        }
    }

    public void writeExternal(@NotNull Element inspectionElement) {
        if (inspectionElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionElement", "com/intellij/codeInspection/ex/ToolsImpl", "writeExternal"));
        }
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                Element scopeElement = new Element("scope");
                scopeElement.setAttribute("name", state.getScopeName());
                scopeElement.setAttribute(LEVEL_ATTRIBUTE, state.getLevel().getName());
                scopeElement.setAttribute(ENABLED_ATTRIBUTE, Boolean.toString(state.isEnabled()));
                InspectionToolWrapper toolWrapper = state.getTool();
                if (toolWrapper.isInitialized()) {
                    ((InspectionProfileEntry)toolWrapper.getTool()).writeSettings(scopeElement);
                }
                inspectionElement.addContent(scopeElement);
            }
        }
        inspectionElement.setAttribute(ENABLED_ATTRIBUTE, Boolean.toString(this.isEnabled()));
        inspectionElement.setAttribute(LEVEL_ATTRIBUTE, this.getLevel().getName());
        inspectionElement.setAttribute(ENABLED_BY_DEFAULT_ATTRIBUTE, Boolean.toString(this.myDefaultState.isEnabled()));
        InspectionToolWrapper toolWrapper = this.myDefaultState.getTool();
        if (toolWrapper.isInitialized()) {
            ((InspectionProfileEntry)toolWrapper.getTool()).writeSettings(inspectionElement);
        }
    }

    void readExternal(@NotNull Element toolElement, @NotNull InspectionProfile profile, Map<String, List<String>> dependencies) throws InvalidDataException {
        HighlightDisplayLevel level;
        if (toolElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolElement", "com/intellij/codeInspection/ex/ToolsImpl", "readExternal"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/intellij/codeInspection/ex/ToolsImpl", "readExternal"));
        }
        String levelName = toolElement.getAttributeValue(LEVEL_ATTRIBUTE);
        ProfileManager profileManager = profile.getProfileManager();
        SeverityRegistrar registrar = ((SeverityProvider)((Object)profileManager)).getOwnSeverityRegistrar();
        HighlightDisplayLevel highlightDisplayLevel = level = levelName != null ? HighlightDisplayLevel.find(registrar.getSeverity(levelName)) : null;
        if (level == null) {
            level = HighlightDisplayLevel.WARNING;
        }
        this.myDefaultState.setLevel(level);
        String enabled = toolElement.getAttributeValue(ENABLED_ATTRIBUTE);
        boolean isEnabled = enabled != null && Boolean.parseBoolean(enabled);
        String enabledTool = toolElement.getAttributeValue(ENABLED_BY_DEFAULT_ATTRIBUTE);
        this.myDefaultState.setEnabled(enabledTool != null ? Boolean.parseBoolean(enabledTool) : isEnabled);
        InspectionToolWrapper toolWrapper = this.myDefaultState.getTool();
        List scopeElements = toolElement.getChildren("scope");
        ArrayList<String> scopeNames = new ArrayList<String>();
        for (Element scopeElement : scopeElements) {
            HighlightDisplayLevel scopeLevel;
            String scopeName = scopeElement.getAttributeValue("name");
            if (scopeName == null) continue;
            NamedScopesHolder scopesHolder = profileManager.getScopesManager();
            NamedScope namedScope = null;
            if (scopesHolder != null) {
                namedScope = scopesHolder.getScope(scopeName);
            }
            String errorLevel = scopeElement.getAttributeValue(LEVEL_ATTRIBUTE);
            String enabledInScope = scopeElement.getAttributeValue(ENABLED_ATTRIBUTE);
            InspectionToolWrapper copyToolWrapper = toolWrapper.createCopy();
            if (scopeElement.getAttributes().size() > 3 || !scopeElement.getChildren().isEmpty()) {
                ((InspectionProfileEntry)copyToolWrapper.getTool()).readSettings(scopeElement);
            }
            HighlightDisplayLevel highlightDisplayLevel2 = scopeLevel = errorLevel != null ? HighlightDisplayLevel.find(registrar.getSeverity(errorLevel)) : null;
            if (scopeLevel == null) {
                scopeLevel = level;
            }
            if (namedScope != null) {
                this.addTool(namedScope, copyToolWrapper, enabledInScope != null && Boolean.parseBoolean(enabledInScope), scopeLevel);
            } else {
                this.addTool(scopeName, copyToolWrapper, enabledInScope != null && Boolean.parseBoolean(enabledInScope), scopeLevel);
            }
            scopeNames.add(scopeName);
        }
        for (int i = 0; i < scopeNames.size(); ++i) {
            String scopeName = (String)scopeNames.get(i);
            List<String> order = dependencies.get(scopeName);
            if (order == null) {
                order = new ArrayList<String>();
                dependencies.put(scopeName, order);
            }
            for (int j = i + 1; j < scopeNames.size(); ++j) {
                order.add((String)scopeNames.get(j));
            }
        }
        if (toolElement.getAttributes().size() > 4 || toolElement.getChildren().size() > scopeElements.size()) {
            ((InspectionProfileEntry)toolWrapper.getTool()).readSettings(toolElement);
        }
        this.myEnabled = isEnabled;
    }

    @Override
    @NotNull
    public InspectionToolWrapper getTool() {
        if (this.myTools == null) {
            InspectionToolWrapper inspectionToolWrapper = this.myDefaultState.getTool();
            if (inspectionToolWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getTool"));
            }
            return inspectionToolWrapper;
        }
        InspectionToolWrapper inspectionToolWrapper = this.myTools.iterator().next().getTool();
        if (inspectionToolWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getTool"));
        }
        return inspectionToolWrapper;
    }

    @Override
    @NotNull
    public List<ScopeToolState> getTools() {
        if (this.myTools == null) {
            List<ScopeToolState> list = Collections.singletonList(this.myDefaultState);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getTools"));
            }
            return list;
        }
        ArrayList<ScopeToolState> result = new ArrayList<ScopeToolState>(this.myTools);
        result.add(this.myDefaultState);
        ArrayList<ScopeToolState> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getTools"));
        }
        return arrayList;
    }

    @Override
    public void collectTools(@NotNull List<ScopeToolState> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInspection/ex/ToolsImpl", "collectTools"));
        }
        if (this.myTools != null) {
            result.addAll(this.myTools);
        }
        result.add(this.myDefaultState);
    }

    @Override
    @NotNull
    public ScopeToolState getDefaultState() {
        ScopeToolState scopeToolState = this.myDefaultState;
        if (scopeToolState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getDefaultState"));
        }
        return scopeToolState;
    }

    public void setDefaultEnabled(boolean isEnabled) {
        this.getDefaultState().setEnabled(isEnabled);
        if (isEnabled) {
            this.setEnabled(true);
        } else {
            this.disableWholeToolIfCan();
        }
    }

    public void removeScope(@NotNull String scopeName) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeName", "com/intellij/codeInspection/ex/ToolsImpl", "removeScope"));
        }
        if (this.myTools != null) {
            for (ScopeToolState tool : this.myTools) {
                if (!scopeName.equals(tool.getScopeName())) continue;
                this.myTools.remove(tool);
                break;
            }
            this.checkToolsIsEmpty();
        }
    }

    private void checkToolsIsEmpty() {
        if (this.myTools.isEmpty()) {
            this.myTools = null;
            this.setEnabled(this.myDefaultState.isEnabled());
        }
    }

    public void removeAllScopes() {
        this.myTools = null;
    }

    public void setScope(int idx, NamedScope namedScope) {
        if (this.myTools != null && this.myTools.size() > idx && idx >= 0) {
            ScopeToolState scopeToolState = this.myTools.get(idx);
            InspectionToolWrapper toolWrapper = scopeToolState.getTool();
            this.myTools.remove(idx);
            this.myTools.add(idx, new ScopeToolState(namedScope, toolWrapper, scopeToolState.isEnabled(), scopeToolState.getLevel()));
        }
    }

    public boolean isEnabled(NamedScope namedScope, Project project) {
        if (!this.myEnabled) {
            return false;
        }
        if (namedScope != null && this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal(namedScope, state.getScope(project))) continue;
                return state.isEnabled();
            }
        }
        return this.myDefaultState.isEnabled();
    }

    public HighlightDisplayLevel getLevel(PsiElement element) {
        if (this.myTools == null || element == null) {
            return this.myDefaultState.getLevel();
        }
        Project project = element.getProject();
        DependencyValidationManager manager = DependencyValidationManager.getInstance(project);
        for (ScopeToolState state : this.myTools) {
            NamedScope scope = state.getScope(project);
            PackageSet set = scope != null ? scope.getValue() : null;
            if (set == null || !set.contains(element.getContainingFile(), manager)) continue;
            return state.getLevel();
        }
        return this.myDefaultState.getLevel();
    }

    public HighlightDisplayLevel getLevel() {
        return this.myDefaultState.getLevel();
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    @Override
    public boolean isEnabled(PsiElement element) {
        if (!this.myEnabled) {
            return false;
        }
        if (this.myTools == null || element == null) {
            return this.myDefaultState.isEnabled();
        }
        Project project = element.getProject();
        DependencyValidationManager manager = DependencyValidationManager.getInstance(project);
        for (ScopeToolState state : this.myTools) {
            PackageSet set;
            NamedScope scope = state.getScope(project);
            if (scope == null || (set = scope.getValue()) == null || !set.contains(element.getContainingFile(), manager)) continue;
            return state.isEnabled();
        }
        return this.myDefaultState.isEnabled();
    }

    @Override
    @Nullable
    public InspectionToolWrapper getEnabledTool(@Nullable PsiElement element, boolean includeDoNotShow) {
        if (!this.myEnabled) {
            return null;
        }
        if (this.myTools != null && element != null) {
            Project project = element.getProject();
            DependencyValidationManager manager = DependencyValidationManager.getInstance(project);
            for (ScopeToolState state : this.myTools) {
                PackageSet set;
                NamedScope scope = state.getScope(project);
                if (scope == null || (set = scope.getValue()) == null || !set.contains(element.getContainingFile(), manager)) continue;
                return state.isEnabled() && (includeDoNotShow || !HighlightDisplayLevel.DO_NOT_SHOW.equals(state.getLevel())) ? state.getTool() : null;
            }
        }
        return this.myDefaultState.isEnabled() && (includeDoNotShow || !HighlightDisplayLevel.DO_NOT_SHOW.equals(this.myDefaultState.getLevel())) ? this.myDefaultState.getTool() : null;
    }

    @Override
    @Nullable
    public InspectionToolWrapper getEnabledTool(@Nullable PsiElement element) {
        return this.getEnabledTool(element, true);
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void enableTool(NamedScope namedScope, Project project) {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal(state.getScope(project), namedScope)) continue;
                state.setEnabled(true);
            }
        }
        this.setEnabled(true);
    }

    public void disableTool(NamedScope namedScope, Project project) {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal(state.getScope(project), namedScope)) continue;
                state.setEnabled(false);
            }
            this.disableWholeToolIfCan();
        }
    }

    public void disableTool(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/ex/ToolsImpl", "disableTool"));
        }
        Project project = element.getProject();
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance(project);
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                PackageSet packageSet;
                NamedScope scope = state.getScope(project);
                if (scope == null || (packageSet = scope.getValue()) == null) continue;
                PsiFile file = element.getContainingFile();
                if (file != null) {
                    if (!packageSet.contains(file, validationManager)) continue;
                    state.setEnabled(false);
                    return;
                }
                if (!(packageSet instanceof PackageSetBase) || !((PackageSetBase)packageSet).contains(PsiUtilCore.getVirtualFile(element), project, validationManager)) continue;
                state.setEnabled(false);
                return;
            }
            this.myDefaultState.setEnabled(false);
        } else {
            this.myDefaultState.setEnabled(false);
            this.setEnabled(false);
        }
    }

    @NotNull
    public HighlightDisplayLevel getLevel(NamedScope scope, Project project) {
        if (this.myTools != null && scope != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal(state.getScope(project), scope)) continue;
                HighlightDisplayLevel highlightDisplayLevel = state.getLevel();
                if (highlightDisplayLevel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getLevel"));
                }
                return highlightDisplayLevel;
            }
        }
        HighlightDisplayLevel highlightDisplayLevel = this.myDefaultState.getLevel();
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean equals(Object o) {
        ToolsImpl tools = (ToolsImpl)o;
        if (this.myEnabled != tools.myEnabled) {
            return false;
        }
        if (this.getTools().size() != tools.getTools().size()) {
            return false;
        }
        for (int i = 0; i < this.getTools().size(); ++i) {
            ScopeToolState toolState;
            ScopeToolState state = this.getTools().get(i);
            if (state.equalTo(toolState = tools.getTools().get(i))) continue;
            return false;
        }
        return true;
    }

    public void setLevel(@NotNull HighlightDisplayLevel level, @Nullable String scopeName, Project project) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LEVEL_ATTRIBUTE, "com/intellij/codeInspection/ex/ToolsImpl", "setLevel"));
        }
        if (scopeName == null) {
            this.myDefaultState.setLevel(level);
        } else {
            if (this.myTools == null) {
                return;
            }
            ScopeToolState scopeToolState = null;
            int index = -1;
            for (int i = 0; i < this.myTools.size(); ++i) {
                ScopeToolState tool = this.myTools.get(i);
                if (!scopeName.equals(tool.getScopeName())) continue;
                scopeToolState = tool;
                this.myTools.remove(tool);
                index = i;
                break;
            }
            if (index < 0) {
                throw new IllegalStateException("Scope " + scopeName + " not found");
            }
            InspectionToolWrapper toolWrapper = scopeToolState.getTool();
            NamedScope scope = scopeToolState.getScope(project);
            if (scope != null) {
                this.myTools.add(index, new ScopeToolState(scope, toolWrapper, scopeToolState.isEnabled(), level));
            } else {
                this.myTools.add(index, new ScopeToolState(scopeToolState.getScopeName(), toolWrapper, scopeToolState.isEnabled(), level));
            }
        }
    }

    public void setDefaultState(@NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/ex/ToolsImpl", "setDefaultState"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LEVEL_ATTRIBUTE, "com/intellij/codeInspection/ex/ToolsImpl", "setDefaultState"));
        }
        this.myDefaultState.setTool(toolWrapper);
        this.myDefaultState.setLevel(level);
        this.myDefaultState.setEnabled(enabled);
    }

    public void setLevel(@NotNull HighlightDisplayLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", LEVEL_ATTRIBUTE, "com/intellij/codeInspection/ex/ToolsImpl", "setLevel"));
        }
        this.myDefaultState.setLevel(level);
    }

    @Nullable
    public List<ScopeToolState> getNonDefaultTools() {
        return this.myTools;
    }

    private void disableWholeToolIfCan() {
        if (this.myDefaultState.isEnabled()) {
            return;
        }
        if (this.myTools != null) {
            for (ScopeToolState tool : this.myTools) {
                if (!tool.isEnabled()) continue;
                return;
            }
        }
        this.setEnabled(false);
    }
}

