/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaFileImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefPackageImpl;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefParameterImpl;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import javax.swing.JButton;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefJavaManagerImpl
extends RefJavaManager {
    private static final Logger LOG = Logger.getInstance("#" + RefJavaManagerImpl.class.getName());
    private PsiMethod myAppMainPattern;
    private PsiMethod myAppPremainPattern;
    private PsiMethod myAppAgentmainPattern;
    private PsiClass myApplet;
    private PsiClass myServlet;
    private RefPackage myDefaultPackage;
    private THashMap<String, RefPackage> myPackages;
    private final RefManagerImpl myRefManager;
    private PsiElementVisitor myProjectIterator;
    private EntryPointsManager myEntryPointsManager;

    public RefJavaManagerImpl(@NotNull RefManagerImpl manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/reference/RefJavaManagerImpl", "<init>"));
        }
        this.myRefManager = manager;
        Project project = manager.getProject();
        PsiManager psiManager = PsiManager.getInstance(project);
        PsiElementFactory factory = JavaPsiFacade.getInstance(psiManager.getProject()).getElementFactory();
        try {
            this.myAppMainPattern = factory.createMethodFromText("void main(String[] args);", null);
            this.myAppPremainPattern = factory.createMethodFromText("void premain(String[] args, java.lang.instrument.Instrumentation i);", null);
            this.myAppAgentmainPattern = factory.createMethodFromText("void agentmain(String[] args, java.lang.instrument.Instrumentation i);", null);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        this.myApplet = JavaPsiFacade.getInstance(psiManager.getProject()).findClass("java.applet.Applet", GlobalSearchScope.allScope(project));
        this.myServlet = JavaPsiFacade.getInstance(psiManager.getProject()).findClass("javax.servlet.Servlet", GlobalSearchScope.allScope(project));
    }

    @Override
    public RefImplicitConstructor getImplicitConstructor(String classFQName) {
        RefEntity entity = this.getReference("class", classFQName);
        if (entity == null) {
            return null;
        }
        RefClass refClass = (RefClass)entity;
        return (RefImplicitConstructor)refClass.getDefaultConstructor();
    }

    @Override
    public RefPackage getPackage(String packageName) {
        RefPackage refPackage;
        if (this.myPackages == null) {
            this.myPackages = new THashMap();
        }
        if ((refPackage = (RefPackage)this.myPackages.get((Object)packageName)) == null) {
            refPackage = new RefPackageImpl(packageName, this.myRefManager);
            this.myPackages.put((Object)packageName, (Object)refPackage);
            int dotIndex = packageName.lastIndexOf(46);
            if (dotIndex >= 0) {
                ((RefPackageImpl)this.getPackage(packageName.substring(0, dotIndex))).add(refPackage);
            } else {
                ((RefProjectImpl)this.myRefManager.getRefProject()).add(refPackage);
            }
        }
        return refPackage;
    }

    public boolean isEntryPoint(RefElement element) {
        UnusedDeclarationInspectionBase tool = this.getDeadCodeTool(element);
        return tool != null && tool.isEntryPoint(element) && RefJavaManagerImpl.isTestSource(tool, element);
    }

    private static boolean isTestSource(UnusedDeclarationInspectionBase tool, RefElement refElement) {
        if (tool.isTestEntryPoints()) {
            return true;
        }
        PsiElement element = refElement.getElement();
        VirtualFile file = PsiUtilCore.getVirtualFile(element);
        if (file != null) {
            return !ProjectRootManager.getInstance(element.getProject()).getFileIndex().isInTestSourceContent(file);
        }
        return false;
    }

    @Nullable
    private UnusedDeclarationInspectionBase getDeadCodeTool(RefElement element) {
        PsiFile file = ((RefElementImpl)element).getContainingFile();
        if (file == null) {
            return null;
        }
        return this.getDeadCodeTool(file.getContainingFile());
    }

    private UnusedDeclarationInspectionBase getDeadCodeTool(PsiFile file) {
        Tools tools = ((GlobalInspectionContextBase)this.myRefManager.getContext()).getTools().get("unused");
        InspectionToolWrapper toolWrapper = tools == null ? null : tools.getEnabledTool(file);
        Object tool = toolWrapper == null ? null : toolWrapper.getTool();
        return tool instanceof UnusedDeclarationInspectionBase ? (UnusedDeclarationInspectionBase)tool : null;
    }

    @Override
    public RefPackage getDefaultPackage() {
        if (this.myDefaultPackage == null) {
            this.myDefaultPackage = this.getPackage(InspectionsBundle.message("inspection.reference.default.package", new Object[0]));
        }
        return this.myDefaultPackage;
    }

    @Override
    public PsiMethod getAppMainPattern() {
        return this.myAppMainPattern;
    }

    @Override
    public PsiMethod getAppPremainPattern() {
        return this.myAppPremainPattern;
    }

    @Override
    public PsiMethod getAppAgentmainPattern() {
        return this.myAppAgentmainPattern;
    }

    @Override
    public PsiClass getApplet() {
        return this.myApplet;
    }

    @Override
    public PsiClass getServlet() {
        return this.myServlet;
    }

    @Override
    public RefParameter getParameterReference(PsiParameter param, int index) {
        LOG.assertTrue(this.myRefManager.isValidPointForReference(), "References may become invalid after process is finished");
        return this.myRefManager.getFromRefTableOrCache(param, () -> {
            RefParameterImpl ref = new RefParameterImpl(param, index, (RefManager)this.myRefManager);
            ref.initialize();
            return ref;
        });
    }

    @Override
    public void iterate(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/reference/RefJavaManagerImpl", "iterate"));
        }
        if (this.myPackages != null) {
            for (RefPackage refPackage : this.myPackages.values()) {
                refPackage.accept(visitor);
            }
        }
        for (RefElement refElement : this.myRefManager.getSortedElements()) {
            RefClass refClass;
            RefMethod refDefaultConstructor;
            if (!(refElement instanceof RefClass) || !((refDefaultConstructor = (refClass = (RefClass)refElement).getDefaultConstructor()) instanceof RefImplicitConstructor)) continue;
            refClass.getDefaultConstructor().accept(visitor);
        }
    }

    @Override
    public void cleanup() {
        if (this.myEntryPointsManager != null) {
            Disposer.dispose(this.myEntryPointsManager);
            this.myEntryPointsManager = null;
        }
        this.myPackages = null;
        this.myApplet = null;
        this.myAppMainPattern = null;
        this.myAppPremainPattern = null;
        this.myAppAgentmainPattern = null;
        this.myServlet = null;
        this.myDefaultPackage = null;
        this.myProjectIterator = null;
    }

    @Override
    public void removeReference(@NotNull RefElement refElement) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "com/intellij/codeInspection/reference/RefJavaManagerImpl", "removeReference"));
        }
        if (refElement instanceof RefMethod) {
            RefParameter[] params;
            RefMethod refMethod = (RefMethod)refElement;
            for (RefParameter param : params = refMethod.getParameters()) {
                this.myRefManager.removeReference(param);
            }
        }
    }

    @Override
    @Nullable
    public RefElement createRefElement(PsiElement elem) {
        if (elem instanceof PsiClass) {
            return new RefClassImpl((PsiClass)elem, (RefManager)this.myRefManager);
        }
        if (elem instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)elem;
            RefElement ref = this.myRefManager.getReference(method.getContainingClass(), true);
            if (ref instanceof RefClass) {
                return new RefMethodImpl((RefClass)ref, method, (RefManager)this.myRefManager);
            }
        } else if (elem instanceof PsiField) {
            PsiField field = (PsiField)elem;
            RefElement ref = this.myRefManager.getReference(field.getContainingClass(), true);
            if (ref instanceof RefClass) {
                return new RefFieldImpl((RefClass)ref, field, (RefManager)this.myRefManager);
            }
        } else if (elem instanceof PsiJavaFile) {
            return new RefJavaFileImpl((PsiJavaFile)elem, (RefManager)this.myRefManager);
        }
        return null;
    }

    @Override
    @Nullable
    public RefEntity getReference(String type, String fqName) {
        if ("implicit.constructor".equals(type)) {
            return this.getImplicitConstructor(fqName);
        }
        if ("method".equals(type)) {
            return RefMethodImpl.methodFromExternalName(this.myRefManager, fqName);
        }
        if ("class".equals(type)) {
            return RefClassImpl.classFromExternalName(this.myRefManager, fqName);
        }
        if ("field".equals(type)) {
            return RefFieldImpl.fieldFromExternalName(this.myRefManager, fqName);
        }
        if ("parameter".equals(type)) {
            return RefParameterImpl.parameterFromExternalName(this.myRefManager, fqName);
        }
        if ("package".equals(type)) {
            return RefPackageImpl.packageFromFQName(this.myRefManager, fqName);
        }
        return null;
    }

    @Override
    @Nullable
    public String getType(RefEntity ref) {
        if (ref instanceof RefImplicitConstructor) {
            return "implicit.constructor";
        }
        if (ref instanceof RefMethod) {
            return "method";
        }
        if (ref instanceof RefClass) {
            return "class";
        }
        if (ref instanceof RefField) {
            return "field";
        }
        if (ref instanceof RefParameter) {
            return "parameter";
        }
        if (ref instanceof RefPackage) {
            return "package";
        }
        return null;
    }

    @Override
    @NotNull
    public RefEntity getRefinedElement(@NotNull RefEntity ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInspection/reference/RefJavaManagerImpl", "getRefinedElement"));
        }
        if (ref instanceof RefImplicitConstructor) {
            RefClass refClass = ((RefImplicitConstructor)ref).getOwnerClass();
            if (refClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefJavaManagerImpl", "getRefinedElement"));
            }
            return refClass;
        }
        RefEntity refEntity = ref;
        if (refEntity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefJavaManagerImpl", "getRefinedElement"));
        }
        return refEntity;
    }

    @Override
    public void visitElement(PsiElement element) {
        if (this.myProjectIterator == null) {
            this.myProjectIterator = new MyJavaElementVisitor();
        }
        element.accept(this.myProjectIterator);
    }

    @Override
    @Nullable
    public String getGroupName(RefEntity entity) {
        if (entity instanceof RefFile && !(entity instanceof RefJavaFileImpl)) {
            return null;
        }
        return RefJavaUtil.getInstance().getPackageName(entity);
    }

    @Override
    public boolean belongsToScope(PsiElement psiElement) {
        return !(psiElement instanceof PsiTypeParameter);
    }

    @Override
    public void export(@NotNull RefEntity refEntity, @NotNull Element element) {
        PsiFile psiFile;
        SmartPsiElementPointer pointer;
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/reference/RefJavaManagerImpl", "export"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInspection/reference/RefJavaManagerImpl", "export"));
        }
        if (refEntity instanceof RefElement && (pointer = ((RefElement)refEntity).getPointer()) != null && (psiFile = pointer.getContainingFile()) instanceof PsiJavaFile) {
            RefJavaManagerImpl.appendPackageElement(element, ((PsiJavaFile)psiFile).getPackageName());
        }
    }

    @Override
    public void onEntityInitialized(RefElement refElement, PsiElement psiElement) {
        if (this.myRefManager.isOfflineView()) {
            return;
        }
        if (this.isEntryPoint(refElement)) {
            this.getEntryPointsManager().addEntryPoint(refElement, false);
        }
    }

    private static void appendPackageElement(Element element, String packageName) {
        Element packageElement = new Element("package");
        packageElement.addContent(packageName.isEmpty() ? InspectionsBundle.message("inspection.export.results.default", new Object[0]) : packageName);
        element.addContent(packageElement);
    }

    @Override
    public EntryPointsManager getEntryPointsManager() {
        if (this.myEntryPointsManager == null) {
            Project project = this.myRefManager.getProject();
            this.myEntryPointsManager = new EntryPointsManagerBase(project){

                @Override
                public void configureAnnotations() {
                }

                @Override
                public JButton createConfigureAnnotationsBtn() {
                    return null;
                }
            };
            Disposer.register(project, this.myEntryPointsManager);
            ((EntryPointsManagerBase)this.myEntryPointsManager).addAllPersistentEntries(EntryPointsManagerBase.getInstance(project));
        }
        return this.myEntryPointsManager;
    }

    private class MyJavaElementVisitor
    extends JavaElementVisitor {
        private final RefJavaUtil myRefUtil = RefJavaUtil.getInstance();

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitElement(expression);
        }

        @Override
        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        }

        @Override
        public void visitReferenceParameterList(PsiReferenceParameterList list) {
            PsiType[] typeArguments;
            PsiTypeParameterListOwner owner;
            super.visitReferenceParameterList(list);
            PsiMember member = PsiTreeUtil.getParentOfType((PsiElement)list, PsiMember.class);
            if (member instanceof PsiTypeParameter && (owner = ((PsiTypeParameter)member).getOwner()) != null) {
                for (PsiType psiType : ((PsiTypeParameter)member).getExtendsListTypes()) {
                    this.myRefUtil.addTypeReference(owner, psiType, RefJavaManagerImpl.this.myRefManager);
                }
            }
            for (PsiType psiType : typeArguments = list.getTypeArguments()) {
                this.myRefUtil.addTypeReference(member, psiType, RefJavaManagerImpl.this.myRefManager);
            }
        }

        @Override
        public void visitClass(PsiClass aClass) {
            if (!(aClass instanceof PsiTypeParameter)) {
                super.visitClass(aClass);
                RefElement refClass = RefJavaManagerImpl.this.myRefManager.getReference(aClass);
                if (refClass != null) {
                    ((RefClassImpl)refClass).buildReferences();
                }
            }
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference(method);
            if (refElement instanceof RefMethodImpl) {
                ((RefMethodImpl)refElement).buildReferences();
            }
        }

        @Override
        public void visitField(PsiField field) {
            super.visitField(field);
            RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference(field);
            if (refElement instanceof RefFieldImpl) {
                ((RefFieldImpl)refElement).buildReferences();
            }
        }

        @Override
        public void visitDocComment(PsiDocComment comment) {
            PsiDocTag[] tags;
            super.visitDocComment(comment);
            for (PsiDocTag tag : tags = comment.getTags()) {
                RefElementImpl element;
                PsiModifierListOwner listOwner;
                PsiElement[] dataElements;
                if (!Comparing.strEqual(tag.getName(), "noinspection") || (dataElements = tag.getDataElements()) == null || dataElements.length <= 0 || (listOwner = PsiTreeUtil.getParentOfType((PsiElement)comment, PsiModifierListOwner.class)) == null || (element = (RefElementImpl)RefJavaManagerImpl.this.myRefManager.getReference(listOwner)) == null) continue;
                String suppression = "";
                for (PsiElement dataElement : dataElements) {
                    suppression = suppression + "," + dataElement.getText();
                }
                element.addSuppression(suppression);
            }
        }

        @Override
        public void visitAnnotation(PsiAnnotation annotation) {
            RefElementImpl element;
            PsiModifierListOwner listOwner;
            super.visitAnnotation(annotation);
            if (Comparing.strEqual(annotation.getQualifiedName(), "java.lang.SuppressWarnings") && (listOwner = PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class)) != null && (element = (RefElementImpl)RefJavaManagerImpl.this.myRefManager.getReference(listOwner)) != null) {
                PsiNameValuePair[] nameValuePairs;
                StringBuilder buf = new StringBuilder();
                for (PsiNameValuePair nameValuePair : nameValuePairs = annotation.getParameterList().getAttributes()) {
                    buf.append(",").append(nameValuePair.getText().replaceAll("[{}\"\"]", ""));
                }
                if (buf.length() > 0) {
                    element.addSuppression(buf.substring(1));
                }
            }
        }

        @Override
        public void visitVariable(PsiVariable variable) {
            RefElement reference;
            super.visitVariable(variable);
            this.myRefUtil.addTypeReference(variable, variable.getType(), RefJavaManagerImpl.this.myRefManager);
            if (variable instanceof PsiParameter && (reference = RefJavaManagerImpl.this.myRefManager.getReference(variable)) instanceof RefParameterImpl) {
                ((RefParameterImpl)reference).buildReferences();
            }
        }

        @Override
        public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
            super.visitInstanceOfExpression(expression);
            PsiTypeElement typeElement = expression.getCheckType();
            if (typeElement != null) {
                this.myRefUtil.addTypeReference(expression, typeElement.getType(), RefJavaManagerImpl.this.myRefManager);
            }
        }

        @Override
        public void visitThisExpression(PsiThisExpression expression) {
            super.visitThisExpression(expression);
            PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
            if (qualifier != null) {
                RefClassImpl refClass;
                this.myRefUtil.addTypeReference(expression, expression.getType(), RefJavaManagerImpl.this.myRefManager);
                RefClass ownerClass = this.myRefUtil.getOwnerClass(RefJavaManagerImpl.this.myRefManager, expression);
                if (ownerClass != null && (refClass = (RefClassImpl)RefJavaManagerImpl.this.myRefManager.getReference(qualifier.resolve())) != null) {
                    refClass.addInstanceReference(ownerClass);
                }
            }
        }
    }
}

