/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.CompositeDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.InheritedJdkOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleExtension;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ClonableContentEntry;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.InheritedJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.LibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleJdkOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleLibraryTable;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.ModuleSourceOrderEntryImpl;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.RootModelBase;
import com.intellij.openapi.roots.impl.RootModelComponentBase;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootModelImpl
extends RootModelBase
implements ModifiableRootModel {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.RootModelImpl");
    private final Set<ContentEntry> myContent;
    private final List<OrderEntry> myOrderEntries;
    @Nullable
    private OrderEntry[] myCachedOrderEntries;
    @NotNull
    private final ModuleLibraryTable myModuleLibraryTable;
    final ModuleRootManagerImpl myModuleRootManager;
    private boolean myWritable;
    private final VirtualFilePointerManager myFilePointerManager;
    private boolean myDisposed;
    private final Set<ModuleExtension> myExtensions;
    private final RootConfigurationAccessor myConfigurationAccessor;
    private final ProjectRootManagerImpl myProjectRootManager;
    private final CompositeDisposable myDisposable;

    RootModelImpl(@NotNull ModuleRootManagerImpl moduleRootManager, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager) {
        if (moduleRootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRootManager", "com/intellij/openapi/roots/impl/RootModelImpl", "<init>"));
        }
        this.myContent = new TreeSet<ContentEntry>(ContentComparator.INSTANCE);
        this.myOrderEntries = new Order();
        this.myDisposed = false;
        this.myExtensions = new TreeSet<ModuleExtension>();
        this.myDisposable = new CompositeDisposable();
        this.myModuleRootManager = moduleRootManager;
        this.myProjectRootManager = projectRootManager;
        this.myFilePointerManager = filePointerManager;
        this.myWritable = false;
        this.addSourceOrderEntries();
        this.myModuleLibraryTable = new ModuleLibraryTable(this, this.myProjectRootManager);
        for (ModuleExtension extension : Extensions.getExtensions(ModuleExtension.EP_NAME, (AreaInstance)moduleRootManager.getModule())) {
            ModuleExtension model = extension.getModifiableModel(false);
            this.registerOnDispose(model);
            this.myExtensions.add(model);
        }
        this.myConfigurationAccessor = new RootConfigurationAccessor();
    }

    private void addSourceOrderEntries() {
        this.myOrderEntries.add(new ModuleSourceOrderEntryImpl(this));
    }

    RootModelImpl(@NotNull Element element, @NotNull ModuleRootManagerImpl moduleRootManager, ProjectRootManagerImpl projectRootManager, VirtualFilePointerManager filePointerManager, boolean writable) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/impl/RootModelImpl", "<init>"));
        }
        if (moduleRootManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleRootManager", "com/intellij/openapi/roots/impl/RootModelImpl", "<init>"));
        }
        this.myContent = new TreeSet<ContentEntry>(ContentComparator.INSTANCE);
        this.myOrderEntries = new Order();
        this.myDisposed = false;
        this.myExtensions = new TreeSet<ModuleExtension>();
        this.myDisposable = new CompositeDisposable();
        this.myProjectRootManager = projectRootManager;
        this.myFilePointerManager = filePointerManager;
        this.myModuleRootManager = moduleRootManager;
        this.myModuleLibraryTable = new ModuleLibraryTable(this, this.myProjectRootManager);
        for (Object child : element.getChildren("content")) {
            this.myContent.add(new ContentEntryImpl((Element)child, this));
        }
        boolean moduleSourceAdded = false;
        for (Element child : element.getChildren("orderEntry")) {
            OrderEntry orderEntry = OrderEntryFactory.createOrderEntryByElement(child, this, this.myProjectRootManager);
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                if (moduleSourceAdded) continue;
                moduleSourceAdded = true;
            }
            this.myOrderEntries.add(orderEntry);
        }
        if (!moduleSourceAdded) {
            this.myOrderEntries.add(new ModuleSourceOrderEntryImpl(this));
        }
        this.myWritable = writable;
        RootModelImpl originalRootModel = moduleRootManager.getRootModel();
        for (ModuleExtension extension : originalRootModel.myExtensions) {
            ModuleExtension model = extension.getModifiableModel(false);
            model.readExternal(element);
            this.registerOnDispose(model);
            this.myExtensions.add(model);
        }
        this.myConfigurationAccessor = new RootConfigurationAccessor();
    }

    @Override
    public boolean isWritable() {
        return this.myWritable;
    }

    public RootConfigurationAccessor getConfigurationAccessor() {
        return this.myConfigurationAccessor;
    }

    RootModelImpl(@NotNull RootModelImpl rootModel, ModuleRootManagerImpl moduleRootManager, boolean writable, RootConfigurationAccessor rootConfigurationAccessor, @NotNull VirtualFilePointerManager filePointerManager, ProjectRootManagerImpl projectRootManager) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/RootModelImpl", "<init>"));
        }
        if (filePointerManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePointerManager", "com/intellij/openapi/roots/impl/RootModelImpl", "<init>"));
        }
        this.myContent = new TreeSet<ContentEntry>(ContentComparator.INSTANCE);
        this.myOrderEntries = new Order();
        this.myDisposed = false;
        this.myExtensions = new TreeSet<ModuleExtension>();
        this.myDisposable = new CompositeDisposable();
        this.myFilePointerManager = filePointerManager;
        this.myModuleRootManager = moduleRootManager;
        this.myProjectRootManager = projectRootManager;
        this.myModuleLibraryTable = new ModuleLibraryTable(this, this.myProjectRootManager);
        this.myWritable = writable;
        this.myConfigurationAccessor = rootConfigurationAccessor;
        Set<ContentEntry> thatContent = rootModel.myContent;
        for (ContentEntry contentEntry : thatContent) {
            if (!(contentEntry instanceof ClonableContentEntry)) continue;
            ContentEntry cloned = ((ClonableContentEntry)((Object)contentEntry)).cloneEntry(this);
            this.myContent.add(cloned);
        }
        this.setOrderEntriesFrom(rootModel);
        for (ModuleExtension extension : rootModel.myExtensions) {
            ModuleExtension model = extension.getModifiableModel(writable);
            this.registerOnDispose(model);
            this.myExtensions.add(model);
        }
    }

    private void setOrderEntriesFrom(@NotNull RootModelImpl rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "com/intellij/openapi/roots/impl/RootModelImpl", "setOrderEntriesFrom"));
        }
        this.removeAllOrderEntries();
        for (OrderEntry orderEntry : rootModel.myOrderEntries) {
            if (!(orderEntry instanceof ClonableOrderEntry)) continue;
            this.myOrderEntries.add(((ClonableOrderEntry)((Object)orderEntry)).cloneEntry(this, this.myProjectRootManager, this.myFilePointerManager));
        }
    }

    private void removeAllOrderEntries() {
        for (OrderEntry entry : this.myOrderEntries) {
            Disposer.dispose((OrderEntryBaseImpl)entry);
        }
        this.myOrderEntries.clear();
    }

    @Override
    @NotNull
    public OrderEntry[] getOrderEntries() {
        OrderEntry[] cachedOrderEntries = this.myCachedOrderEntries;
        if (cachedOrderEntries == null) {
            cachedOrderEntries = this.myOrderEntries.toArray(new OrderEntry[this.myOrderEntries.size()]);
            this.myCachedOrderEntries = cachedOrderEntries;
        }
        if (cachedOrderEntries == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelImpl", "getOrderEntries"));
        }
        return cachedOrderEntries;
    }

    Iterator<OrderEntry> getOrderIterator() {
        return Collections.unmodifiableList(this.myOrderEntries).iterator();
    }

    @Override
    public void removeContentEntry(@NotNull ContentEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/roots/impl/RootModelImpl", "removeContentEntry"));
        }
        this.assertWritable();
        LOG.assertTrue(this.myContent.contains(entry));
        if (entry instanceof RootModelComponentBase) {
            Disposer.dispose((RootModelComponentBase)((Object)entry));
            RootModelImpl entryModel = ((RootModelComponentBase)((Object)entry)).getRootModel();
            LOG.assertTrue(entryModel == this, "Removing from " + this + " content entry obtained from " + entryModel);
        }
        this.myContent.remove(entry);
    }

    @Override
    public void addOrderEntry(@NotNull OrderEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/roots/impl/RootModelImpl", "addOrderEntry"));
        }
        this.assertWritable();
        LOG.assertTrue(!this.myOrderEntries.contains(entry));
        this.myOrderEntries.add(entry);
    }

    @Override
    @NotNull
    public LibraryOrderEntry addLibraryEntry(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/RootModelImpl", "addLibraryEntry"));
        }
        this.assertWritable();
        LibraryOrderEntryImpl libraryOrderEntry = new LibraryOrderEntryImpl(library, this, this.myProjectRootManager);
        if (!libraryOrderEntry.isValid()) {
            LibraryEx libraryEx = ObjectUtils.tryCast(library, LibraryEx.class);
            boolean libraryDisposed = libraryEx != null ? libraryEx.isDisposed() : Disposer.isDisposed(library);
            throw new AssertionError((Object)("Invalid libraryOrderEntry, library: " + library + " of type " + library.getClass() + ", disposed: " + libraryDisposed + ", kind: " + (libraryEx != null ? libraryEx.getKind() : "<undefined>")));
        }
        this.myOrderEntries.add(libraryOrderEntry);
        LibraryOrderEntryImpl libraryOrderEntryImpl = libraryOrderEntry;
        if (libraryOrderEntryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelImpl", "addLibraryEntry"));
        }
        return libraryOrderEntryImpl;
    }

    @Override
    @NotNull
    public LibraryOrderEntry addInvalidLibrary(@NotNull String name, @NotNull String level) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/roots/impl/RootModelImpl", "addInvalidLibrary"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/roots/impl/RootModelImpl", "addInvalidLibrary"));
        }
        this.assertWritable();
        LibraryOrderEntryImpl libraryOrderEntry = new LibraryOrderEntryImpl(name, level, this, this.myProjectRootManager);
        this.myOrderEntries.add(libraryOrderEntry);
        LibraryOrderEntryImpl libraryOrderEntryImpl = libraryOrderEntry;
        if (libraryOrderEntryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelImpl", "addInvalidLibrary"));
        }
        return libraryOrderEntryImpl;
    }

    @Override
    @NotNull
    public ModuleOrderEntry addModuleOrderEntry(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/impl/RootModelImpl", "addModuleOrderEntry"));
        }
        this.assertWritable();
        LOG.assertTrue(!module.equals(this.getModule()));
        LOG.assertTrue(Comparing.equal(this.myModuleRootManager.getModule().getProject(), module.getProject()));
        ModuleOrderEntryImpl moduleOrderEntry = new ModuleOrderEntryImpl(module, this);
        this.myOrderEntries.add(moduleOrderEntry);
        ModuleOrderEntryImpl moduleOrderEntryImpl = moduleOrderEntry;
        if (moduleOrderEntryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelImpl", "addModuleOrderEntry"));
        }
        return moduleOrderEntryImpl;
    }

    @Override
    @NotNull
    public ModuleOrderEntry addInvalidModuleEntry(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/roots/impl/RootModelImpl", "addInvalidModuleEntry"));
        }
        this.assertWritable();
        LOG.assertTrue(!name.equals(this.getModule().getName()));
        ModuleOrderEntryImpl moduleOrderEntry = new ModuleOrderEntryImpl(name, this);
        this.myOrderEntries.add(moduleOrderEntry);
        ModuleOrderEntryImpl moduleOrderEntryImpl = moduleOrderEntry;
        if (moduleOrderEntryImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelImpl", "addInvalidModuleEntry"));
        }
        return moduleOrderEntryImpl;
    }

    @Override
    @Nullable
    public LibraryOrderEntry findLibraryOrderEntry(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/impl/RootModelImpl", "findLibraryOrderEntry"));
        }
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry) || !library.equals(((LibraryOrderEntry)orderEntry).getLibrary())) continue;
            return (LibraryOrderEntry)orderEntry;
        }
        return null;
    }

    @Override
    public void removeOrderEntry(@NotNull OrderEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/roots/impl/RootModelImpl", "removeOrderEntry"));
        }
        this.assertWritable();
        this.removeOrderEntryInternal(entry);
    }

    private void removeOrderEntryInternal(OrderEntry entry) {
        LOG.assertTrue(this.myOrderEntries.contains(entry));
        Disposer.dispose((OrderEntryBaseImpl)entry);
        this.myOrderEntries.remove(entry);
    }

    @Override
    public void rearrangeOrderEntries(@NotNull OrderEntry[] newEntries) {
        if (newEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newEntries", "com/intellij/openapi/roots/impl/RootModelImpl", "rearrangeOrderEntries"));
        }
        this.assertWritable();
        this.assertValidRearrangement(newEntries);
        this.myOrderEntries.clear();
        ContainerUtil.addAll(this.myOrderEntries, newEntries);
    }

    private void assertValidRearrangement(@NotNull OrderEntry[] newEntries) {
        if (newEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newEntries", "com/intellij/openapi/roots/impl/RootModelImpl", "assertValidRearrangement"));
        }
        String error = this.checkValidRearrangement(newEntries);
        LOG.assertTrue(error == null, error);
    }

    @Nullable
    private String checkValidRearrangement(@NotNull OrderEntry[] newEntries) {
        if (newEntries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newEntries", "com/intellij/openapi/roots/impl/RootModelImpl", "checkValidRearrangement"));
        }
        if (newEntries.length != this.myOrderEntries.size()) {
            return "Size mismatch: old size=" + this.myOrderEntries.size() + "; new size=" + newEntries.length;
        }
        HashSet<OrderEntry> set = new HashSet<OrderEntry>();
        for (OrderEntry newEntry : newEntries) {
            if (!this.myOrderEntries.contains(newEntry)) {
                return "Trying to add nonexisting order entry " + newEntry;
            }
            if (set.contains(newEntry)) {
                return "Trying to add duplicate order entry " + newEntry;
            }
            set.add(newEntry);
        }
        return null;
    }

    @Override
    public void clear() {
        Sdk jdk = this.getSdk();
        this.removeAllContentEntries();
        this.removeAllOrderEntries();
        this.setSdk(jdk);
        this.addSourceOrderEntries();
    }

    private void removeAllContentEntries() {
        for (ContentEntry entry : this.myContent) {
            if (!(entry instanceof RootModelComponentBase)) continue;
            Disposer.dispose((RootModelComponentBase)((Object)entry));
        }
        this.myContent.clear();
    }

    @Override
    public void commit() {
        this.myModuleRootManager.commitModel(this);
        this.myWritable = false;
    }

    public void docommit() {
        assert (this.isWritable());
        if (this.areOrderEntriesChanged()) {
            this.getSourceModel().setOrderEntriesFrom(this);
        }
        for (ModuleExtension extension : this.myExtensions) {
            if (!extension.isChanged()) continue;
            extension.commit();
        }
        if (this.areContentEntriesChanged()) {
            this.getSourceModel().removeAllContentEntries();
            for (ContentEntry contentEntry : this.myContent) {
                ContentEntry cloned = ((ClonableContentEntry)((Object)contentEntry)).cloneEntry(this.getSourceModel());
                this.getSourceModel().myContent.add(cloned);
            }
        }
    }

    @Override
    @NotNull
    public LibraryTable getModuleLibraryTable() {
        ModuleLibraryTable moduleLibraryTable = this.myModuleLibraryTable;
        if (moduleLibraryTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelImpl", "getModuleLibraryTable"));
        }
        return moduleLibraryTable;
    }

    @Override
    public Project getProject() {
        return this.myProjectRootManager.getProject();
    }

    @Override
    @NotNull
    public ContentEntry addContentEntry(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/RootModelImpl", "addContentEntry"));
        }
        ContentEntry contentEntry = this.addContentEntry(new ContentEntryImpl(file, this));
        if (contentEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelImpl", "addContentEntry"));
        }
        return contentEntry;
    }

    @Override
    @NotNull
    public ContentEntry addContentEntry(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/impl/RootModelImpl", "addContentEntry"));
        }
        ContentEntry contentEntry = this.addContentEntry(new ContentEntryImpl(url, this));
        if (contentEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelImpl", "addContentEntry"));
        }
        return contentEntry;
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    @NotNull
    private ContentEntry addContentEntry(@NotNull ContentEntry e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/impl/RootModelImpl", "addContentEntry"));
        }
        if (this.myContent.contains(e)) {
            for (ContentEntry contentEntry : this.getContentEntries()) {
                if (ContentComparator.INSTANCE.compare(contentEntry, e) != 0) continue;
                ContentEntry contentEntry2 = contentEntry;
                if (contentEntry2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelImpl", "addContentEntry"));
                }
                return contentEntry2;
            }
        }
        this.myContent.add(e);
        ContentEntry contentEntry = e;
        if (contentEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelImpl", "addContentEntry"));
        }
        return contentEntry;
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/impl/RootModelImpl", "writeExternal"));
        }
        for (ModuleExtension extension : this.myExtensions) {
            extension.writeExternal(element);
        }
        for (ContentEntry contentEntry : this.getContent()) {
            if (!(contentEntry instanceof ContentEntryImpl)) continue;
            Element subElement = new Element("content");
            ((ContentEntryImpl)contentEntry).writeExternal(subElement);
            element.addContent(subElement);
        }
        for (Iterator<ModuleExtension<Object>> iterator : this.getOrderEntries()) {
            if (!(iterator instanceof WritableOrderEntry)) continue;
            ((WritableOrderEntry)((Object)iterator)).writeExternal(element);
        }
    }

    @Override
    public void setSdk(@Nullable Sdk jdk) {
        this.assertWritable();
        ModuleJdkOrderEntryImpl jdkLibraryEntry = jdk != null ? new ModuleJdkOrderEntryImpl(jdk, this, this.myProjectRootManager) : null;
        this.replaceEntryOfType(JdkOrderEntry.class, jdkLibraryEntry);
    }

    @Override
    public void setInvalidSdk(@NotNull String jdkName, String jdkType) {
        if (jdkName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jdkName", "com/intellij/openapi/roots/impl/RootModelImpl", "setInvalidSdk"));
        }
        this.assertWritable();
        this.replaceEntryOfType(JdkOrderEntry.class, new ModuleJdkOrderEntryImpl(jdkName, jdkType, this, this.myProjectRootManager));
    }

    @Override
    public void inheritSdk() {
        this.assertWritable();
        this.replaceEntryOfType(JdkOrderEntry.class, new InheritedJdkOrderEntryImpl(this, this.myProjectRootManager));
    }

    @Override
    public <T extends OrderEntry> void replaceEntryOfType(@NotNull Class<T> entryClass, @Nullable T entry) {
        if (entryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryClass", "com/intellij/openapi/roots/impl/RootModelImpl", "replaceEntryOfType"));
        }
        this.assertWritable();
        for (int i = 0; i < this.myOrderEntries.size(); ++i) {
            OrderEntry orderEntry = this.myOrderEntries.get(i);
            if (!entryClass.isInstance(orderEntry)) continue;
            this.myOrderEntries.remove(i);
            if (entry != null) {
                this.myOrderEntries.add(i, entry);
            }
            return;
        }
        if (entry != null) {
            this.myOrderEntries.add(0, entry);
        }
    }

    @Override
    public String getSdkName() {
        for (OrderEntry orderEntry : this.getOrderEntries()) {
            if (!(orderEntry instanceof JdkOrderEntry)) continue;
            return ((JdkOrderEntry)orderEntry).getJdkName();
        }
        return null;
    }

    public void assertWritable() {
        LOG.assertTrue(this.myWritable);
    }

    public boolean isDependsOn(Module module) {
        for (OrderEntry entry : this.getOrderEntries()) {
            Module module1;
            if (!(entry instanceof ModuleOrderEntry) || (module1 = ((ModuleOrderEntry)entry).getModule()) != module) continue;
            return true;
        }
        return false;
    }

    public boolean isOrderEntryDisposed() {
        for (OrderEntry entry : this.myOrderEntries) {
            if (!(entry instanceof RootModelComponentBase) || !((RootModelComponentBase)((Object)entry)).isDisposed()) continue;
            return true;
        }
        return false;
    }

    protected Set<ContentEntry> getContent() {
        return this.myContent;
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myModuleRootManager.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelImpl", "getModule"));
        }
        return module;
    }

    @Override
    public boolean isChanged() {
        if (!this.myWritable) {
            return false;
        }
        for (ModuleExtension moduleExtension : this.myExtensions) {
            if (!moduleExtension.isChanged()) continue;
            return true;
        }
        return this.areOrderEntriesChanged() || this.areContentEntriesChanged();
    }

    private boolean areContentEntriesChanged() {
        return ArrayUtil.lexicographicCompare(this.getContentEntries(), this.getSourceModel().getContentEntries()) != 0;
    }

    private boolean areOrderEntriesChanged() {
        OrderEntry[] sourceOrderEntries;
        OrderEntry[] orderEntries = this.getOrderEntries();
        if (orderEntries.length != (sourceOrderEntries = this.getSourceModel().getOrderEntries()).length) {
            return true;
        }
        for (int i = 0; i < orderEntries.length; ++i) {
            OrderEntry orderEntry = orderEntries[i];
            OrderEntry sourceOrderEntry = sourceOrderEntries[i];
            if (RootModelImpl.orderEntriesEquals(orderEntry, sourceOrderEntry)) continue;
            return true;
        }
        return false;
    }

    private static boolean orderEntriesEquals(@NotNull OrderEntry orderEntry1, @NotNull OrderEntry orderEntry2) {
        OrderRootType[] allTypes;
        if (orderEntry1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry1", "com/intellij/openapi/roots/impl/RootModelImpl", "orderEntriesEquals"));
        }
        if (orderEntry2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry2", "com/intellij/openapi/roots/impl/RootModelImpl", "orderEntriesEquals"));
        }
        if (!((OrderEntryBaseImpl)orderEntry1).sameType(orderEntry2)) {
            return false;
        }
        if (orderEntry1 instanceof JdkOrderEntry) {
            String name2;
            String name1;
            if (!(orderEntry2 instanceof JdkOrderEntry)) {
                return false;
            }
            if (orderEntry1 instanceof InheritedJdkOrderEntry && orderEntry2 instanceof ModuleJdkOrderEntry) {
                return false;
            }
            if (orderEntry2 instanceof InheritedJdkOrderEntry && orderEntry1 instanceof ModuleJdkOrderEntry) {
                return false;
            }
            if (orderEntry1 instanceof ModuleJdkOrderEntry && orderEntry2 instanceof ModuleJdkOrderEntry && !Comparing.strEqual(name1 = ((ModuleJdkOrderEntry)orderEntry1).getJdkName(), name2 = ((ModuleJdkOrderEntry)orderEntry2).getJdkName())) {
                return false;
            }
        }
        if (orderEntry1 instanceof ExportableOrderEntry) {
            if (((ExportableOrderEntry)orderEntry1).isExported() != ((ExportableOrderEntry)orderEntry2).isExported()) {
                return false;
            }
            if (((ExportableOrderEntry)orderEntry1).getScope() != ((ExportableOrderEntry)orderEntry2).getScope()) {
                return false;
            }
        }
        if (orderEntry1 instanceof ModuleOrderEntry) {
            LOG.assertTrue(orderEntry2 instanceof ModuleOrderEntry);
            ModuleOrderEntryImpl entry1 = (ModuleOrderEntryImpl)orderEntry1;
            ModuleOrderEntryImpl entry2 = (ModuleOrderEntryImpl)orderEntry2;
            return entry1.isProductionOnTestDependency() == entry2.isProductionOnTestDependency() && Comparing.equal(entry1.getModuleName(), entry2.getModuleName());
        }
        if (orderEntry1 instanceof LibraryOrderEntry) {
            boolean equal;
            LOG.assertTrue(orderEntry2 instanceof LibraryOrderEntry);
            LibraryOrderEntry libraryOrderEntry1 = (LibraryOrderEntry)orderEntry1;
            LibraryOrderEntry libraryOrderEntry2 = (LibraryOrderEntry)orderEntry2;
            boolean bl = equal = Comparing.equal(libraryOrderEntry1.getLibraryName(), libraryOrderEntry2.getLibraryName()) && Comparing.equal(libraryOrderEntry1.getLibraryLevel(), libraryOrderEntry2.getLibraryLevel());
            if (!equal) {
                return false;
            }
            Library library1 = libraryOrderEntry1.getLibrary();
            Library library2 = libraryOrderEntry2.getLibrary();
            if (library1 != null && library2 != null && !Arrays.equals(((LibraryEx)library1).getExcludedRootUrls(), ((LibraryEx)library2).getExcludedRootUrls())) {
                return false;
            }
        }
        for (OrderRootType type : allTypes = OrderRootType.getAllTypes()) {
            Object[] orderedRootUrls2;
            Object[] orderedRootUrls1 = orderEntry1.getUrls(type);
            if (Arrays.equals(orderedRootUrls1, orderedRootUrls2 = orderEntry2.getUrls(type))) continue;
            return false;
        }
        return true;
    }

    void makeExternalChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/roots/impl/RootModelImpl", "makeExternalChange"));
        }
        if (this.myWritable || this.myDisposed) {
            return;
        }
        this.myModuleRootManager.makeRootsChange(runnable);
    }

    @Override
    public void dispose() {
        assert (!this.myDisposed);
        Disposer.dispose(this.myDisposable);
        this.myExtensions.clear();
        this.myWritable = false;
        this.myDisposed = true;
    }

    private RootModelImpl getSourceModel() {
        this.assertWritable();
        return this.myModuleRootManager.getRootModel();
    }

    public String toString() {
        return "RootModelImpl{module=" + this.getModule().getName() + ", writable=" + this.myWritable + ", disposed=" + this.myDisposed + '}';
    }

    @Override
    @Nullable
    public <T> T getModuleExtension(@NotNull Class<T> klass) {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "com/intellij/openapi/roots/impl/RootModelImpl", "getModuleExtension"));
        }
        for (ModuleExtension extension : this.myExtensions) {
            if (!klass.isAssignableFrom(extension.getClass())) continue;
            return (T)extension;
        }
        return null;
    }

    void registerOnDispose(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/roots/impl/RootModelImpl", "registerOnDispose"));
        }
        this.myDisposable.add(disposable);
    }

    static /* synthetic */ OrderEntry[] access$102(RootModelImpl x0, OrderEntry[] x1) {
        x0.myCachedOrderEntries = x1;
        return x1;
    }

    private class Order
    extends ArrayList<OrderEntry> {
        private Order() {
        }

        @Override
        public void clear() {
            super.clear();
            this.clearCachedEntries();
        }

        @Override
        @NotNull
        public OrderEntry set(int i, @NotNull OrderEntry orderEntry) {
            if (orderEntry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry", "com/intellij/openapi/roots/impl/RootModelImpl$Order", "set"));
            }
            super.set(i, orderEntry);
            ((OrderEntryBaseImpl)orderEntry).setIndex(i);
            this.clearCachedEntries();
            OrderEntry orderEntry2 = orderEntry;
            if (orderEntry2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/RootModelImpl$Order", "set"));
            }
            return orderEntry2;
        }

        @Override
        public boolean add(@NotNull OrderEntry orderEntry) {
            if (orderEntry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry", "com/intellij/openapi/roots/impl/RootModelImpl$Order", "add"));
            }
            super.add(orderEntry);
            ((OrderEntryBaseImpl)orderEntry).setIndex(this.size() - 1);
            this.clearCachedEntries();
            return true;
        }

        @Override
        public void add(int i, OrderEntry orderEntry) {
            super.add(i, orderEntry);
            this.clearCachedEntries();
            this.setIndicies(i);
        }

        @Override
        public OrderEntry remove(int i) {
            OrderEntry entry = (OrderEntry)super.remove(i);
            this.setIndicies(i);
            this.clearCachedEntries();
            return entry;
        }

        @Override
        public boolean remove(Object o) {
            int index = this.indexOf(o);
            if (index < 0) {
                return false;
            }
            this.remove(index);
            this.clearCachedEntries();
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends OrderEntry> collection) {
            int startSize = this.size();
            boolean result = super.addAll(collection);
            this.setIndicies(startSize);
            this.clearCachedEntries();
            return result;
        }

        @Override
        public boolean addAll(int i, Collection<? extends OrderEntry> collection) {
            boolean result = super.addAll(i, collection);
            this.setIndicies(i);
            this.clearCachedEntries();
            return result;
        }

        @Override
        public void removeRange(int i, int i1) {
            super.removeRange(i, i1);
            this.clearCachedEntries();
            this.setIndicies(i);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean result = super.removeAll(collection);
            this.setIndicies(0);
            this.clearCachedEntries();
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean result = super.retainAll(collection);
            this.setIndicies(0);
            this.clearCachedEntries();
            return result;
        }

        private void clearCachedEntries() {
            RootModelImpl.access$102(RootModelImpl.this, null);
        }

        private void setIndicies(int startIndex) {
            for (int j = startIndex; j < this.size(); ++j) {
                ((OrderEntryBaseImpl)this.get(j)).setIndex(j);
            }
        }
    }

    private static class ContentComparator
    implements Comparator<ContentEntry> {
        public static final ContentComparator INSTANCE = new ContentComparator();

        private ContentComparator() {
        }

        @Override
        public int compare(@NotNull ContentEntry o1, @NotNull ContentEntry o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "com/intellij/openapi/roots/impl/RootModelImpl$ContentComparator", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "com/intellij/openapi/roots/impl/RootModelImpl$ContentComparator", "compare"));
            }
            return o1.getUrl().compareTo(o2.getUrl());
        }
    }
}

