/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java;

import com.google.common.base.MoreObjects;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.java.ReferenceChainLink;
import com.intellij.psi.impl.search.ApproximateResolver;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FunExprOccurrence {
    public final int funExprOffset;
    private final int argIndex;
    private final List<ReferenceChainLink> referenceContext;

    public FunExprOccurrence(int funExprOffset, int argIndex, List<ReferenceChainLink> referenceContext) {
        this.funExprOffset = funExprOffset;
        this.argIndex = argIndex;
        this.referenceContext = referenceContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunExprOccurrence)) {
            return false;
        }
        FunExprOccurrence that = (FunExprOccurrence)o;
        if (this.funExprOffset != that.funExprOffset) {
            return false;
        }
        if (this.argIndex != that.argIndex) {
            return false;
        }
        return this.referenceContext.equals(that.referenceContext);
    }

    public int hashCode() {
        int result = this.funExprOffset;
        result = 31 * result + this.argIndex;
        result = 31 * result + this.referenceContext.hashCode();
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("offset", this.funExprOffset).add("argIndex", this.argIndex).add("chain", this.referenceContext).toString();
    }

    void serialize(DataOutput out) throws IOException {
        DataInputOutputUtil.writeINT(out, this.funExprOffset);
        DataInputOutputUtil.writeINT(out, this.argIndex);
        DataInputOutputUtil.writeINT(out, this.referenceContext.size());
        for (ReferenceChainLink link : this.referenceContext) {
            FunExprOccurrence.serializeLink(out, link);
        }
    }

    static FunExprOccurrence deserialize(DataInput in) throws IOException {
        int offset = DataInputOutputUtil.readINT(in);
        int argIndex = DataInputOutputUtil.readINT(in);
        int contextSize = DataInputOutputUtil.readINT(in);
        ArrayList<ReferenceChainLink> context = new ArrayList<ReferenceChainLink>(contextSize);
        for (int i = 0; i < contextSize; ++i) {
            context.add(FunExprOccurrence.deserializeLink(in));
        }
        return new FunExprOccurrence(offset, argIndex, context);
    }

    private static void serializeLink(DataOutput out, ReferenceChainLink link) throws IOException {
        IOUtil.writeUTF(out, link.referenceName);
        out.writeBoolean(link.isCall);
        if (link.isCall) {
            DataInputOutputUtil.writeINT(out, link.argCount);
        }
    }

    @NotNull
    private static ReferenceChainLink deserializeLink(DataInput in) throws IOException {
        boolean isCall;
        String referenceName = IOUtil.readUTF(in);
        ReferenceChainLink referenceChainLink = new ReferenceChainLink(referenceName, isCall, (isCall = in.readBoolean()) ? DataInputOutputUtil.readINT(in) : -1);
        if (referenceChainLink == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/java/FunExprOccurrence", "deserializeLink"));
        }
        return referenceChainLink;
    }

    public boolean canHaveType(@NotNull List<PsiClass> samClasses, @NotNull VirtualFile placeFile) {
        if (samClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samClasses", "com/intellij/psi/impl/java/FunExprOccurrence", "canHaveType"));
        }
        if (placeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeFile", "com/intellij/psi/impl/java/FunExprOccurrence", "canHaveType"));
        }
        if (this.referenceContext.isEmpty()) {
            return true;
        }
        Set<PsiClass> qualifiers = null;
        for (int i = 0; i < this.referenceContext.size(); ++i) {
            List<? extends PsiMember> candidates;
            ReferenceChainLink link = this.referenceContext.get(i);
            List<? extends PsiMember> list = candidates = i == 0 ? link.getGlobalMembers(placeFile, samClasses.get(0).getProject()) : link.getSymbolMembers(qualifiers);
            if (candidates == null) {
                return true;
            }
            if (i == this.referenceContext.size() - 1) {
                return ContainerUtil.exists(candidates, m -> {
                    if (samClasses == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samClasses", "com/intellij/psi/impl/java/FunExprOccurrence", "lambda$canHaveType$0"));
                    }
                    return this.isCompatible(link, (PsiMember)m, samClasses);
                });
            }
            qualifiers = ApproximateResolver.getDefiniteSymbolTypes(candidates);
            if (qualifiers != null) continue;
            return true;
        }
        return true;
    }

    private boolean isCompatible(ReferenceChainLink link, PsiMember member, List<PsiClass> samClasses) {
        if (link.isCall) {
            return member instanceof PsiMethod && FunExprOccurrence.hasCompatibleParameter((PsiMethod)member, this.argIndex, samClasses);
        }
        if (member instanceof PsiClass) {
            return ContainerUtil.exists(samClasses, c -> InheritanceUtil.isInheritorOrSelf((PsiClass)member, c, true));
        }
        return member instanceof PsiField && ContainerUtil.exists(samClasses, c -> FunExprOccurrence.canPassFunctionalExpression(c, ((PsiField)member).getType()));
    }

    public static boolean hasCompatibleParameter(PsiMethod method, int argIndex, List<PsiClass> samClasses) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        int paramIndex = method.isVarArgs() ? Math.min(argIndex, parameters.length - 1) : argIndex;
        return paramIndex < parameters.length && ContainerUtil.exists(samClasses, c -> FunExprOccurrence.canPassFunctionalExpression(c, parameters[paramIndex].getType()));
    }

    private static boolean canPassFunctionalExpression(PsiClass sam2, PsiType paramType) {
        PsiClass functionalCandidate;
        if (paramType instanceof PsiEllipsisType) {
            paramType = ((PsiEllipsisType)paramType).getComponentType();
        }
        if ((functionalCandidate = PsiUtil.resolveClassInClassTypeOnly(paramType)) instanceof PsiTypeParameter) {
            return InheritanceUtil.isInheritorOrSelf(sam2, PsiUtil.resolveClassInClassTypeOnly(TypeConversionUtil.erasure(paramType)), true);
        }
        return InheritanceUtil.isInheritorOrSelf(functionalCandidate, sam2, true);
    }
}

