/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiJavaModuleReference
extends PsiReferenceBase.Poly<PsiJavaModuleReferenceElement> {
    public PsiJavaModuleReference(@NotNull PsiJavaModuleReferenceElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiJavaModuleReference", "<init>"));
        }
        super(element, new TextRange(0, element.getTextLength()), false);
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = ((PsiJavaModuleReferenceElement)this.getElement()).getReferenceText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference", "getCanonicalText"));
        }
        return string;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance(this.getProject()).resolveWithCaching(this, Resolver.INSTANCE, false, incompleteCode);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    private Project getProject() {
        return ((PsiJavaModuleReferenceElement)this.getElement()).getProject();
    }

    private static class Resolver
    implements ResolveCache.PolyVariantResolver<PsiJavaModuleReference> {
        private static final ResolveCache.PolyVariantResolver<PsiJavaModuleReference> INSTANCE = new Resolver();

        private Resolver() {
        }

        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull PsiJavaModuleReference reference, boolean incompleteCode) {
            JavaFileManager service;
            Collection<PsiJavaModule> modules;
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/psi/impl/source/PsiJavaModuleReference$Resolver", "resolve"));
            }
            Project project = reference.getProject();
            GlobalSearchScope scope = null;
            if (!incompleteCode) {
                Module module;
                VirtualFile file = ((PsiJavaModuleReferenceElement)reference.getElement()).getContainingFile().getVirtualFile();
                if (file != null && (module = FileIndexFacade.getInstance(project).getModuleForFile(file)) != null) {
                    scope = module.getModuleWithDependenciesAndLibrariesScope(false);
                }
            } else {
                scope = GlobalSearchScope.allScope(project);
            }
            if (scope != null && !(modules = (service = ServiceManager.getService(project, JavaFileManager.class)).findModules(reference.getCanonicalText(), scope)).isEmpty()) {
                ResolveResult[] result = new ResolveResult[modules.size()];
                int i = 0;
                for (PsiJavaModule module : modules) {
                    result[i++] = new PsiElementResolveResult(module);
                }
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference$Resolver", "resolve"));
                }
                return result;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReference$Resolver", "resolve"));
            }
            return ResolveResult.EMPTY_ARRAY;
        }
    }
}

