/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionGadgetsFix
implements LocalQuickFix {
    public static final InspectionGadgetsFix[] EMPTY_ARRAY = new InspectionGadgetsFix[0];
    private boolean myOnTheFly = false;

    @Override
    public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/InspectionGadgetsFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/siyeh/ig/InspectionGadgetsFix", "applyFix"));
        }
        PsiElement problemElement = descriptor.getPsiElement();
        if (problemElement == null || !problemElement.isValid()) {
            return;
        }
        if (this.prepareForWriting() && !FileModificationService.getInstance().preparePsiElementsForWrite(problemElement)) {
            return;
        }
        try {
            this.doFix(project, descriptor);
        }
        catch (IncorrectOperationException e) {
            Class<?> aClass = this.getClass();
            String className = aClass.getName();
            Logger logger = Logger.getInstance(className);
            logger.error(e);
        }
    }

    protected boolean prepareForWriting() {
        return true;
    }

    protected abstract void doFix(Project var1, ProblemDescriptor var2);

    protected static void deleteElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/InspectionGadgetsFix", "deleteElement"));
        }
        element.delete();
    }

    public final void setOnTheFly(boolean onTheFly) {
        this.myOnTheFly = onTheFly;
    }

    public final boolean isOnTheFly() {
        return this.myOnTheFly;
    }
}

