/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OptionalGetWithoutIsPresentInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("optional.get.without.is.present.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/OptionalGetWithoutIsPresentInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(type);
        assert (aClass != null);
        String string = InspectionGadgetsBundle.message("optional.get.without.is.present.problem.descriptor", aClass.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/OptionalGetWithoutIsPresentInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OptionalGetWithoutIsPresentVisitor();
    }

    private static boolean isSurroundedByIsPresentGuard(PsiReferenceExpression optionalReference, PsiElement context) {
        PsiStatement sibling = PsiTreeUtil.getParentOfType(context, PsiStatement.class);
        sibling = PsiTreeUtil.getPrevSiblingOfType(sibling, PsiStatement.class);
        IsPresentChecker checker = new IsPresentChecker(optionalReference);
        while (sibling != null) {
            PsiMethodCallExpression methodCallExpression;
            PsiExpressionStatement expressionStatement;
            PsiExpression expression;
            PsiExpression condition;
            if (sibling instanceof PsiIfStatement) {
                PsiIfStatement ifStatement = (PsiIfStatement)sibling;
                condition = ifStatement.getCondition();
                if (condition != null) {
                    PsiStatement elseBranch;
                    PsiElement target = optionalReference.resolve();
                    if (!(target instanceof PsiVariable)) {
                        return true;
                    }
                    PsiVariable variable = (PsiVariable)target;
                    PsiStatement thenBranch = ifStatement.getThenBranch();
                    if (!ControlFlowUtils.statementMayCompleteNormally(thenBranch) || VariableAccessUtils.variableIsAssigned(variable, thenBranch)) {
                        checker.negate = true;
                        if (checker.checkExpression(condition)) {
                            return true;
                        }
                    }
                    if (!ControlFlowUtils.statementMayCompleteNormally(elseBranch = ifStatement.getElseBranch()) || VariableAccessUtils.variableIsAssigned(variable, elseBranch)) {
                        checker.negate = false;
                        if (checker.checkExpression(condition)) {
                            return true;
                        }
                    }
                }
            } else if (sibling instanceof PsiWhileStatement) {
                PsiWhileStatement whileStatement = (PsiWhileStatement)sibling;
                condition = whileStatement.getCondition();
                checker.negate = true;
                if (checker.checkExpression(condition)) {
                    return true;
                }
            } else if (sibling instanceof PsiAssertStatement) {
                PsiAssertStatement assertStatement = (PsiAssertStatement)sibling;
                condition = assertStatement.getAssertCondition();
                checker.negate = false;
                if (checker.checkExpression(condition)) {
                    return true;
                }
            } else if (sibling instanceof PsiExpressionStatement && (expression = (expressionStatement = (PsiExpressionStatement)sibling).getExpression()) instanceof PsiMethodCallExpression && (MethodCallUtils.isCallToMethod(methodCallExpression = (PsiMethodCallExpression)expression, "org.junit.Assert", (PsiType)PsiType.VOID, "assertTrue", null) || MethodCallUtils.isCallToMethod(methodCallExpression, "junit.framework.Assert", (PsiType)PsiType.VOID, "assertTrue", null) || MethodCallUtils.isCallToMethod(methodCallExpression, "org.testng.Assert", (PsiType)PsiType.VOID, "assertTrue", null) || MethodCallUtils.isCallToMethod(methodCallExpression, "org.testng.AssertJUnit", (PsiType)PsiType.VOID, "assertTrue", null))) {
                PsiExpression[] arguments;
                checker.negate = false;
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                    if (!checker.checkExpression(argument)) continue;
                    return true;
                }
            }
            sibling = PsiTreeUtil.getPrevSiblingOfType(sibling, PsiStatement.class);
        }
        checker.negate = false;
        Object parent = PsiTreeUtil.getParentOfType(context, PsiIfStatement.class, PsiWhileStatement.class, PsiConditionalExpression.class, PsiPolyadicExpression.class);
        while (parent != null) {
            PsiPolyadicExpression polyadicExpression;
            if (parent instanceof PsiPolyadicExpression && JavaTokenType.OROR.equals((polyadicExpression = (PsiPolyadicExpression)parent).getOperationTokenType())) {
                checker.negate = true;
            }
            parent.accept(checker);
            if (checker.hasIsPresentCall()) {
                return true;
            }
            parent = PsiTreeUtil.getParentOfType(parent, new Class[]{PsiIfStatement.class, PsiWhileStatement.class, PsiConditionalExpression.class, PsiPolyadicExpression.class});
        }
        return checker.hasIsPresentCall();
    }

    private static class IsPresentChecker
    extends JavaElementVisitor {
        private final PsiReferenceExpression referenceExpression;
        private boolean negate = false;
        private boolean hasIsPresentCall = false;

        IsPresentChecker(PsiReferenceExpression referenceExpression) {
            this.referenceExpression = referenceExpression;
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitExpression(expression);
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            IElementType tokenType = expression.getOperationTokenType();
            if (tokenType != JavaTokenType.ANDAND && tokenType != JavaTokenType.OROR) {
                return;
            }
            for (PsiExpression operand : expression.getOperands()) {
                if (PsiTreeUtil.isAncestor(operand, this.referenceExpression, false)) {
                    return;
                }
                this.checkExpression(operand);
                if (!this.hasIsPresentCall) continue;
                return;
            }
        }

        @Override
        public void visitWhileStatement(PsiWhileStatement statement) {
            this.checkExpression(statement.getCondition());
        }

        @Override
        public void visitIfStatement(PsiIfStatement ifStatement) {
            PsiBlockStatement blockStatement;
            PsiStatement statement;
            PsiStatement elseBranch = ifStatement.getElseBranch();
            this.negate = elseBranch != null && PsiTreeUtil.isAncestor(elseBranch, this.referenceExpression, true);
            PsiStatement psiStatement = statement = this.negate ? elseBranch : ifStatement.getThenBranch();
            if (statement instanceof PsiBlockStatement && VariableAccessUtils.variableIsAssignedBeforeReference(this.referenceExpression, blockStatement = (PsiBlockStatement)statement)) {
                return;
            }
            this.checkExpression(ifStatement.getCondition());
        }

        @Override
        public void visitConditionalExpression(PsiConditionalExpression expression) {
            PsiExpression elseExpression = expression.getElseExpression();
            this.negate = elseExpression != null && PsiTreeUtil.isAncestor(elseExpression, this.referenceExpression, true);
            this.checkExpression(expression.getCondition());
        }

        private boolean checkExpression(PsiExpression expression) {
            if ((expression = PsiUtil.deparenthesizeExpression(expression)) instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                IElementType tokenType = prefixExpression.getOperationTokenType();
                if (tokenType != JavaTokenType.EXCL) {
                    return false;
                }
                this.negate = !this.negate;
                return this.checkExpression(prefixExpression.getOperand());
            }
            if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression binaryExpression = (PsiPolyadicExpression)expression;
                this.visitPolyadicExpression(binaryExpression);
            } else if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String name = methodExpression.getReferenceName();
                if (!"isPresent".equals(name)) {
                    return false;
                }
                PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                this.hasIsPresentCall = !this.negate && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(referenceExpression, this.referenceExpression);
            } else if (expression instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
                PsiExpression definition = DeclarationSearchUtils.findDefinition(referenceExpression, null);
                PsiExpression optionalDefinition = DeclarationSearchUtils.findDefinition(this.referenceExpression, null);
                if (definition == null || optionalDefinition == null || optionalDefinition.getTextOffset() > definition.getTextOffset()) {
                    return false;
                }
                return this.checkExpression(definition);
            }
            return this.hasIsPresentCall;
        }

        public boolean hasIsPresentCall() {
            return this.hasIsPresentCall;
        }
    }

    private static class OptionalGetWithoutIsPresentVisitor
    extends BaseInspectionVisitor {
        private OptionalGetWithoutIsPresentVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiReferenceExpression referenceExpression;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!("get".equals(name) || "getAsDouble".equals(name) || "getAsInt".equals(name) || "getAsLong".equals(name))) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (qualifier == null) {
                return;
            }
            PsiType type = qualifier.getType();
            if (!TypeUtils.isOptional(type)) {
                return;
            }
            if (qualifier instanceof PsiReferenceExpression && OptionalGetWithoutIsPresentInspection.isSurroundedByIsPresentGuard(referenceExpression = (PsiReferenceExpression)qualifier, expression)) {
                return;
            }
            this.registerMethodCallError(expression, type);
        }
    }
}

