/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoubleNegationInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("double.negation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DoubleNegationInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("double.negation.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DoubleNegationInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new DoubleNegationFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DoubleNegationVisitor();
    }

    public static boolean isNegation(@Nullable PsiExpression expression) {
        if ((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiPrefixExpression) {
            return DoubleNegationInspection.isNegation((PsiPrefixExpression)expression);
        }
        if (expression instanceof PsiPolyadicExpression) {
            return DoubleNegationInspection.isNegation((PsiPolyadicExpression)expression);
        }
        return false;
    }

    static boolean isNegation(PsiPrefixExpression expression) {
        return JavaTokenType.EXCL.equals(expression.getOperationTokenType());
    }

    static boolean isNegation(PsiPolyadicExpression expression) {
        for (PsiExpression operand : expression.getOperands()) {
            if (!TypeUtils.hasFloatingPointType(operand)) continue;
            return false;
        }
        return JavaTokenType.NE.equals(expression.getOperationTokenType());
    }

    private static class DoubleNegationVisitor
    extends BaseInspectionVisitor {
        private DoubleNegationVisitor() {
        }

        @Override
        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            if (!DoubleNegationInspection.isNegation(expression)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (!DoubleNegationInspection.isNegation(operand)) {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            if (!DoubleNegationInspection.isNegation(expression)) {
                return;
            }
            PsiExpression[] operands = expression.getOperands();
            if (operands.length == 2) {
                int notNegatedCount = 0;
                for (PsiExpression operand : operands) {
                    if (DoubleNegationInspection.isNegation(operand)) continue;
                    ++notNegatedCount;
                }
                if (notNegatedCount > 1) {
                    return;
                }
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }

    private static class DoubleNegationFix
    extends InspectionGadgetsFix {
        private DoubleNegationFix() {
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("double.negation.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DoubleNegationInspection$DoubleNegationFix", "getName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/DoubleNegationInspection$DoubleNegationFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement expression = descriptor.getPsiElement();
            if (expression instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)expression;
                PsiExpression operand = ParenthesesUtils.stripParentheses(prefixExpression.getOperand());
                PsiReplacementUtil.replaceExpression(prefixExpression, BoolUtils.getNegatedExpressionText(operand));
            } else if (expression instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                PsiExpression[] operands = polyadicExpression.getOperands();
                int length = operands.length;
                if (length == 2) {
                    PsiExpression firstOperand = operands[0];
                    PsiExpression secondOperand = operands[1];
                    if (DoubleNegationInspection.isNegation(firstOperand)) {
                        PsiReplacementUtil.replaceExpression(polyadicExpression, BoolUtils.getNegatedExpressionText(firstOperand) + "==" + secondOperand.getText());
                    } else {
                        PsiReplacementUtil.replaceExpression(polyadicExpression, firstOperand.getText() + "==" + BoolUtils.getNegatedExpressionText(secondOperand));
                    }
                } else {
                    StringBuilder newExpressionText = new StringBuilder();
                    for (int i = 0; i < length; ++i) {
                        if (i > 0) {
                            if (length % 2 != 1 && i == length - 1) {
                                newExpressionText.append("!=");
                            } else {
                                newExpressionText.append("==");
                            }
                        }
                        newExpressionText.append(operands[i].getText());
                    }
                    PsiReplacementUtil.replaceExpression(polyadicExpression, newExpressionText.toString());
                }
            }
        }
    }
}

