/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.util.Consumer;
import com.intellij.util.Function;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.DonePromise;
import org.jetbrains.concurrency.MessageError;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.concurrency.RejectedPromise;

public interface Promise<T> {
    @Deprecated
    public static final Promise<Void> DONE = new DonePromise<Object>(null);
    @Deprecated
    public static final Promise<Void> REJECTED = new RejectedPromise<Void>(new MessageError("rejected", false));

    @NotNull
    public static <T> Promise<T> resolve(T result) {
        DonePromise<T> donePromise = result == null ? Promises.resolvedPromise() : new DonePromise<T>(result);
        if (donePromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/concurrency/Promise", "resolve"));
        }
        return donePromise;
    }

    @NotNull
    public Promise<T> done(@NotNull Consumer<? super T> var1);

    @NotNull
    public Promise<T> processed(@NotNull AsyncPromise<? super T> var1);

    @NotNull
    public Promise<T> rejected(@NotNull Consumer<Throwable> var1);

    public Promise<T> processed(@NotNull Consumer<? super T> var1);

    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> var1);

    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, Promise<SUB_RESULT>> var1);

    @NotNull
    public State getState();

    @Nullable
    public T blockingGet(int var1, @NotNull TimeUnit var2);

    default public T blockingGet(int timeout) {
        return this.blockingGet(timeout, TimeUnit.MILLISECONDS);
    }

    public void notify(@NotNull AsyncPromise<? super T> var1);

    public static enum State {
        PENDING,
        FULFILLED,
        REJECTED;

    }
}

