/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationHolderImpl
extends SmartList<Annotation>
implements AnnotationHolder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl");
    private final AnnotationSession myAnnotationSession;
    private final boolean myBatchMode;

    public AnnotationHolderImpl(@NotNull AnnotationSession session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "<init>"));
        }
        this(session, false);
    }

    public AnnotationHolderImpl(@NotNull AnnotationSession session, boolean batchMode) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "<init>"));
        }
        this.myAnnotationSession = session;
        this.myBatchMode = batchMode;
    }

    @Override
    public boolean isBatchMode() {
        return this.myBatchMode;
    }

    @Override
    public Annotation createErrorAnnotation(@NotNull PsiElement elt, String message) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createErrorAnnotation"));
        }
        this.assertMyFile(elt);
        return this.createAnnotation(HighlightSeverity.ERROR, elt.getTextRange(), message);
    }

    @Override
    public Annotation createErrorAnnotation(@NotNull ASTNode node, String message) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createErrorAnnotation"));
        }
        this.assertMyFile(node.getPsi());
        return this.createAnnotation(HighlightSeverity.ERROR, node.getTextRange(), message);
    }

    @Override
    public Annotation createErrorAnnotation(@NotNull TextRange range, String message) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createErrorAnnotation"));
        }
        return this.createAnnotation(HighlightSeverity.ERROR, range, message);
    }

    @Override
    public Annotation createWarningAnnotation(@NotNull PsiElement elt, String message) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createWarningAnnotation"));
        }
        this.assertMyFile(elt);
        return this.createAnnotation(HighlightSeverity.WARNING, elt.getTextRange(), message);
    }

    @Override
    public Annotation createWarningAnnotation(@NotNull ASTNode node, String message) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createWarningAnnotation"));
        }
        this.assertMyFile(node.getPsi());
        return this.createAnnotation(HighlightSeverity.WARNING, node.getTextRange(), message);
    }

    @Override
    public Annotation createWarningAnnotation(@NotNull TextRange range, String message) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createWarningAnnotation"));
        }
        return this.createAnnotation(HighlightSeverity.WARNING, range, message);
    }

    @Override
    public Annotation createWeakWarningAnnotation(@NotNull PsiElement elt, @Nullable String message) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createWeakWarningAnnotation"));
        }
        this.assertMyFile(elt);
        return this.createAnnotation(HighlightSeverity.WEAK_WARNING, elt.getTextRange(), message);
    }

    @Override
    public Annotation createWeakWarningAnnotation(@NotNull ASTNode node, @Nullable String message) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createWeakWarningAnnotation"));
        }
        this.assertMyFile(node.getPsi());
        return this.createAnnotation(HighlightSeverity.WEAK_WARNING, node.getTextRange(), message);
    }

    @Override
    public Annotation createWeakWarningAnnotation(@NotNull TextRange range, String message) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createWeakWarningAnnotation"));
        }
        return this.createAnnotation(HighlightSeverity.WEAK_WARNING, range, message);
    }

    @Override
    public Annotation createInfoAnnotation(@NotNull PsiElement elt, String message) {
        if (elt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elt", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createInfoAnnotation"));
        }
        this.assertMyFile(elt);
        return this.createAnnotation(HighlightSeverity.INFORMATION, elt.getTextRange(), message);
    }

    @Override
    public Annotation createInfoAnnotation(@NotNull ASTNode node, String message) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createInfoAnnotation"));
        }
        this.assertMyFile(node.getPsi());
        return this.createAnnotation(HighlightSeverity.INFORMATION, node.getTextRange(), message);
    }

    private void assertMyFile(PsiElement node) {
        if (node == null) {
            return;
        }
        PsiFile myFile = this.myAnnotationSession.getFile();
        PsiFile containingFile = node.getContainingFile();
        LOG.assertTrue(containingFile != null, node);
        VirtualFile containingVFile = containingFile.getVirtualFile();
        VirtualFile myVFile = myFile.getVirtualFile();
        if (!Comparing.equal(containingVFile, myVFile)) {
            LOG.error("Annotation must be registered for an element inside '" + myFile + "' which is in '" + myVFile + "'.\nElement passed: '" + node + "' is inside the '" + containingFile + "' which is in '" + containingVFile + "'");
        }
    }

    @Override
    public Annotation createInfoAnnotation(@NotNull TextRange range, String message) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createInfoAnnotation"));
        }
        return this.createAnnotation(HighlightSeverity.INFORMATION, range, message);
    }

    @Override
    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range, @Nullable String message) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createAnnotation"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createAnnotation"));
        }
        String tooltip = message == null ? null : XmlStringUtil.wrapInHtml(XmlStringUtil.escapeString(message));
        return this.createAnnotation(severity, range, message, tooltip);
    }

    @Override
    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range, @Nullable String message, @Nullable String tooltip) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createAnnotation"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "createAnnotation"));
        }
        Annotation annotation = new Annotation(range.getStartOffset(), range.getEndOffset(), severity, message, tooltip);
        this.add(annotation);
        return annotation;
    }

    public boolean hasAnnotations() {
        return !this.isEmpty();
    }

    @Override
    @NotNull
    public AnnotationSession getCurrentAnnotationSession() {
        AnnotationSession annotationSession = this.myAnnotationSession;
        if (annotationSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/AnnotationHolderImpl", "getCurrentAnnotationSession"));
        }
        return annotationSession;
    }
}

