/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.PairedUnfairLocalInspectionTool;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalInspectionToolWrapper
extends InspectionToolWrapper<LocalInspectionTool, LocalInspectionEP> {
    private static final NotNullLazyValue<Map<String, LocalInspectionEP>> ourEPMap = new NotNullLazyValue<Map<String, LocalInspectionEP>>(){

        @Override
        @NotNull
        protected Map<String, LocalInspectionEP> compute() {
            THashMap map = new THashMap();
            for (LocalInspectionEP ep : LocalInspectionEP.LOCAL_INSPECTION.getExtensions()) {
                map.put(ep.getShortName(), ep);
            }
            THashMap tHashMap = map;
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/LocalInspectionToolWrapper$1", "compute"));
            }
            return tHashMap;
        }
    };

    public LocalInspectionToolWrapper(@NotNull LocalInspectionTool tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tool", "com/intellij/codeInspection/ex/LocalInspectionToolWrapper", "<init>"));
        }
        super(tool, (InspectionEP)ourEPMap.getValue().get(tool.getShortName()));
    }

    public LocalInspectionToolWrapper(@NotNull LocalInspectionEP ep) {
        if (ep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ep", "com/intellij/codeInspection/ex/LocalInspectionToolWrapper", "<init>"));
        }
        super(ep);
    }

    private LocalInspectionToolWrapper(@NotNull LocalInspectionToolWrapper other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/codeInspection/ex/LocalInspectionToolWrapper", "<init>"));
        }
        super(other);
    }

    @NotNull
    public LocalInspectionToolWrapper createCopy() {
        LocalInspectionToolWrapper localInspectionToolWrapper = new LocalInspectionToolWrapper(this);
        if (localInspectionToolWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/LocalInspectionToolWrapper", "createCopy"));
        }
        return localInspectionToolWrapper;
    }

    @Override
    @NotNull
    public JobDescriptor[] getJobDescriptors(@NotNull GlobalInspectionContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/ex/LocalInspectionToolWrapper", "getJobDescriptors"));
        }
        if (context.getStdJobDescriptors().LOCAL_ANALYSIS_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/LocalInspectionToolWrapper", "getJobDescriptors"));
        }
        return context.getStdJobDescriptors().LOCAL_ANALYSIS_ARRAY;
    }

    public boolean isUnfair() {
        return this.myEP == null ? this.getTool() instanceof UnfairLocalInspectionTool : ((LocalInspectionEP)this.myEP).unfair;
    }

    @Override
    public String getID() {
        return this.myEP == null ? ((LocalInspectionTool)this.getTool()).getID() : (((LocalInspectionEP)this.myEP).id == null ? ((LocalInspectionEP)this.myEP).getShortName() : ((LocalInspectionEP)this.myEP).id);
    }

    @Nullable
    public String getAlternativeID() {
        return this.myEP == null ? ((LocalInspectionTool)this.getTool()).getAlternativeID() : ((LocalInspectionEP)this.myEP).alternativeId;
    }

    public boolean runForWholeFile() {
        return this.myEP == null ? ((LocalInspectionTool)this.getTool()).runForWholeFile() : ((LocalInspectionEP)this.myEP).runForWholeFile;
    }

    @Nullable
    public static InspectionToolWrapper findTool2RunInBatch(@NotNull Project project, @Nullable PsiElement element, @NotNull String name) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/LocalInspectionToolWrapper", "findTool2RunInBatch"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/ex/LocalInspectionToolWrapper", "findTool2RunInBatch"));
        }
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
        InspectionToolWrapper toolWrapper = element == null ? inspectionProfile.getInspectionTool(name, project) : inspectionProfile.getInspectionTool(name, element);
        return LocalInspectionToolWrapper.findTool2RunInBatch(project, element, inspectionProfile, toolWrapper);
    }

    @Nullable
    public static InspectionToolWrapper findTool2RunInBatch(@NotNull Project project, @Nullable PsiElement element, @NotNull InspectionProfile inspectionProfile, @Nullable InspectionToolWrapper toolWrapper) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/ex/LocalInspectionToolWrapper", "findTool2RunInBatch"));
        }
        if (inspectionProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inspectionProfile", "com/intellij/codeInspection/ex/LocalInspectionToolWrapper", "findTool2RunInBatch"));
        }
        if (toolWrapper instanceof LocalInspectionToolWrapper && ((LocalInspectionToolWrapper)toolWrapper).isUnfair()) {
            LocalInspectionTool inspectionTool = (LocalInspectionTool)((LocalInspectionToolWrapper)toolWrapper).getTool();
            if (inspectionTool instanceof PairedUnfairLocalInspectionTool) {
                String oppositeShortName = ((PairedUnfairLocalInspectionTool)((Object)inspectionTool)).getInspectionForBatchShortName();
                return element == null ? inspectionProfile.getInspectionTool(oppositeShortName, project) : inspectionProfile.getInspectionTool(oppositeShortName, element);
            }
            return null;
        }
        return toolWrapper;
    }
}

