/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.java18api.ReplaceWithMapPutIfAbsentFix;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.List;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java8CollectionsApiInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(Java8CollectionsApiInspection.class);
    public boolean myReportContainsCondition;

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Report when 'containsKey' is used in condition (may change semantics)", this, "myReportContainsCondition");
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiClass containingClass;
                PsiMethod method;
                super.visitMethodCallExpression(expression);
                PsiElement nameElement = expression.getMethodExpression().getReferenceNameElement();
                if (nameElement != null && expression.getArgumentList().getExpressions().length == 2 && "sort".equals(nameElement.getText()) && (method = expression.resolveMethod()) != null && (containingClass = method.getContainingClass()) != null && "java.util.Collections".equals(containingClass.getQualifiedName())) {
                    holder.registerProblem(nameElement, QuickFixBundle.message("java.8.collections.api.inspection.sort.description", new Object[0]), new ReplaceWithListSortFix());
                }
            }

            @Override
            public void visitConditionalExpression(PsiConditionalExpression expression) {
                ConditionInfo conditionInfo = Java8CollectionsApiInspection.this.extractConditionInfo(expression.getCondition());
                if (conditionInfo == null) {
                    return;
                }
                PsiExpression thenExpression = expression.getThenExpression();
                PsiExpression elseExpression = expression.getElseExpression();
                if (thenExpression == null || elseExpression == null) {
                    return;
                }
                Java8CollectionsApiInspection.analyzeCorrespondenceOfPutAndGet(conditionInfo.isInverted() ? thenExpression : elseExpression, conditionInfo.isInverted() ? elseExpression : thenExpression, conditionInfo.getQualifier(), conditionInfo.getContainsKey(), holder, expression);
            }

            @Override
            public void visitIfStatement(PsiIfStatement statement) {
                PsiStatement maybePutStatement;
                PsiStatement branch;
                PsiStatement maybeGetBranch;
                this.handleGetWithVariable(holder, statement);
                PsiExpression condition = statement.getCondition();
                ConditionInfo conditionInfo = Java8CollectionsApiInspection.this.extractConditionInfo(condition);
                if (conditionInfo == null) {
                    return;
                }
                PsiStatement psiStatement = maybeGetBranch = conditionInfo.isInverted() ? statement.getElseBranch() : statement.getThenBranch();
                if (maybeGetBranch instanceof PsiBlockStatement) {
                    PsiStatement[] getBranchStatements = ((PsiBlockStatement)maybeGetBranch).getCodeBlock().getStatements();
                    if (getBranchStatements.length > 1) {
                        return;
                    }
                    maybeGetBranch = getBranchStatements.length == 0 ? null : getBranchStatements[0];
                }
                PsiStatement psiStatement2 = branch = conditionInfo.isInverted() ? statement.getThenBranch() : statement.getElseBranch();
                if (branch instanceof PsiBlockStatement) {
                    PsiStatement[] statements = ((PsiBlockStatement)branch).getCodeBlock().getStatements();
                    if (statements.length != 1) {
                        return;
                    }
                    maybePutStatement = statements[statements.length - 1];
                } else {
                    maybePutStatement = branch;
                }
                if (maybePutStatement != null) {
                    Java8CollectionsApiInspection.analyzeCorrespondenceOfPutAndGet(maybePutStatement, maybeGetBranch, conditionInfo.getQualifier(), conditionInfo.getContainsKey(), holder, statement);
                }
            }

            private void handleGetWithVariable(ProblemsHolder holder2, PsiIfStatement statement) {
                if (statement.getElseBranch() != null) {
                    return;
                }
                PsiExpression condition = statement.getCondition();
                PsiReferenceExpression value = Java8CollectionsApiInspection.getReferenceComparedWithNull(condition);
                if (value == null) {
                    return;
                }
                PsiElement previous = PsiTreeUtil.skipSiblingsBackward(statement, PsiWhiteSpace.class, PsiComment.class);
                PsiMethodCallExpression getCall = Java8CollectionsApiInspection.tryExtractMapGetCall(value, previous);
                if (getCall == null) {
                    return;
                }
                PsiExpression[] getArguments = getCall.getArgumentList().getExpressions();
                if (getArguments.length != 1) {
                    return;
                }
                PsiStatement thenBranch = ControlFlowUtils.stripBraces(statement.getThenBranch());
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(thenBranch);
                EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
                if (assignment != null) {
                    if (ExpressionUtils.isSimpleExpression(assignment.getRExpression()) && equivalence.expressionsAreEquivalent(assignment.getLExpression(), value)) {
                        holder2.registerProblem((PsiElement)condition, QuickFixBundle.message("java.8.collections.api.inspection.description", new Object[0]), new ReplaceGetNullCheck("getOrDefault"));
                    }
                } else if (thenBranch instanceof PsiBlockStatement) {
                    PsiExpression key = getArguments[0];
                    PsiStatement[] statements = ((PsiBlockStatement)thenBranch).getCodeBlock().getStatements();
                    if (statements.length != 2) {
                        return;
                    }
                    assignment = ExpressionUtils.getAssignment(statements[0]);
                    if (assignment == null) {
                        return;
                    }
                    PsiExpression lambdaCandidate = assignment.getRExpression();
                    if (lambdaCandidate == null || !equivalence.expressionsAreEquivalent(assignment.getLExpression(), value) || !(statements[1] instanceof PsiExpressionStatement)) {
                        return;
                    }
                    PsiExpression expression = ((PsiExpressionStatement)statements[1]).getExpression();
                    if (!(expression instanceof PsiMethodCallExpression)) {
                        return;
                    }
                    PsiMethodCallExpression putCall = (PsiMethodCallExpression)expression;
                    if (!Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(putCall, "put")) {
                        return;
                    }
                    PsiExpression[] putArguments = putCall.getArgumentList().getExpressions();
                    if (!(putArguments.length == 2 && equivalence.expressionsAreEquivalent(putCall.getMethodExpression().getQualifierExpression(), getCall.getMethodExpression().getQualifierExpression()) && equivalence.expressionsAreEquivalent(key, putArguments[0]) && equivalence.expressionsAreEquivalent(value, putArguments[1]))) {
                        return;
                    }
                    if (!ExceptionUtil.getThrownCheckedExceptions(new PsiElement[]{lambdaCandidate}).isEmpty()) {
                        return;
                    }
                    if (!PsiTreeUtil.processElements(lambdaCandidate, e -> {
                        if (!(e instanceof PsiReferenceExpression)) {
                            return true;
                        }
                        PsiElement element = ((PsiReferenceExpression)e).resolve();
                        if (!(element instanceof PsiVariable)) {
                            return true;
                        }
                        return HighlightControlFlowUtil.isEffectivelyFinal((PsiVariable)element, lambdaCandidate, null);
                    })) {
                        return;
                    }
                    holder2.registerProblem((PsiElement)condition, QuickFixBundle.message("java.8.collections.api.inspection.description", new Object[0]), new ReplaceGetNullCheck("computeIfAbsent"));
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Nullable
    private static PsiReferenceExpression getReferenceComparedWithNull(PsiExpression condition) {
        if (!(condition instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)condition;
        if (!binOp.getOperationTokenType().equals(JavaTokenType.EQEQ)) {
            return null;
        }
        PsiExpression value = Java8CollectionsApiInspection.getValueComparedWithNull(binOp);
        if (!(value instanceof PsiReferenceExpression)) {
            return null;
        }
        return (PsiReferenceExpression)value;
    }

    @Nullable
    @Contract(value="_, null -> null")
    static PsiMethodCallExpression tryExtractMapGetCall(PsiReferenceExpression target, PsiElement element) {
        PsiExpression rValue;
        PsiExpression lValue;
        PsiLocalVariable var;
        PsiExpression initializer;
        PsiElement lastDeclaration;
        PsiDeclarationStatement declaration;
        PsiElement[] elements;
        if (element instanceof PsiDeclarationStatement && (elements = (declaration = (PsiDeclarationStatement)element).getDeclaredElements()).length > 0 && (lastDeclaration = elements[elements.length - 1]) instanceof PsiLocalVariable && lastDeclaration == target.resolve() && (initializer = PsiUtil.skipParenthesizedExprDown((var = (PsiLocalVariable)lastDeclaration).getInitializer())) instanceof PsiMethodCallExpression && Java8CollectionsApiInspection.isJavaUtilMapMethodWithName((PsiMethodCallExpression)initializer, "get")) {
            return (PsiMethodCallExpression)initializer;
        }
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(element);
        if (assignment != null && (lValue = assignment.getLExpression()) instanceof PsiReferenceExpression && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(target, lValue) && (rValue = PsiUtil.skipParenthesizedExprDown(assignment.getRExpression())) instanceof PsiMethodCallExpression && Java8CollectionsApiInspection.isJavaUtilMapMethodWithName((PsiMethodCallExpression)rValue, "get")) {
            return (PsiMethodCallExpression)rValue;
        }
        return null;
    }

    @Nullable
    private ConditionInfo extractConditionInfo(PsiExpression condition) {
        ConditionInfo info = Java8CollectionsApiInspection.extractConditionInfoIfGet(condition);
        if (info != null) {
            return info;
        }
        return !this.myReportContainsCondition ? null : Java8CollectionsApiInspection.extractConditionInfoIfContains(condition);
    }

    @Nullable
    private static PsiExpression getValueComparedWithNull(PsiBinaryExpression binOp) {
        if (!binOp.getOperationTokenType().equals(JavaTokenType.EQEQ) && !binOp.getOperationTokenType().equals(JavaTokenType.NE)) {
            return null;
        }
        PsiExpression left = binOp.getLOperand();
        PsiExpression right = binOp.getROperand();
        if (ExpressionUtils.isNullLiteral(right)) {
            return left;
        }
        if (ExpressionUtils.isNullLiteral(left)) {
            return right;
        }
        return null;
    }

    @Nullable
    private static ConditionInfo extractConditionInfoIfGet(PsiExpression condition) {
        if (!(condition instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)condition;
        PsiExpression operand = Java8CollectionsApiInspection.getValueComparedWithNull(binOp);
        if (!(operand instanceof PsiMethodCallExpression)) {
            return null;
        }
        PsiMethodCallExpression maybeGetCall = (PsiMethodCallExpression)operand;
        if (!Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(maybeGetCall, "get")) {
            return null;
        }
        PsiExpression[] arguments = maybeGetCall.getArgumentList().getExpressions();
        if (arguments.length != 1) {
            return null;
        }
        PsiExpression getQualifier = maybeGetCall.getMethodExpression().getQualifierExpression();
        PsiExpression keyExpression = arguments[0];
        return new ConditionInfo(getQualifier, keyExpression, binOp.getOperationTokenType().equals(JavaTokenType.EQEQ));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static ConditionInfo extractConditionInfoIfContains(PsiExpression condition) {
        PsiMethodCallExpression conditionMethodCall;
        boolean inverted = false;
        if (condition instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
            if (!JavaTokenType.EXCL.equals(prefixExpression.getOperationSign().getTokenType()) || !(prefixExpression.getOperand() instanceof PsiMethodCallExpression)) return null;
            conditionMethodCall = (PsiMethodCallExpression)prefixExpression.getOperand();
            inverted = true;
        } else {
            if (!(condition instanceof PsiMethodCallExpression)) return null;
            conditionMethodCall = (PsiMethodCallExpression)condition;
        }
        if (!Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(conditionMethodCall, "containsKey")) {
            return null;
        }
        PsiExpression containsQualifier = conditionMethodCall.getMethodExpression().getQualifierExpression();
        if (containsQualifier == null) {
            return null;
        }
        PsiExpression[] expressions = conditionMethodCall.getArgumentList().getExpressions();
        if (expressions.length != 1) {
            return null;
        }
        PsiExpression containsKey = expressions[0];
        return new ConditionInfo(containsQualifier, containsKey, inverted);
    }

    private static void analyzeCorrespondenceOfPutAndGet(@NotNull PsiElement adjustedElseBranch, @Nullable PsiElement adjustedThenBranch, @Nullable PsiExpression containsQualifier, @Nullable PsiExpression containsKey, @NotNull ProblemsHolder holder, @NotNull PsiElement context) {
        PsiElement maybePutMethodCall;
        PsiElement maybeGetMethodCall;
        if (adjustedElseBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adjustedElseBranch", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "analyzeCorrespondenceOfPutAndGet"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "analyzeCorrespondenceOfPutAndGet"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "analyzeCorrespondenceOfPutAndGet"));
        }
        if (adjustedThenBranch == null) {
            PsiExpression expression;
            maybeGetMethodCall = null;
            maybePutMethodCall = adjustedElseBranch instanceof PsiExpressionStatement ? ((expression = ((PsiExpressionStatement)adjustedElseBranch).getExpression()) instanceof PsiMethodCallExpression && Java8CollectionsApiInspection.isJavaUtilMapMethodWithName((PsiMethodCallExpression)expression, "put") ? expression : null) : null;
        } else if (adjustedElseBranch instanceof PsiStatement && adjustedThenBranch instanceof PsiStatement) {
            EquivalenceChecker.Decision decision = EquivalenceChecker.getCanonicalPsiEquivalence().statementsAreEquivalentDecision((PsiStatement)adjustedElseBranch, (PsiStatement)adjustedThenBranch);
            maybePutMethodCall = decision.getLeftDiff();
            maybeGetMethodCall = decision.getRightDiff();
        } else {
            maybePutMethodCall = adjustedElseBranch;
            maybeGetMethodCall = adjustedThenBranch;
        }
        if (maybePutMethodCall instanceof PsiMethodCallExpression && (maybeGetMethodCall == null || maybeGetMethodCall instanceof PsiMethodCallExpression)) {
            PsiExpression getQualifier;
            PsiMethodCallExpression putMethodCall = (PsiMethodCallExpression)maybePutMethodCall;
            PsiMethodCallExpression getMethodCall = (PsiMethodCallExpression)maybeGetMethodCall;
            PsiExpression putQualifier = putMethodCall.getMethodExpression().getQualifierExpression();
            PsiExpression psiExpression = getQualifier = getMethodCall == null ? null : getMethodCall.getMethodExpression().getQualifierExpression();
            if ((getMethodCall == null || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(putQualifier, getQualifier)) && EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(putQualifier, containsQualifier) && Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(putMethodCall, "put") && (getMethodCall == null || Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(getMethodCall, "get"))) {
                PsiExpression getArgument;
                if (getMethodCall != null) {
                    PsiExpression[] arguments = getMethodCall.getArgumentList().getExpressions();
                    if (arguments.length != 1) {
                        return;
                    }
                    getArgument = arguments[0];
                } else {
                    getArgument = null;
                }
                PsiExpression[] putArguments = putMethodCall.getArgumentList().getExpressions();
                if (putArguments.length != 2) {
                    return;
                }
                PsiExpression putKeyArgument = putArguments[0];
                if (EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(containsKey, putKeyArgument) && (getArgument == null || EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(getArgument, putKeyArgument))) {
                    holder.registerProblem(context, QuickFixBundle.message("java.8.collections.api.inspection.description", new Object[0]), new ReplaceWithMapPutIfAbsentFix(putMethodCall));
                }
            }
        }
    }

    private static boolean isJavaUtilMapMethodWithName(@NotNull PsiMethodCallExpression methodCallExpression, @NotNull String expectedName) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "isJavaUtilMapMethodWithName"));
        }
        if (expectedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedName", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection", "isJavaUtilMapMethodWithName"));
        }
        if (!expectedName.equals(methodCallExpression.getMethodExpression().getReferenceName())) {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        Object[] superMethods = method.findDeepestSuperMethods();
        if (superMethods.length == 0) {
            superMethods = new PsiMethod[]{method};
        }
        return ((StreamEx)StreamEx.of((Object[])superMethods).map(PsiMember::getContainingClass).nonNull()).map(PsiClass::getQualifiedName).has((Object)"java.util.Map");
    }

    private static class ReplaceGetNullCheck
    implements LocalQuickFix {
        private final String myMethodName;

        ReplaceGetNullCheck(String methodName) {
            this.myMethodName = methodName;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = QuickFixBundle.message("java.8.collections.api.inspection.fix.text", this.myMethodName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection$ReplaceGetNullCheck", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("java.8.collections.api.inspection.get.fix.family.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection$ReplaceGetNullCheck", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection$ReplaceGetNullCheck", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection$ReplaceGetNullCheck", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            PsiIfStatement ifStatement = PsiTreeUtil.getParentOfType(element, PsiIfStatement.class);
            if (ifStatement == null) {
                return;
            }
            PsiReferenceExpression value = Java8CollectionsApiInspection.getReferenceComparedWithNull(ifStatement.getCondition());
            if (value == null) {
                return;
            }
            PsiElement statement = PsiTreeUtil.skipSiblingsBackward(ifStatement, PsiWhiteSpace.class, PsiComment.class);
            PsiMethodCallExpression getCall = Java8CollectionsApiInspection.tryExtractMapGetCall(value, statement);
            if (getCall == null || !Java8CollectionsApiInspection.isJavaUtilMapMethodWithName(getCall, "get")) {
                return;
            }
            PsiElement nameElement = getCall.getMethodExpression().getReferenceNameElement();
            if (nameElement == null) {
                return;
            }
            PsiExpression[] args = getCall.getArgumentList().getExpressions();
            if (args.length != 1) {
                return;
            }
            PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            List<PsiComment> comments = ContainerUtil.map(PsiTreeUtil.findChildrenOfType(ifStatement, PsiComment.class), comment -> (PsiComment)comment.copy());
            PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
            if (thenBranch instanceof PsiExpressionStatement) {
                PsiExpression expression = ((PsiExpressionStatement)thenBranch).getExpression();
                if (!(expression instanceof PsiAssignmentExpression)) {
                    return;
                }
                PsiExpression defaultValue = ((PsiAssignmentExpression)expression).getRExpression();
                if (!ExpressionUtils.isSimpleExpression(defaultValue)) {
                    return;
                }
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element.getContainingFile())) {
                    return;
                }
                nameElement.replace(factory.createIdentifier("getOrDefault"));
                getCall.getArgumentList().add(defaultValue);
            } else if (thenBranch instanceof PsiBlockStatement) {
                PsiStatement[] statements = ((PsiBlockStatement)thenBranch).getCodeBlock().getStatements();
                if (statements.length != 2) {
                    return;
                }
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(statements[0]);
                if (assignment == null) {
                    return;
                }
                PsiExpression lambdaCandidate = assignment.getRExpression();
                if (lambdaCandidate == null) {
                    return;
                }
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element.getContainingFile())) {
                    return;
                }
                nameElement.replace(factory.createIdentifier("computeIfAbsent"));
                String varName = JavaCodeStyleManager.getInstance(project).suggestUniqueVariableName("k", (PsiElement)lambdaCandidate, true);
                PsiExpression lambda2 = factory.createExpressionFromText(varName + " -> " + lambdaCandidate.getText(), lambdaCandidate);
                getCall.getArgumentList().add(lambda2);
            } else {
                return;
            }
            ifStatement.delete();
            CodeStyleManager.getInstance(project).reformat(statement);
            comments.forEach(comment -> statement.getParent().addBefore((PsiElement)comment, statement));
        }
    }

    private static class ReplaceWithListSortFix
    implements LocalQuickFix {
        private ReplaceWithListSortFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection$ReplaceWithListSortFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = QuickFixBundle.message("java.8.collections.api.inspection.sort.fix.name", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection$ReplaceWithListSortFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression[] args;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection$ReplaceWithListSortFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/java18api/Java8CollectionsApiInspection$ReplaceWithListSortFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement();
            PsiMethodCallExpression methodCallExpression = PsiTreeUtil.getParentOfType(element, PsiMethodCallExpression.class);
            if (methodCallExpression != null && (args = methodCallExpression.getArgumentList().getExpressions()).length == 2) {
                PsiExpression list = args[0];
                PsiExpression comparator = args[1];
                String replacement = ParenthesesUtils.getText(list, 1) + ".sort(" + comparator.getText() + ")";
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element.getContainingFile())) {
                    return;
                }
                methodCallExpression.replace(JavaPsiFacade.getElementFactory(project).createExpressionFromText(replacement, methodCallExpression));
            }
        }
    }

    private static class ConditionInfo {
        private final PsiExpression myQualifier;
        private final PsiExpression myContainsKey;
        private final boolean myInverted;

        private ConditionInfo(PsiExpression qualifier, PsiExpression containsKey, boolean inverted) {
            this.myQualifier = qualifier;
            this.myContainsKey = containsKey;
            this.myInverted = inverted;
        }

        public PsiExpression getQualifier() {
            return this.myQualifier;
        }

        public PsiExpression getContainsKey() {
            return this.myContainsKey;
        }

        public boolean isInverted() {
            return this.myInverted;
        }
    }
}

