/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefFileImpl;
import com.intellij.codeInspection.reference.RefImplicitConstructorImpl;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefModuleImpl;
import com.intellij.codeInspection.reference.RefPackageImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefClassImpl
extends RefJavaElementImpl
implements RefClass {
    private static final Set<RefElement> EMPTY_SET = Collections.emptySet();
    private static final Set<RefClass> EMPTY_CLASS_SET = Collections.emptySet();
    private static final List<RefMethod> EMPTY_METHOD_LIST = ContainerUtil.emptyList();
    private static final int IS_ANONYMOUS_MASK = 65536;
    private static final int IS_INTERFACE_MASK = 131072;
    private static final int IS_UTILITY_MASK = 262144;
    private static final int IS_ABSTRACT_MASK = 524288;
    private static final int IS_APPLET_MASK = 0x200000;
    private static final int IS_SERVLET_MASK = 0x400000;
    private static final int IS_TESTCASE_MASK = 0x800000;
    private static final int IS_LOCAL_MASK = 0x1000000;
    private Set<RefClass> myBases;
    private Set<RefClass> mySubClasses;
    private List<RefMethod> myConstructors;
    private RefMethodImpl myDefaultConstructor;
    private List<RefMethod> myOverridingMethods;
    private Set<RefElement> myInTypeReferences;
    private Set<RefElement> myInstanceReferences;
    private List<RefJavaElement> myClassExporters;

    RefClassImpl(PsiClass psiClass, RefManager manager) {
        super(psiClass, manager);
    }

    @Override
    protected void initialize() {
        PsiClass applet;
        this.myDefaultConstructor = null;
        PsiClass psiClass = this.getElement();
        LOG.assertTrue(psiClass != null);
        PsiElement psiParent = psiClass.getParent();
        if (psiParent instanceof PsiFile) {
            if (this.isSyntheticJSP()) {
                RefFileImpl refFile = (RefFileImpl)this.getRefManager().getReference(RefClassImpl.getJspFile(psiClass));
                LOG.assertTrue(refFile != null);
                refFile.add(this);
            } else if (psiParent instanceof PsiJavaFile) {
                PsiJavaFile psiFile = (PsiJavaFile)psiParent;
                String packageName = psiFile.getPackageName();
                if (!"".equals(packageName)) {
                    ((RefPackageImpl)this.getRefJavaManager().getPackage(packageName)).add(this);
                } else {
                    ((RefPackageImpl)this.getRefJavaManager().getDefaultPackage()).add(this);
                }
            }
            Module module = ModuleUtilCore.findModuleForPsiElement(psiClass);
            LOG.assertTrue(module != null);
            RefModuleImpl refModule = (RefModuleImpl)this.getRefManager().getRefModule(module);
            LOG.assertTrue(refModule != null);
            refModule.add(this);
        } else {
            while (!(psiParent instanceof PsiClass || psiParent instanceof PsiMethod || psiParent instanceof PsiField)) {
                psiParent = psiParent.getParent();
            }
            RefElement refParent = this.getRefManager().getReference(psiParent);
            LOG.assertTrue(refParent != null);
            ((RefElementImpl)refParent).add(this);
        }
        this.setAbstract(psiClass.hasModifierProperty("abstract"));
        this.setAnonymous(psiClass instanceof PsiAnonymousClass);
        this.setIsLocal(!this.isAnonymous() && !(psiParent instanceof PsiClass) && !(psiParent instanceof PsiFile));
        this.setInterface(psiClass.isInterface());
        this.initializeSuperReferences(psiClass);
        PsiMethod[] psiMethods = psiClass.getMethods();
        PsiField[] psiFields = psiClass.getFields();
        this.setUtilityClass(psiMethods.length > 0 || psiFields.length > 0);
        for (PsiField psiField : psiFields) {
            this.getRefManager().getReference(psiField);
        }
        if (!this.isApplet()) {
            PsiClass servlet = this.getRefJavaManager().getServlet();
            this.setServlet(servlet != null && psiClass.isInheritor(servlet, true));
        }
        if (!this.isApplet() && !this.isServlet()) {
            boolean isTestClass = TestFrameworks.getInstance().isTestClass(psiClass);
            this.setTestCase(isTestClass);
            if (isTestClass) {
                for (RefClass refBase : this.getBaseClasses()) {
                    ((RefClassImpl)refBase).setTestCase(true);
                }
            }
        }
        RefMethod varargConstructor = null;
        for (PsiMethod psiMethod : psiMethods) {
            RefMethod refMethod = (RefMethod)this.getRefManager().getReference(psiMethod);
            if (refMethod == null) continue;
            if (psiMethod.isConstructor()) {
                PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                if (parameters.length > 0 || !psiMethod.hasModifierProperty("private")) {
                    this.setUtilityClass(false);
                }
                this.addConstructor(refMethod);
                if (parameters.length == 0) {
                    this.setDefaultConstructor((RefMethodImpl)refMethod);
                    continue;
                }
                if (parameters.length != 1 || !parameters[0].isVarArgs()) continue;
                varargConstructor = refMethod;
                continue;
            }
            if (psiMethod.hasModifierProperty("static")) continue;
            this.setUtilityClass(false);
        }
        if (varargConstructor != null && this.getDefaultConstructor() == null) {
            this.setDefaultConstructor((RefMethodImpl)varargConstructor);
        }
        if (this.getConstructors().isEmpty() && !this.isInterface() && !this.isAnonymous()) {
            RefImplicitConstructorImpl refImplicitConstructor = new RefImplicitConstructorImpl(this);
            this.setDefaultConstructor(refImplicitConstructor);
            this.addConstructor(refImplicitConstructor);
        }
        if (this.isInterface()) {
            for (int i2 = 0; i2 < psiFields.length && this.isUtilityClass(); ++i2) {
                PsiField psiField = psiFields[i2];
                if (psiField.hasModifierProperty("static")) continue;
                this.setUtilityClass(false);
            }
        }
        this.setApplet((applet = this.getRefJavaManager().getApplet()) != null && psiClass.isInheritor(applet, true));
        PsiManager psiManager = this.getRefManager().getPsiManager();
        psiManager.dropResolveCaches();
        PsiFile file = psiClass.getContainingFile();
        if (file != null) {
            InjectedLanguageManager.getInstance(file.getProject()).dropFileCaches(file);
        }
    }

    private static ServerPageFile getJspFile(PsiClass psiClass) {
        PsiFile psiFile = PsiUtilCore.getTemplateLanguageFile(psiClass);
        return psiFile instanceof ServerPageFile ? (ServerPageFile)psiFile : null;
    }

    private void initializeSuperReferences(PsiClass psiClass) {
        if (!this.isSelfInheritor(psiClass)) {
            for (PsiClass psiSuperClass : psiClass.getSupers()) {
                RefClassImpl refClass;
                if (!this.getRefManager().belongsToScope(psiSuperClass) || (refClass = (RefClassImpl)this.getRefManager().getReference(psiSuperClass)) == null) continue;
                this.addBaseClass(refClass);
                refClass.addSubClass(this);
            }
        }
    }

    @Override
    public boolean isSelfInheritor(PsiClass psiClass) {
        return RefClassImpl.isSelfInheritor(psiClass, new ArrayList<PsiClass>());
    }

    @Override
    @Nullable
    public PsiClass getElement() {
        return (PsiClass)super.getElement();
    }

    private static boolean isSelfInheritor(PsiClass psiClass, ArrayList<PsiClass> visited) {
        if (visited.contains(psiClass)) {
            return true;
        }
        visited.add(psiClass);
        for (PsiClass aSuper : psiClass.getSupers()) {
            if (!RefClassImpl.isSelfInheritor(aSuper, visited)) continue;
            return true;
        }
        visited.remove(psiClass);
        return false;
    }

    private void setDefaultConstructor(RefMethodImpl defaultConstructor) {
        if (defaultConstructor != null) {
            for (RefClass superClass : this.getBaseClasses()) {
                RefMethodImpl superDefaultConstructor = (RefMethodImpl)superClass.getDefaultConstructor();
                if (superDefaultConstructor == null) continue;
                superDefaultConstructor.addInReference(defaultConstructor);
                defaultConstructor.addOutReference(superDefaultConstructor);
            }
        }
        this.myDefaultConstructor = defaultConstructor;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        PsiClass psiClass = this.getElement();
        if (psiClass == null) {
            String string = super.getQualifiedName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getQualifiedName"));
            }
            return string;
        }
        String qName = psiClass.getQualifiedName();
        if (qName == null) {
            String string = super.getQualifiedName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getQualifiedName"));
            }
            return string;
        }
        String string = qName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getQualifiedName"));
        }
        return string;
    }

    @Override
    public void buildReferences() {
        PsiClass psiClass = this.getElement();
        if (psiClass != null) {
            PsiMethod[] psiMethods;
            PsiField[] psiFields;
            for (PsiClassInitializer classInitializer : psiClass.getInitializers()) {
                RefJavaUtil.getInstance().addReferences(psiClass, this, classInitializer.getBody());
            }
            RefJavaUtil.getInstance().addReferences(psiClass, this, psiClass.getModifierList());
            for (PsiField psiField : psiFields = psiClass.getFields()) {
                this.getRefManager().getReference(psiField);
                PsiExpression initializer = psiField.getInitializer();
                if (initializer == null) continue;
                RefJavaUtil.getInstance().addReferences(psiClass, this, initializer);
            }
            for (PsiMethod psiMethod : psiMethods = psiClass.getMethods()) {
                this.getRefManager().getReference(psiMethod);
            }
            RefJavaUtil.getInstance().addReferences(psiClass, this, psiClass.getExtendsList());
            RefJavaUtil.getInstance().addReferences(psiClass, this, psiClass.getImplementsList());
            this.getRefManager().fireBuildReferences(this);
        }
    }

    @Override
    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/reference/RefClassImpl", "accept"));
        }
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (visitor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/codeInspection/reference/RefClassImpl", "lambda$accept$0"));
                }
                ((RefJavaVisitor)visitor).visitClass(this);
            });
        } else {
            super.accept(visitor);
        }
    }

    @Override
    @NotNull
    public Set<RefClass> getBaseClasses() {
        if (this.myBases == null) {
            Set<RefClass> set = EMPTY_CLASS_SET;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getBaseClasses"));
            }
            return set;
        }
        Set<RefClass> set = this.myBases;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getBaseClasses"));
        }
        return set;
    }

    private void addBaseClass(RefClass refClass) {
        if (this.myBases == null) {
            this.myBases = Collections.singleton(refClass);
            return;
        }
        if (this.myBases.size() == 1) {
            this.myBases = new THashSet(this.myBases);
        }
        this.myBases.add(refClass);
    }

    @Override
    @NotNull
    public Set<RefClass> getSubClasses() {
        if (this.mySubClasses == null) {
            Set<RefClass> set = EMPTY_CLASS_SET;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getSubClasses"));
            }
            return set;
        }
        Set<RefClass> set = this.mySubClasses;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getSubClasses"));
        }
        return set;
    }

    private void addSubClass(@NotNull RefClass refClass) {
        if (refClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/codeInspection/reference/RefClassImpl", "addSubClass"));
        }
        if (this.mySubClasses == null) {
            this.mySubClasses = Collections.singleton(refClass);
            return;
        }
        if (this.mySubClasses.size() == 1) {
            this.mySubClasses = new THashSet(this.mySubClasses);
        }
        this.mySubClasses.add(refClass);
    }

    private void removeSubClass(RefClass refClass) {
        if (this.mySubClasses == null) {
            return;
        }
        if (this.mySubClasses.size() == 1) {
            this.mySubClasses = null;
        } else {
            this.mySubClasses.remove(refClass);
        }
    }

    @Override
    @NotNull
    public List<RefMethod> getConstructors() {
        if (this.myConstructors == null) {
            List<RefMethod> list = EMPTY_METHOD_LIST;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getConstructors"));
            }
            return list;
        }
        List<RefMethod> list = this.myConstructors;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getConstructors"));
        }
        return list;
    }

    @Override
    @NotNull
    public Set<RefElement> getInTypeReferences() {
        if (this.myInTypeReferences == null) {
            Set<RefElement> set = EMPTY_SET;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getInTypeReferences"));
            }
            return set;
        }
        Set<RefElement> set = this.myInTypeReferences;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getInTypeReferences"));
        }
        return set;
    }

    public void addTypeReference(RefJavaElement from) {
        if (from != null) {
            if (this.myInTypeReferences == null) {
                this.myInTypeReferences = new THashSet(1);
            }
            this.myInTypeReferences.add(from);
            ((RefJavaElementImpl)from).addOutTypeRefernce(this);
            this.getRefManager().fireNodeMarkedReferenced(this, from, false, false, false);
        }
    }

    @Override
    @NotNull
    public Set<RefElement> getInstanceReferences() {
        if (this.myInstanceReferences == null) {
            Set<RefElement> set = EMPTY_SET;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getInstanceReferences"));
            }
            return set;
        }
        Set<RefElement> set = this.myInstanceReferences;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getInstanceReferences"));
        }
        return set;
    }

    public void addInstanceReference(RefElement from) {
        if (this.myInstanceReferences == null) {
            this.myInstanceReferences = new THashSet(1);
        }
        this.myInstanceReferences.add(from);
    }

    @Override
    public RefMethod getDefaultConstructor() {
        return this.myDefaultConstructor;
    }

    private void addConstructor(RefMethod refConstructor) {
        if (this.myConstructors == null) {
            this.myConstructors = new ArrayList<RefMethod>(1);
        }
        this.myConstructors.add(refConstructor);
    }

    public void addLibraryOverrideMethod(RefMethod refMethod) {
        if (this.myOverridingMethods == null) {
            this.myOverridingMethods = new ArrayList<RefMethod>(2);
        }
        this.myOverridingMethods.add(refMethod);
    }

    @Override
    @NotNull
    public List<RefMethod> getLibraryMethods() {
        if (this.myOverridingMethods == null) {
            List<RefMethod> list = EMPTY_METHOD_LIST;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getLibraryMethods"));
            }
            return list;
        }
        List<RefMethod> list = this.myOverridingMethods;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getLibraryMethods"));
        }
        return list;
    }

    @Override
    public boolean isAnonymous() {
        return this.checkFlag(65536L);
    }

    @Override
    public boolean isInterface() {
        return this.checkFlag(131072L);
    }

    @Override
    public boolean isSuspicious() {
        return (!this.isUtilityClass() || !this.getOutReferences().isEmpty()) && super.isSuspicious();
    }

    @Override
    public boolean isUtilityClass() {
        return this.checkFlag(262144L);
    }

    @Override
    public String getExternalName() {
        String[] result = new String[1];
        ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass psiClass = this.getElement();
            LOG.assertTrue(psiClass != null);
            result[0] = PsiFormatUtil.getExternalName(psiClass);
        });
        return result[0];
    }

    @Nullable
    public static RefClass classFromExternalName(RefManager manager, String externalName) {
        return (RefClass)manager.getReference(ClassUtil.findPsiClass(PsiManager.getInstance(manager.getProject()), externalName));
    }

    @Override
    public void referenceRemoved() {
        super.referenceRemoved();
        for (RefClass subClass : this.getSubClasses()) {
            ((RefClassImpl)subClass).removeBase(this);
        }
        for (RefClass superClass : this.getBaseClasses()) {
            ((RefClassImpl)superClass).removeSubClass(this);
        }
    }

    private void removeBase(RefClass superClass) {
        Set<RefClass> baseClasses = this.getBaseClasses();
        if (baseClasses.contains(superClass)) {
            if (baseClasses.size() == 1) {
                this.myBases = null;
                return;
            }
            baseClasses.remove(superClass);
        }
    }

    protected void methodRemoved(RefMethod method) {
        this.getConstructors().remove(method);
        this.getLibraryMethods().remove(method);
        if (this.getDefaultConstructor() == method) {
            this.setDefaultConstructor(null);
        }
    }

    @Override
    public boolean isAbstract() {
        return this.checkFlag(524288L);
    }

    @Override
    public boolean isApplet() {
        return this.checkFlag(0x200000L);
    }

    @Override
    public boolean isServlet() {
        return this.checkFlag(0x400000L);
    }

    @Override
    public boolean isTestCase() {
        return this.checkFlag(0x800000L);
    }

    @Override
    public boolean isLocalClass() {
        return this.checkFlag(0x1000000L);
    }

    @Override
    public boolean isReferenced() {
        if (super.isReferenced()) {
            return true;
        }
        return (this.isInterface() || this.isAbstract()) && !this.getSubClasses().isEmpty();
    }

    @Override
    public boolean hasSuspiciousCallers() {
        if (super.hasSuspiciousCallers()) {
            return true;
        }
        return (this.isInterface() || this.isAbstract()) && !this.getSubClasses().isEmpty();
    }

    public void addClassExporter(RefJavaElement exporter) {
        if (this.myClassExporters == null) {
            this.myClassExporters = new ArrayList<RefJavaElement>(1);
        }
        if (this.myClassExporters.contains(exporter)) {
            return;
        }
        this.myClassExporters.add(exporter);
    }

    public List<RefJavaElement> getClassExporters() {
        return this.myClassExporters;
    }

    private void setAnonymous(boolean anonymous) {
        this.setFlag(anonymous, 65536L);
    }

    private void setInterface(boolean anInterface) {
        this.setFlag(anInterface, 131072L);
    }

    private void setUtilityClass(boolean utilityClass) {
        this.setFlag(utilityClass, 262144L);
    }

    private void setAbstract(boolean anAbstract) {
        this.setFlag(anAbstract, 524288L);
    }

    private void setApplet(boolean applet) {
        this.setFlag(applet, 0x200000L);
    }

    private void setServlet(boolean servlet) {
        this.setFlag(servlet, 0x400000L);
    }

    private void setTestCase(boolean testCase) {
        this.setFlag(testCase, 0x800000L);
    }

    private void setIsLocal(boolean isLocal) {
        this.setFlag(isLocal, 0x1000000L);
    }

    @Override
    @NotNull
    public RefElement getContainingEntry() {
        RefMethod defaultConstructor = this.getDefaultConstructor();
        if (defaultConstructor != null) {
            RefMethod refMethod = defaultConstructor;
            if (refMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getContainingEntry"));
            }
            return refMethod;
        }
        RefElement refElement = super.getContainingEntry();
        if (refElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefClassImpl", "getContainingEntry"));
        }
        return refElement;
    }
}

