/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.streamMigration.MigrateToStreamFix;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ReplaceWithFindFirstFix
extends MigrateToStreamFix {
    ReplaceWithFindFirstFix() {
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Replace with findFirst()" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "getFamilyName"));
        }
        return "Replace with findFirst()";
    }

    @Override
    void migrate(@NotNull Project project, @NotNull ProblemDescriptor descriptor, @NotNull PsiForeachStatement foreachStatement, @NotNull PsiExpression iteratedValue, @NotNull PsiStatement body, @NotNull StreamApiMigrationInspection.TerminalBlock tb, @NotNull List<StreamApiMigrationInspection.Operation> operations) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        if (foreachStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreachStatement", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        if (iteratedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iteratedValue", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        if (operations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operations", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "migrate"));
        }
        PsiStatement statement = tb.getSingleStatement();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
        String stream = ReplaceWithFindFirstFix.generateStream(iteratedValue, operations).append(".findFirst()").toString();
        if (statement instanceof PsiReturnStatement) {
            PsiReturnStatement returnStatement = (PsiReturnStatement)statement;
            PsiExpression value = returnStatement.getReturnValue();
            if (value == null) {
                return;
            }
            PsiReturnStatement nextReturnStatement = StreamApiMigrationInspection.getNextReturnStatement(foreachStatement);
            if (nextReturnStatement == null) {
                return;
            }
            PsiExpression orElseExpression = nextReturnStatement.getReturnValue();
            if (!ExpressionUtils.isSimpleExpression(orElseExpression)) {
                return;
            }
            stream = ReplaceWithFindFirstFix.generateOptionalUnwrap(stream, tb, value, orElseExpression);
            ReplaceWithFindFirstFix.restoreComments(foreachStatement, body);
            boolean siblings = nextReturnStatement.getParent() == foreachStatement.getParent();
            PsiElement result = foreachStatement.replace(elementFactory.createStatementFromText("return " + stream + ";", foreachStatement));
            if (siblings) {
                nextReturnStatement.delete();
            }
            ReplaceWithFindFirstFix.simplifyAndFormat(project, result);
        } else {
            PsiExpression initializer;
            PsiStatement[] statements = tb.getStatements();
            if (statements.length != 2) {
                return;
            }
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment(statements[0]);
            if (assignment == null) {
                return;
            }
            PsiExpression lValue = assignment.getLExpression();
            if (!(lValue instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement element = ((PsiReferenceExpression)lValue).resolve();
            if (!(element instanceof PsiVariable)) {
                return;
            }
            PsiVariable var = (PsiVariable)element;
            PsiExpression value = assignment.getRExpression();
            if (value == null) {
                return;
            }
            ReplaceWithFindFirstFix.restoreComments(foreachStatement, body);
            if (StreamApiMigrationInspection.isDeclarationJustBefore(var, foreachStatement) && (initializer = var.getInitializer()) != null) {
                PsiElement result = initializer.replace(elementFactory.createExpressionFromText(ReplaceWithFindFirstFix.generateOptionalUnwrap(stream, tb, value, initializer), initializer));
                ReplaceWithFindFirstFix.removeLoop(foreachStatement);
                ReplaceWithFindFirstFix.simplifyAndFormat(project, result);
                return;
            }
            PsiElement result = foreachStatement.replace(elementFactory.createStatementFromText(var.getName() + " = " + ReplaceWithFindFirstFix.generateOptionalUnwrap(stream, tb, value, lValue) + ";", foreachStatement));
            ReplaceWithFindFirstFix.simplifyAndFormat(project, result);
        }
    }

    private static String generateOptionalUnwrap(String stream, @NotNull StreamApiMigrationInspection.TerminalBlock tb, PsiExpression trueExpression, PsiExpression falseExpression) {
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/ReplaceWithFindFirstFix", "generateOptionalUnwrap"));
        }
        PsiVariable var = tb.getVariable();
        if (!StreamApiMigrationInspection.isIdentityMapping(var, trueExpression)) {
            PsiTypeCastExpression castExpression;
            PsiTypeElement castType;
            if (trueExpression instanceof PsiTypeCastExpression && ExpressionUtils.isNullLiteral(falseExpression) && (castType = (castExpression = (PsiTypeCastExpression)trueExpression).getCastType()) != null && StreamApiMigrationInspection.isIdentityMapping(var, castExpression.getOperand())) {
                return "(" + castType.getText() + ")" + stream + ".orElse(null)";
            }
            stream = stream + ".map(" + StreamApiMigrationInspection.createLambda(var, trueExpression) + ")";
        }
        stream = stream + ".orElse(" + falseExpression.getText() + ")";
        return stream;
    }
}

