/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.streamMigration.MigrateToStreamFix;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiStatement;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ReplaceWithForeachCallFix
extends MigrateToStreamFix {
    private static final Logger LOG = Logger.getInstance("#" + ReplaceWithForeachCallFix.class.getName());
    private final String myForEachMethodName;

    protected ReplaceWithForeachCallFix(String forEachMethodName) {
        this.myForEachMethodName = forEachMethodName;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = "Replace with " + this.myForEachMethodName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/streamMigration/ReplaceWithForeachCallFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    void migrate(@NotNull Project project, @NotNull ProblemDescriptor descriptor, @NotNull PsiForeachStatement foreachStatement, @NotNull PsiExpression iteratedValue, @NotNull PsiStatement body, @NotNull StreamApiMigrationInspection.TerminalBlock tb, @NotNull List<StreamApiMigrationInspection.Operation> operations) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/streamMigration/ReplaceWithForeachCallFix", "migrate"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/streamMigration/ReplaceWithForeachCallFix", "migrate"));
        }
        if (foreachStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreachStatement", "com/intellij/codeInspection/streamMigration/ReplaceWithForeachCallFix", "migrate"));
        }
        if (iteratedValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iteratedValue", "com/intellij/codeInspection/streamMigration/ReplaceWithForeachCallFix", "migrate"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "com/intellij/codeInspection/streamMigration/ReplaceWithForeachCallFix", "migrate"));
        }
        if (tb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tb", "com/intellij/codeInspection/streamMigration/ReplaceWithForeachCallFix", "migrate"));
        }
        if (operations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operations", "com/intellij/codeInspection/streamMigration/ReplaceWithForeachCallFix", "migrate"));
        }
        ReplaceWithForeachCallFix.restoreComments(foreachStatement, body);
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(project);
        StringBuilder buffer = ReplaceWithForeachCallFix.generateStream(iteratedValue, operations, true);
        PsiElement block = tb.convertToElement(elementFactory);
        buffer.append(".").append(this.myForEachMethodName).append("(");
        String functionalExpressionText = tb.getVariable().getName() + " -> " + ReplaceWithForeachCallFix.wrapInBlock(block);
        PsiExpressionStatement callStatement = (PsiExpressionStatement)elementFactory.createStatementFromText(buffer.toString() + functionalExpressionText + ");", foreachStatement);
        callStatement = (PsiExpressionStatement)foreachStatement.replace(callStatement);
        PsiExpressionList argumentList = ((PsiCallExpression)callStatement.getExpression()).getArgumentList();
        LOG.assertTrue(argumentList != null, callStatement.getText());
        PsiExpression[] expressions = argumentList.getExpressions();
        LOG.assertTrue(expressions.length == 1);
        if (expressions[0] instanceof PsiFunctionalExpression && ((PsiFunctionalExpression)expressions[0]).getFunctionalInterfaceType() == null) {
            callStatement = (PsiExpressionStatement)callStatement.replace(elementFactory.createStatementFromText(buffer.toString() + "(" + tb.getVariable().getText() + ") -> " + ReplaceWithForeachCallFix.wrapInBlock(block) + ");", callStatement));
        }
        ReplaceWithForeachCallFix.simplifyAndFormat(project, callStatement);
    }

    private static String wrapInBlock(PsiElement block) {
        if (block instanceof PsiExpressionStatement) {
            return ((PsiExpressionStatement)block).getExpression().getText();
        }
        if (block instanceof PsiCodeBlock) {
            return block.getText();
        }
        return "{" + block.getText() + "}";
    }
}

