/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.ColorBlindness;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import java.awt.image.ImageFilter;
import java.util.EnumMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorBlindnessSupport {
    @NotNull
    public static ColorBlindnessSupport get() {
        ColorBlindnessSupport colorBlindnessSupport = Lazy.VALUE;
        if (colorBlindnessSupport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/ui/ColorBlindnessSupport", "get"));
        }
        return colorBlindnessSupport;
    }

    @Nullable
    public String getDisplayName(@NotNull ColorBlindness blindness) {
        if (blindness == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blindness", "com/intellij/ide/ui/ColorBlindnessSupport", "getDisplayName"));
        }
        return ColorBlindness.deuteranopia.equals((Object)blindness) ? blindness.name() : null;
    }

    @Nullable
    public ImageFilter getFilter(@Nullable ColorBlindness blindness) {
        return null;
    }

    private static final class Lazy
    extends ColorBlindnessSupport {
        private static final ColorBlindnessSupport VALUE = Lazy.create();
        private final EnumMap<ColorBlindness, ColorBlindnessSupport> myMap;

        private static ColorBlindnessSupport create() {
            ColorBlindnessSupport[] extensions = (ColorBlindnessSupport[])Extensions.getExtensions("com.intellij.supportColorBlindness");
            if (extensions.length == 1) {
                return extensions[0];
            }
            if (extensions.length > 0) {
                Logger logger = Logger.getInstance(ColorBlindnessSupport.class);
                EnumMap<ColorBlindness, ColorBlindnessSupport> map = new EnumMap<ColorBlindness, ColorBlindnessSupport>(ColorBlindness.class);
                for (ColorBlindness blindness : ColorBlindness.values()) {
                    ColorBlindnessSupport support = null;
                    for (ColorBlindnessSupport ext : extensions) {
                        if (support != null || ext.getDisplayName(blindness) == null) continue;
                        support = ext;
                    }
                    if (support == null) continue;
                    map.put(blindness, support);
                    if (logger.isDebugEnabled()) {
                        logger.debug(Lazy.toString("use", blindness, support));
                    }
                    for (ColorBlindnessSupport ext : extensions) {
                        if (support == ext || ext.getDisplayName(blindness) == null) continue;
                        logger.warn(Lazy.toString("ignore", blindness, ext));
                    }
                }
                if (!map.isEmpty()) {
                    return new Lazy(map);
                }
            }
            return new ColorBlindnessSupport();
        }

        private static String toString(String prefix, ColorBlindness blindness, ColorBlindnessSupport support) {
            return prefix + " " + blindness.name() + " from " + support.getClass();
        }

        private Lazy(EnumMap<ColorBlindness, ColorBlindnessSupport> map) {
            this.myMap = map;
        }

        @Override
        @Nullable
        public String getDisplayName(@NotNull ColorBlindness blindness) {
            if (blindness == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blindness", "com/intellij/ide/ui/ColorBlindnessSupport$Lazy", "getDisplayName"));
            }
            ColorBlindnessSupport support = this.myMap.get((Object)blindness);
            return support == null ? null : support.getDisplayName(blindness);
        }

        @Override
        @Nullable
        public ImageFilter getFilter(@Nullable ColorBlindness blindness) {
            if (blindness == null) {
                return null;
            }
            ColorBlindnessSupport support = this.myMap.get((Object)blindness);
            return support == null ? null : support.getFilter(blindness);
        }
    }
}

