/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.search.BulkOccurrenceProcessor;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchRequest;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.search.UseScopeOptimizer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSearchHelperImpl
implements PsiSearchHelper {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.search.PsiSearchHelperImpl");
    private final PsiManagerEx myManager;

    @Override
    @NotNull
    public SearchScope getUseScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getUseScope"));
        }
        SearchScope scope = element.getUseScope();
        for (UseScopeEnlarger enlarger : UseScopeEnlarger.EP_NAME.getExtensions()) {
            SearchScope additionalScope = enlarger.getAdditionalUseScope(element);
            if (additionalScope == null) continue;
            scope = scope.union(additionalScope);
        }
        for (UseScopeOptimizer optimizer : UseScopeOptimizer.EP_NAME.getExtensions()) {
            GlobalSearchScope scopeToExclude = optimizer.getScopeToExclude(element);
            if (scopeToExclude == null) continue;
            scope = scope.intersectWith(GlobalSearchScope.notScope(scopeToExclude));
        }
        SearchScope searchScope = scope;
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getUseScope"));
        }
        return searchScope;
    }

    public PsiSearchHelperImpl(@NotNull PsiManagerEx manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "<init>"));
        }
        this.myManager = manager;
    }

    @Override
    @NotNull
    public PsiElement[] findCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "findCommentsContainingIdentifier"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "findCommentsContainingIdentifier"));
        }
        List result = Collections.synchronizedList(new ArrayList());
        Processor<PsiElement> processor = Processors.cancelableCollectProcessor(result);
        this.processCommentsContainingIdentifier(identifier, searchScope, processor);
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "findCommentsContainingIdentifier"));
        }
        return psiElementArray;
    }

    @Override
    public boolean processCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, @NotNull Processor<PsiElement> processor) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processCommentsContainingIdentifier"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processCommentsContainingIdentifier"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processCommentsContainingIdentifier"));
        }
        TextOccurenceProcessor occurrenceProcessor = (element, offsetInElement) -> {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processCommentsContainingIdentifier$0"));
            }
            if (CommentUtilCore.isCommentTextElement(element) && element.findReferenceAt(offsetInElement) == null) {
                return processor.process(element);
            }
            return true;
        };
        return this.processElementsWithWord(occurrenceProcessor, searchScope, identifier, (short)2, true);
    }

    @Override
    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitive) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        return this.processElementsWithWord(processor, searchScope, text, searchContext, caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
    }

    @Override
    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitive, boolean processInjectedPsi) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        EnumSet<Options> options = EnumSet.of(Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (caseSensitive) {
            options.add(Options.CASE_SENSITIVE_SEARCH);
        }
        if (processInjectedPsi) {
            options.add(Options.PROCESS_INJECTED_PSI);
        }
        return this.processElementsWithWord(processor, searchScope, text, searchContext, options, null);
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> processElementsWithWordAsync(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, boolean caseSensitively) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWordAsync"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWordAsync"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWordAsync"));
        }
        boolean result = this.processElementsWithWord(processor, searchScope, text, searchContext, caseSensitively, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
        AsyncFuture<Boolean> asyncFuture = AsyncUtil.wrapBoolean(result);
        if (asyncFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWordAsync"));
        }
        return asyncFuture;
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor, @NotNull SearchScope searchScope, @NotNull String text, short searchContext, @NotNull EnumSet<Options> options, @Nullable String containerName) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithWord"));
        }
        return this.bulkProcessElementsWithWord(searchScope, text, searchContext, options, containerName, (scope, offsetsInScope, searcher) -> {
            if (options == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processElementsWithWord$1"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processElementsWithWord$1"));
            }
            return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, options.contains((Object)Options.PROCESS_INJECTED_PSI), PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, processor);
        });
    }

    private boolean bulkProcessElementsWithWord(@NotNull SearchScope searchScope, @NotNull String text, short searchContext, @NotNull EnumSet<Options> options, @Nullable String containerName, final @NotNull BulkOccurrenceProcessor processor) {
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "bulkProcessElementsWithWord"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "bulkProcessElementsWithWord"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "bulkProcessElementsWithWord"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "bulkProcessElementsWithWord"));
        }
        if (text.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text");
        }
        final ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        if (searchScope instanceof GlobalSearchScope) {
            StringSearcher searcher = new StringSearcher(text, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
            return this.processElementsWithTextInGlobalScope(processor, (GlobalSearchScope)searchScope, searcher, searchContext, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), containerName, progress);
        }
        LocalSearchScope scope = (LocalSearchScope)searchScope;
        PsiElement[] scopeElements = scope.getScope();
        final StringSearcher searcher = new StringSearcher(text, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
        ReadActionProcessor<PsiElement> localProcessor = new ReadActionProcessor<PsiElement>(){

            @Override
            public boolean processInReadAction(PsiElement scopeElement) {
                if (!scopeElement.isValid()) {
                    return true;
                }
                if (!scopeElement.isPhysical()) {
                    scopeElement = scopeElement.getNavigationElement();
                }
                if (scopeElement.getTextRange() == null) {
                    LOG.debug("Element " + scopeElement + " of class " + scopeElement.getClass() + " has null range");
                    return true;
                }
                return processor.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher, progress), searcher);
            }

            public String toString() {
                return processor.toString();
            }
        };
        return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(scopeElements), progress, true, true, localProcessor);
    }

    @NotNull
    private static ProgressIndicator getOrCreateIndicator() {
        ProgressIndicator progress = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress == null) {
            progress = new EmptyProgressIndicator();
        }
        ProgressIndicator progressIndicator = progress;
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getOrCreateIndicator"));
        }
        return progressIndicator;
    }

    static boolean shouldProcessInjectedPsi(@NotNull SearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "shouldProcessInjectedPsi"));
        }
        return !(scope instanceof LocalSearchScope) || !((LocalSearchScope)scope).isIgnoreInjectedPsi();
    }

    @NotNull
    private static Processor<PsiElement> localProcessor(final @NotNull BulkOccurrenceProcessor processor, final @NotNull ProgressIndicator progress, final @NotNull StringSearcher searcher) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "localProcessor"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "localProcessor"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "localProcessor"));
        }
        ReadActionProcessor<PsiElement> readActionProcessor = new ReadActionProcessor<PsiElement>(){

            @Override
            public boolean processInReadAction(PsiElement scopeElement) {
                return scopeElement.isValid() && processor.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher, progress), searcher);
            }

            public String toString() {
                return processor.toString();
            }
        };
        if (readActionProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "localProcessor"));
        }
        return readActionProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processElementsWithTextInGlobalScope(@NotNull BulkOccurrenceProcessor processor, @NotNull GlobalSearchScope scope, @NotNull StringSearcher searcher, short searchContext, boolean caseSensitively, @Nullable String containerName, @NotNull ProgressIndicator progress) {
        boolean result;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithTextInGlobalScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithTextInGlobalScope"));
        }
        if (searcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithTextInGlobalScope"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processElementsWithTextInGlobalScope"));
        }
        if (Thread.holdsLock(PsiLock.LOCK)) {
            throw new AssertionError((Object)"You must not run search from within updating PSI activity. Please consider invokeLatering it instead.");
        }
        progress.pushState();
        try {
            progress.setText(PsiBundle.message("psi.scanning.files.progress", new Object[0]));
            String text = searcher.getPattern();
            THashSet fileSet = new THashSet();
            this.getFilesWithText(scope, searchContext, caseSensitively, text, (Collection<VirtualFile>)fileSet);
            progress.setText(PsiBundle.message("psi.search.for.word.progress", text));
            Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(processor, progress, searcher);
            if (containerName != null) {
                ArrayList<VirtualFile> intersectionWithContainerFiles = new ArrayList<VirtualFile>();
                this.getFilesWithText(scope, searchContext, caseSensitively, text + " " + containerName, intersectionWithContainerFiles);
                if (!intersectionWithContainerFiles.isEmpty()) {
                    int totalSize = fileSet.size();
                    boolean result2 = this.processPsiFileRoots(intersectionWithContainerFiles, totalSize, 0, progress, localProcessor);
                    if (result2) {
                        fileSet.removeAll(intersectionWithContainerFiles);
                        if (!fileSet.isEmpty()) {
                            result2 = this.processPsiFileRoots(new ArrayList<VirtualFile>((Collection<VirtualFile>)fileSet), totalSize, intersectionWithContainerFiles.size(), progress, localProcessor);
                        }
                    }
                    boolean bl = result2;
                    return bl;
                }
            }
            result = fileSet.isEmpty() || this.processPsiFileRoots(new ArrayList<VirtualFile>((Collection<VirtualFile>)fileSet), fileSet.size(), 0, progress, localProcessor);
        }
        finally {
            progress.popState();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processPsiFileRoots(@NotNull List<VirtualFile> files, int totalSize, int alreadyProcessedFiles, @NotNull ProgressIndicator progress, @NotNull Processor<? super PsiFile> localProcessor) {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processPsiFileRoots"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processPsiFileRoots"));
        }
        if (localProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localProcessor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processPsiFileRoots"));
        }
        this.myManager.startBatchFilesProcessingMode();
        try {
            AtomicInteger counter = new AtomicInteger(alreadyProcessedFiles);
            AtomicBoolean canceled = new AtomicBoolean(false);
            boolean completed = true;
            while (true) {
                SmartList<VirtualFile> failedList = new SmartList<VirtualFile>();
                List failedFiles = Collections.synchronizedList(failedList);
                Processor<VirtualFile> processor = vfile -> {
                    if (progress == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processPsiFileRoots$2"));
                    }
                    if (localProcessor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localProcessor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processPsiFileRoots$2"));
                    }
                    try {
                        TooManyUsagesStatus.getFrom(progress).pauseProcessingIfTooManyUsages();
                        this.processVirtualFile((VirtualFile)vfile, progress, localProcessor, canceled, counter, totalSize);
                    }
                    catch (ApplicationUtil.CannotRunReadActionException action) {
                        failedFiles.add(vfile);
                    }
                    return !canceled.get();
                };
                completed = ApplicationManager.getApplication().isWriteAccessAllowed() || ((ApplicationEx)ApplicationManager.getApplication()).isWriteActionPending() ? (completed &= ContainerUtil.process(files, processor)) : (completed &= JobLauncher.getInstance().invokeConcurrentlyUnderProgress(files, progress, false, false, processor));
                if (failedFiles.isEmpty()) break;
                DumbService.getInstance(this.myManager.getProject()).runReadActionInSmartMode(EmptyRunnable.getInstance());
                files = failedList;
            }
            boolean bl = completed;
            return bl;
        }
        finally {
            this.myManager.finishBatchFilesProcessingMode();
        }
    }

    private void processVirtualFile(@NotNull VirtualFile vfile, @NotNull ProgressIndicator progress, @NotNull Processor<? super PsiFile> localProcessor, @NotNull AtomicBoolean canceled, @NotNull AtomicInteger counter, int totalSize) throws ApplicationUtil.CannotRunReadActionException {
        if (vfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfile", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processVirtualFile"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processVirtualFile"));
        }
        if (localProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localProcessor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processVirtualFile"));
        }
        if (canceled == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canceled", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processVirtualFile"));
        }
        if (counter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "counter", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processVirtualFile"));
        }
        PsiFile file = ApplicationUtil.tryRunReadAction(() -> {
            if (vfile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vfile", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processVirtualFile$3"));
            }
            return vfile.isValid() ? this.myManager.findFile(vfile) : null;
        });
        if (file != null && !(file instanceof PsiBinaryFile)) {
            if (FileDocumentManager.getInstance().getCachedDocument(vfile) == null) {
                try {
                    vfile.contentsToByteArray();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ApplicationUtil.tryRunReadAction(() -> {
                if (progress == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processVirtualFile$4"));
                }
                if (localProcessor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localProcessor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processVirtualFile$4"));
                }
                if (canceled == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canceled", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processVirtualFile$4"));
                }
                Project project = this.myManager.getProject();
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                if (DumbService.isDumb(project)) {
                    throw new ApplicationUtil.CannotRunReadActionException();
                }
                List<PsiFile> psiRoots = file.getViewProvider().getAllFiles();
                THashSet processed2 = new THashSet(psiRoots.size() * 2, 0.5f);
                for (PsiFile psiRoot : psiRoots) {
                    progress.checkCanceled();
                    assert (psiRoot != null) : "One of the roots of file " + file + " is null. All roots: " + psiRoots + "; ViewProvider: " + file.getViewProvider() + "; Virtual file: " + file.getViewProvider().getVirtualFile();
                    if (!processed2.add(psiRoot) || !psiRoot.isValid() || localProcessor.process(psiRoot)) continue;
                    canceled.set(true);
                    break;
                }
            });
        }
        if (progress.isRunning()) {
            double fraction = (double)counter.incrementAndGet() / (double)totalSize;
            progress.setFraction(fraction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text, @NotNull Collection<VirtualFile> result) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getFilesWithText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getFilesWithText"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getFilesWithText"));
        }
        this.myManager.startBatchFilesProcessingMode();
        try {
            Processor<VirtualFile> processor = Processors.cancelableCollectProcessor(result);
            boolean bl = this.processFilesWithText(scope, searchContext, caseSensitively, text, processor);
        }
        finally {
            this.myManager.finishBatchFilesProcessingMode();
        }
    }

    public boolean processFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text, @NotNull Processor<VirtualFile> processor) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processFilesWithText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processFilesWithText"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processFilesWithText"));
        }
        List<IdIndexEntry> entries = PsiSearchHelperImpl.getWordEntries(text, caseSensitively);
        if (entries.isEmpty()) {
            return true;
        }
        Condition<Integer> contextMatches = integer -> (integer & searchContext) != 0;
        return PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, contextMatches, entries, processor);
    }

    @Override
    @NotNull
    public PsiFile[] findFilesWithPlainTextWords(@NotNull String word) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "findFilesWithPlainTextWords"));
        }
        PsiFile[] psiFileArray = CacheManager.SERVICE.getInstance(this.myManager.getProject()).getFilesWithWord(word, (short)16, GlobalSearchScope.projectScope(this.myManager.getProject()), true);
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "findFilesWithPlainTextWords"));
        }
        return psiFileArray;
    }

    @Override
    public boolean processUsagesInNonJavaFiles(@NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor, @NotNull GlobalSearchScope searchScope) {
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processUsagesInNonJavaFiles"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processUsagesInNonJavaFiles"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processUsagesInNonJavaFiles"));
        }
        return this.processUsagesInNonJavaFiles(null, qName, processor, searchScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processUsagesInNonJavaFiles(final @Nullable PsiElement originalElement, @NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor, final @NotNull GlobalSearchScope initialScope) {
        int dollarIndex;
        if (qName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qName", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processUsagesInNonJavaFiles"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processUsagesInNonJavaFiles"));
        }
        if (initialScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialScope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processUsagesInNonJavaFiles"));
        }
        if (qName.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text. Element: " + originalElement + "; " + (originalElement == null ? null : originalElement.getClass()));
        }
        ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        int dotIndex = qName.lastIndexOf(46);
        int maxIndex = Math.max(dotIndex, dollarIndex = qName.lastIndexOf(36));
        final String wordToSearch = maxIndex >= 0 ? qName.substring(maxIndex + 1) : qName;
        final GlobalSearchScope theSearchScope = ApplicationManager.getApplication().runReadAction(new Computable<GlobalSearchScope>(){

            @Override
            public GlobalSearchScope compute() {
                if (originalElement != null && PsiSearchHelperImpl.this.myManager.isInProject(originalElement) && initialScope.isSearchInLibraries()) {
                    return initialScope.intersectWith(GlobalSearchScope.projectScope(PsiSearchHelperImpl.this.myManager.getProject()));
                }
                return initialScope;
            }
        });
        PsiFile[] files = ApplicationManager.getApplication().runReadAction(new Computable<PsiFile[]>(){

            @Override
            public PsiFile[] compute() {
                return CacheManager.SERVICE.getInstance(PsiSearchHelperImpl.this.myManager.getProject()).getFilesWithWord(wordToSearch, (short)16, theSearchScope, true);
            }
        });
        StringSearcher searcher = new StringSearcher(qName, true, true, false);
        progress.pushState();
        Ref<Boolean> cancelled = Ref.create(Boolean.FALSE);
        try {
            progress.setText(PsiBundle.message("psi.search.in.non.java.files.progress", new Object[0]));
            final SearchScope useScope = originalElement == null ? null : ApplicationManager.getApplication().runReadAction(new Computable<SearchScope>(){

                @Override
                public SearchScope compute() {
                    return PsiSearchHelperImpl.this.getUseScope(originalElement);
                }
            });
            int patternLength = qName.length();
            for (int i2 = 0; i2 < files.length; ++i2) {
                progress.checkCanceled();
                final PsiFile psiFile = files[i2];
                if (psiFile instanceof PsiBinaryFile) continue;
                CharSequence text = ApplicationManager.getApplication().runReadAction(new Computable<CharSequence>(){

                    @Override
                    public CharSequence compute() {
                        return psiFile.getViewProvider().getContents();
                    }
                });
                LowLevelSearchUtil.processTextOccurrences(text, 0, text.length(), searcher, progress, index -> {
                    if (initialScope == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialScope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processUsagesInNonJavaFiles$6"));
                    }
                    if (processor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processUsagesInNonJavaFiles$6"));
                    }
                    boolean isReferenceOK = ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                        @Override
                        public Boolean compute() {
                            PsiReference referenceAt = psiFile.findReferenceAt(index);
                            return referenceAt == null || useScope == null || !PsiSearchScopeUtil.isInScope(useScope.intersectWith(initialScope), (PsiElement)psiFile);
                        }
                    });
                    if (isReferenceOK && !processor.process(psiFile, index, index + patternLength)) {
                        cancelled.set(Boolean.TRUE);
                        return false;
                    }
                    return true;
                });
                if (cancelled.get().booleanValue()) {
                    break;
                }
                progress.setFraction((double)(i2 + 1) / (double)files.length);
            }
        }
        finally {
            progress.popState();
        }
        return cancelled.get() == false;
    }

    @Override
    public boolean processAllFilesWithWord(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor, boolean caseSensitively) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWord"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWord"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWord"));
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)1, scope, caseSensitively);
    }

    @Override
    public boolean processAllFilesWithWordInText(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor, boolean caseSensitively) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInText"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInText"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInText"));
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)16, scope, caseSensitively);
    }

    @Override
    public boolean processAllFilesWithWordInComments(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInComments"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInComments"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInComments"));
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)2, scope, true);
    }

    @Override
    public boolean processAllFilesWithWordInLiterals(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiFile> processor) {
        if (word == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInLiterals"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInLiterals"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processAllFilesWithWordInLiterals"));
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor, word, (short)4, scope, true);
    }

    @Override
    public boolean processRequests(@NotNull SearchRequestCollector collector, @NotNull Processor<PsiReference> processor) {
        boolean result;
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processRequests"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processRequests"));
        }
        HashMap<SearchRequestCollector, Processor<PsiReference>> collectors = ContainerUtil.newHashMap();
        collectors.put(collector, processor);
        ProgressIndicator progress = PsiSearchHelperImpl.getOrCreateIndicator();
        PsiSearchHelperImpl.appendCollectorsFromQueryRequests(collectors);
        do {
            RequestWithProcessor local;
            MultiMap<Set<IdIndexEntry>, RequestWithProcessor> globals = new MultiMap<Set<IdIndexEntry>, RequestWithProcessor>();
            ArrayList<Computable<Boolean>> customs = ContainerUtil.newArrayList();
            LinkedHashSet<RequestWithProcessor> locals = ContainerUtil.newLinkedHashSet();
            THashMap localProcessors = new THashMap();
            PsiSearchHelperImpl.distributePrimitives(collectors, locals, globals, customs, (Map<RequestWithProcessor, Processor<PsiElement>>)localProcessors, progress);
            result = this.processGlobalRequestsOptimized(globals, progress, (Map<RequestWithProcessor, Processor<PsiElement>>)localProcessors);
            if (!result) continue;
            Iterator iterator = locals.iterator();
            while (iterator.hasNext() && (result = this.processSingleRequest((local = (RequestWithProcessor)iterator.next()).request, local.refProcessor))) {
            }
            if (result) {
                Computable custom;
                iterator = customs.iterator();
                while (iterator.hasNext() && (result = ((Boolean)(custom = (Computable)iterator.next()).compute()).booleanValue())) {
                }
            }
            if (!result) break;
        } while (PsiSearchHelperImpl.appendCollectorsFromQueryRequests(collectors));
        return result;
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> processRequestsAsync(@NotNull SearchRequestCollector collector, @NotNull Processor<PsiReference> processor) {
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processRequestsAsync"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processRequestsAsync"));
        }
        AsyncFuture<Boolean> asyncFuture = AsyncUtil.wrapBoolean(this.processRequests(collector, processor));
        if (asyncFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processRequestsAsync"));
        }
        return asyncFuture;
    }

    private static boolean appendCollectorsFromQueryRequests(@NotNull Map<SearchRequestCollector, Processor<PsiReference>> collectors) {
        if (collectors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectors", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "appendCollectorsFromQueryRequests"));
        }
        boolean changed = false;
        LinkedList<SearchRequestCollector> queue = new LinkedList<SearchRequestCollector>(collectors.keySet());
        while (!queue.isEmpty()) {
            SearchRequestCollector each = (SearchRequestCollector)queue.removeFirst();
            for (QuerySearchRequest request : each.takeQueryRequests()) {
                request.runQuery();
                assert (!collectors.containsKey(request.collector) || collectors.get(request.collector) == request.processor);
                collectors.put(request.collector, request.processor);
                queue.addLast(request.collector);
                changed = true;
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processGlobalRequestsOptimized(@NotNull MultiMap<Set<IdIndexEntry>, RequestWithProcessor> singles, @NotNull ProgressIndicator progress, @NotNull Map<RequestWithProcessor, Processor<PsiElement>> localProcessors) {
        boolean result;
        Collection<RequestWithProcessor> requests;
        if (singles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "singles", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processGlobalRequestsOptimized"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processGlobalRequestsOptimized"));
        }
        if (localProcessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localProcessors", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processGlobalRequestsOptimized"));
        }
        if (singles.isEmpty()) {
            return true;
        }
        if (singles.size() == 1 && (requests = singles.values()).size() == 1) {
            RequestWithProcessor theOnly = requests.iterator().next();
            return this.processSingleRequest(theOnly.request, theOnly.refProcessor);
        }
        progress.pushState();
        progress.setText(PsiBundle.message("psi.scanning.files.progress", new Object[0]));
        try {
            MultiMap<VirtualFile, RequestWithProcessor> intersectionCandidateFiles = PsiSearchHelperImpl.createMultiMap();
            MultiMap<VirtualFile, RequestWithProcessor> restCandidateFiles = PsiSearchHelperImpl.createMultiMap();
            this.collectFiles(singles, progress, intersectionCandidateFiles, restCandidateFiles);
            if (intersectionCandidateFiles.isEmpty() && restCandidateFiles.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            TreeSet<String> allWords = new TreeSet<String>();
            for (RequestWithProcessor singleRequest : localProcessors.keySet()) {
                allWords.add(((RequestWithProcessor)singleRequest).request.word);
            }
            progress.setText(PsiBundle.message("psi.search.for.word.progress", PsiSearchHelperImpl.getPresentableWordsDescription(allWords)));
            if (intersectionCandidateFiles.isEmpty()) {
                result = this.processCandidates(localProcessors, restCandidateFiles, progress, restCandidateFiles.size(), 0);
            } else {
                int totalSize = restCandidateFiles.size() + intersectionCandidateFiles.size();
                result = this.processCandidates(localProcessors, intersectionCandidateFiles, progress, totalSize, 0);
                if (result) {
                    result = this.processCandidates(localProcessors, restCandidateFiles, progress, totalSize, intersectionCandidateFiles.size());
                }
            }
        }
        finally {
            progress.popState();
        }
        return result;
    }

    private boolean processCandidates(@NotNull Map<RequestWithProcessor, Processor<PsiElement>> localProcessors, @NotNull MultiMap<VirtualFile, RequestWithProcessor> candidateFiles, @NotNull ProgressIndicator progress, int totalSize, int alreadyProcessedFiles) {
        if (localProcessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localProcessors", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processCandidates"));
        }
        if (candidateFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateFiles", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processCandidates"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processCandidates"));
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(candidateFiles.keySet());
        return this.processPsiFileRoots(files, totalSize, alreadyProcessedFiles, progress, psiRoot -> {
            if (candidateFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateFiles", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processCandidates$7"));
            }
            if (localProcessors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localProcessors", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processCandidates$7"));
            }
            VirtualFile vfile = psiRoot.getVirtualFile();
            for (RequestWithProcessor singleRequest : candidateFiles.get(vfile)) {
                Processor localProcessor = (Processor)localProcessors.get(singleRequest);
                if (localProcessor.process(psiRoot)) continue;
                return false;
            }
            return true;
        });
    }

    @NotNull
    private static String getPresentableWordsDescription(@NotNull Set<String> allWords) {
        if (allWords == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allWords", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getPresentableWordsDescription"));
        }
        StringBuilder result = new StringBuilder();
        for (String string : allWords) {
            if (string == null || string.isEmpty()) continue;
            if (result.length() > 50) {
                result.append("...");
                break;
            }
            if (result.length() != 0) {
                result.append(", ");
            }
            result.append(string);
        }
        String string = result.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getPresentableWordsDescription"));
        }
        return string;
    }

    @NotNull
    private static BulkOccurrenceProcessor adaptProcessor(@NotNull PsiSearchRequest singleRequest, final @NotNull Processor<PsiReference> consumer) {
        if (singleRequest == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "singleRequest", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "adaptProcessor"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "adaptProcessor"));
        }
        SearchScope searchScope = singleRequest.searchScope;
        final boolean ignoreInjectedPsi = searchScope instanceof LocalSearchScope && ((LocalSearchScope)searchScope).isIgnoreInjectedPsi();
        final RequestResultProcessor wrapped = singleRequest.processor;
        BulkOccurrenceProcessor bulkOccurrenceProcessor = new BulkOccurrenceProcessor(){

            @Override
            public boolean execute(@NotNull PsiElement scope, int[] offsetsInScope, @NotNull StringSearcher searcher) {
                if (scope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/PsiSearchHelperImpl$8", "execute"));
                }
                if (searcher == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searcher", "com/intellij/psi/impl/search/PsiSearchHelperImpl$8", "execute"));
                }
                try {
                    if (wrapped instanceof RequestResultProcessor.BulkResultProcessor) {
                        return ((RequestResultProcessor.BulkResultProcessor)wrapped).processTextOccurrences(scope, offsetsInScope, consumer);
                    }
                    return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, !ignoreInjectedPsi, PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, (element, offsetInElement) -> {
                        if (consumer == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/PsiSearchHelperImpl$8", "lambda$execute$0"));
                        }
                        if (ignoreInjectedPsi && element instanceof PsiLanguageInjectionHost) {
                            return true;
                        }
                        return wrapped.processTextOccurrence(element, offsetInElement, consumer);
                    });
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Error | Exception e) {
                    LOG.error(e);
                    return true;
                }
            }

            public String toString() {
                return consumer.toString();
            }
        };
        if (bulkOccurrenceProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "adaptProcessor"));
        }
        return bulkOccurrenceProcessor;
    }

    private void collectFiles(@NotNull MultiMap<Set<IdIndexEntry>, RequestWithProcessor> singles, @NotNull ProgressIndicator progress, @NotNull MultiMap<VirtualFile, RequestWithProcessor> intersectionResult, @NotNull MultiMap<VirtualFile, RequestWithProcessor> restResult) {
        if (singles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "singles", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "collectFiles"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "collectFiles"));
        }
        if (intersectionResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intersectionResult", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "collectFiles"));
        }
        if (restResult == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restResult", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "collectFiles"));
        }
        for (Set<IdIndexEntry> keys : singles.keySet()) {
            if (keys.isEmpty()) continue;
            Collection<RequestWithProcessor> data = singles.get(keys);
            GlobalSearchScope commonScope = PsiSearchHelperImpl.uniteScopes(data);
            Set<VirtualFile> intersectionWithContainerNameFiles = this.intersectionWithContainerNameFiles(commonScope, data, keys);
            ArrayList result = new ArrayList();
            Processor<VirtualFile> processor = Processors.cancelableCollectProcessor(result);
            PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, null, keys, processor);
            for (VirtualFile file : result) {
                progress.checkCanceled();
                for (IdIndexEntry entry : keys) {
                    DumbService.getInstance(this.myManager.getProject()).runReadActionInSmartMode(() -> {
                        if (restResult == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restResult", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$collectFiles$9"));
                        }
                        if (intersectionResult == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intersectionResult", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$collectFiles$9"));
                        }
                        return FileBasedIndex.getInstance().processValues(IdIndex.NAME, entry, file, (file1, value) -> {
                            if (restResult == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restResult", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$null$8"));
                            }
                            if (intersectionResult == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intersectionResult", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$null$8"));
                            }
                            int mask = value;
                            for (RequestWithProcessor single : data) {
                                PsiSearchRequest request = single.request;
                                if ((mask & request.searchContext) == 0 || !((GlobalSearchScope)request.searchScope).contains(file1)) continue;
                                MultiMap result1 = intersectionWithContainerNameFiles == null || !intersectionWithContainerNameFiles.contains(file1) ? restResult : intersectionResult;
                                result1.putValue(file1, single);
                            }
                            return true;
                        }, commonScope);
                    });
                }
            }
        }
    }

    @Nullable(value="null means we did not find common container files")
    private Set<VirtualFile> intersectionWithContainerNameFiles(@NotNull GlobalSearchScope commonScope, @NotNull Collection<RequestWithProcessor> data, @NotNull Set<IdIndexEntry> keys) {
        if (commonScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonScope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "intersectionWithContainerNameFiles"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "intersectionWithContainerNameFiles"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "intersectionWithContainerNameFiles"));
        }
        String commonName = null;
        short searchContext = 0;
        boolean caseSensitive = true;
        for (RequestWithProcessor r : data) {
            String name = ((RequestWithProcessor)r).request.containerName;
            if (name == null) continue;
            if (commonName == null) {
                commonName = ((RequestWithProcessor)r).request.containerName;
                searchContext = ((RequestWithProcessor)r).request.searchContext;
                caseSensitive = ((RequestWithProcessor)r).request.caseSensitive;
                continue;
            }
            if (commonName.equals(name)) {
                searchContext = (short)(searchContext | ((RequestWithProcessor)r).request.searchContext);
                caseSensitive &= ((RequestWithProcessor)r).request.caseSensitive;
                continue;
            }
            return null;
        }
        if (commonName == null) {
            return null;
        }
        List<IdIndexEntry> entries = PsiSearchHelperImpl.getWordEntries(commonName, caseSensitive);
        if (entries.isEmpty()) {
            return null;
        }
        entries.addAll(keys);
        short finalSearchContext = searchContext;
        Condition<Integer> contextMatches = context -> (context & finalSearchContext) != 0;
        THashSet containerFiles = new THashSet();
        Processor<VirtualFile> processor = Processors.cancelableCollectProcessor(containerFiles);
        PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, contextMatches, entries, processor);
        return containerFiles;
    }

    @NotNull
    private static MultiMap<VirtualFile, RequestWithProcessor> createMultiMap() {
        MultiMap<VirtualFile, RequestWithProcessor> multiMap = MultiMap.createSmart();
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "createMultiMap"));
        }
        return multiMap;
    }

    @NotNull
    private static GlobalSearchScope uniteScopes(@NotNull Collection<RequestWithProcessor> requests) {
        if (requests == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requests", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "uniteScopes"));
        }
        Set<GlobalSearchScope> scopes = ContainerUtil.map2LinkedSet(requests, r -> (GlobalSearchScope)((RequestWithProcessor)r).request.searchScope);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union(scopes.toArray(new GlobalSearchScope[scopes.size()]));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "uniteScopes"));
        }
        return globalSearchScope;
    }

    private static void distributePrimitives(@NotNull Map<SearchRequestCollector, Processor<PsiReference>> collectors, @NotNull Set<RequestWithProcessor> locals, @NotNull MultiMap<Set<IdIndexEntry>, RequestWithProcessor> singles, @NotNull List<Computable<Boolean>> customs, @NotNull Map<RequestWithProcessor, Processor<PsiElement>> localProcessors, @NotNull ProgressIndicator progress) {
        if (collectors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collectors", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "distributePrimitives"));
        }
        if (locals == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locals", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "distributePrimitives"));
        }
        if (singles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "singles", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "distributePrimitives"));
        }
        if (customs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customs", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "distributePrimitives"));
        }
        if (localProcessors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localProcessors", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "distributePrimitives"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "distributePrimitives"));
        }
        for (Map.Entry<SearchRequestCollector, Processor<PsiReference>> entry : collectors.entrySet()) {
            Processor<PsiReference> processor = entry.getValue();
            SearchRequestCollector collector = entry.getKey();
            for (PsiSearchRequest psiSearchRequest : collector.takeSearchRequests()) {
                SearchScope scope = psiSearchRequest.searchScope;
                if (scope instanceof LocalSearchScope) {
                    PsiSearchHelperImpl.registerRequest(locals, psiSearchRequest, processor);
                    continue;
                }
                HashSet<IdIndexEntry> key = new HashSet<IdIndexEntry>(PsiSearchHelperImpl.getWordEntries(psiSearchRequest.word, psiSearchRequest.caseSensitive));
                PsiSearchHelperImpl.registerRequest(singles.getModifiable(key), psiSearchRequest, processor);
            }
            for (Processor processor2 : collector.takeCustomSearchActions()) {
                customs.add(() -> customAction.process(processor));
            }
        }
        for (Map.Entry<Object, Object> entry : singles.entrySet()) {
            for (RequestWithProcessor singleRequest : (Collection)entry.getValue()) {
                PsiSearchRequest primitive = singleRequest.request;
                StringSearcher stringSearcher = new StringSearcher(primitive.word, primitive.caseSensitive, true, false);
                BulkOccurrenceProcessor adapted = PsiSearchHelperImpl.adaptProcessor(primitive, singleRequest.refProcessor);
                Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(adapted, progress, stringSearcher);
                assert (!localProcessors.containsKey(singleRequest) || localProcessors.get(singleRequest) == localProcessor);
                localProcessors.put(singleRequest, localProcessor);
            }
        }
    }

    private static void registerRequest(@NotNull Collection<RequestWithProcessor> collection, @NotNull PsiSearchRequest primitive, @NotNull Processor<PsiReference> processor) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "registerRequest"));
        }
        if (primitive == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primitive", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "registerRequest"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "registerRequest"));
        }
        RequestWithProcessor singleRequest = new RequestWithProcessor(primitive, processor);
        for (RequestWithProcessor existing : collection) {
            if (!existing.uniteWith(singleRequest)) continue;
            return;
        }
        collection.add(singleRequest);
    }

    private boolean processSingleRequest(@NotNull PsiSearchRequest single, @NotNull Processor<PsiReference> consumer) {
        if (single == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "single", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processSingleRequest"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processSingleRequest"));
        }
        EnumSet<Options> options = EnumSet.of(Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (single.caseSensitive) {
            options.add(Options.CASE_SENSITIVE_SEARCH);
        }
        if (PsiSearchHelperImpl.shouldProcessInjectedPsi(single.searchScope)) {
            options.add(Options.PROCESS_INJECTED_PSI);
        }
        return this.bulkProcessElementsWithWord(single.searchScope, single.word, single.searchContext, options, single.containerName, PsiSearchHelperImpl.adaptProcessor(single, consumer));
    }

    @Override
    @NotNull
    public PsiSearchHelper.SearchCostResult isCheapEnoughToSearch(@NotNull String name, @NotNull GlobalSearchScope scope, final @Nullable PsiFile fileToIgnoreOccurrencesIn, @Nullable ProgressIndicator progress) {
        boolean cheap;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "isCheapEnoughToSearch"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "isCheapEnoughToSearch"));
        }
        final AtomicInteger count = new AtomicInteger();
        final ProgressIndicator indicator = progress == null ? new EmptyProgressIndicator() : progress;
        Processor<VirtualFile> processor = new Processor<VirtualFile>(){
            private final VirtualFile virtualFileToIgnoreOccurrencesIn;
            {
                this.virtualFileToIgnoreOccurrencesIn = fileToIgnoreOccurrencesIn == null ? null : fileToIgnoreOccurrencesIn.getVirtualFile();
            }

            @Override
            public boolean process(VirtualFile file) {
                indicator.checkCanceled();
                if (Comparing.equal(file, this.virtualFileToIgnoreOccurrencesIn)) {
                    return true;
                }
                int value = count.incrementAndGet();
                return value < 10;
            }
        };
        List<IdIndexEntry> keys = PsiSearchHelperImpl.getWordEntries(name, true);
        boolean bl = cheap = keys.isEmpty() || PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, null, keys, processor);
        if (!cheap) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "isCheapEnoughToSearch"));
            }
            return searchCostResult;
        }
        PsiSearchHelper.SearchCostResult searchCostResult = count.get() == 0 ? PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES : PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES;
        if (searchCostResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "isCheapEnoughToSearch"));
        }
        return searchCostResult;
    }

    private static boolean processFilesContainingAllKeys(@NotNull Project project, @NotNull GlobalSearchScope scope, @Nullable Condition<Integer> checker, @NotNull Collection<IdIndexEntry> keys, @NotNull Processor<VirtualFile> processor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processFilesContainingAllKeys"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processFilesContainingAllKeys"));
        }
        if (keys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processFilesContainingAllKeys"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processFilesContainingAllKeys"));
        }
        FileIndexFacade index = FileIndexFacade.getInstance(project);
        return DumbService.getInstance(project).runReadActionInSmartMode(() -> {
            if (keys == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keys", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processFilesContainingAllKeys$14"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processFilesContainingAllKeys$14"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processFilesContainingAllKeys$14"));
            }
            return FileBasedIndex.getInstance().processFilesContainingAllKeys(IdIndex.NAME, keys, scope, checker, file -> {
                if (scope == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$null$13"));
                }
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$null$13"));
                }
                return !index.shouldBeFound(scope, (VirtualFile)file) || processor.process((VirtualFile)file);
            });
        });
    }

    @NotNull
    private static List<IdIndexEntry> getWordEntries(@NotNull String name, boolean caseSensitively) {
        String trimmed;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getWordEntries"));
        }
        List<String> words = StringUtil.getWordsInStringLongestFirst(name);
        if (words.isEmpty() && StringUtil.isNotEmpty(trimmed = name.trim())) {
            words = Collections.singletonList(trimmed);
        }
        if (words.isEmpty()) {
            List<IdIndexEntry> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getWordEntries"));
            }
            return list;
        }
        List<IdIndexEntry> list = ContainerUtil.map2List(words, word -> new IdIndexEntry((String)word, caseSensitively));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "getWordEntries"));
        }
        return list;
    }

    public static boolean processTextOccurrences(final @NotNull PsiElement element, @NotNull String stringToSearch, @NotNull GlobalSearchScope searchScope, @NotNull Processor<UsageInfo> processor, final @NotNull UsageInfoFactory factory) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processTextOccurrences"));
        }
        if (stringToSearch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringToSearch", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processTextOccurrences"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processTextOccurrences"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processTextOccurrences"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "processTextOccurrences"));
        }
        PsiSearchHelper helper = ApplicationManager.getApplication().runReadAction(new Computable<PsiSearchHelper>(){

            @Override
            public PsiSearchHelper compute() {
                return PsiSearchHelper.SERVICE.getInstance(element.getProject());
            }
        });
        return helper.processUsagesInNonJavaFiles(element, stringToSearch, (psiFile, startOffset, endOffset) -> {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processTextOccurrences$16"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl", "lambda$processTextOccurrences$16"));
            }
            try {
                UsageInfo usageInfo = ApplicationManager.getApplication().runReadAction(new Computable<UsageInfo>(){

                    @Override
                    public UsageInfo compute() {
                        return factory.createUsageInfo(psiFile, startOffset, endOffset);
                    }
                });
                return usageInfo == null || processor.process(usageInfo);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error(e);
                return true;
            }
        }, searchScope);
    }

    private static class RequestWithProcessor {
        @NotNull
        private final PsiSearchRequest request;
        @NotNull
        private Processor<PsiReference> refProcessor;

        private RequestWithProcessor(@NotNull PsiSearchRequest request, @NotNull Processor<PsiReference> processor) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor", "<init>"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor", "<init>"));
            }
            this.request = request;
            this.refProcessor = processor;
        }

        private boolean uniteWith(@NotNull RequestWithProcessor another) {
            if (another == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "another", "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor", "uniteWith"));
            }
            if (this.request.equals(another.request)) {
                Processor<PsiReference> myProcessor = this.refProcessor;
                if (myProcessor != another.refProcessor) {
                    this.refProcessor = psiReference -> {
                        if (another == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "another", "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor", "lambda$uniteWith$0"));
                        }
                        return myProcessor.process((PsiReference)psiReference) && another.refProcessor.process((PsiReference)psiReference);
                    };
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return this.request.toString();
        }
    }

    public static enum Options {
        PROCESS_INJECTED_PSI,
        CASE_SENSITIVE_SEARCH,
        PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE;

    }
}

