/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.FilePathSplittingPolicy;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class SplitBySeparatorPolicy
extends FilePathSplittingPolicy {
    @Override
    public String getPresentableName(File file, int length) {
        String s;
        String absolutePath = file.getPath();
        if (absolutePath.length() <= length) {
            return absolutePath;
        }
        String name = file.getName();
        if (length < name.length()) {
            return "...";
        }
        if (length == name.length()) {
            return name;
        }
        ArrayList<String> components = this.getComponents(file);
        int currentLength = 0;
        ArrayList<String> end = new ArrayList<String>();
        ArrayList<String> begin = new ArrayList<String>();
        int size = components.size();
        int mult = 1;
        int currentIndex = 0;
        for (int i2 = size - 1; i2 >= 0 && (currentLength += (s = (String)components.get(currentIndex)).length()) <= length - 3; --i2) {
            if (mult > 0) {
                end.add(s);
            } else {
                begin.add(s);
            }
            currentIndex += i2 * mult;
            mult *= -1;
        }
        if (end.isEmpty()) {
            return name;
        }
        StringBuffer result = new StringBuffer();
        Iterator iterator = begin.iterator();
        while (iterator.hasNext()) {
            result.append((String)iterator.next());
        }
        result.append("...");
        for (int i3 = end.size() - 1; i3 >= 0; --i3) {
            result.append((String)end.get(i3));
        }
        return result.toString();
    }

    private ArrayList<String> getComponents(File file) {
        ArrayList<String> result = new ArrayList<String>();
        File current = file;
        while (current != null) {
            result.add(this.getFileName(current));
            if ((current = current.getParentFile()) == null) continue;
            result.add(File.separator);
        }
        return result;
    }

    private String getFileName(File current) {
        String result = current.getName();
        if (!result.isEmpty()) {
            return result;
        }
        String path = current.getPath();
        return path.substring(0, path.length() - 1);
    }
}

