/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.DeclarationSearchUtils;
import org.jetbrains.annotations.NotNull;

public class ConstantIfStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("constant.if.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConstantIfStatementInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("constant.if.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConstantIfStatementInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConstantIfStatementVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConstantIfStatementFix();
    }

    private static class ConstantIfStatementVisitor
    extends BaseInspectionVisitor {
        private ConstantIfStatementVisitor() {
        }

        @Override
        public void visitIfStatement(PsiIfStatement statement) {
            super.visitIfStatement(statement);
            PsiExpression condition = statement.getCondition();
            if (condition == null) {
                return;
            }
            PsiStatement thenBranch = statement.getThenBranch();
            if (thenBranch == null) {
                return;
            }
            if (BoolUtils.isTrue(condition) || BoolUtils.isFalse(condition)) {
                this.registerStatementError(statement, new Object[0]);
            }
        }
    }

    private static class ConstantIfStatementFix
    extends InspectionGadgetsFix {
        private ConstantIfStatementFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConstantIfStatementInspection$ConstantIfStatementFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("constant.conditional.expression.simplify.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/ConstantIfStatementInspection$ConstantIfStatementFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement ifKeyword = descriptor.getPsiElement();
            PsiIfStatement statement = (PsiIfStatement)ifKeyword.getParent();
            assert (statement != null);
            PsiStatement thenBranch = statement.getThenBranch();
            PsiStatement elseBranch = statement.getElseBranch();
            PsiExpression condition = statement.getCondition();
            if (BoolUtils.isFalse(condition)) {
                if (elseBranch != null) {
                    ConstantIfStatementFix.replaceStatementWithUnwrapping(elseBranch, statement);
                } else {
                    ConstantIfStatementFix.deleteElement(statement);
                }
            } else {
                ConstantIfStatementFix.replaceStatementWithUnwrapping(thenBranch, statement);
            }
        }

        private static void replaceStatementWithUnwrapping(PsiStatement branch, PsiIfStatement statement) throws IncorrectOperationException {
            if (branch instanceof PsiBlockStatement && !(statement.getParent() instanceof PsiIfStatement)) {
                PsiCodeBlock parentBlock = PsiTreeUtil.getParentOfType((PsiElement)branch, PsiCodeBlock.class);
                if (parentBlock == null) {
                    String elseText = branch.getText();
                    PsiReplacementUtil.replaceStatement(statement, elseText);
                    return;
                }
                PsiCodeBlock block = ((PsiBlockStatement)branch).getCodeBlock();
                boolean hasConflicts = DeclarationSearchUtils.containsConflictingDeclarations(block, parentBlock);
                if (hasConflicts) {
                    String elseText = branch.getText();
                    PsiReplacementUtil.replaceStatement(statement, elseText);
                } else {
                    PsiElement containingElement = statement.getParent();
                    PsiStatement[] statements = block.getStatements();
                    if (statements.length > 0) {
                        assert (containingElement != null);
                        PsiJavaToken lBrace = block.getLBrace();
                        PsiJavaToken rBrace = block.getRBrace();
                        PsiElement added = null;
                        if (lBrace != null && rBrace != null) {
                            PsiElement firstNonBrace = lBrace.getNextSibling();
                            PsiElement lastNonBrace = rBrace.getPrevSibling();
                            if (firstNonBrace != null && lastNonBrace != null) {
                                added = containingElement.addRangeBefore(firstNonBrace, lastNonBrace, statement);
                            }
                        }
                        if (added == null) {
                            added = containingElement.addRangeBefore(statements[0], statements[statements.length - 1], statement);
                        }
                        Project project = statement.getProject();
                        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(project);
                        codeStyleManager.reformat(added);
                    }
                    statement.delete();
                }
            } else {
                String elseText = branch.getText();
                PsiReplacementUtil.replaceStatement(statement, elseText);
            }
        }
    }
}

